

<?php $__env->startSection('content'); ?>
<style>
/* Set a beautiful background, improve typography, and enhance layout */
body {
    background: linear-gradient(45deg, #070824, #1c1c1c); /* Gradient background */
    color: #fff;
    font-family: "Helvetica Neue", sans-serif; /* Aesthetic font choice */
    line-height: 1.6;
    margin: 0;
    padding: 0;
    text-align: center; /* Center-align text */
    transition: background 0.5s;
}

/* Improve the appearance of links */
a {
    color: #ffca28;
    text-decoration: none;
    transition: color 0.3s;
}

a:hover {
    color: #fff;
}

/* Center content on the page with subtle animations */
.container {
    display: flex;
    justify-content: center;
    align-items: center;
    min-height: 100vh;
    flex-direction: column;
    opacity: 0; /* Start with opacity 0 for a fade-in effect */
    transform: translateY(20px); /* Slightly offset for an animation */
    transition: opacity 1s, transform 1s;
}

.container.show {
    opacity: 1; /* Fading effect */
    transform: translateY(0); /* Sliding up animation */
}

/* Enhance card-like elements */
.card-content {
    background: rgba(0, 0, 0, 0.8); /* Semi-transparent background */
    color: #fff;
    padding: 20px;
    border-radius: 10px;
    box-shadow: 0 0 10px rgba(0, 0, 0, 0.3);
    margin: 20px;
    transition: background 0.5s;
}

.card-content:hover {
    background: rgba(0, 0, 0, 0.9); /* Darker background on hover */
}

/* Style buttons with a gradient effect */
.button {
    background: linear-gradient(45deg, #ffca28, #ff8a00); /* Gradient button background */
    color: #fff;
    border: none;
    padding: 12px 24px;
    border-radius: 5px;
    cursor: pointer;
    transition: background 0.3s;
}

.button:hover {
    background: linear-gradient(45deg, #ff8a00, #ffca28); /* Gradient change on hover */
}

/* Style headings with a different color and font weight */
h1, h2, h3, h4, h5, h6 {
    font-weight: bold;
    color: #ffca28;
}

/* Style the tooltip button */
button {
    background: transparent;
    border: none;
    cursor: pointer;
}

/* Add more specific styles as needed for your content and structure */

/* Fade-in animation for the container */
@keyframes fadein {
    from {
        opacity: 0;
        transform: translateY(20px);
    }
    to {
        opacity: 1;
        transform: translateY(0);
    }
}

</style>
<div class="invite-content">
    <div class="invite-main-content">
        <div class="invite-dd invite-code">
            <span>Invite Code</span>
            <div class="invite-code-info copy" data-clipboard-text="<?php echo e(route('home')); ?>?reference=<?php echo e(auth()->user()->username); ?>"><?php echo e(auth()->user()->username); ?></div>
      
    
    <button onclick="myFunction()" onmouseout="outFunc()">
        <span class="tooltiptext" id="myTooltip">Copy Link</span>
    </button>
</div>

<?php
  $authUser = Auth::user();
  $userCount = App\Models\User::where('ref_by', $authUser->id)->count();
    $referralCommission = App\Models\Transaction::where('user_id', $authUser->id)
                                    ->where('remark', 'referral_commission')
                                    ->sum('amount');
?>
<div class="my-team">
    <ul>
        <li>
            <span><?php echo e($userCount); ?></span>
            <label>Invite</label>
        </li>
        <li>
            <span><?php echo e(showamount($referralCommission)); ?> <?php echo e($general->cur_text); ?></span>
            <label>Team Income</label>
        </li>
    </ul>
</div>



<div class="team-option">
    <?php if($user->allReferrals->count() > 0 && $maxLevel > 0): ?>
        <div class="card">
            <div class="card-body">
                <div class="treeview-container">
                    <ul class="treeview">
                        <li class="items-expanded"> <?php echo e($user->fullname); ?> ( <?php echo e($user->username); ?> )
                            <?php echo $__env->make($activeTemplate.'partials.under_tree',['user'=>$user,'layer'=>0,'isFirst'=>true], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                        </li>
                    </ul>
                </div>
            </div>
        </div>
    <?php endif; ?>
</div>
<?php $__env->stopSection(); ?>

<?php $__env->startPush('style'); ?>
    <link href="<?php echo e(asset('assets/global/css/jquery.treeView.css')); ?>" rel="stylesheet" type="text/css">
<?php $__env->stopPush(); ?>

<?php $__env->startPush('script'); ?>
<script src="<?php echo e(asset('assets/global/js/jquery.treeView.js')); ?>"></script>
<script>
(function($){
    "use strict"
    $('.treeview').treeView();
    $('.copyBoard').click(function(){
        var copyText = document.getElementsByClassName("copyURL");
        copyText = copyText[0];
        copyText.select();
        copyText.setSelectionRange(0, 99999);
        document.execCommand("copy");
        $('.copyText').text('Copied');
        setTimeout(() => {
            $('.copyText').text('Copy');
        }, 2000);
    });
})(jQuery);
</script>
<?php $__env->stopPush(); ?>

<?php echo $__env->make($activeTemplate.'layouts.master', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/u329847458/domains/crownbit.pro/public_html/core/resources/views/templates/invester/user/referrals.blade.php ENDPATH**/ ?>