@extends($activeTemplate.'layouts.master')
@section('content')

 


    <div id="app-wrap">
        <a class="box-profile mt-1" >
            <div class="inner d-flex align-items-center">
                <div class="box-avatar">
                    <img src="https://cdn.pixabay.com/photo/2020/07/01/12/58/icon-5359553_1280.png" alt="image">
                    
                </div>
                <div class="info">
                    <h2 class="fw_8" style="text-transform:uppercase;">{{ auth()->user()->username }}</h2>
                    <p><span class="__cf_email__" data-cfemail="e1808d8880838380928f808584848cd4d2d9a1868c80888dcf828e8c">[email&#160;protected]</span> </p>
                     <p>Analog options </p>
                </div>
            </div>
            
                      
        </a>  
      
        <ul class="mt-1">
            <li>
                <a  class="list-profile outline">
                    <svg width="24" height="24" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
                        <path d="M23.625 12V15.375C23.6244 15.5737 23.5452 15.7642 23.4047 15.9047C23.2642 16.0452 23.0737 16.1244 22.875 16.125H17.625C17.4263 16.1244 17.2358 16.0452 17.0953 15.9047C16.9548 15.7642 16.8756 15.5737 16.875 15.375V13.125C16.8756 12.9263 16.9548 12.7358 17.0953 12.5953C17.2358 12.4548 17.4263 12.3756 17.625 12.375H22.125V11.25H22.875C23.0737 11.2506 23.2642 11.3298 23.4047 11.4703C23.5452 11.6108 23.6244 11.8013 23.625 12ZM19.5 14.25C19.5 14.1017 19.456 13.9567 19.3736 13.8333C19.2912 13.71 19.1741 13.6139 19.037 13.5571C18.9 13.5003 18.7492 13.4855 18.6037 13.5144C18.4582 13.5433 18.3246 13.6148 18.2197 13.7197C18.1148 13.8246 18.0433 13.9582 18.0144 14.1037C17.9855 14.2492 18.0003 14.4 18.0571 14.537C18.1139 14.6741 18.21 14.7912 18.3333 14.8736C18.4567 14.956 18.6017 15 18.75 15C18.9487 14.9994 19.1392 14.9202 19.2797 14.7797C19.4202 14.6392 19.4994 14.4487 19.5 14.25Z" fill="#E03E3E"/>
                        <path d="M20.49 0.375L23.625 9.2925L22.125 9.82875V7.5C22.1244 7.30127 22.0452 7.11085 21.9047 6.97033C21.7642 6.8298 21.5737 6.75059 21.375 6.75H20.7562L19.6987 3.7425C19.5193 3.80644 19.329 3.83425 19.1387 3.82433C18.9485 3.81441 18.7621 3.76696 18.5902 3.6847C18.4184 3.60245 18.2645 3.48701 18.1375 3.34504C18.0104 3.20308 17.9127 3.03738 17.85 2.8575L6.93 6.735V6.75H3.75C3.65704 6.75012 3.56423 6.74259 3.4725 6.7275L3.375 6.4575L16.14 1.92L20.49 0.375Z" fill="#36CE94"/>
                        <path d="M1.9125 5.23875C1.98704 5.61758 2.17701 5.96406 2.45632 6.23061C2.73563 6.49717 3.0906 6.67074 3.4725 6.7275C3.56423 6.74259 3.65704 6.75012 3.75 6.75H21.375C21.5737 6.7506 21.7642 6.82981 21.9047 6.97033C22.0452 7.11085 22.1244 7.30127 22.125 7.5V12.375H17.625C17.4263 12.3756 17.2358 12.4548 17.0953 12.5953C16.9548 12.7359 16.8756 12.9263 16.875 13.125V15.375C16.8756 15.5737 16.9548 15.7642 17.0953 15.9047C17.2358 16.0452 17.4263 16.1244 17.625 16.125H22.125V20.25C22.125 20.7038 21.4538 21.375 20.625 21.375H15.375V15.375C15.3744 15.1763 15.2952 14.9859 15.1547 14.8453C15.0142 14.7048 14.8237 14.6256 14.625 14.625H2.625C2.42627 14.6256 2.23585 14.7048 2.09533 14.8453C1.9548 14.9859 1.87559 15.1763 1.875 15.375V21.375C1.47718 21.375 1.09564 21.217 0.81434 20.9357C0.533035 20.6544 0.375 20.2728 0.375 19.875V5.25C0.375 4.65327 0.612053 4.08097 1.03401 3.65901C1.45597 3.23706 2.02826 3 2.625 3H3.82875C3.35291 2.99238 2.89102 3.16082 2.5318 3.47298C2.17257 3.78513 1.94134 4.219 1.8825 4.69125C1.86398 4.8742 1.8741 5.05892 1.9125 5.23875Z" fill="#FEBD55"/>
                        <path d="M19.6987 3.74254L20.7562 6.75004H6.92993V6.73504L17.8499 2.85754C17.9127 3.03743 18.0104 3.20312 18.1374 3.34509C18.2644 3.48705 18.4183 3.60249 18.5901 3.68475C18.762 3.767 18.9484 3.81446 19.1386 3.82438C19.3289 3.8343 19.5192 3.80649 19.6987 3.74254Z" fill="#2FB380"/>
                        <path d="M18.75 15C19.1642 15 19.5 14.6642 19.5 14.25C19.5 13.8358 19.1642 13.5 18.75 13.5C18.3358 13.5 18 13.8358 18 14.25C18 14.6642 18.3358 15 18.75 15Z" fill="#2B2B37"/>
                        <path d="M8.1076 3L15.3751 0.375L16.1251 1.875L16.1401 1.92L3.3751 6.4575L3.4726 6.7275C3.0907 6.67074 2.73573 6.49717 2.45642 6.23061C2.1771 5.96405 1.98714 5.61758 1.9126 5.23875L8.1076 3Z" fill="#2FB380"/>
                        <path d="M8.10753 3L1.91253 5.23875C1.87413 5.05892 1.86401 4.8742 1.88253 4.69125C1.94137 4.219 2.1726 3.78513 2.53182 3.47298C2.89105 3.16082 3.35293 2.99238 3.82878 3H8.10753Z" fill="#BD6F08"/>
                        <path d="M15.375 21.375V22.875C15.3744 23.0737 15.2952 23.2642 15.1547 23.4047C15.0142 23.5452 14.8237 23.6244 14.625 23.625H2.625C2.42627 23.6244 2.23585 23.5452 2.09533 23.4047C1.9548 23.2642 1.87559 23.0737 1.875 22.875V18H15.375V21.375Z" fill="#FF6161"/>
                        <path d="M15.375 16.875V18H15H2.25H1.875V16.875H2.25H15H15.375Z" fill="#EDF4FA"/>
                        <path d="M15.375 15.375V16.875H1.875V15.375C1.87559 15.1763 1.9548 14.9858 2.09533 14.8453C2.23585 14.7048 2.42627 14.6256 2.625 14.625H14.625C14.8237 14.6256 15.0142 14.7048 15.1547 14.8453C15.2952 14.9858 15.3744 15.1763 15.375 15.375Z" fill="#CB3541"/>
                        <path d="M14.625 22.5H10.5C9.10509 22.4992 7.74474 22.066 6.60617 21.2601C5.46761 20.4542 4.60681 19.3153 4.14225 18H1.875V22.875C1.87559 23.0737 1.9548 23.2642 2.09533 23.4047C2.23585 23.5452 2.42627 23.6244 2.625 23.625H14.625C14.8237 23.6244 15.0142 23.5452 15.1547 23.4047C15.2952 23.2642 15.3744 23.0737 15.375 22.875V21.75C15.375 21.9489 15.296 22.1397 15.1553 22.2803C15.0147 22.421 14.8239 22.5 14.625 22.5Z" fill="#E03E3E"/>
                        <path d="M4.14225 18C4.01286 17.6341 3.9155 17.2577 3.85125 16.875H1.875V18H4.14225Z" fill="#C1CFE8"/>
                        <path d="M3.85125 16.875C3.78628 16.5035 3.75242 16.1272 3.75 15.75V14.625H2.625C2.42627 14.6256 2.23585 14.7048 2.09533 14.8453C1.9548 14.9858 1.87559 15.1763 1.875 15.375V16.875H3.85125Z" fill="#A81E29"/>
                        <path d="M16.1251 1.87499L15.8206 1.26599L4.43185 5.37862C4.24893 5.44466 4.04752 5.43707 3.8701 5.35745C3.69267 5.27783 3.55311 5.13241 3.48085 4.95187L3.38297 4.70737L1.9126 5.23874C1.98714 5.61757 2.1771 5.96404 2.45642 6.2306C2.73573 6.49716 3.0907 6.67073 3.4726 6.72749L3.3751 6.45749L16.1401 1.91999L16.1251 1.87499Z" fill="#2AA173"/>
                        <path d="M10.056 5.625H5.71688L3.375 6.4575L3.4725 6.7275C3.56423 6.74259 3.65704 6.75012 3.75 6.75H6.93V6.735L10.056 5.625Z" fill="#2FB380"/>
                        <path d="M23.625 9.2925L22.3358 5.625H20.3625L20.7582 6.75H21.375C21.5738 6.75059 21.7642 6.8298 21.9047 6.97033C22.0452 7.11085 22.1245 7.30127 22.125 7.5V9.82875L23.625 9.2925Z" fill="#2FB380"/>
                        <path d="M10.0559 5.625L6.92993 6.735V6.75H20.7562L20.3606 5.625H10.0559Z" fill="#2AA173"/>
                        <path d="M23.25 15.375H19.5C19.3406 15.3746 19.183 15.3401 19.038 15.2738C18.893 15.2075 18.7639 15.111 18.6592 14.9906C18.4775 14.9697 18.3097 14.8827 18.1879 14.7461C18.0662 14.6096 17.9989 14.433 17.9989 14.25C17.9989 14.067 18.0662 13.8904 18.1879 13.7539C18.3097 13.6173 18.4775 13.5303 18.6592 13.5094C18.7639 13.389 18.893 13.2925 19.038 13.2262C19.183 13.1599 19.3406 13.1254 19.5 13.125H22.125C22.3239 13.125 22.5147 13.046 22.6553 12.9053C22.796 12.7647 22.875 12.5739 22.875 12.375V11.25H22.125V12.375H17.625C17.4263 12.3756 17.2358 12.4548 17.0953 12.5953C16.9548 12.7358 16.8756 12.9263 16.875 13.125V15.375C16.8756 15.5737 16.9548 15.7642 17.0953 15.9047C17.2358 16.0452 17.4263 16.1244 17.625 16.125H22.875C23.0737 16.1244 23.2642 16.0452 23.4047 15.9047C23.5452 15.7642 23.6244 15.5737 23.625 15.375V15C23.625 15.0995 23.5855 15.1948 23.5152 15.2652C23.4448 15.3355 23.3495 15.375 23.25 15.375Z" fill="#CB3541"/>
                        <path d="M18 17.25H22.125V16.125H17.625C17.4929 16.1242 17.3634 16.0881 17.25 16.0204V16.5C17.25 16.6989 17.329 16.8897 17.4697 17.0303C17.6103 17.171 17.8011 17.25 18 17.25Z" fill="#FC9E20"/>
                        <path d="M1.875 16.875V15.375C1.87559 15.1763 1.9548 14.9859 2.09533 14.8453C2.23585 14.7048 2.42627 14.6256 2.625 14.625H3.375V6.705C3.01367 6.63235 2.68195 6.45433 2.42167 6.19339C2.1614 5.93244 1.98422 5.60027 1.9125 5.23875C1.8741 5.05892 1.86398 4.8742 1.8825 4.69125C1.94134 4.219 2.17257 3.78513 2.5318 3.47298C2.89102 3.16082 3.35291 2.99238 3.82875 3H2.625C2.02826 3 1.45597 3.23706 1.03401 3.65901C0.612053 4.08097 0.375 4.65327 0.375 5.25V19.875C0.375 20.2728 0.533035 20.6544 0.81434 20.9357C1.09564 21.217 1.47718 21.375 1.875 21.375V16.875Z" fill="#FC9E20"/>
                        <path d="M21 19.875H18C17.6022 19.875 17.2206 19.717 16.9393 19.4357C16.658 19.1544 16.5 18.7728 16.5 18.375V16.5C16.5 16.3011 16.421 16.1103 16.2803 15.9697C16.1397 15.829 15.9489 15.75 15.75 15.75H15.375V21.375H20.625C21.4538 21.375 22.125 20.7038 22.125 20.25V18.75C22.125 19.0484 22.0065 19.3345 21.7955 19.5455C21.5845 19.7565 21.2984 19.875 21 19.875Z" fill="#FC9E20"/>
                    </svg>
                    <p>Account Balance</p>
                    <span>{{ $general->cur_text }}.{{ showAmount(auth()->user()->interest_wallet) }} </span>
                </a>    
            </li>
            
            <li >
                <a  class="list-profile">
                    <svg width="24" height="24" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
                        <path d="M19.4783 12.1688L17.2002 11.339C17.1299 11.3109 17.0455 11.2969 16.9612 11.2969H2.36426C1.97046 11.2969 1.66113 11.6062 1.66113 12V21.8906C1.66113 23.0578 2.60328 24 3.77051 24H17.833C19.0003 24 19.9424 23.0578 19.9424 21.8906V12.8296C19.9424 12.5344 19.7596 12.2672 19.4783 12.1688Z" fill="#FC1A40"/>
                        <path d="M19.9424 12.8296V21.8906C19.9424 23.0578 19.0003 24 17.833 24H10.8018V11.2969H16.9611C17.0455 11.2969 17.1299 11.3109 17.2002 11.339L19.4783 12.1688C19.7595 12.2672 19.9424 12.5344 19.9424 12.8296Z" fill="#C60034"/>
                        <path d="M19.6892 4.58381C19.4501 3.6135 18.7329 2.85417 17.7626 2.54475C16.8063 2.24939 15.7797 2.46037 15.0345 3.13533L13.4032 4.56975L13.0798 2.41823C12.9251 1.43385 12.2923 0.604118 11.3501 0.210414C11.1673 0.140054 10.9845 0.0838041 10.8017 0.055679C10.0282 -0.0990088 9.22668 0.0697415 8.57976 0.547914C7.72195 1.16667 7.28605 2.20729 7.42663 3.24787C7.58137 4.2885 8.28449 5.17444 9.28289 5.526L10.8017 6.07444L12.672 6.7635C12.6861 6.7635 12.6861 6.7635 12.6861 6.7635L15.9345 7.95877C16.2579 8.07132 16.5954 8.12762 16.9188 8.12762C17.608 8.12762 18.283 7.8744 18.8173 7.39632C19.6048 6.69319 19.9423 5.61033 19.6892 4.58381Z" fill="#FE9923"/>
                        <path d="M18.8174 7.39635C18.283 7.87443 17.608 8.12765 16.9189 8.12765C16.5955 8.12765 16.258 8.07135 15.9346 7.95881L12.6861 6.76354C12.6861 6.76354 12.6861 6.76354 12.6721 6.76354L10.8018 6.07447V0.0556641C10.9846 0.083836 11.1674 0.140039 11.3502 0.210399C12.2923 0.604103 12.9252 1.43384 13.0798 2.41822L13.4032 4.56974L15.0345 3.13531C15.7798 2.46036 16.8064 2.24937 17.7627 2.54473C18.733 2.85415 19.4502 3.61348 19.6892 4.5838C19.9424 5.61036 19.6049 6.69322 18.8174 7.39635Z" fill="#FE8821"/>
                        <path d="M22.3471 10.9733L21.3908 13.6171C21.2783 13.8983 21.0111 14.0671 20.7299 14.0671C20.6455 14.0671 20.5611 14.053 20.4908 14.0249L13.2205 11.3812L12.5596 9.20149L10.8018 9.5952L9.25493 9.94676L1.98455 7.30301C1.61893 7.16243 1.43616 6.75457 1.56268 6.403L2.53299 3.75934C2.7158 3.22497 3.1096 2.803 3.61585 2.56398C4.1221 2.32496 4.69862 2.29679 5.233 2.49367L10.8018 4.51867L11.1815 4.65925C11.1815 4.65925 12.7002 7.41555 12.7425 7.41555C12.7707 7.41555 13.3753 7.07805 13.9659 6.75457C14.5564 6.43113 15.1471 6.09367 15.1471 6.09367L21.0814 8.25926C21.6158 8.45613 22.0377 8.84993 22.2767 9.35618C22.5158 9.86239 22.5439 10.439 22.3471 10.9733Z" fill="#FF3E75"/>
                        <path d="M22.3471 10.9733L21.3908 13.6171C21.2783 13.8983 21.0111 14.0671 20.7299 14.0671C20.6455 14.0671 20.5611 14.053 20.4908 14.0249L13.2205 11.3812L12.5596 9.2015L10.8018 9.5952V4.51868L11.1815 4.65926C11.1815 4.65926 12.7002 7.41556 12.7424 7.41556C12.7706 7.41556 13.3752 7.07806 13.9659 6.75457C14.5564 6.43113 15.1471 6.09368 15.1471 6.09368L21.0814 8.25926C21.6158 8.45614 22.0377 8.84994 22.2767 9.35619C22.5158 9.86239 22.5439 10.439 22.3471 10.9733Z" fill="#FC1A40"/>
                        <path d="M8.69238 11.2969V24H12.9111V11.2969H8.69238Z" fill="#FCBF29"/>
                        <path d="M11.1814 4.6593L10.8017 5.69993L9.25488 9.94686L10.8017 10.5094L12.5595 11.1422L13.2204 11.3812L15.1471 6.09373L11.1814 4.6593Z" fill="#FCBF29"/>
                        <path d="M12.9114 11.2969H10.802V24H12.9114V11.2969Z" fill="#FE9923"/>
                        <path d="M15.1471 6.09373L13.2205 11.3812L12.5596 11.1422L10.8018 10.5094V5.69993L11.1814 4.6593L15.1471 6.09373Z" fill="#FE9923"/>
                    </svg>                    
                    <p>wallet Deposit</p>
                    <span>{{ showAmount(auth()->user()->deposit_wallet) }} {{ $general->cur_text }}</span>
                </a>
            </li>
        </ul>
        <ul class="mt-1">
            <li>
                <a href="{{route ('user.invest.log')}}" class="list-profile outline">
                    <svg width="25" height="22" viewBox="0 0 25 22" fill="none" xmlns="http://www.w3.org/2000/svg">
                                    <path d="M22.7003 14.8487L6.19428 17.7592C5.17447 17.939 4.202 17.258 4.02219 16.2383L2.20531 5.93436C2.0255 4.91454 2.70645 3.94208 3.72622 3.76226L20.2322 0.851795C21.252 0.671982 22.2245 1.35294 22.4043 2.3727L24.2212 12.6766C24.401 13.6964 23.7201 14.6689 22.7003 14.8487Z" fill="#3555A2"></path>
                                    <path d="M20.2322 0.851795L11.9792 2.30703L14.4473 16.304L22.7003 14.8488C23.7201 14.669 24.401 13.6965 24.2212 12.6767L22.4043 2.37275C22.2245 1.35294 21.2521 0.671982 20.2322 0.851795Z" fill="#1B3555"></path>
                                    <path d="M18.5312 21.177H2.125C1.08948 21.177 0.25 20.3375 0.25 19.302V9.09644C0.25 8.06092 1.08948 7.22144 2.125 7.22144H18.5312C19.5668 7.22144 20.4062 8.06092 20.4062 9.09644V19.302C20.4062 20.3375 19.5668 21.177 18.5312 21.177Z" fill="#53D8E3"></path>
                                    <path d="M18.5312 7.22144H10.3281V21.177H18.5312C19.5668 21.177 20.4062 20.3375 20.4062 19.302V9.09644C20.4062 8.06092 19.5668 7.22144 18.5312 7.22144Z" fill="#18A8C9"></path>
                                    <path d="M0.25 10.4111H20.4062V13.601H0.25V10.4111Z" fill="#ECF6FD"></path>
                                    <path d="M5.83218 18.0813H2.64233C2.25402 18.0813 1.93921 18.3961 1.93921 18.7844C1.93921 19.1727 2.25402 19.4875 2.64233 19.4875H5.83218C6.22049 19.4875 6.5353 19.1727 6.5353 18.7844C6.5353 18.3961 6.22049 18.0813 5.83218 18.0813Z" fill="#EAF6FF"></path>
                                    <path d="M10.3281 10.4111H20.4062V13.601H10.3281V10.4111Z" fill="#D6E8FE"></path>
                                    </svg>
                                         <p>Invest Log</p>
                            <span><i class="las la-angle-right fs-203"></i></span>
                                    </a>
            </li>
            <li>
                <a href="{{route ('user.deposit.history')}}" class="list-profile outline">
                    <svg width="24" height="24" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
                                    <path d="M23.875 12V15.375C23.8744 15.5737 23.7952 15.7642 23.6547 15.9047C23.5142 16.0452 23.3237 16.1244 23.125 16.125H17.875C17.6763 16.1244 17.4858 16.0452 17.3453 15.9047C17.2048 15.7642 17.1256 15.5737 17.125 15.375V13.125C17.1256 12.9263 17.2048 12.7358 17.3453 12.5953C17.4858 12.4548 17.6763 12.3756 17.875 12.375H22.375V11.25H23.125C23.3237 11.2506 23.5142 11.3298 23.6547 11.4703C23.7952 11.6108 23.8744 11.8013 23.875 12ZM19.75 14.25C19.75 14.1017 19.706 13.9567 19.6236 13.8333C19.5412 13.71 19.4241 13.6139 19.287 13.5571C19.15 13.5003 18.9992 13.4855 18.8537 13.5144C18.7082 13.5433 18.5746 13.6148 18.4697 13.7197C18.3648 13.8246 18.2933 13.9582 18.2644 14.1037C18.2355 14.2492 18.2503 14.4 18.3071 14.537C18.3639 14.6741 18.46 14.7912 18.5833 14.8736C18.7067 14.956 18.8517 15 19 15C19.1987 14.9994 19.3892 14.9202 19.5297 14.7797C19.6702 14.6392 19.7494 14.4487 19.75 14.25Z" fill="#E03E3E"/>
                                    <path d="M20.74 0.375L23.875 9.2925L22.375 9.82875V7.5C22.3744 7.30127 22.2952 7.11085 22.1547 6.97033C22.0142 6.8298 21.8237 6.75059 21.625 6.75H21.0062L19.9487 3.7425C19.7693 3.80644 19.579 3.83425 19.3887 3.82433C19.1985 3.81441 19.0121 3.76696 18.8402 3.6847C18.6684 3.60245 18.5145 3.48701 18.3875 3.34504C18.2604 3.20308 18.1627 3.03738 18.1 2.8575L7.18 6.735V6.75H4C3.90704 6.75012 3.81423 6.74259 3.7225 6.7275L3.625 6.4575L16.39 1.92L20.74 0.375Z" fill="#36CE94"/>
                                    <path d="M2.1625 5.23875C2.23704 5.61758 2.42701 5.96406 2.70632 6.23061C2.98563 6.49717 3.3406 6.67074 3.7225 6.7275C3.81423 6.74259 3.90704 6.75012 4 6.75H21.625C21.8237 6.7506 22.0142 6.82981 22.1547 6.97033C22.2952 7.11085 22.3744 7.30127 22.375 7.5V12.375H17.875C17.6763 12.3756 17.4858 12.4548 17.3453 12.5953C17.2048 12.7359 17.1256 12.9263 17.125 13.125V15.375C17.1256 15.5737 17.2048 15.7642 17.3453 15.9047C17.4858 16.0452 17.6763 16.1244 17.875 16.125H22.375V20.25C22.375 20.7038 21.7038 21.375 20.875 21.375H15.625V15.375C15.6244 15.1763 15.5452 14.9859 15.4047 14.8453C15.2642 14.7048 15.0737 14.6256 14.875 14.625H2.875C2.67627 14.6256 2.48585 14.7048 2.34533 14.8453C2.2048 14.9859 2.12559 15.1763 2.125 15.375V21.375C1.72718 21.375 1.34564 21.217 1.06434 20.9357C0.783035 20.6544 0.625 20.2728 0.625 19.875V5.25C0.625 4.65327 0.862053 4.08097 1.28401 3.65901C1.70597 3.23706 2.27826 3 2.875 3H4.07875C3.60291 2.99238 3.14102 3.16082 2.7818 3.47298C2.42257 3.78513 2.19134 4.219 2.1325 4.69125C2.11398 4.8742 2.1241 5.05892 2.1625 5.23875Z" fill="#FEBD55"/>
                                    <path d="M19.9487 3.74242L21.0062 6.74992H7.17999V6.73492L18.1 2.85742C18.1627 3.0373 18.2604 3.203 18.3875 3.34496C18.5145 3.48693 18.6684 3.60237 18.8402 3.68462C19.012 3.76688 19.1985 3.81434 19.3887 3.82426C19.579 3.83418 19.7693 3.80636 19.9487 3.74242Z" fill="#2FB380"/>
                                    <path d="M19 15C19.4142 15 19.75 14.6642 19.75 14.25C19.75 13.8358 19.4142 13.5 19 13.5C18.5858 13.5 18.25 13.8358 18.25 14.25C18.25 14.6642 18.5858 15 19 15Z" fill="#2B2B37"/>
                                    <path d="M8.35748 3L15.625 0.375L16.375 1.875L16.39 1.92L3.62498 6.4575L3.72248 6.7275C3.34058 6.67074 2.98561 6.49717 2.7063 6.23061C2.42698 5.96405 2.23702 5.61758 2.16248 5.23875L8.35748 3Z" fill="#2FB380"/>
                                    <path d="M8.35753 3L2.16253 5.23875C2.12413 5.05892 2.11401 4.8742 2.13253 4.69125C2.19137 4.219 2.4226 3.78513 2.78182 3.47298C3.14105 3.16082 3.60293 2.99238 4.07878 3H8.35753Z" fill="#BD6F08"/>
                                    <path d="M15.625 21.375V22.875C15.6244 23.0737 15.5452 23.2642 15.4047 23.4047C15.2642 23.5452 15.0737 23.6244 14.875 23.625H2.875C2.67627 23.6244 2.48585 23.5452 2.34533 23.4047C2.2048 23.2642 2.12559 23.0737 2.125 22.875V18H15.625V21.375Z" fill="#FF6161"/>
                                    <path d="M15.625 16.875V18H15.25H2.5H2.125V16.875H2.5H15.25H15.625Z" fill="#EDF4FA"/>
                                    <path d="M15.625 15.375V16.875H2.125V15.375C2.12559 15.1763 2.2048 14.9858 2.34533 14.8453C2.48585 14.7048 2.67627 14.6256 2.875 14.625H14.875C15.0737 14.6256 15.2642 14.7048 15.4047 14.8453C15.5452 14.9858 15.6244 15.1763 15.625 15.375Z" fill="#CB3541"/>
                                    <path d="M14.875 22.5H10.75C9.35509 22.4992 7.99474 22.066 6.85617 21.2601C5.71761 20.4542 4.85681 19.3153 4.39225 18H2.125V22.875C2.12559 23.0737 2.2048 23.2642 2.34533 23.4047C2.48585 23.5452 2.67627 23.6244 2.875 23.625H14.875C15.0737 23.6244 15.2642 23.5452 15.4047 23.4047C15.5452 23.2642 15.6244 23.0737 15.625 22.875V21.75C15.625 21.9489 15.546 22.1397 15.4053 22.2803C15.2647 22.421 15.0739 22.5 14.875 22.5Z" fill="#E03E3E"/>
                                    <path d="M4.39225 18C4.26286 17.6341 4.1655 17.2577 4.10125 16.875H2.125V18H4.39225Z" fill="#C1CFE8"/>
                                    <path d="M4.10125 16.875C4.03628 16.5035 4.00242 16.1272 4 15.75V14.625H2.875C2.67627 14.6256 2.48585 14.7048 2.34533 14.8453C2.2048 14.9858 2.12559 15.1763 2.125 15.375V16.875H4.10125Z" fill="#A81E29"/>
                                    <path d="M16.375 1.87511L16.0705 1.26611L4.68173 5.37874C4.49881 5.44478 4.2974 5.43719 4.11997 5.35757C3.94255 5.27796 3.80299 5.13253 3.73073 4.95199L3.63285 4.70749L2.16248 5.23886C2.23702 5.61769 2.42698 5.96417 2.7063 6.23072C2.98561 6.49728 3.34058 6.67085 3.72248 6.72761L3.62498 6.45761L16.39 1.92011L16.375 1.87511Z" fill="#2AA173"/>
                                    <path d="M10.306 5.625H5.96688L3.625 6.4575L3.7225 6.7275C3.81423 6.74259 3.90704 6.75012 4 6.75H7.18V6.735L10.306 5.625Z" fill="#2FB380"/>
                                    <path d="M23.875 9.2925L22.5857 5.625H20.6125L21.0081 6.75H21.625C21.8237 6.75059 22.0141 6.8298 22.1547 6.97033C22.2952 7.11085 22.3744 7.30127 22.375 7.5V9.82875L23.875 9.2925Z" fill="#2FB380"/>
                                    <path d="M10.306 5.625L7.17999 6.735V6.75H21.0062L20.6106 5.625H10.306Z" fill="#2AA173"/>
                                    <path d="M23.5 15.375H19.75C19.5906 15.3746 19.433 15.3401 19.288 15.2738C19.143 15.2075 19.0139 15.111 18.9092 14.9906C18.7275 14.9697 18.5597 14.8827 18.4379 14.7461C18.3162 14.6096 18.2489 14.433 18.2489 14.25C18.2489 14.067 18.3162 13.8904 18.4379 13.7539C18.5597 13.6173 18.7275 13.5303 18.9092 13.5094C19.0139 13.389 19.143 13.2925 19.288 13.2262C19.433 13.1599 19.5906 13.1254 19.75 13.125H22.375C22.5739 13.125 22.7647 13.046 22.9053 12.9053C23.046 12.7647 23.125 12.5739 23.125 12.375V11.25H22.375V12.375H17.875C17.6763 12.3756 17.4858 12.4548 17.3453 12.5953C17.2048 12.7358 17.1256 12.9263 17.125 13.125V15.375C17.1256 15.5737 17.2048 15.7642 17.3453 15.9047C17.4858 16.0452 17.6763 16.1244 17.875 16.125H23.125C23.3237 16.1244 23.5142 16.0452 23.6547 15.9047C23.7952 15.7642 23.8744 15.5737 23.875 15.375V15C23.875 15.0995 23.8355 15.1948 23.7652 15.2652C23.6948 15.3355 23.5995 15.375 23.5 15.375Z" fill="#CB3541"/>
                                    <path d="M18.25 17.2499H22.375V16.1249H17.875C17.7429 16.1241 17.6134 16.088 17.5 16.0203V16.4999C17.5 16.6988 17.579 16.8896 17.7197 17.0302C17.8603 17.1709 18.0511 17.2499 18.25 17.2499Z" fill="#FC9E20"/>
                                    <path d="M2.125 16.875V15.375C2.12559 15.1763 2.2048 14.9859 2.34533 14.8453C2.48585 14.7048 2.67627 14.6256 2.875 14.625H3.625V6.705C3.26367 6.63235 2.93195 6.45433 2.67167 6.19339C2.4114 5.93244 2.23422 5.60027 2.1625 5.23875C2.1241 5.05892 2.11398 4.8742 2.1325 4.69125C2.19134 4.219 2.42257 3.78513 2.7818 3.47298C3.14102 3.16082 3.60291 2.99238 4.07875 3H2.875C2.27826 3 1.70597 3.23706 1.28401 3.65901C0.862053 4.08097 0.625 4.65327 0.625 5.25V19.875C0.625 20.2728 0.783035 20.6544 1.06434 20.9357C1.34564 21.217 1.72718 21.375 2.125 21.375V16.875Z" fill="#FC9E20"/>
                                    <path d="M21.25 19.875H18.25C17.8522 19.875 17.4706 19.717 17.1893 19.4357C16.908 19.1544 16.75 18.7728 16.75 18.375V16.5C16.75 16.3011 16.671 16.1103 16.5303 15.9697C16.3897 15.829 16.1989 15.75 16 15.75H15.625V21.375H20.875C21.7038 21.375 22.375 20.7038 22.375 20.25V18.75C22.375 19.0484 22.2565 19.3345 22.0455 19.5455C21.8345 19.7565 21.5484 19.875 21.25 19.875Z" fill="#FC9E20"/>
                                </svg>  
                    <p>Deposit Records</p>
                    <span><i class="las la-angle-right fs-203"></i></span>
                </a>   
            </li>
           <li>
                <a href="{{route ('user.withdraw.history')}}" class="list-profile outline">
                    <svg width="25" height="24" viewBox="0 0 25 24" fill="none" xmlns="http://www.w3.org/2000/svg">
                                        <path d="M23.1834 10.0255H23.1572H3.01642L13.0996 3.63647L14.5332 4.55682H14.5344C14.4507 4.85654 14.4064 5.17262 14.4064 5.4984C14.4064 7.45252 16.0002 9.04571 17.9531 9.04571C18.8352 9.04571 19.6434 8.72054 20.2658 8.18419L23.1834 10.0255Z" fill="#E4E8EB"/>
                                        <path d="M23.1573 10.0256V12.0884H22.308H19.5172H18.4858H15.695H10.4775H7.74743H6.71604H3.92529H3.01526V10.0256H3.01643H23.1573Z" fill="#CAD0D7"/>
                                        <path d="M22.3079 12.0884V12.9984H21.7012H20.1239H19.5172V12.0884H22.3079Z" fill="#E4E8EB"/>
                                        <path d="M20.1239 12.9983H21.7012V21.9166H20.1239V12.9983Z" fill="#CAD0D7"/>
                                        <path d="M20.2658 8.18416C19.6433 8.72051 18.8352 9.04568 17.9531 9.04568C16.0002 9.04568 14.4064 7.45249 14.4064 5.49837C14.4064 5.17258 14.4507 4.85651 14.5344 4.55679C14.9481 3.05829 16.3259 1.95288 17.9531 1.95288C19.906 1.95288 21.5004 3.54485 21.5004 5.49837C21.5004 6.57035 21.0205 7.53316 20.2658 8.18416Z" fill="#FDCD56"/>
                                        <path d="M20.1239 12.9984V21.9168H17.8791V12.9984H18.4858V12.0884H19.5172V12.9984H20.1239Z" fill="#636C77"/>
                                        <path d="M18.4858 12.0884V12.9984H17.8791H16.3017H15.695V12.0884H18.4858Z" fill="#E4E8EB"/>
                                        <path d="M16.3018 12.9983H17.8791V21.9166H16.3018V12.9983Z" fill="#CAD0D7"/>
                                        <path d="M16.3017 12.9984V21.9168H15.2097V16.2139H11.0235V21.9168H9.87079V12.9984H10.4775V12.0884H15.695V12.9984H16.3017Z" fill="#636C77"/>
                                        <path d="M11.0235 16.2139H15.2097V21.9167H11.0235V16.2139Z" fill="#424852"/>
                                        <path d="M13.8628 0.687988C14.2839 0.687988 14.626 1.03139 14.626 1.45121C14.626 1.87285 14.2839 2.21443 13.8628 2.21443C13.443 2.21443 13.0996 1.87285 13.0996 1.45121C13.0996 1.03135 13.443 0.687988 13.8628 0.687988Z" fill="#F76C82"/>
                                        <path d="M10.4775 12.0884V12.9984H9.87083H8.35409H7.74744V12.0884H10.4775Z" fill="#E4E8EB"/>
                                        <path d="M8.35406 12.9983H9.8708V21.9166H8.35406V12.9983Z" fill="#CAD0D7"/>
                                        <path d="M8.35406 12.9984V21.9168H6.10931V12.9984H6.71602V12.0884H7.74741V12.9984H8.35406Z" fill="#636C77"/>
                                        <path d="M6.71604 12.0884V12.9984H6.10934H4.53195H3.92529V12.0884H6.71604Z" fill="#E4E8EB"/>
                                        <path d="M4.53192 12.9983H6.10931V21.9166H4.53192V12.9983Z" fill="#CAD0D7"/>
                                        <path d="M23.1573 21.6094H17.0904H15.2097H11.0235H9.08209H3.01524C2.84771 21.6094 2.71191 21.7465 2.71191 21.9141C2.71191 22.0816 2.84766 22.2188 3.01524 22.2188H9.08213H11.0236H15.2097H17.0904H23.1573C23.3249 22.2188 23.4607 22.0816 23.4607 21.9141C23.4607 21.7465 23.3248 21.6094 23.1573 21.6094Z" fill="#424852"/>
                                        <path d="M23.1573 23.3121H3.01524C2.84771 23.3121 2.71191 23.1763 2.71191 23.0087C2.71191 22.8411 2.84766 22.7053 3.01524 22.7053H23.1573C23.3248 22.7053 23.4607 22.8411 23.4607 23.0087C23.4607 23.1763 23.3248 23.3121 23.1573 23.3121Z" fill="#424852"/>
                                        <path d="M18.1669 5.18951C17.6911 5.02053 17.5613 4.80799 17.5729 4.73154C17.5824 4.66971 17.7095 4.57835 17.961 4.56884C18.1292 4.5634 18.317 4.59288 18.5193 4.6564C18.679 4.70656 18.8494 4.61763 18.8995 4.45779C18.9497 4.29795 18.8695 4.1277 18.7096 4.07754C18.5524 4.02823 18.3542 3.99504 18.2604 3.97718V3.59463C18.2604 3.4271 18.1232 3.29126 17.9557 3.29126C17.7882 3.29126 17.651 3.4271 17.651 3.59463V4.00517C17.276 4.09709 17.0281 4.32851 16.9804 4.6399C16.9266 4.99273 17.1548 5.47263 17.9676 5.76129C18.2909 5.87595 18.421 6.02435 18.4084 6.12054C18.3961 6.21438 18.2571 6.34957 18.0225 6.39804C17.9963 6.39068 17.9688 6.38543 17.9402 6.38543C17.8939 6.38543 17.8502 6.39663 17.811 6.4152C17.6533 6.41051 17.4895 6.36753 17.3316 6.28728C17.1823 6.21148 16.9996 6.27096 16.9237 6.42031C16.8478 6.56965 16.9147 6.75228 17.064 6.82817C17.2518 6.9236 17.4635 6.98459 17.651 7.00976V7.35617C17.651 7.5237 17.7881 7.65949 17.9557 7.65949C18.1232 7.65949 18.2604 7.5237 18.2604 7.35617V6.9671C18.6822 6.84907 18.9702 6.55371 19.0167 6.19953C19.0377 6.04001 19.0303 5.49579 18.1669 5.18951Z" fill="white"/>
                                        <path d="M4.6533 6.68873H3.13657C2.96903 6.68873 2.83319 6.55289 2.83319 6.38536C2.83319 6.21783 2.96899 6.08203 3.13657 6.08203H4.65325C4.82078 6.08203 4.95663 6.21783 4.95663 6.38536C4.95663 6.55289 4.82083 6.68873 4.6533 6.68873Z" fill="#424852"/>
                                        <path d="M3.92528 7.41689C3.75774 7.41689 3.62195 7.28105 3.62195 7.11352V5.59683C3.62195 5.4293 3.7577 5.29346 3.92528 5.29346C4.09285 5.29346 4.22865 5.4293 4.22865 5.59683V7.11352C4.2286 7.28105 4.09281 7.41689 3.92528 7.41689Z" fill="#424852"/>
                                        <path d="M24.6133 14.8792H23.036C22.8684 14.8792 22.7326 14.7434 22.7326 14.5758C22.7326 14.4083 22.8684 14.2725 23.036 14.2725H24.6133C24.7809 14.2725 24.9167 14.4083 24.9167 14.5758C24.9167 14.7434 24.7809 14.8792 24.6133 14.8792Z" fill="#424852"/>
                                        <path d="M23.8246 15.6679C23.6571 15.6679 23.5213 15.5321 23.5213 15.3645V13.8478C23.5213 13.6803 23.6571 13.5444 23.8246 13.5444C23.9922 13.5444 24.128 13.6802 24.128 13.8478V15.3645C24.128 15.5321 23.9922 15.6679 23.8246 15.6679Z" fill="#424852"/>
                                        <path d="M2.74825 21.1504C2.67067 21.1504 2.59304 21.1208 2.53384 21.0617L1.00567 19.5353C0.887121 19.4169 0.887027 19.2248 1.00539 19.1063C1.12365 18.9878 1.3157 18.9876 1.43434 19.106L2.96265 20.6325C3.08115 20.7509 3.0812 20.943 2.96284 21.0615C2.90364 21.1208 2.82592 21.1504 2.74825 21.1504Z" fill="#424852"/>
                                        <path d="M1.22009 21.1505C1.14237 21.1505 1.0647 21.1208 1.00545 21.0615C0.887088 20.943 0.887182 20.7509 1.00573 20.6325L2.5339 19.1061C2.6524 18.9877 2.84445 18.9877 2.9629 19.1063C3.08126 19.2248 3.08121 19.4169 2.96271 19.5353L1.4344 21.0618C1.37515 21.1209 1.29762 21.1505 1.22009 21.1505Z" fill="#424852"/>
                                        <path d="M24.2517 21.0771C24.174 21.0771 24.0963 21.0474 24.0371 20.9881L22.5107 19.4593C22.3923 19.3407 22.3924 19.1487 22.511 19.0303C22.6297 18.9119 22.8217 18.9122 22.94 19.0306L24.4664 20.5595C24.5847 20.678 24.5846 20.8701 24.466 20.9884C24.4069 21.0476 24.3294 21.0771 24.2517 21.0771Z" fill="#424852"/>
                                        <path d="M22.7253 21.0772C22.6478 21.0772 22.5702 21.0476 22.511 20.9885C22.3924 20.8701 22.3923 20.6781 22.5107 20.5596L24.0371 19.0307C24.1554 18.9122 24.3474 18.9119 24.4661 19.0303C24.5846 19.1487 24.5847 19.3408 24.4664 19.4593L22.94 20.9881C22.8807 21.0475 22.8031 21.0772 22.7253 21.0772Z" fill="#424852"/>
                                    </svg>
                    <p>Withdraw Records</p>
                    <span><i class="las la-angle-right fs-203"></i></span>
                </a>   
            </li>
        </ul>
        <ul class="box-settings-profile mt-1 mb-8">
            <li>
                <a href="#" class="list-setting-profile ">
                    <i class="las la-user-shield fs-203"></i>
                    <p>Costumer Service</p>
                    <i class="las la-angle-right fs-202"></i>
                </a> 
            </li>
            <li>
                <a href="#" class="list-setting-profile">
                    <i class="las la-info-circle fs-203"></i>                     
                    <p>Wa Group</p>
                   <i class="las la-angle-right fs-202"></i>
                </a>  
            </li>
            <li>
                <a href="{{ route('user.change.password') }}" class="list-setting-profile">
                    <i class="las la-key fs-203"></i>
                    <p>Password Reset</p>
                    <i class="las la-angle-right fs-202"></i>
                </a>   
            </li>
  
             <li>
                <a href="{{route ('user.logout')}}" class="list-setting-profile critical_color">
                    <i class="las la-power-off fs-203"></i>
                    <p class="text-danger">Logout</p>
                   <i class="las la-angle-right fs-202"></i>
                </a>   
            </li>
        </ul>
    </div>
    


      <style>
     .acti{
  color:blue;
  }
  .icon-scan-qr-code::before{
      content:'' !important;
      coloe:white
  }
 </style>
    <div class="bottom-navigation-bar">
        <div class="tf-container">
            <ul class="tf-navigation-bar">
                <li >
                    <a class="fw_6 d-flex justify-content-center align-items-center flex-column" href="https://raxyzen.com/system/team-details">
                      <i class="las la-users" style="font-size:20px"></i> Team</a> 
                </li>
               
                <li>
                    <a class="fw_4 d-flex justify-content-center align-items-center flex-column active"  href="https://raxyzen.com/system/balance-history">
                        <i class="las la-history" style="font-size:20px"></i> History</a> 
                </li>
                <li>
                    <a class="fw_4 d-flex justify-content-center align-items-center flex-column" href="https://raxyzen.com/system/dashboard">
                        <span class="icon-scan-qr-code"> <i class="las la-home text-white" style="font-size:22px"></i> </span> </a> 
                </li>
                 <li >
                    <a class="fw_4 d-flex justify-content-center align-items-center flex-column active" href="https://chat.whatsapp.com/Lk0W0HrSigAHetZhC7oKOt"><i class="lab la-whatsapp" style="font-size:18px"></i> WA Group</a> 
                </li>
                <li >
                    <a class="fw_6 d-flex justify-content-center align-items-center flex-column" href="https://raxyzen.com/system/profile-setting">
                      <i class="las la-user-cog" style="font-size:20px"></i> Profile</a> 
                </li>
            </ul>
        </div>
    </div>
    
      </div> <!-- page-wrapper end -->
  
    <script data-cfasync="false" src="/cdn-cgi/scripts/5c5dd728/cloudflare-static/email-decode.min.js"></script><script type="text/javascript" src="https://raxyzen.com/assets/templates/bit_gold//nayapay/javascript/jquery.min.js"></script>
    <script type="text/javascript" src="https://raxyzen.com/assets/templates/bit_gold//nayapay/javascript/bootstrap.min.js"></script>
    <script type="text/javascript" src="https://raxyzen.com/assets/templates/bit_gold//nayapay/javascript/swiper-bundle.min.js"></script>
    <script type="text/javascript" src="https://raxyzen.com/assets/templates/bit_gold//nayapay/javascript/swiper.js"></script>
    <script type="text/javascript" src="https://raxyzen.com/assets/templates/bit_gold//nayapay/javascript/main.js"></script>
   


  <link rel="stylesheet" href="https://raxyzen.com/assets/templates/bit_gold/css/iziToast.min.css">
<script src="https://raxyzen.com/assets/templates/bit_gold/js/iziToast.min.js"></script>


<script>
"use strict";
    function notify(status,message) {
        iziToast[status]({
            message: message,
            position: "topRight"
        });
    }
</script>

  
  
<script>
    $(document).ready(function() {
    $("[href]").each(function() {
        if (this.href == window.location.href) {
            $(this).addClass("acti");
            }
            $(this).removeClass("sex");
        });
    });

</script>  

<script>
    (function () {
        "use strict";
        $(document).on("change", ".langSel", function () {
            window.location.href = "https://raxyzen.com/change/" + $(this).val();
        });
    })();
</script>


</body>
</html>


   
@endsection
