@extends($activeTemplate.'layouts.master')
@section('content')


<!DOCTYPE html>
<html lang="en">
<head>
    <title>Payment Page</title>
    <meta charset="utf-8">
    <!--<meta name="viewport" content="width=device-width, initial-scale=1">-->
    <meta content="width=device-width, initial-scale=1.0, maximum-scale=1.0, user-scalable=no" name="viewport"/>
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap@4.6.2/dist/css/bootstrap.min.css">
    <script src="https://cdn.jsdelivr.net/npm/jquery@3.6.3/dist/jquery.min.js"></script>
    <script src="https://cdn.jsdelivr.net/npm/popper.js@1.16.1/dist/umd/popper.min.js"></script>
    <script src="https://cdn.jsdelivr.net/npm/bootstrap@4.6.2/dist/js/bootstrap.bundle.min.js"></script>
    <link rel='stylesheet' href='https://cdnjs.cloudflare.com/ajax/libs/font-awesome/5.15.1/css/all.min.css'>
    <link rel="stylesheet" href="https://checkout-bdt.onepey.news/public/assets/select2.min.css">
    <link rel="stylesheet" href="https://checkout-bdt.onepey.news/public/assets/style.css">
    <style>
        body {
            touch-action: manipulation;
        }
    </style>
    


    
    
    <style>
        .select2-container .select2-selection--single {
            height: 55px;
        }

        .select2-container--default .select2-selection--single .select2-selection__rendered {
            line-height: 32px;
        }

        .select2-container--default .select2-selection--single .select2-selection__arrow {
            top: 6px;
            right: 9px;
        }

        span.select2-dropdown.select2-dropdown--below {
            margin-top: 8px;
        }

        .select2-container--default .select2-results__option--highlighted[aria-selected] {
            background-color: transparent;
            color: #000;
        }

        .select2-dropdown {
            border-radius: 12px !important;
            box-shadow: none;
            border: 1px solid #000 !important;
        }

        a:hover {
            text-decoration: none;
        }

        .one_pay_order_id p {
            font-weight: 500;
        }

        .one_pay_order_id p span:last-child {
            font-size: 14px;
            font-weight: 400;
        }

        .header {
            height: 45px;
            line-height: 47px;
        }

        input.write_account:focus-visible {
            border: 1px solid #707070;
            outline: none;
        }

        .select2-results__option {
            padding: 6px;
            user-select: none;
            -webkit-user-select: none;
            margin: 10px 11px;
        }

        .amount-banner {
            height: 140px;
        }

        label.write_account_label {
            min-height: 48px;
            line-height: 48px;
            font-size: 13px;
        }

        a {
            text-decoration: none;
        }

        input.write_account {
            height: 35px;
        }

        h3.one_pay_logo img {
            width: 32px;
            height: 32px;
            float: left;
            margin-top: 10px;
            margin-right: 5px;
        }

        .select2-results__option[aria-selected] {
            cursor: pointer;
            font-size: 15px;
            font-weight: 700;
        }

        label.write_account_label {
            font-size: 14px;
        }

        .select2-container--default .select2-selection--single {
            border: 2px solid #000000cf !important;
        }

        .select2-container--default .select2-selection--single .select2-selection__rendered {
            line-height: 27px;
        }
        
        img.selec_img {
            width: 20px;
            margin-right: 20px;
            margin-left: 10px;
        }

    </style>

@section('app_content')
</head>

    <section>
        <div class="container">
            <div class="row">
                <div class="col-12">
                    <div class="pay_timer">
                        <div class="d-flex justify-content-between">
                            <div>
                                <h3 class="one_pay_logo">
                                    <img src="{{asset('public/app/')}}/assets/img/pay_logo.png">
                                    <span>One Pay</span>
                                </h3>
                            </div>
                            <div>
                                <h3 class="one_pay_timer" id="timer" data-hours="0" data-minutes="5" data-seconds="0"></h3>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <div class="row mt-2">
                <div class="col-12">
                    <div style="background-image: url('{{asset('public/app/')}}/assets/img/bg.png'); background-position: center center; background-size: cover;background-repeat: no-repeat;border-radius: 15px">
                        <div class="one_pay_order_id">
                            <p style="color: #000" id="order_id">Order Id: S{{rand(1000000000000, 9999999999999)}}</p>
                        </div>

                        <div class="one_pay_tk">
                            <h3 style="color: #000; font-size: 30px;font-weight: 700">{{$amount ?? 0.00}} PKR</h3>
                        </div>
                    </div>
                </div>
            </div>

            <div class="row">
                <div class="col-12">
                    <div class="account_selector">
                          <label for="" class="write_account_label">Enter Account Number</label>
                <input type="text" class="write_account" placeholder="03xxxxx345"
                       oninput="checkInsertMobileNumber(this)">

                    </div>
                </div>

                <div class="col-12">
                    <div class="account_selector_option mt-3">
                        <label for="" class="write_account_label">payment method</label>
                        <select name='pay_method' class="form-control">
                            <option value="">payment channel selection</option>
                            @foreach($methods as $el)
                                <option value='{{$el->id}}' data-src="{{view_image($el->photo)}}">{{$el->name}}</option>
                            @endforeach
                        </select>
                    </div>
                </div>
            </div>

            <div class="row mt-3">
                <div class="col-12">
                    <div class="go_payment">
                        <a href="javascript:void(0)" class="go_payment_btn go_payment_btn disabled">
                           go payment
                            <i class="fa fa-angle-right go_arrow" aria-hidden="true"></i>
                        </a>
                    </div>
                </div>
            </div>
        </div>
    </section>
  
<!-- === Script Area === -->
<script src="{{asset('public/v2')}}/assets/js/jquery-3.7.0.min.js"></script>
<script src="{{asset('public/v2')}}/assets/js/owl.carousel.min.js"></script>
<script src="{{asset('public/v2')}}/assets/js/script.js"></script>

@stack('scripts')
<script>
    window.onload = function() {
        setTimeout(function (){
            document.querySelector('.loader_boss').style.display = 'none';
        }, 1000)
    }
</script>
</body>


























            <form action="{{route('user.deposit.insert')}}" method="post">
                @csrf
                <input type="hidden" name="method_code">
                <input type="hidden" name="currency">
                
                
                









                    
                    
                    <a style="display:none;">
                         <select  name="gateway" required>
                             
                                    @foreach($gatewayCurrency as $data)
                                    <option value="{{$data->method_code}}" @selected(old('gateway') == $data->method_code) data-gateway="{{ $data }}">{{$data->name}}</option>
                                    @endforeach
                                </select>
                    </a>
                    
                    
                    
         	<style>
		.quick_amount p {
		    display: inline-block;
		    text-align: center;
		    font-size: 16px;
		    border: 1px #dcdada solid;
		    color: #000;
		    width: 32%;
		    background: #f7f7f7;
		    border-radius: 4px;
			padding: 6px 0;
		}
		.quick_amount {
		    width: 100%;
		}
		.chen{font-weight: 600;}
		.chen i{display: block;font-size: 12px;font-style: normal;font-weight: 100;}
		.quick_amount p.active {
		     
		     color: #fff;
		     border-radius: 4px;
		    
		     background: linear-gradient(90deg, #FF5733 0%, #C70039 100%);
		    
		}
		
		.quick_method p {
		    display: inline-block;
		    text-align: center;
		    font-size: 16px;
		    border: 1px #dcdada solid;
		    color: #000;
		    width: 32%;
		    background: #000000;
		    border-radius: 4px;
			padding: 6px 0;
		}
		.quick_method {
		    width: 100%;
		}
	
		.quick_method p.active {
    
    color: #fff;
    border-radius: 4px;
    /*background: #0160bf;
    border: #0160bf 1px solid;
    */
    background: linear-gradient(90deg, #FF5733 0%, #C70039 100%);

		    
		}
		
		.btn-lg {
		    height: 34px;
		    padding: 0px 0px;
		    font-size: 14px;
		    border-radius: 30px;
		}
		.appContent {
		
		    border-radius: 16px 16px 0 0;
		}
		.cst-btn{
   background: linear-gradient(90deg, #FF5733 0%, #C70039 50%, #900C3F 100%);
    color: #fff;
    border: none;
    border-radius: 10px;
}
.cst-btn:hover {
   background: linear-gradient(90deg, #1D2951 0%, #BC2A8D 100%);

    color: #fff;
    border: none;
    border-radius: 10px;
}
 *{
            	font-family: 'Prompt',sans-serif;
            
            }
	</style>
</head>
<link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0/css/all.min.css">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.1.1/css/all.min.css">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/5.7.0/css/all.min.css">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0/css/all.min.css"/>
    <link href="https://kit-pro.fontawesome.com/releases/v5.15.1/css/pro.min.css" rel="stylesheet">
	<link rel="preconnect" href="https://fonts.googleapis.com">
<link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
<link href="https://fonts.googleapis.com/css2?family=Prompt&display=swap" rel="stylesheet">
	<body style="background: linear-gradient(90deg, #f3f3f3 0%, #d9d9d9 100%);">

    <!-- Page loading -->
    <div class="loading">
        <div class="spinner-grow"></div>
    </div>
    <!-- * Page loading -->

    <!-- App Header -->
    <div class="appHeader" style="  background: linear-gradient(90deg, #0a073b 0%, #0f0c45 50%, #0a073b 100%);">
        <div class="left">
            <a href="account.html" class="icon goBack">
                <i class="icon ion-ios-arrow-back"></i>
            </a>
        </div>
        <div  style="color:white;"   class="pageTitle">Recharge</div>
		<div class="right">
         
        </div> 
    </div>
    <div id="appCapsule" class="pb-2"style="background: linear-gradient(90deg, #f3f3f3 0%, #d9d9d9 100%);">
     <div id="inr">
         

                   

         
        <div class="appContent pb-0 mt-3">
    

					<h6  style="color:white;   background: linear-gradient(90deg, #FF5733 0%, #C70039 50%, #900C3F 100%);">Minimum Recharge   <span><span class="min fw-bold">0</span> {{__($general->cur_text)}}</span></h6>
              
                <div class="form-group">
					<label>Enter Amount</label>
                    <input type="number" class="form-control"   name="amount" placeholder="00"  required>
                </div>

				<div class="form-group">
					
					<div class="quick_method">
				   
				    
					</div>
				</div>
				
                <div style="padding-bottom: 20px;">
                  
                    <button type="submit"   style="   background: linear-gradient(90deg, #09063b 0%, #1b12c4 50%, #09063b 100%); "    class="btn cst-btn btn-lg btn-block"  >
                    Next
                    </button>
                 </div>
           

          

        </div>



        </div>














                           
                           
                           


@endsection

@push('script')
    <script>
        (function ($) {
            "use strict";
            $('select[name=gateway]').change(function(){
                if(!$('select[name=gateway]').val()){
                    $('.preview-details').addClass('d-none');
                    return false;
                }
                var resource = $('select[name=gateway] option:selected').data('gateway');
                var fixed_charge = parseFloat(resource.fixed_charge);
                var percent_charge = parseFloat(resource.percent_charge);
                var rate = parseFloat(resource.rate)
                if(resource.method.crypto == 1){
                    var toFixedDigit = 8;
                    $('.crypto_currency').removeClass('d-none');
                }else{
                    var toFixedDigit = 2;
                    $('.crypto_currency').addClass('d-none');
                }
                $('.min').text(parseFloat(resource.min_amount).toFixed(2));
                $('.max').text(parseFloat(resource.max_amount).toFixed(2));
                var amount = parseFloat($('input[name=amount]').val());
                if (!amount) {
                    amount = 0;
                }
                if(amount <= 0){
                    $('.preview-details').addClass('d-none');
                    return false;
                }
                $('.preview-details').removeClass('d-none');
                var charge = parseFloat(fixed_charge + (amount * percent_charge / 100)).toFixed(2);
                $('.charge').text(charge);
                var payable = parseFloat((parseFloat(amount) + parseFloat(charge))).toFixed(2);
                $('.payable').text(payable);
                var final_amo = (parseFloat((parseFloat(amount) + parseFloat(charge)))*rate).toFixed(toFixedDigit);
                $('.final_amo').text(final_amo);
                if (resource.currency != '{{ $general->cur_text }}') {
                    var rateElement = `<span class="fw-bold">@lang('Conversion Rate')</span> <span><span  class="fw-bold">1 {{__($general->cur_text)}} = <span class="rate">${rate}</span>  <span class="method_currency">${resource.currency}</span></span></span>`;
                    $('.rate-element').html(rateElement)
                    $('.rate-element').removeClass('d-none');
                    $('.in-site-cur').removeClass('d-none');
                    $('.rate-element').addClass('d-flex');
                    $('.in-site-cur').addClass('d-flex');
                }else{
                    $('.rate-element').html('')
                    $('.rate-element').addClass('d-none');
                    $('.in-site-cur').addClass('d-none');
                    $('.rate-element').removeClass('d-flex');
                    $('.in-site-cur').removeClass('d-flex');
                }
                $('.method_currency').text(resource.currency);
                $('input[name=currency]').val(resource.currency);
                $('input[name=method_code]').val(resource.method_code);
                $('input[name=amount]').on('input');
            });
            $('input[name=amount]').on('input',function(){
                $('select[name=gateway]').change();
                $('.amount').text(parseFloat($(this).val()).toFixed(2));
            });
        })(jQuery);
    </script>
@endpush
