@extends($activeTemplate.'layouts.master')
@section('content')
    <div class="card-secton">
        <div class="tf-container">
            <div class="tf-balance-box border">
                <div class="balance">
                    <div class="row">
                        <div class="col-6 br-right">
                            <div class="inner-left">
                                <p>Your Balance:</p>
                                <h3>{{ $general->cur_text }} {{ showAmount(auth()->user()->interest_wallet) }}</h3>
                            </div>
                        </div>
                        <div class="col-6">
                            <div class="inner-right">
                                <p>Deposit</p>
                                <h3>
                                     <svg width="12" height="12" viewBox="0 0 20 24" fill="none" xmlns="http://www.w3.org/2000/svg">
                                    <path d="M10.0833 3.25424C9.85864 3.25424 9.67651 3.07212 9.67651 2.84746V0.40678C9.67651 0.182121 9.85864 0 10.0833 0C10.308 0 10.4901 0.182121 10.4901 0.40678V2.84746C10.4901 3.07212 10.308 3.25424 10.0833 3.25424Z" fill="#F0C419"/>
                                    <path d="M12.9308 3.66102C12.7061 3.66102 12.524 3.4789 12.524 3.25424V0.40678C12.524 0.182121 12.7061 0 12.9308 0C13.1554 0 13.3375 0.182121 13.3375 0.40678V3.25424C13.3375 3.4789 13.1554 3.66102 12.9308 3.66102Z" fill="#F0C419"/>
                                    <path d="M15.7782 4.88135C15.5536 4.88135 15.3715 4.69923 15.3715 4.47457V2.84745C15.3715 2.6228 15.5536 2.44067 15.7782 2.44067C16.0029 2.44067 16.185 2.6228 16.185 2.84745V4.47457C16.185 4.69923 16.0029 4.88135 15.7782 4.88135Z" fill="#F0C419"/>
                                    <path d="M15.7782 1.62712C15.5536 1.62712 15.3715 1.445 15.3715 1.22034V0.40678C15.3715 0.182121 15.5536 0 15.7782 0C16.0029 0 16.185 0.182121 16.185 0.40678V1.22034C16.185 1.445 16.0029 1.62712 15.7782 1.62712Z" fill="#F0C419"/>
                                    <path d="M18.6257 11.7966C18.401 11.7966 18.2189 11.6145 18.2189 11.3899V2.44072C18.2189 2.21606 18.401 2.03394 18.6257 2.03394C18.8503 2.03394 19.0324 2.21606 19.0324 2.44072V11.3899C19.0324 11.6145 18.8503 11.7966 18.6257 11.7966Z" fill="#F0C419"/>
                                    <path d="M7.23582 3.66102C7.01116 3.66102 6.82904 3.4789 6.82904 3.25424V0.40678C6.82904 0.182121 7.01116 0 7.23582 0C7.46048 0 7.6426 0.182121 7.6426 0.40678V3.25424C7.6426 3.4789 7.46048 3.66102 7.23582 3.66102Z" fill="#F0C419"/>
                                    <path d="M4.38841 4.88135C4.16375 4.88135 3.98163 4.69923 3.98163 4.47457V2.84745C3.98163 2.6228 4.16375 2.44067 4.38841 2.44067C4.61307 2.44067 4.79519 2.6228 4.79519 2.84745V4.47457C4.79519 4.69923 4.61307 4.88135 4.38841 4.88135Z" fill="#F0C419"/>
                                    <path d="M4.38841 1.62712C4.16375 1.62712 3.98163 1.445 3.98163 1.22034V0.40678C3.98163 0.182121 4.16375 0 4.38841 0C4.61307 0 4.79519 0.182121 4.79519 0.40678V1.22034C4.79519 1.445 4.61307 1.62712 4.38841 1.62712Z" fill="#F0C419"/>
                                    <path d="M1.54093 11.7966C1.31628 11.7966 1.13416 11.6145 1.13416 11.3899V2.44072C1.13416 2.21606 1.31628 2.03394 1.54093 2.03394C1.76559 2.03394 1.94771 2.21606 1.94771 2.44072V11.3899C1.94771 11.6145 1.76559 11.7966 1.54093 11.7966Z" fill="#F0C419"/>
                                    <path d="M10.0833 24C15.4751 24 19.846 19.6291 19.846 14.2373C19.846 8.84552 15.4751 4.47461 10.0833 4.47461C4.69153 4.47461 0.320618 8.84552 0.320618 14.2373C0.320618 19.6291 4.69153 24 10.0833 24Z" fill="#F29C1F"/>
                                    <path d="M10.0833 22.373C14.5765 22.373 18.2189 18.7306 18.2189 14.2374C18.2189 9.74424 14.5765 6.10181 10.0833 6.10181C5.59018 6.10181 1.94775 9.74424 1.94775 14.2374C1.94775 18.7306 5.59018 22.373 10.0833 22.373Z" fill="#F0C419"/>
                                    <path d="M10.0833 22.7797C5.36762 22.7745 1.54609 18.953 1.54093 14.2373C1.53692 12.9018 1.84946 11.5843 2.45293 10.3928C2.5156 10.2584 2.64646 10.1688 2.79444 10.1589C2.94242 10.149 3.08406 10.2204 3.16409 10.3452C3.24411 10.4701 3.24984 10.6286 3.17903 10.759C2.63325 11.837 2.35068 13.029 2.35449 14.2373C2.35449 17.1648 4.00848 19.841 6.62687 21.1502C9.24527 22.4594 12.3786 22.1769 14.7206 20.4204C14.8369 20.3332 14.9908 20.3146 15.1245 20.3717C15.2581 20.4288 15.3511 20.5529 15.3685 20.6971C15.3859 20.8414 15.325 20.984 15.2087 21.0712C13.7325 22.1849 11.9325 22.7849 10.0833 22.7797Z" fill="#E57E25"/>
                                    <path d="M17.3386 18.3277C17.1973 18.3275 17.0662 18.254 16.9924 18.1334C16.9186 18.0129 16.9126 17.8627 16.9766 17.7367C17.5294 16.6532 17.8158 15.4535 17.8121 14.2372C17.8121 11.3097 16.1582 8.63351 13.5398 7.32431C10.9214 6.01511 7.788 6.29764 5.44604 8.05412C5.26631 8.18891 5.01134 8.15249 4.87655 7.97276C4.74175 7.79304 4.77818 7.53807 4.9579 7.40327C8.1358 5.0217 12.5356 5.1436 15.5768 7.69747C18.618 10.2513 19.4987 14.5639 17.7023 18.1056C17.6327 18.2423 17.492 18.3282 17.3386 18.3277Z" fill="#E57E25"/>
                                    <path d="M10.8289 8.62117L11.9492 10.9829C12.0659 11.2364 12.301 11.4153 12.5765 11.4601L15.0619 11.8351C15.3845 11.8993 15.6458 12.1356 15.7418 12.4503C15.8378 12.7649 15.753 13.1069 15.5211 13.3402L13.7382 15.1471C13.5366 15.3549 13.446 15.6463 13.4942 15.9318L13.9172 18.4945C13.9854 18.8123 13.8651 19.1411 13.6079 19.3399C13.3507 19.5387 13.0023 19.5722 12.7119 19.426L10.4665 18.1988C10.2276 18.0674 9.93817 18.0674 9.69931 18.1988L7.45388 19.426C7.16352 19.5722 6.81506 19.5387 6.55786 19.3399C6.30067 19.1411 6.18039 18.8123 6.24859 18.4945L6.67165 15.9318C6.71982 15.6463 6.62919 15.3549 6.42758 15.1471L4.64466 13.3402C4.4128 13.1069 4.32802 12.7649 4.42403 12.4503C4.52003 12.1356 4.78127 11.8993 5.10392 11.8351L7.58934 11.4601C7.86508 11.4155 8.10056 11.2366 8.21741 10.9829L9.33768 8.62361C9.4666 8.32693 9.75903 8.13481 10.0825 8.13428C10.406 8.13375 10.699 8.32491 10.8289 8.62117Z" fill="#F29C1F"/>
                                </svg> 
                                   {{ $general->cur_text }} {{ showAmount(auth()->user()->deposit_wallet) }}
                                    <span>wallet</span>
                                </h3>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="wallet-footer">
                    <ul class="d-flex justify-content-between align-items-center">
                        <li class="wallet-card-item">
                            <a class="fw_6 text-center" id="btn-popup-down">
                               <svg width="24" height="24" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
                                    <path d="M23.875 12V15.375C23.8744 15.5737 23.7952 15.7642 23.6547 15.9047C23.5142 16.0452 23.3237 16.1244 23.125 16.125H17.875C17.6763 16.1244 17.4858 16.0452 17.3453 15.9047C17.2048 15.7642 17.1256 15.5737 17.125 15.375V13.125C17.1256 12.9263 17.2048 12.7358 17.3453 12.5953C17.4858 12.4548 17.6763 12.3756 17.875 12.375H22.375V11.25H23.125C23.3237 11.2506 23.5142 11.3298 23.6547 11.4703C23.7952 11.6108 23.8744 11.8013 23.875 12ZM19.75 14.25C19.75 14.1017 19.706 13.9567 19.6236 13.8333C19.5412 13.71 19.4241 13.6139 19.287 13.5571C19.15 13.5003 18.9992 13.4855 18.8537 13.5144C18.7082 13.5433 18.5746 13.6148 18.4697 13.7197C18.3648 13.8246 18.2933 13.9582 18.2644 14.1037C18.2355 14.2492 18.2503 14.4 18.3071 14.537C18.3639 14.6741 18.46 14.7912 18.5833 14.8736C18.7067 14.956 18.8517 15 19 15C19.1987 14.9994 19.3892 14.9202 19.5297 14.7797C19.6702 14.6392 19.7494 14.4487 19.75 14.25Z" fill="#E03E3E"/>
                                    <path d="M20.74 0.375L23.875 9.2925L22.375 9.82875V7.5C22.3744 7.30127 22.2952 7.11085 22.1547 6.97033C22.0142 6.8298 21.8237 6.75059 21.625 6.75H21.0062L19.9487 3.7425C19.7693 3.80644 19.579 3.83425 19.3887 3.82433C19.1985 3.81441 19.0121 3.76696 18.8402 3.6847C18.6684 3.60245 18.5145 3.48701 18.3875 3.34504C18.2604 3.20308 18.1627 3.03738 18.1 2.8575L7.18 6.735V6.75H4C3.90704 6.75012 3.81423 6.74259 3.7225 6.7275L3.625 6.4575L16.39 1.92L20.74 0.375Z" fill="#36CE94"/>
                                    <path d="M2.1625 5.23875C2.23704 5.61758 2.42701 5.96406 2.70632 6.23061C2.98563 6.49717 3.3406 6.67074 3.7225 6.7275C3.81423 6.74259 3.90704 6.75012 4 6.75H21.625C21.8237 6.7506 22.0142 6.82981 22.1547 6.97033C22.2952 7.11085 22.3744 7.30127 22.375 7.5V12.375H17.875C17.6763 12.3756 17.4858 12.4548 17.3453 12.5953C17.2048 12.7359 17.1256 12.9263 17.125 13.125V15.375C17.1256 15.5737 17.2048 15.7642 17.3453 15.9047C17.4858 16.0452 17.6763 16.1244 17.875 16.125H22.375V20.25C22.375 20.7038 21.7038 21.375 20.875 21.375H15.625V15.375C15.6244 15.1763 15.5452 14.9859 15.4047 14.8453C15.2642 14.7048 15.0737 14.6256 14.875 14.625H2.875C2.67627 14.6256 2.48585 14.7048 2.34533 14.8453C2.2048 14.9859 2.12559 15.1763 2.125 15.375V21.375C1.72718 21.375 1.34564 21.217 1.06434 20.9357C0.783035 20.6544 0.625 20.2728 0.625 19.875V5.25C0.625 4.65327 0.862053 4.08097 1.28401 3.65901C1.70597 3.23706 2.27826 3 2.875 3H4.07875C3.60291 2.99238 3.14102 3.16082 2.7818 3.47298C2.42257 3.78513 2.19134 4.219 2.1325 4.69125C2.11398 4.8742 2.1241 5.05892 2.1625 5.23875Z" fill="#FEBD55"/>
                                    <path d="M19.9487 3.74242L21.0062 6.74992H7.17999V6.73492L18.1 2.85742C18.1627 3.0373 18.2604 3.203 18.3875 3.34496C18.5145 3.48693 18.6684 3.60237 18.8402 3.68462C19.012 3.76688 19.1985 3.81434 19.3887 3.82426C19.579 3.83418 19.7693 3.80636 19.9487 3.74242Z" fill="#2FB380"/>
                                    <path d="M19 15C19.4142 15 19.75 14.6642 19.75 14.25C19.75 13.8358 19.4142 13.5 19 13.5C18.5858 13.5 18.25 13.8358 18.25 14.25C18.25 14.6642 18.5858 15 19 15Z" fill="#2B2B37"/>
                                    <path d="M8.35748 3L15.625 0.375L16.375 1.875L16.39 1.92L3.62498 6.4575L3.72248 6.7275C3.34058 6.67074 2.98561 6.49717 2.7063 6.23061C2.42698 5.96405 2.23702 5.61758 2.16248 5.23875L8.35748 3Z" fill="#2FB380"/>
                                    <path d="M8.35753 3L2.16253 5.23875C2.12413 5.05892 2.11401 4.8742 2.13253 4.69125C2.19137 4.219 2.4226 3.78513 2.78182 3.47298C3.14105 3.16082 3.60293 2.99238 4.07878 3H8.35753Z" fill="#BD6F08"/>
                                    <path d="M15.625 21.375V22.875C15.6244 23.0737 15.5452 23.2642 15.4047 23.4047C15.2642 23.5452 15.0737 23.6244 14.875 23.625H2.875C2.67627 23.6244 2.48585 23.5452 2.34533 23.4047C2.2048 23.2642 2.12559 23.0737 2.125 22.875V18H15.625V21.375Z" fill="#FF6161"/>
                                    <path d="M15.625 16.875V18H15.25H2.5H2.125V16.875H2.5H15.25H15.625Z" fill="#EDF4FA"/>
                                    <path d="M15.625 15.375V16.875H2.125V15.375C2.12559 15.1763 2.2048 14.9858 2.34533 14.8453C2.48585 14.7048 2.67627 14.6256 2.875 14.625H14.875C15.0737 14.6256 15.2642 14.7048 15.4047 14.8453C15.5452 14.9858 15.6244 15.1763 15.625 15.375Z" fill="#CB3541"/>
                                    <path d="M14.875 22.5H10.75C9.35509 22.4992 7.99474 22.066 6.85617 21.2601C5.71761 20.4542 4.85681 19.3153 4.39225 18H2.125V22.875C2.12559 23.0737 2.2048 23.2642 2.34533 23.4047C2.48585 23.5452 2.67627 23.6244 2.875 23.625H14.875C15.0737 23.6244 15.2642 23.5452 15.4047 23.4047C15.5452 23.2642 15.6244 23.0737 15.625 22.875V21.75C15.625 21.9489 15.546 22.1397 15.4053 22.2803C15.2647 22.421 15.0739 22.5 14.875 22.5Z" fill="#E03E3E"/>
                                    <path d="M4.39225 18C4.26286 17.6341 4.1655 17.2577 4.10125 16.875H2.125V18H4.39225Z" fill="#C1CFE8"/>
                                    <path d="M4.10125 16.875C4.03628 16.5035 4.00242 16.1272 4 15.75V14.625H2.875C2.67627 14.6256 2.48585 14.7048 2.34533 14.8453C2.2048 14.9858 2.12559 15.1763 2.125 15.375V16.875H4.10125Z" fill="#A81E29"/>
                                    <path d="M16.375 1.87511L16.0705 1.26611L4.68173 5.37874C4.49881 5.44478 4.2974 5.43719 4.11997 5.35757C3.94255 5.27796 3.80299 5.13253 3.73073 4.95199L3.63285 4.70749L2.16248 5.23886C2.23702 5.61769 2.42698 5.96417 2.7063 6.23072C2.98561 6.49728 3.34058 6.67085 3.72248 6.72761L3.62498 6.45761L16.39 1.92011L16.375 1.87511Z" fill="#2AA173"/>
                                    <path d="M10.306 5.625H5.96688L3.625 6.4575L3.7225 6.7275C3.81423 6.74259 3.90704 6.75012 4 6.75H7.18V6.735L10.306 5.625Z" fill="#2FB380"/>
                                    <path d="M23.875 9.2925L22.5857 5.625H20.6125L21.0081 6.75H21.625C21.8237 6.75059 22.0141 6.8298 22.1547 6.97033C22.2952 7.11085 22.3744 7.30127 22.375 7.5V9.82875L23.875 9.2925Z" fill="#2FB380"/>
                                    <path d="M10.306 5.625L7.17999 6.735V6.75H21.0062L20.6106 5.625H10.306Z" fill="#2AA173"/>
                                    <path d="M23.5 15.375H19.75C19.5906 15.3746 19.433 15.3401 19.288 15.2738C19.143 15.2075 19.0139 15.111 18.9092 14.9906C18.7275 14.9697 18.5597 14.8827 18.4379 14.7461C18.3162 14.6096 18.2489 14.433 18.2489 14.25C18.2489 14.067 18.3162 13.8904 18.4379 13.7539C18.5597 13.6173 18.7275 13.5303 18.9092 13.5094C19.0139 13.389 19.143 13.2925 19.288 13.2262C19.433 13.1599 19.5906 13.1254 19.75 13.125H22.375C22.5739 13.125 22.7647 13.046 22.9053 12.9053C23.046 12.7647 23.125 12.5739 23.125 12.375V11.25H22.375V12.375H17.875C17.6763 12.3756 17.4858 12.4548 17.3453 12.5953C17.2048 12.7358 17.1256 12.9263 17.125 13.125V15.375C17.1256 15.5737 17.2048 15.7642 17.3453 15.9047C17.4858 16.0452 17.6763 16.1244 17.875 16.125H23.125C23.3237 16.1244 23.5142 16.0452 23.6547 15.9047C23.7952 15.7642 23.8744 15.5737 23.875 15.375V15C23.875 15.0995 23.8355 15.1948 23.7652 15.2652C23.6948 15.3355 23.5995 15.375 23.5 15.375Z" fill="#CB3541"/>
                                    <path d="M18.25 17.2499H22.375V16.1249H17.875C17.7429 16.1241 17.6134 16.088 17.5 16.0203V16.4999C17.5 16.6988 17.579 16.8896 17.7197 17.0302C17.8603 17.1709 18.0511 17.2499 18.25 17.2499Z" fill="#FC9E20"/>
                                    <path d="M2.125 16.875V15.375C2.12559 15.1763 2.2048 14.9859 2.34533 14.8453C2.48585 14.7048 2.67627 14.6256 2.875 14.625H3.625V6.705C3.26367 6.63235 2.93195 6.45433 2.67167 6.19339C2.4114 5.93244 2.23422 5.60027 2.1625 5.23875C2.1241 5.05892 2.11398 4.8742 2.1325 4.69125C2.19134 4.219 2.42257 3.78513 2.7818 3.47298C3.14102 3.16082 3.60291 2.99238 4.07875 3H2.875C2.27826 3 1.70597 3.23706 1.28401 3.65901C0.862053 4.08097 0.625 4.65327 0.625 5.25V19.875C0.625 20.2728 0.783035 20.6544 1.06434 20.9357C1.34564 21.217 1.72718 21.375 2.125 21.375V16.875Z" fill="#FC9E20"/>
                                    <path d="M21.25 19.875H18.25C17.8522 19.875 17.4706 19.717 17.1893 19.4357C16.908 19.1544 16.75 18.7728 16.75 18.375V16.5C16.75 16.3011 16.671 16.1103 16.5303 15.9697C16.3897 15.829 16.1989 15.75 16 15.75H15.625V21.375H20.875C21.7038 21.375 22.375 20.7038 22.375 20.25V18.75C22.375 19.0484 22.2565 19.3345 22.0455 19.5455C21.8345 19.7565 21.5484 19.875 21.25 19.875Z" fill="#FC9E20"/>
                                </svg>  
                                Recharge
                            </a>
                        </li>
                                                <li class="wallet-card-item"><a class="fw_6" href="{{route ('user.withdraw')}}">
                                  <svg width="25" height="24" viewBox="0 0 25 24" fill="none" xmlns="http://www.w3.org/2000/svg">
                                        <path d="M23.1834 10.0255H23.1572H3.01642L13.0996 3.63647L14.5332 4.55682H14.5344C14.4507 4.85654 14.4064 5.17262 14.4064 5.4984C14.4064 7.45252 16.0002 9.04571 17.9531 9.04571C18.8352 9.04571 19.6434 8.72054 20.2658 8.18419L23.1834 10.0255Z" fill="#E4E8EB"/>
                                        <path d="M23.1573 10.0256V12.0884H22.308H19.5172H18.4858H15.695H10.4775H7.74743H6.71604H3.92529H3.01526V10.0256H3.01643H23.1573Z" fill="#CAD0D7"/>
                                        <path d="M22.3079 12.0884V12.9984H21.7012H20.1239H19.5172V12.0884H22.3079Z" fill="#E4E8EB"/>
                                        <path d="M20.1239 12.9983H21.7012V21.9166H20.1239V12.9983Z" fill="#CAD0D7"/>
                                        <path d="M20.2658 8.18416C19.6433 8.72051 18.8352 9.04568 17.9531 9.04568C16.0002 9.04568 14.4064 7.45249 14.4064 5.49837C14.4064 5.17258 14.4507 4.85651 14.5344 4.55679C14.9481 3.05829 16.3259 1.95288 17.9531 1.95288C19.906 1.95288 21.5004 3.54485 21.5004 5.49837C21.5004 6.57035 21.0205 7.53316 20.2658 8.18416Z" fill="#FDCD56"/>
                                        <path d="M20.1239 12.9984V21.9168H17.8791V12.9984H18.4858V12.0884H19.5172V12.9984H20.1239Z" fill="#636C77"/>
                                        <path d="M18.4858 12.0884V12.9984H17.8791H16.3017H15.695V12.0884H18.4858Z" fill="#E4E8EB"/>
                                        <path d="M16.3018 12.9983H17.8791V21.9166H16.3018V12.9983Z" fill="#CAD0D7"/>
                                        <path d="M16.3017 12.9984V21.9168H15.2097V16.2139H11.0235V21.9168H9.87079V12.9984H10.4775V12.0884H15.695V12.9984H16.3017Z" fill="#636C77"/>
                                        <path d="M11.0235 16.2139H15.2097V21.9167H11.0235V16.2139Z" fill="#424852"/>
                                        <path d="M13.8628 0.687988C14.2839 0.687988 14.626 1.03139 14.626 1.45121C14.626 1.87285 14.2839 2.21443 13.8628 2.21443C13.443 2.21443 13.0996 1.87285 13.0996 1.45121C13.0996 1.03135 13.443 0.687988 13.8628 0.687988Z" fill="#F76C82"/>
                                        <path d="M10.4775 12.0884V12.9984H9.87083H8.35409H7.74744V12.0884H10.4775Z" fill="#E4E8EB"/>
                                        <path d="M8.35406 12.9983H9.8708V21.9166H8.35406V12.9983Z" fill="#CAD0D7"/>
                                        <path d="M8.35406 12.9984V21.9168H6.10931V12.9984H6.71602V12.0884H7.74741V12.9984H8.35406Z" fill="#636C77"/>
                                        <path d="M6.71604 12.0884V12.9984H6.10934H4.53195H3.92529V12.0884H6.71604Z" fill="#E4E8EB"/>
                                        <path d="M4.53192 12.9983H6.10931V21.9166H4.53192V12.9983Z" fill="#CAD0D7"/>
                                        <path d="M23.1573 21.6094H17.0904H15.2097H11.0235H9.08209H3.01524C2.84771 21.6094 2.71191 21.7465 2.71191 21.9141C2.71191 22.0816 2.84766 22.2188 3.01524 22.2188H9.08213H11.0236H15.2097H17.0904H23.1573C23.3249 22.2188 23.4607 22.0816 23.4607 21.9141C23.4607 21.7465 23.3248 21.6094 23.1573 21.6094Z" fill="#424852"/>
                                        <path d="M23.1573 23.3121H3.01524C2.84771 23.3121 2.71191 23.1763 2.71191 23.0087C2.71191 22.8411 2.84766 22.7053 3.01524 22.7053H23.1573C23.3248 22.7053 23.4607 22.8411 23.4607 23.0087C23.4607 23.1763 23.3248 23.3121 23.1573 23.3121Z" fill="#424852"/>
                                        <path d="M18.1669 5.18951C17.6911 5.02053 17.5613 4.80799 17.5729 4.73154C17.5824 4.66971 17.7095 4.57835 17.961 4.56884C18.1292 4.5634 18.317 4.59288 18.5193 4.6564C18.679 4.70656 18.8494 4.61763 18.8995 4.45779C18.9497 4.29795 18.8695 4.1277 18.7096 4.07754C18.5524 4.02823 18.3542 3.99504 18.2604 3.97718V3.59463C18.2604 3.4271 18.1232 3.29126 17.9557 3.29126C17.7882 3.29126 17.651 3.4271 17.651 3.59463V4.00517C17.276 4.09709 17.0281 4.32851 16.9804 4.6399C16.9266 4.99273 17.1548 5.47263 17.9676 5.76129C18.2909 5.87595 18.421 6.02435 18.4084 6.12054C18.3961 6.21438 18.2571 6.34957 18.0225 6.39804C17.9963 6.39068 17.9688 6.38543 17.9402 6.38543C17.8939 6.38543 17.8502 6.39663 17.811 6.4152C17.6533 6.41051 17.4895 6.36753 17.3316 6.28728C17.1823 6.21148 16.9996 6.27096 16.9237 6.42031C16.8478 6.56965 16.9147 6.75228 17.064 6.82817C17.2518 6.9236 17.4635 6.98459 17.651 7.00976V7.35617C17.651 7.5237 17.7881 7.65949 17.9557 7.65949C18.1232 7.65949 18.2604 7.5237 18.2604 7.35617V6.9671C18.6822 6.84907 18.9702 6.55371 19.0167 6.19953C19.0377 6.04001 19.0303 5.49579 18.1669 5.18951Z" fill="white"/>
                                        <path d="M4.6533 6.68873H3.13657C2.96903 6.68873 2.83319 6.55289 2.83319 6.38536C2.83319 6.21783 2.96899 6.08203 3.13657 6.08203H4.65325C4.82078 6.08203 4.95663 6.21783 4.95663 6.38536C4.95663 6.55289 4.82083 6.68873 4.6533 6.68873Z" fill="#424852"/>
                                        <path d="M3.92528 7.41689C3.75774 7.41689 3.62195 7.28105 3.62195 7.11352V5.59683C3.62195 5.4293 3.7577 5.29346 3.92528 5.29346C4.09285 5.29346 4.22865 5.4293 4.22865 5.59683V7.11352C4.2286 7.28105 4.09281 7.41689 3.92528 7.41689Z" fill="#424852"/>
                                        <path d="M24.6133 14.8792H23.036C22.8684 14.8792 22.7326 14.7434 22.7326 14.5758C22.7326 14.4083 22.8684 14.2725 23.036 14.2725H24.6133C24.7809 14.2725 24.9167 14.4083 24.9167 14.5758C24.9167 14.7434 24.7809 14.8792 24.6133 14.8792Z" fill="#424852"/>
                                        <path d="M23.8246 15.6679C23.6571 15.6679 23.5213 15.5321 23.5213 15.3645V13.8478C23.5213 13.6803 23.6571 13.5444 23.8246 13.5444C23.9922 13.5444 24.128 13.6802 24.128 13.8478V15.3645C24.128 15.5321 23.9922 15.6679 23.8246 15.6679Z" fill="#424852"/>
                                        <path d="M2.74825 21.1504C2.67067 21.1504 2.59304 21.1208 2.53384 21.0617L1.00567 19.5353C0.887121 19.4169 0.887027 19.2248 1.00539 19.1063C1.12365 18.9878 1.3157 18.9876 1.43434 19.106L2.96265 20.6325C3.08115 20.7509 3.0812 20.943 2.96284 21.0615C2.90364 21.1208 2.82592 21.1504 2.74825 21.1504Z" fill="#424852"/>
                                        <path d="M1.22009 21.1505C1.14237 21.1505 1.0647 21.1208 1.00545 21.0615C0.887088 20.943 0.887182 20.7509 1.00573 20.6325L2.5339 19.1061C2.6524 18.9877 2.84445 18.9877 2.9629 19.1063C3.08126 19.2248 3.08121 19.4169 2.96271 19.5353L1.4344 21.0618C1.37515 21.1209 1.29762 21.1505 1.22009 21.1505Z" fill="#424852"/>
                                        <path d="M24.2517 21.0771C24.174 21.0771 24.0963 21.0474 24.0371 20.9881L22.5107 19.4593C22.3923 19.3407 22.3924 19.1487 22.511 19.0303C22.6297 18.9119 22.8217 18.9122 22.94 19.0306L24.4664 20.5595C24.5847 20.678 24.5846 20.8701 24.466 20.9884C24.4069 21.0476 24.3294 21.0771 24.2517 21.0771Z" fill="#424852"/>
                                        <path d="M22.7253 21.0772C22.6478 21.0772 22.5702 21.0476 22.511 20.9885C22.3924 20.8701 22.3923 20.6781 22.5107 20.5596L24.0371 19.0307C24.1554 18.9122 24.3474 18.9119 24.4661 19.0303C24.5846 19.1487 24.5847 19.3408 24.4664 19.4593L22.94 20.9881C22.8807 21.0475 22.8031 21.0772 22.7253 21.0772Z" fill="#424852"/>
                                    </svg>
                                Withdraw
                            </a></li>
                                                <li class="wallet-card-item"><a class="fw_6" href="{{ route('user.referrals') }}">
                                 <svg width="24" height="24" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
                                        <path d="M7.14721 0H16.717C17.152 0 17.5047 0.288097 17.5047 0.643459V2.41376C17.5047 2.76912 17.152 3.05722 16.717 3.05722H15.5176L13.9173 3.91499H8.77838L7.14721 3.05722C6.7122 3.05722 6.35956 2.76912 6.35956 2.41376V0.643459C6.35956 0.288097 6.7122 0 7.14721 0V0Z" fill="#FABE2C"/>
                                        <path d="M16.717 0H11.75V3.05722L12.2187 3.91504H13.9174L15.5176 3.05726H16.717C17.152 3.05726 17.5047 2.76917 17.5047 2.4138V0.643459C17.5047 0.288097 17.152 0 16.717 0V0Z" fill="#FF9100"/>
                                        <path d="M5.94777 3.05713H15.5176C15.9526 3.05713 16.3052 3.34523 16.3052 3.70059V5.47089C16.3052 5.82625 15.9526 6.11435 15.5176 6.11435L14.3112 6.54321H8.3845L7.14718 6.11435H5.94777C5.51277 6.11435 5.16013 5.82625 5.16013 5.47089V3.70064C5.16017 3.34523 5.51282 3.05713 5.94777 3.05713Z" fill="#FFE666"/>
                                        <path d="M15.5176 3.05713H11.75V6.11432L12.2187 6.54318H14.3113L15.5176 6.11432C15.9526 6.11432 16.3052 5.82622 16.3052 5.47086V3.70063C16.3052 3.34522 15.9526 3.05713 15.5176 3.05713Z" fill="#FABE2C"/>
                                        <path d="M7.06285 6.1145H16.8014C17.1898 6.1145 17.5046 6.42936 17.5046 6.81777V8.46845C17.5046 8.85686 17.1898 9.17172 16.8014 9.17172L11.9321 10.1092L7.0628 9.17172C6.67439 9.17172 6.35953 8.85686 6.35953 8.46845V6.81777C6.35957 6.42936 6.67444 6.1145 7.06285 6.1145Z" fill="#FABE2C"/>
                                        <path d="M16.8014 6.1145H11.75V9.17177L11.9321 10.1093L16.8014 9.17177C17.1898 9.17177 17.5046 8.8569 17.5046 8.46849V6.81782C17.5047 6.42937 17.1898 6.1145 16.8014 6.1145Z" fill="#FF9100"/>
                                        <path d="M19.4778 9.17163H4.11213C3.74139 9.17163 3.44083 9.4722 3.44083 9.84293V13.2938C3.44083 13.6645 3.74139 13.9651 4.11213 13.9651C4.48287 13.9651 4.78343 13.6645 4.78343 13.2938V10.5142H11.0787V13.2938C11.0787 13.6645 11.3793 13.9651 11.75 13.9651C12.1208 13.9651 12.4213 13.6645 12.4213 13.2938V10.5142H18.8065V13.2938C18.8065 13.6645 19.1071 13.9651 19.4778 13.9651C19.8485 13.9651 20.1491 13.6645 20.1491 13.2938V9.84293C20.1491 9.47215 19.8485 9.17163 19.4778 9.17163Z" fill="#5C7099"/>
                                        <path d="M7.93107 20.827C7.93107 18.9625 6.51173 17.4297 4.6946 17.2497C5.73055 16.9889 6.49823 16.0427 6.49823 14.915C6.49823 13.5861 5.43223 12.5088 4.11728 12.5088C2.80233 12.5088 1.73634 13.5861 1.73634 14.915C1.73634 16.0418 2.50275 16.9874 3.53743 17.2491C1.7166 17.4255 0.293182 18.9598 0.293182 20.8269V23.3288C0.293182 23.6995 0.593701 24 0.964392 24H8.86858L7.93107 20.827Z" fill="#9EE2F8"/>
                                        <path d="M19.4778 9.17163H11.75V12.5086L12.4213 13.2937V10.5142H18.8065V13.2937C18.8065 13.6645 19.107 13.965 19.4778 13.965C19.8485 13.965 20.1491 13.6645 20.1491 13.2937V9.84289C20.1491 9.47215 19.8485 9.17163 19.4778 9.17163Z" fill="#404A80"/>
                                        <path d="M19.9704 17.2497C21.0063 16.9889 21.774 16.0427 21.774 14.915C21.774 13.5861 20.708 12.5088 19.393 12.5088C18.0781 12.5088 17.0121 13.5861 17.0121 14.915C17.0121 16.0418 17.7786 16.9874 18.8132 17.2491C16.9924 17.4255 15.5689 18.9598 15.5689 20.8269L14.6314 24H22.5357C22.9064 24 23.2069 23.6995 23.2069 23.3288V20.8269C23.2068 18.9625 21.7875 17.4297 19.9704 17.2497Z" fill="#E62E6B"/>
                                        <path d="M12.2773 17.2625C13.341 17.0219 14.1361 16.0626 14.1361 14.915C14.1361 13.5861 13.0701 12.5088 11.7552 12.5088C10.4402 12.5088 9.37423 13.5861 9.37423 14.915C9.37423 16.0613 10.1676 17.0197 11.2294 17.2617C9.37034 17.492 7.93103 19.0761 7.93103 20.9975V24.0001H15.5689V20.9974C15.569 19.0784 14.1331 17.4958 12.2773 17.2625Z" fill="#00DD80"/>
                                        <path d="M12.2773 17.2625C13.341 17.0219 14.1361 16.0626 14.1361 14.9151C14.1361 13.5844 13.0674 12.506 11.7501 12.5088C11.7501 12.5088 11.75 12.5089 11.75 12.5089V24H15.569V20.9974C15.569 19.0784 14.1331 17.4958 12.2773 17.2625Z" fill="#00AA95"/>
                                        </svg>
                                Team
                            </a></li>
                            <style>
                                .wallet-card-item img{
                                    width:24px !important;
                                }
                            </style>
                            <li class="wallet-card-item"><a class="fw_6" href="https://wa.me/+92">
                                 <img src="https://static-00.iconduck.com/assets.00/whatsapp-icon-2040x2048-8b5th74o.png" width="24px" height="24">
                                Chat
                            </a></li>
                            
                    </ul>
                    
                </div>
            </div>
        </div>

    </div>

    
    <div class="mt-5">
        <div class="tf-container">
            <div class="tf-title d-flex justify-content-between">
                <h3 class="fw_6">Our Service</h3>
                
            </div>
            <ul class="box-service mt-3">
                <li>
                    <a href="{{ route('user.profile.setting') }}">
                    <div class="icon-box bg_color_1">
                        <svg width="25" height="22" viewBox="0 0 25 22" fill="none" xmlns="http://www.w3.org/2000/svg">
                                    <path d="M22.7003 14.8487L6.19428 17.7592C5.17447 17.939 4.202 17.258 4.02219 16.2383L2.20531 5.93436C2.0255 4.91454 2.70645 3.94208 3.72622 3.76226L20.2322 0.851795C21.252 0.671982 22.2245 1.35294 22.4043 2.3727L24.2212 12.6766C24.401 13.6964 23.7201 14.6689 22.7003 14.8487Z" fill="#3555A2"/>
                                    <path d="M20.2322 0.851795L11.9792 2.30703L14.4473 16.304L22.7003 14.8488C23.7201 14.669 24.401 13.6965 24.2212 12.6767L22.4043 2.37275C22.2245 1.35294 21.2521 0.671982 20.2322 0.851795Z" fill="#1B3555"/>
                                    <path d="M18.5312 21.177H2.125C1.08948 21.177 0.25 20.3375 0.25 19.302V9.09644C0.25 8.06092 1.08948 7.22144 2.125 7.22144H18.5312C19.5668 7.22144 20.4062 8.06092 20.4062 9.09644V19.302C20.4062 20.3375 19.5668 21.177 18.5312 21.177Z" fill="#53D8E3"/>
                                    <path d="M18.5312 7.22144H10.3281V21.177H18.5312C19.5668 21.177 20.4062 20.3375 20.4062 19.302V9.09644C20.4062 8.06092 19.5668 7.22144 18.5312 7.22144Z" fill="#18A8C9"/>
                                    <path d="M0.25 10.4111H20.4062V13.601H0.25V10.4111Z" fill="#ECF6FD"/>
                                    <path d="M5.83218 18.0813H2.64233C2.25402 18.0813 1.93921 18.3961 1.93921 18.7844C1.93921 19.1727 2.25402 19.4875 2.64233 19.4875H5.83218C6.22049 19.4875 6.5353 19.1727 6.5353 18.7844C6.5353 18.3961 6.22049 18.0813 5.83218 18.0813Z" fill="#EAF6FF"/>
                                    <path d="M10.3281 10.4111H20.4062V13.601H10.3281V10.4111Z" fill="#D6E8FE"/>
                                    </svg>    
                    </div>
                    Account
                    </a> 
                </li>
                <li>
                    <a href="{{ route('user.twofactor') }}">
                    <div class="icon-box custom-im bg_color_2">
                        <img src="https://cdn-icons-png.flaticon.com/512/3631/3631626.png" width="15px" height="15px">
                             
                    </div>
                    Invite
                    </a> 
                </li>
                <li>
                    <a href="{{ route('user.invest.log') }}">
                        <div class="icon-box custom-im bg_color_3">
                      <img src="https://cdn-icons-png.flaticon.com/512/4924/4924862.png" width="15px" height="15px">
                        </div>
                        My Plans 
                    </a> 
                </li>
                <li>
                    <a href="{{ route('user.claim') }}">
                    <div class="icon-box bg_color_4">
                         <svg width="25" height="24" viewBox="0 0 25 24" fill="none" xmlns="http://www.w3.org/2000/svg">
                                <g clip-path="url(#clip0_4355_15432)">
                                <path d="M4.2248 7.60006L16.7592 0.603265C17.1297 0.396475 17.5672 0.345328 17.9754 0.461073C18.3836 0.576818 18.7292 0.849977 18.936 1.22047L20.146 3.38807C20.2362 3.54579 20.2691 3.72987 20.2391 3.90908C20.209 4.08828 20.1179 4.25158 19.9812 4.37127C19.5254 4.75969 19.1876 5.26814 19.0063 5.83888C18.8249 6.40962 18.8072 7.01978 18.9552 7.60006L18.8752 8.80007H4.0752L4.2248 7.60006Z" fill="#F7C331"/>
                                <path d="M21.2749 15.6001C21.275 16.3406 21.5317 17.0583 22.0014 17.6308C22.4711 18.2033 23.1247 18.5953 23.8509 18.7401C24.0286 18.7774 24.1879 18.875 24.3016 19.0165C24.4154 19.158 24.4766 19.3346 24.4749 19.5161V22.0001C24.4749 22.4244 24.3063 22.8314 24.0063 23.1315C23.7062 23.4315 23.2993 23.6001 22.8749 23.6001H2.8749C2.45056 23.6001 2.04359 23.4315 1.74353 23.1315C1.44347 22.8314 1.2749 22.4244 1.2749 22.0001V9.2001C1.2749 8.77575 1.44347 8.36879 1.74353 8.06873C2.04359 7.76867 2.45056 7.6001 2.8749 7.6001H22.8749C23.2993 7.6001 23.7062 7.76867 24.0063 8.06873C24.3063 8.36879 24.4749 8.77575 24.4749 9.2001V11.6841C24.4766 11.8656 24.4154 12.0422 24.3016 12.1837C24.1879 12.3251 24.0286 12.4228 23.8509 12.4601C23.1247 12.6049 22.4711 12.9969 22.0014 13.5694C21.5317 14.1419 21.275 14.8596 21.2749 15.6001Z" fill="#E5354B"/>
                                <path d="M18.4748 22.4V23.6H17.6748V22.4C17.6748 22.2939 17.7169 22.1922 17.792 22.1172C17.867 22.0421 17.9687 22 18.0748 22C18.1809 22 18.2826 22.0421 18.3576 22.1172C18.4327 22.1922 18.4748 22.2939 18.4748 22.4Z" fill="#C12748"/>
                                <path d="M18.0748 19.6001C17.9687 19.6001 17.867 19.6422 17.792 19.7173C17.7169 19.7923 17.6748 19.894 17.6748 20.0001V20.8001C17.6748 20.9062 17.7169 21.0079 17.792 21.0829C17.867 21.158 17.9687 21.2001 18.0748 21.2001C18.1809 21.2001 18.2826 21.158 18.3576 21.0829C18.4327 21.0079 18.4748 20.9062 18.4748 20.8001V20.0001C18.4748 19.894 18.4327 19.7923 18.3576 19.7173C18.2826 19.6422 18.1809 19.6001 18.0748 19.6001Z" fill="#C12748"/>
                                <path d="M18.0748 17.2002C17.9687 17.2002 17.867 17.2423 17.792 17.3174C17.7169 17.3924 17.6748 17.4941 17.6748 17.6002V18.4002C17.6748 18.5063 17.7169 18.608 17.792 18.683C17.867 18.7581 17.9687 18.8002 18.0748 18.8002C18.1809 18.8002 18.2826 18.7581 18.3576 18.683C18.4327 18.608 18.4748 18.5063 18.4748 18.4002V17.6002C18.4748 17.4941 18.4327 17.3924 18.3576 17.3174C18.2826 17.2423 18.1809 17.2002 18.0748 17.2002Z" fill="#C12748"/>
                                <path d="M18.0748 14.8003C17.9687 14.8003 17.867 14.8424 17.792 14.9174C17.7169 14.9925 17.6748 15.0942 17.6748 15.2003V16.0003C17.6748 16.1064 17.7169 16.2081 17.792 16.2831C17.867 16.3582 17.9687 16.4003 18.0748 16.4003C18.1809 16.4003 18.2826 16.3582 18.3576 16.2831C18.4327 16.2081 18.4748 16.1064 18.4748 16.0003V15.2003C18.4748 15.0942 18.4327 14.9925 18.3576 14.9174C18.2826 14.8424 18.1809 14.8003 18.0748 14.8003Z" fill="#C12748"/>
                                <path d="M18.0748 12.3999C17.9687 12.3999 17.867 12.442 17.792 12.5171C17.7169 12.5921 17.6748 12.6938 17.6748 12.7999V13.5999C17.6748 13.706 17.7169 13.8077 17.792 13.8827C17.867 13.9578 17.9687 13.9999 18.0748 13.9999C18.1809 13.9999 18.2826 13.9578 18.3576 13.8827C18.4327 13.8077 18.4748 13.706 18.4748 13.5999V12.7999C18.4748 12.6938 18.4327 12.5921 18.3576 12.5171C18.2826 12.442 18.1809 12.3999 18.0748 12.3999Z" fill="#C12748"/>
                                <path d="M18.0748 10C17.9687 10 17.867 10.0421 17.792 10.1172C17.7169 10.1922 17.6748 10.2939 17.6748 10.4V11.2C17.6748 11.3061 17.7169 11.4078 17.792 11.4828C17.867 11.5579 17.9687 11.6 18.0748 11.6C18.1809 11.6 18.2826 11.5579 18.3576 11.4828C18.4327 11.4078 18.4748 11.3061 18.4748 11.2V10.4C18.4748 10.2939 18.4327 10.1922 18.3576 10.1172C18.2826 10.0421 18.1809 10 18.0748 10Z" fill="#C12748"/>
                                <path d="M18.4748 7.6001V8.8001C18.4748 8.90618 18.4327 9.00793 18.3576 9.08294C18.2826 9.15796 18.1809 9.2001 18.0748 9.2001C17.9687 9.2001 17.867 9.15796 17.792 9.08294C17.7169 9.00793 17.6748 8.90618 17.6748 8.8001V7.6001H18.4748Z" fill="#C12748"/>
                                <path d="M5.67482 20.8002C5.59572 20.8001 5.5184 20.7767 5.45263 20.7327C5.38687 20.6888 5.33561 20.6263 5.30535 20.5532C5.27508 20.4801 5.26716 20.3997 5.28258 20.3222C5.29801 20.2446 5.33609 20.1733 5.39202 20.1174L14.192 11.3174C14.2675 11.2445 14.3685 11.2042 14.4734 11.2051C14.5783 11.206 14.6786 11.2481 14.7527 11.3222C14.8269 11.3964 14.869 11.4967 14.8699 11.6016C14.8708 11.7065 14.8305 11.8075 14.7576 11.883L5.95762 20.683C5.88262 20.758 5.7809 20.8001 5.67482 20.8002Z" fill="white"/>
                                <path d="M7.2749 15.2002C6.87934 15.2002 6.49266 15.0829 6.16376 14.8631C5.83486 14.6434 5.57852 14.331 5.42714 13.9656C5.27577 13.6001 5.23616 13.198 5.31333 12.81C5.3905 12.4221 5.58098 12.0657 5.86069 11.786C6.14039 11.5063 6.49676 11.3158 6.88472 11.2386C7.27268 11.1615 7.67482 11.2011 8.04027 11.3524C8.40572 11.5038 8.71808 11.7602 8.93784 12.0891C9.15761 12.418 9.2749 12.8046 9.2749 13.2002C9.27427 13.7304 9.06335 14.2388 8.68842 14.6137C8.31348 14.9886 7.80514 15.1996 7.2749 15.2002ZM7.2749 12.0002C7.03757 12.0002 6.80556 12.0706 6.60822 12.2024C6.41088 12.3343 6.25707 12.5217 6.16625 12.741C6.07542 12.9602 6.05166 13.2015 6.09796 13.4343C6.14426 13.6671 6.25855 13.8809 6.42638 14.0487C6.5942 14.2165 6.80802 14.3308 7.0408 14.3771C7.27357 14.4234 7.51485 14.3997 7.73412 14.3089C7.95339 14.218 8.14081 14.0642 8.27267 13.8669C8.40452 13.6695 8.4749 13.4375 8.4749 13.2002C8.4749 12.8819 8.34848 12.5767 8.12343 12.3517C7.89839 12.1266 7.59316 12.0002 7.2749 12.0002Z" fill="white"/>
                                <path d="M12.875 20.7998C12.4794 20.7998 12.0928 20.6825 11.7639 20.4627C11.435 20.243 11.1786 19.9306 11.0272 19.5652C10.8759 19.1997 10.8363 18.7976 10.9134 18.4096C10.9906 18.0217 11.1811 17.6653 11.4608 17.3856C11.7405 17.1059 12.0969 16.9154 12.4848 16.8382C12.8728 16.7611 13.2749 16.8007 13.6404 16.952C14.0058 17.1034 14.3182 17.3598 14.5379 17.6887C14.7577 18.0176 14.875 18.4042 14.875 18.7998C14.8744 19.33 14.6634 19.8384 14.2885 20.2133C13.9136 20.5883 13.4052 20.7992 12.875 20.7998ZM12.875 17.5998C12.6377 17.5998 12.4057 17.6702 12.2083 17.802C12.011 17.9339 11.8572 18.1213 11.7663 18.3406C11.6755 18.5599 11.6518 18.8011 11.6981 19.0339C11.7444 19.2667 11.8586 19.4805 12.0265 19.6483C12.1943 19.8162 12.4081 19.9304 12.6409 19.9767C12.8737 20.0231 13.1149 19.9993 13.3342 19.9085C13.5535 19.8176 13.7409 19.6638 13.8728 19.4665C14.0046 19.2692 14.075 19.0371 14.075 18.7998C14.075 18.4815 13.9486 18.1763 13.7235 17.9513C13.4985 17.7262 13.1933 17.5998 12.875 17.5998Z" fill="white"/>
                                </g>
                                <defs>
                                <clipPath id="clip0_4355_15432">
                                <rect width="24" height="24" fill="white" transform="translate(0.875)"/>
                                </clipPath>
                                </defs>
                                </svg>
                    </div>
           Check-in
                    </a> 
                </li>
                <li>
                    <a href="">
                    <div class="icon-box bg_color_5">
                        <svg width="20" height="24" viewBox="0 0 20 24" fill="none" xmlns="http://www.w3.org/2000/svg">
                                    <path d="M10.0833 3.25424C9.85864 3.25424 9.67651 3.07212 9.67651 2.84746V0.40678C9.67651 0.182121 9.85864 0 10.0833 0C10.308 0 10.4901 0.182121 10.4901 0.40678V2.84746C10.4901 3.07212 10.308 3.25424 10.0833 3.25424Z" fill="#F0C419"/>
                                    <path d="M12.9308 3.66102C12.7061 3.66102 12.524 3.4789 12.524 3.25424V0.40678C12.524 0.182121 12.7061 0 12.9308 0C13.1554 0 13.3375 0.182121 13.3375 0.40678V3.25424C13.3375 3.4789 13.1554 3.66102 12.9308 3.66102Z" fill="#F0C419"/>
                                    <path d="M15.7782 4.88135C15.5536 4.88135 15.3715 4.69923 15.3715 4.47457V2.84745C15.3715 2.6228 15.5536 2.44067 15.7782 2.44067C16.0029 2.44067 16.185 2.6228 16.185 2.84745V4.47457C16.185 4.69923 16.0029 4.88135 15.7782 4.88135Z" fill="#F0C419"/>
                                    <path d="M15.7782 1.62712C15.5536 1.62712 15.3715 1.445 15.3715 1.22034V0.40678C15.3715 0.182121 15.5536 0 15.7782 0C16.0029 0 16.185 0.182121 16.185 0.40678V1.22034C16.185 1.445 16.0029 1.62712 15.7782 1.62712Z" fill="#F0C419"/>
                                    <path d="M18.6257 11.7966C18.401 11.7966 18.2189 11.6145 18.2189 11.3899V2.44072C18.2189 2.21606 18.401 2.03394 18.6257 2.03394C18.8503 2.03394 19.0324 2.21606 19.0324 2.44072V11.3899C19.0324 11.6145 18.8503 11.7966 18.6257 11.7966Z" fill="#F0C419"/>
                                    <path d="M7.23582 3.66102C7.01116 3.66102 6.82904 3.4789 6.82904 3.25424V0.40678C6.82904 0.182121 7.01116 0 7.23582 0C7.46048 0 7.6426 0.182121 7.6426 0.40678V3.25424C7.6426 3.4789 7.46048 3.66102 7.23582 3.66102Z" fill="#F0C419"/>
                                    <path d="M4.38841 4.88135C4.16375 4.88135 3.98163 4.69923 3.98163 4.47457V2.84745C3.98163 2.6228 4.16375 2.44067 4.38841 2.44067C4.61307 2.44067 4.79519 2.6228 4.79519 2.84745V4.47457C4.79519 4.69923 4.61307 4.88135 4.38841 4.88135Z" fill="#F0C419"/>
                                    <path d="M4.38841 1.62712C4.16375 1.62712 3.98163 1.445 3.98163 1.22034V0.40678C3.98163 0.182121 4.16375 0 4.38841 0C4.61307 0 4.79519 0.182121 4.79519 0.40678V1.22034C4.79519 1.445 4.61307 1.62712 4.38841 1.62712Z" fill="#F0C419"/>
                                    <path d="M1.54093 11.7966C1.31628 11.7966 1.13416 11.6145 1.13416 11.3899V2.44072C1.13416 2.21606 1.31628 2.03394 1.54093 2.03394C1.76559 2.03394 1.94771 2.21606 1.94771 2.44072V11.3899C1.94771 11.6145 1.76559 11.7966 1.54093 11.7966Z" fill="#F0C419"/>
                                    <path d="M10.0833 24C15.4751 24 19.846 19.6291 19.846 14.2373C19.846 8.84552 15.4751 4.47461 10.0833 4.47461C4.69153 4.47461 0.320618 8.84552 0.320618 14.2373C0.320618 19.6291 4.69153 24 10.0833 24Z" fill="#F29C1F"/>
                                    <path d="M10.0833 22.373C14.5765 22.373 18.2189 18.7306 18.2189 14.2374C18.2189 9.74424 14.5765 6.10181 10.0833 6.10181C5.59018 6.10181 1.94775 9.74424 1.94775 14.2374C1.94775 18.7306 5.59018 22.373 10.0833 22.373Z" fill="#F0C419"/>
                                    <path d="M10.0833 22.7797C5.36762 22.7745 1.54609 18.953 1.54093 14.2373C1.53692 12.9018 1.84946 11.5843 2.45293 10.3928C2.5156 10.2584 2.64646 10.1688 2.79444 10.1589C2.94242 10.149 3.08406 10.2204 3.16409 10.3452C3.24411 10.4701 3.24984 10.6286 3.17903 10.759C2.63325 11.837 2.35068 13.029 2.35449 14.2373C2.35449 17.1648 4.00848 19.841 6.62687 21.1502C9.24527 22.4594 12.3786 22.1769 14.7206 20.4204C14.8369 20.3332 14.9908 20.3146 15.1245 20.3717C15.2581 20.4288 15.3511 20.5529 15.3685 20.6971C15.3859 20.8414 15.325 20.984 15.2087 21.0712C13.7325 22.1849 11.9325 22.7849 10.0833 22.7797Z" fill="#E57E25"/>
                                    <path d="M17.3386 18.3277C17.1973 18.3275 17.0662 18.254 16.9924 18.1334C16.9186 18.0129 16.9126 17.8627 16.9766 17.7367C17.5294 16.6532 17.8158 15.4535 17.8121 14.2372C17.8121 11.3097 16.1582 8.63351 13.5398 7.32431C10.9214 6.01511 7.788 6.29764 5.44604 8.05412C5.26631 8.18891 5.01134 8.15249 4.87655 7.97276C4.74175 7.79304 4.77818 7.53807 4.9579 7.40327C8.1358 5.0217 12.5356 5.1436 15.5768 7.69747C18.618 10.2513 19.4987 14.5639 17.7023 18.1056C17.6327 18.2423 17.492 18.3282 17.3386 18.3277Z" fill="#E57E25"/>
                                    <path d="M10.8289 8.62117L11.9492 10.9829C12.0659 11.2364 12.301 11.4153 12.5765 11.4601L15.0619 11.8351C15.3845 11.8993 15.6458 12.1356 15.7418 12.4503C15.8378 12.7649 15.753 13.1069 15.5211 13.3402L13.7382 15.1471C13.5366 15.3549 13.446 15.6463 13.4942 15.9318L13.9172 18.4945C13.9854 18.8123 13.8651 19.1411 13.6079 19.3399C13.3507 19.5387 13.0023 19.5722 12.7119 19.426L10.4665 18.1988C10.2276 18.0674 9.93817 18.0674 9.69931 18.1988L7.45388 19.426C7.16352 19.5722 6.81506 19.5387 6.55786 19.3399C6.30067 19.1411 6.18039 18.8123 6.24859 18.4945L6.67165 15.9318C6.71982 15.6463 6.62919 15.3549 6.42758 15.1471L4.64466 13.3402C4.4128 13.1069 4.32802 12.7649 4.42403 12.4503C4.52003 12.1356 4.78127 11.8993 5.10392 11.8351L7.58934 11.4601C7.86508 11.4155 8.10056 11.2366 8.21741 10.9829L9.33768 8.62361C9.4666 8.32693 9.75903 8.13481 10.0825 8.13428C10.406 8.13375 10.699 8.32491 10.8289 8.62117Z" fill="#F29C1F"/>
                                </svg> 
                    </div>
                 About
                    </a> 
                </li>
              
                <li>
                   
                    <a href="{{ route('ticket.index') }}">
                        <div class="icon-box custom-im bg_color_7">
                            <img src="https://cdn2.iconfinder.com/data/icons/thesquid-ink-40-free-flat-icon-pack/64/support-512.png" width="15px" height="15px">
                           
                                
                        </div>
                        Support
                    </a> 
                </li>
                <li>
                    <a href="" target="_blank">
                        <div class="icon-box custom-imf bg_color_2">
                              <img src="https://cdn0.iconfinder.com/data/icons/bold-purple-free-samples/32/Import_Circle_File_Downloaded_Download-512.png" width="24" height="24">
                                
                        </div>
                       App
                    </a> 
                </li> 
                <li>
                    <a href="{{route ('user.logout')}}">
                        <div class="icon-box custom-imf bg_color_2">
                              <img src="https://centralmichigan211.org/wp-content/uploads/2021/01/About-Icon.png" width="24" height="24">
                                
                        </div>
                 Logout
                    </a> 
                </li> 
            </ul>
        </div>
    </div>
             		 @php
        $plans = App\Models\Plan::where('status', 1)
            ->where('featured', 1)
            ->get();
        $gatewayCurrency = null;
        if (auth()->check()) {
            $gatewayCurrency = App\Models\GatewayCurrency::whereHas('method', function ($gate) {
                $gate->where('status', 1);
            })
                ->with('method')
                ->orderby('method_code')
                ->get();
        }
    @endphp
         
         
    
    
    
    
    
    
    <div class="container mt-3" style="margin-bottom:100px">
        <div class="row">
            <div class="col-7 ">
                <div class="text-gradient">Investment Plans</div>
            </div>
            <div class="col-5 text-right">
                <a href="" class="text-gradient text-left" >See All</a>
            </div>
        </div>
                         
                         
                         
                         
                         
                            @foreach ($plans as $plan)

  			 <form action="{{ route('user.invest.submit') }}" method="post">
                                       @csrf

         
               
              
              
              <div class="saving-plan text-white">

                
                                       <input type="hidden" name="plan_id" value="{{ __($plan->id) }}">
                                       <input type="hidden" name="wallet_type" value="deposit_wallet">
                                       <input type="hidden" name="amount" value="{{ getAmount($plan->fixed_amount,0) }}">
                                       
                                       
                                       
           <div class="row">
               <div class="col-3">
                <div class=" ">
                    <img src="https://i.ibb.co/rb5Lyy9/pngtree-d-render-of-white-background-gas-station-symbol-with-minimalist-fuel-picture-image-5819078-r.png">
                </div>
            </div>
                <div class="col-9">
                <div class="fs-201  fw-600 ">{{ __($plan->name) }}</div>
                 <div class="row">
                     <div class="col-6">
                         <div class="fs-198 text-danger mt-2 ">Price</div>
                    <div><span class="fw-600 fs-200 text-col">@if ($plan->fixed_amount == 0)
                                {{ __($general->cur_sym) }}{{ showAmount($plan->minimum) }} -
                                {{ __($general->cur_sym) }}{{ showAmount($plan->maximum) }}
                            @else
                                {{ __($general->cur_sym) }}{{ showAmount($plan->fixed_amount) }}
                            @endif</span></div>
                     </div>
                     <div class="col-6">
                         <div class="fs-198 text-danger mt-2 ">Duration</div>
                    <div><span class="fw-600 fs-200 text-col">@if ($plan->lifetime == 0)
                            {{ __($plan->repeat_time) }} {{ __(strtoupper($plan->time_name)) }}
                        @else
                            @lang('LIFETIME')
                        @endif </span></div>
                     </div>
                 </div>
            </div>
         
             
            
           </div>
            <div class="row mt-2 justify-content-center text-center">
                <div class="col-4 px-0">
                    <div><span class=" fs-199"> {{ $plan->interest_type != 1 ? $general->cur_sym : '' }}{{ showAmount($plan->interest) }}{{ $plan->interest_type == 1 ? '%' : '' }}</span></div>
                                        <div class="fs-198 text-info  ">{{ __(strtoupper($plan->time_name)) }} Profit</div>
                                    </div>
                
                <div class="col-4 px-0">
                                            <div><span class=" fs-199">@if ($plan->lifetime == 0)
                        @lang('')
                        {{ __($plan->interest * $plan->repeat_time) }}{{ $plan->interest_type == 1 ? '%' : ' ' . __($general->cur_text) }}
                        @lang('')
                    @else
                        @lang('Unlimited')
                    @endif </span> </div>
                                                <div class="fs-198 text-info ">Total Profit</div>
                </div>
                
                <div class="subscribe-button mt-3">
                        
                        <button type="submit"  class="btn btn-col text-white border-pill w-100">Buy Plan</button>
                </div>
               
                
            </div>
        </div>
          </form>
                         
                         
                         
                         
                                     @endforeach	
          
        
                    
                         
                         
                         
                         
                         
                         
         
     
    </div>
 
    <div class="modal fade" id="modalhome2">
     <div class="modal-dialog modal-dialog-centered">
        <div class="modal-content">
           <div class="heading">
            <h2>Privacy</h2>
            <p class="mt-1 fw_3">
                A mobile app privacy policy is a legal statement that must be clear, conspicuous, and consented to by all users. It must disclose how a mobile app gathers, stores, and uses the personally identifiable information it collects from its users.
                A mobile privacy app is developed and presented to users so that mobile app developers stay compliant with state, federal, and international laws. As a result, they fulfill the legal requirement to safeguard user privacy while protecting the company itself from legal challenges.

            </p>
            <h2 class="mt-3">Authorized Users</h2>
            <p class="fw-3">
                A mobile app privacy policy is a legal statement that must be clear, conspicuous, and consented to by all users. It must disclose how a mobile app gathers, stores, and uses the personally identifiable information it collects from its users.
            </p>
            <div class="group-cb mt-3 align-items-center">
                <div class="cb">
                    <input type="checkbox" class="tf-checkbox st1" checked>
                </div>
                <span class="fw_3">I agree to the Term of sevice and Privacy policyy</span> 
            </div>
         
           </div>
           <div class="bottom mt-5">
              <a href="#" class="tf-btn accent large" data-dismiss="modal">I Accept</a>
           </div>
        </div>
     </div>
    </div>
    <div class="tf-panel up">
        <div class="panel-box panel-up panel-noti">
            <div class="header is-fixed">
                <div class="tf-container">
                    <div class="tf-statusbar d-flex justify-content-center align-items-center">
                        <a href="#" class="clear-panel"> <i class="icon-left"></i> </a>
                        <h3>Notification</h3>
                    </div>
                </div>
            </div>
            <div id="app-wrap" class="style1">
                <div class="tf-container">
                    <div class="tf-tab mt-3">
                        <div class="swiper-container tes-noti">
                            <ul class="swiper-wrapper menu-tabs">
                                <li class="swiper-slide nav-tab active "><a href="#">All Notification</a></li>
                                <li class=" swiper-slide nav-tab "><a href="#">Remind</a></li>
                                <li class="swiper-slide nav-tab"><a href="#"> Transaction</a></li>
                                <li class="swiper-slide nav-tab "><a href="#">Promotion</a></li>
                            </ul>
                        </div>
                        <div class="content-tab mt-5">
                            <div class="noti-box">
                                <div class="noti-list">
                                    <div class="icon-box bg_service-4">
                                        <svg width="16" height="16" viewBox="0 0 16 16" fill="none" xmlns="http://www.w3.org/2000/svg">
                                            <path d="M7.99995 14.7062C12.0609 14.7062 15.353 11.4141 15.353 7.35309C15.353 3.29209 12.0609 0 7.99995 0C3.93894 0 0.646851 3.29209 0.646851 7.35309C0.646851 11.4141 3.93894 14.7062 7.99995 14.7062Z" fill="#F7B239"/>
                                            <path d="M7.99997 12.1931C10.673 12.1931 12.8399 10.0261 12.8399 7.35312C12.8399 4.6801 10.673 2.51318 7.99997 2.51318C5.32695 2.51318 3.16003 4.6801 3.16003 7.35312C3.16003 10.0261 5.32695 12.1931 7.99997 12.1931Z" fill="#E09B2D"/>
                                            <path d="M14.6157 15.1809C14.6307 15.2373 14.638 15.294 14.638 15.3495C14.638 15.637 14.4463 15.8997 14.1558 15.9776C13.8089 16.0706 13.4521 15.8646 13.3591 15.5178L12.2661 11.4386C12.1731 11.0918 12.3791 10.7349 12.726 10.6419C13.0732 10.549 13.4297 10.755 13.5227 11.1022L14.6157 15.1809Z" fill="#F24C8F"/>
                                            <path d="M2.4596 11.5182L3.01855 11.668L4.49394 6.16149L3.93499 6.01173L2.4596 11.5182Z" fill="#CCCCCC"/>
                                            <path d="M11.6446 7.71971L12.4469 10.7156L13.0059 10.5659L12.2036 7.57L11.6446 7.71971Z" fill="#CCCCCC"/>
                                            <path d="M5.26403 2.1712C6.18881 2.41888 6.60972 3.8456 6.20463 5.3572C5.79953 6.86917 4.88478 7.28545 3.96 7.03776C3.03559 6.79007 2.4515 5.97217 2.85659 4.4602C3.26169 2.94823 4.33963 1.92351 5.26403 2.1712Z" fill="#E6E6E6"/>
                                            <path d="M2.9944 10.642C3.34162 10.7349 3.54727 11.0918 3.45427 11.4386L2.36168 15.5178C2.28374 15.8083 2.02099 16 1.73359 16C1.67802 16 1.6213 15.9927 1.56499 15.9776C1.21777 15.8847 1.01174 15.5278 1.10471 15.181L2.19771 11.1022C2.29068 10.755 2.64755 10.549 2.9944 10.642Z" fill="#F24C8F"/>
                                            <path d="M13.0658 6.02202L12.141 2.57046C12.1045 2.4344 11.9629 2.35446 11.8268 2.39515C11.6951 2.43455 11.6237 2.57771 11.6592 2.71046L12.3966 5.46168C12.4517 5.66743 12.3296 5.87893 12.1239 5.93408L12.1235 5.93415C11.9177 5.98937 11.7061 5.86721 11.651 5.66143L10.911 2.89987C10.8745 2.76371 10.7327 2.6838 10.5967 2.72458C10.465 2.76405 10.3937 2.90718 10.4293 3.0399L11.1666 5.79137C11.2217 5.99715 11.0996 6.20865 10.8938 6.26383C10.688 6.31896 10.4766 6.19687 10.4214 5.99108L9.68139 3.22937C9.64493 3.09324 9.5033 3.01337 9.36721 3.05405C9.23552 3.09346 9.16408 3.23658 9.19964 3.36933L10.1216 6.81049C10.2269 7.20383 10.479 7.53255 10.8316 7.73615C11.0665 7.87177 11.327 7.94102 11.5912 7.94102C11.7236 7.94102 11.857 7.92358 11.9883 7.8884C12.6534 7.71015 13.1178 7.10524 13.1178 6.4174C13.1178 6.28349 13.1003 6.15027 13.0658 6.02202Z" fill="#E6E6E6"/>
                                        </svg>
                                            
                                    </div>
                                    <div class="content-right">
                                        <div class="title">
                                            <h3 class="fw_6">Restaurant</h3>
                                            <span class="fw_6 on_surface_color">5 Min Ago</span>
                                        </div>
                                        <div class="desc">
                                            <p class="on_surface_color fw_4">Alipay gives you 20% offcoupon for all bills, applicable for bills paid through Alipay wallet!</p>
                                            <i class="dot"></i>
                                        </div>
                                    </div>
                                </div>
                                <div class="noti-list">
                                    <div class="icon-box bg_service-3">
                                        <svg width="16" height="16" viewBox="0 0 25 24" fill="none" xmlns="http://www.w3.org/2000/svg">
                                            <path d="M24.2838 7.48567C22.5636 -5.34697 15.3153 2.01241 6.99199 5.99402C4.62414 7.12675 1.38339 7.13603 0.529097 10.1115C-0.458746 13.5521 2.49213 15.7224 4.86696 17.5562C7.726 19.7638 7.32082 24.1061 11.9929 23.7198C12.874 23.647 13.9302 23.7352 14.4994 23.0587C16.8551 20.2588 17.5094 16.0487 20.5731 13.8156C22.7339 12.2406 24.6702 10.3686 24.2838 7.48567V7.48567Z" fill="url(#paint0_linear_4516_5327)"/>
                                            <path d="M11.1101 8.50233C10.8512 8.50233 10.6413 8.29243 10.6413 8.03358V4.51604C10.6413 3.36872 9.70791 2.4353 8.56059 2.4353C7.41328 2.4353 6.47986 3.36872 6.47986 4.51604V8.03358C6.47986 8.29243 6.27 8.50233 6.01111 8.50233C5.75222 8.50233 5.54236 8.29243 5.54236 8.03358V4.51604C5.54236 2.85179 6.89634 1.4978 8.56059 1.4978C10.2248 1.4978 11.5788 2.85179 11.5788 4.51604V8.03358C11.5788 8.29248 11.369 8.50233 11.1101 8.50233V8.50233Z" fill="#FFC498"/>
                                            <path d="M4.77612 20.4084H2.87707C2.74085 20.4084 2.63332 20.2927 2.64335 20.1568L3.59196 7.27699C3.60096 7.15455 3.70296 7.05981 3.82568 7.05981H5.72482L4.77612 20.4084Z" fill="#FF7300"/>
                                            <path d="M10.2019 1.98511C9.70002 2.02945 9.26681 2.20284 8.90198 2.46379C9.5587 2.57269 10.1121 2.99006 10.4085 3.56161C10.4256 3.56119 10.4425 3.56029 10.4596 3.56029C10.8392 3.56029 11.1951 3.663 11.5018 3.84131C11.3243 3.06712 10.8485 2.40586 10.2019 1.98511V1.98511Z" fill="#FFAA66"/>
                                            <path d="M13.3223 5.13473C14.475 5.29359 15.5495 5.49229 16.5249 5.72507C16.6042 5.74396 16.6598 5.81503 16.6598 5.8965V9.13706C16.6598 9.26034 16.5367 9.34537 16.4213 9.30168C15.46 8.93756 14.4044 8.66198 13.2743 8.50078C13.1872 8.48836 13.1222 8.41434 13.1222 8.3264V5.30939C13.1222 5.2027 13.2166 5.12015 13.3223 5.13473V5.13473Z" fill="#9393FF"/>
                                            <path d="M19.934 11.522C19.3646 10.9961 18.6909 10.5108 17.9281 10.086C17.8721 10.0548 17.837 9.99604 17.837 9.93201V6.37448C17.837 6.25486 17.9539 6.16978 18.0677 6.20672C20.528 7.0057 22.0239 8.06062 22.0239 9.21736L21.8832 11.1587L19.934 11.522Z" fill="#9393FF"/>
                                            <path d="M22.0238 13.3463L21.8386 14.0752L22.0238 14.2763V14.5922L21.9179 15.2644L22.0238 15.5222V16.0791C22.0238 17.1707 20.6922 18.5447 18.4754 19.6873C18.2885 19.7836 18.0657 19.6472 18.0657 19.4369V12.4824C18.0657 12.3314 18.1622 12.1974 18.3052 12.1486C20.6241 11.3602 22.0238 10.3364 22.0238 9.21753V13.3463Z" fill="#D8D8FF"/>
                                            <path d="M22.0238 14.592V15.522C21.4594 16.2172 20.5032 16.8463 19.4996 17.4355C19.4625 17.4575 19.4217 17.4678 19.3814 17.4678C19.3008 17.4678 19.2225 17.4266 19.1789 17.352C19.1133 17.2405 19.1508 17.0966 19.2624 17.0314C20.9536 16.0386 21.8133 15.2853 22.0238 14.592V14.592Z" fill="#9393FF"/>
                                            <path d="M22.0238 13.3462V14.2762C21.4589 14.9713 20.5032 15.6004 19.4996 16.1896C19.4625 16.2112 19.4217 16.2215 19.3814 16.2215C19.3008 16.2215 19.2225 16.1803 19.1789 16.1062C19.1133 15.9942 19.1508 15.8507 19.2624 15.7851C20.9536 14.7923 21.8133 14.0395 22.0238 13.3462Z" fill="#9393FF"/>
                                            <path d="M19.3813 15.2074C19.3025 15.2074 19.2256 15.1678 19.1813 15.0957C19.1136 14.9854 19.148 14.8411 19.2583 14.7734C19.5345 14.6037 19.7758 14.4484 19.996 14.2986C20.1032 14.2258 20.2489 14.2537 20.3216 14.3607C20.3944 14.4678 20.3666 14.6136 20.2596 14.6863C20.0333 14.8401 19.786 14.9993 19.5037 15.1727C19.4655 15.1962 19.4231 15.2074 19.3813 15.2074V15.2074Z" fill="#9393FF"/>
                                            <path d="M19.3812 13.4436C19.2918 13.4436 19.2064 13.3922 19.1674 13.3054C19.1142 13.1874 19.1668 13.0486 19.2848 12.9955C19.6547 12.8289 19.9883 12.6536 20.2766 12.4743C20.3866 12.406 20.5311 12.4397 20.5994 12.5495C20.6677 12.6595 20.634 12.804 20.5242 12.8724C20.2183 13.0626 19.8661 13.2478 19.4773 13.4229C19.4461 13.4369 19.4134 13.4436 19.3812 13.4436V13.4436Z" fill="#FF9393"/>
                                            <path d="M18.0681 6.20699C17.9542 6.17001 17.837 6.2549 17.837 6.37462V9.93215C17.837 9.99623 17.8721 10.055 17.9281 10.0862C18.6779 10.5038 19.3408 10.9801 19.904 11.4957C19.4371 11.7274 18.9017 11.946 18.3048 12.149C18.1621 12.1976 18.0658 12.3317 18.0658 12.4826V19.437C18.0658 19.6473 18.2886 19.7838 18.4756 19.6874C20.6923 18.5446 22.0239 17.1709 22.0239 16.0793V9.21749C22.0239 8.0608 20.5282 7.00593 18.0681 6.20699Z" fill="url(#paint1_linear_4516_5327)"/>
                                            <path d="M16.1433 20.4084H4.77616C4.63975 20.4084 4.53241 20.2926 4.54225 20.1567L5.491 7.27685C5.49991 7.1545 5.6021 7.05981 5.72491 7.05981H15.1946C15.3174 7.05981 15.4191 7.1545 15.4285 7.27685L16.3768 20.1567C16.3871 20.2926 16.2793 20.4084 16.1433 20.4084Z" fill="#FFAA66"/>
                                            <path d="M11.0447 10.5326C10.9228 10.6545 10.7608 10.7216 10.5884 10.7216C10.4161 10.7216 10.2541 10.6545 10.1322 10.5326C10.0104 10.4107 9.94324 10.2487 9.94324 10.0763C9.94324 9.90399 10.0104 9.74199 10.1322 9.62011C10.3838 9.36849 10.7932 9.36854 11.0447 9.62011L11.2104 9.78586L11.5419 9.45441L11.3761 9.28866C11.2188 9.13135 11.0257 9.03188 10.8228 8.98847V8.53955H10.3541V8.98852C10.1512 9.03188 9.95805 9.13139 9.80074 9.28866C9.59036 9.49908 9.47449 9.77883 9.47449 10.0763C9.47449 10.3739 9.59036 10.6537 9.80074 10.864C9.95472 11.018 10.146 11.1211 10.3541 11.1655V11.6131H10.8228V11.1655C11.0309 11.1211 11.2221 11.018 11.3761 10.864L11.5419 10.6983L11.2104 10.3668L11.0447 10.5326Z" fill="white"/>
                                            <path d="M7.44153 7.05981H8.37903V8.87763C8.37903 9.13638 8.16903 9.34638 7.91028 9.34638C7.65153 9.34638 7.44153 9.13638 7.44153 8.87763V7.05981Z" fill="#FF9C33"/>
                                            <path d="M13.4781 7.05981V8.87763C13.4781 9.13638 13.2681 9.34638 13.0094 9.34638C12.7502 9.34638 12.5406 9.13638 12.5406 8.87763V7.05981H13.4781Z" fill="#FF9C33"/>
                                            <path d="M10.9984 13.5775C12.884 13.4304 14.6278 13.183 16.1577 12.8558C16.3769 12.8089 16.5833 12.9764 16.5833 13.2005V20.4353C16.5833 20.5874 16.4858 20.7222 16.3414 20.7701C14.7835 21.2871 12.9957 21.6755 11.0566 21.8444C10.8508 21.8623 10.6738 21.6995 10.6738 21.4929V13.9288C10.6738 13.745 10.8151 13.5918 10.9984 13.5775V13.5775Z" fill="#D8D8FF"/>
                                            <path d="M15.4929 20.1811C15.3913 20.1811 15.2977 20.1146 15.2679 20.0122C15.2318 19.8879 15.3032 19.7578 15.4274 19.7216C15.4987 19.7009 15.5694 19.6798 15.6398 19.6586C15.7636 19.621 15.8946 19.6911 15.9321 19.815C15.9696 19.9389 15.8995 20.0697 15.7756 20.1072C15.7036 20.129 15.6313 20.1505 15.5584 20.1717C15.5366 20.1781 15.5146 20.1811 15.4929 20.1811V20.1811Z" fill="#8282FF"/>
                                            <path d="M15.4929 19.4651C15.3913 19.4651 15.2977 19.3986 15.2679 19.2961C15.2318 19.1719 15.3032 19.0418 15.4274 19.0056C15.4987 18.9848 15.5694 18.9638 15.6398 18.9425C15.7636 18.9049 15.8946 18.9751 15.9321 19.0989C15.9696 19.2228 15.8995 19.3537 15.7756 19.3912C15.7036 19.413 15.6313 19.4344 15.5584 19.4556C15.5366 19.462 15.5146 19.4651 15.4929 19.4651V19.4651Z" fill="#8282FF"/>
                                            <path d="M16.0011 15.6087L14.8434 14.5739C14.8277 14.5598 14.8076 14.5527 14.7878 14.5541L14.2639 14.5906C14.2315 14.5929 14.2048 14.6166 14.1978 14.6498C14.1563 14.846 13.9983 14.997 13.7931 15.013C13.586 15.0292 13.3922 14.9033 13.3049 14.713C13.29 14.6807 13.2572 14.6607 13.2233 14.6631L12.6622 14.7021C12.6407 14.7036 12.6207 14.714 12.6071 14.7308L11.5495 16.0345C11.5196 16.0715 11.5257 16.1262 11.5632 16.1566L12.2405 16.7049C12.2768 16.7343 12.3301 16.7283 12.359 16.6915L12.7033 16.2534L12.643 18.6497C12.6416 18.7057 12.6911 18.7494 12.7465 18.7411L15.0027 18.4026C15.0469 18.396 15.0795 18.3579 15.0794 18.3132L15.074 16.0106L15.4573 16.3438C15.4903 16.3725 15.5408 16.3668 15.5666 16.3314L16.0137 15.7194C16.038 15.6862 16.0324 15.6366 16.0011 15.6087V15.6087Z" fill="#FFAA66"/>
                                            <path d="M12.9243 20.3039C13.5523 20.3039 14.0615 19.7948 14.0615 19.1667C14.0615 18.5387 13.5523 18.0295 12.9243 18.0295C12.2962 18.0295 11.7871 18.5387 11.7871 19.1667C11.7871 19.7948 12.2962 20.3039 12.9243 20.3039Z" fill="#FF6C6C"/>
                                            <path d="M12.7735 19.6973C12.7114 19.6973 12.6518 19.6726 12.6078 19.6287L12.3171 19.3379C12.2255 19.2464 12.2255 19.098 12.3171 19.0065C12.4086 18.915 12.5571 18.915 12.6485 19.0065L12.7735 19.1315L13.2002 18.7049C13.2917 18.6134 13.4402 18.6134 13.5316 18.7049C13.6232 18.7964 13.6232 18.9448 13.5316 19.0363L12.9392 19.6287C12.8953 19.6726 12.8357 19.6973 12.7735 19.6973V19.6973Z" fill="white"/>
                                            <path d="M14.3828 16.2914C14.2533 16.2914 14.1484 16.1864 14.1484 16.057V15.9878C14.1484 15.8584 14.2533 15.7534 14.3828 15.7534C14.5123 15.7534 14.6172 15.8584 14.6172 15.9878V16.057C14.6172 16.1864 14.5122 16.2914 14.3828 16.2914Z" fill="#FFD5BA"/>
                                            <path d="M13.0091 8.50233C12.7502 8.50233 12.5404 8.29243 12.5404 8.03358V4.51604C12.5404 3.36872 11.607 2.4353 10.4596 2.4353C9.31233 2.4353 8.37891 3.36872 8.37891 4.51604V8.03358C8.37891 8.29243 8.16905 8.50233 7.91016 8.50233C7.65127 8.50233 7.44141 8.29243 7.44141 8.03358V4.51604C7.44141 2.85179 8.79539 1.4978 10.4596 1.4978C12.1239 1.4978 13.4779 2.85179 13.4779 4.51604V8.03358C13.4779 8.29248 13.268 8.50233 13.0091 8.50233Z" fill="#FFD5BA"/>
                                            <path d="M8.8133 19.1614H6.17639C6.04697 19.1614 5.94202 19.0564 5.94202 18.927C5.94202 18.7976 6.04697 18.6926 6.17639 18.6926H8.8133C8.94272 18.6926 9.04767 18.7976 9.04767 18.927C9.04767 19.0564 8.94272 19.1614 8.8133 19.1614Z" fill="#FFD5BA"/>
                                            <path d="M8.86591 18.2642H6.229C6.09958 18.2642 5.99463 18.1592 5.99463 18.0298C5.99463 17.9004 6.09958 17.7954 6.229 17.7954H8.86591C8.99533 17.7954 9.10028 17.9004 9.10028 18.0298C9.10028 18.1592 8.99533 18.2642 8.86591 18.2642Z" fill="#FFD5BA"/>
                                            <path d="M7.0261 17.3667H6.28149C6.15207 17.3667 6.04712 17.2617 6.04712 17.1323C6.04712 17.0029 6.15207 16.8979 6.28149 16.8979H7.0261C7.15553 16.8979 7.26048 17.0029 7.26048 17.1323C7.26048 17.2617 7.15553 17.3667 7.0261 17.3667Z" fill="#FFD5BA"/>
                                            <path d="M16.525 5.72504C15.5939 5.5028 14.5715 5.31202 13.478 5.15696V4.51604C13.478 2.85179 12.124 1.4978 10.4597 1.4978C10.128 1.4978 9.80901 1.55237 9.51023 1.65169C9.21145 1.55237 8.89242 1.4978 8.56073 1.4978C6.89648 1.4978 5.5425 2.85179 5.5425 4.51604V7.05976H3.82584C3.70307 7.05976 3.60112 7.15449 3.59212 7.27693L2.64347 20.1568C2.63348 20.2927 2.74097 20.4084 2.87723 20.4084H10.6739V21.4929C10.6739 21.6995 10.8509 21.8623 11.0567 21.8444C12.9958 21.6755 14.7836 21.2871 16.3415 20.7701C16.4859 20.7222 16.5833 20.5874 16.5833 20.4353V13.2006C16.5833 12.9764 16.377 12.809 16.1578 12.8558C16.0543 12.878 15.9496 12.8997 15.8441 12.9211L15.5559 9.00638C15.852 9.09694 16.1408 9.19538 16.4214 9.30165C16.5367 9.34533 16.6598 9.2603 16.6598 9.13702V5.89646C16.6598 5.81504 16.6042 5.74397 16.525 5.72504V5.72504ZM7.4415 7.05976H6.48V4.51604C6.48 3.47265 7.25207 2.6064 8.25487 2.45799C7.75087 2.99757 7.4415 3.72118 7.4415 4.51604V7.05976ZM8.379 4.51604C8.379 3.71068 8.83926 3.01126 9.51023 2.66555C10.1812 3.01126 10.6415 3.71068 10.6415 4.51604V7.05976H8.379V4.51604ZM12.5405 7.05976H11.579V4.51604C11.579 3.72118 11.2696 2.99757 10.7656 2.45799C11.7684 2.6064 12.5405 3.47265 12.5405 4.51604V7.05976Z" fill="url(#paint2_linear_4516_5327)"/>
                                            <path d="M2.97083 3.40723H2.50208C2.24361 3.40723 2.03333 3.19695 2.03333 2.93848V2.46973C2.03333 2.21126 2.24361 2.00098 2.50208 2.00098H2.97083C3.22929 2.00098 3.43958 2.21126 3.43958 2.46973V2.93848C3.43958 3.19695 3.22929 3.40723 2.97083 3.40723V3.40723ZM2.50208 2.46973V2.93876L2.97083 2.93848V2.46973H2.50208Z" fill="#FF6C6C"/>
                                            <path d="M22.1149 20.8145H21.6461C21.3876 20.8145 21.1774 20.6042 21.1774 20.3457V19.877C21.1774 19.6185 21.3876 19.4082 21.6461 19.4082H22.1149C22.3733 19.4082 22.5836 19.6185 22.5836 19.877V20.3457C22.5836 20.6042 22.3733 20.8145 22.1149 20.8145ZM21.6461 19.877V20.346L22.1149 20.3457V19.877H21.6461Z" fill="#FF6C6C"/>
                                            <path d="M16.8109 4.39062H16.3422C16.0837 4.39062 15.8734 4.18034 15.8734 3.92188V3.45312C15.8734 3.19466 16.0837 2.98438 16.3422 2.98438H16.8109C17.0694 2.98438 17.2797 3.19466 17.2797 3.45312V3.92188C17.2797 4.18034 17.0694 4.39062 16.8109 4.39062ZM16.3422 3.45312V3.92216L16.8109 3.92188V3.45312H16.3422Z" fill="#6C6CFF"/>
                                            <path d="M3.7439 5.73242C3.6839 5.73242 3.62394 5.70955 3.57815 5.6638L3.50727 5.59292C3.37935 5.46495 3.17104 5.46495 3.04297 5.59292L2.9721 5.6638C2.88055 5.7553 2.73219 5.7553 2.64065 5.6638C2.5949 5.618 2.57202 5.55805 2.57202 5.49805C2.57202 5.43805 2.5949 5.37809 2.64065 5.3323L2.71152 5.26142C2.77354 5.19941 2.80771 5.11695 2.80771 5.0293C2.80771 4.94164 2.77354 4.85919 2.71157 4.79717L2.64065 4.7263C2.5949 4.6805 2.57202 4.62055 2.57202 4.56055C2.57202 4.50055 2.5949 4.44059 2.64065 4.3948C2.73219 4.3033 2.88055 4.3033 2.9721 4.3948L3.04297 4.46567C3.17094 4.59364 3.37926 4.59364 3.50722 4.46567L3.5781 4.3948C3.66965 4.3033 3.81801 4.3033 3.90955 4.3948C3.9553 4.44059 3.97818 4.50055 3.97818 4.56055C3.97818 4.62055 3.9553 4.6805 3.90955 4.7263L3.83868 4.79717C3.71066 4.92514 3.71066 5.13345 3.83868 5.26142L3.90955 5.3323C3.9553 5.37809 3.97818 5.43805 3.97818 5.49805C3.97818 5.55805 3.9553 5.618 3.90955 5.6638C3.86385 5.70955 3.8039 5.73242 3.7439 5.73242V5.73242Z" fill="#FF9C33"/>
                                            <path d="M9.3708 23.1479C9.3108 23.1479 9.25085 23.1251 9.20505 23.0793L9.13418 23.0084C9.00621 22.8805 8.7979 22.8805 8.66993 23.0084L8.59905 23.0793C8.50751 23.1708 8.35915 23.1708 8.2676 23.0793C8.22185 23.0335 8.19897 22.9736 8.19897 22.9136C8.19897 22.8536 8.22185 22.7936 8.2676 22.7478L8.33847 22.6769C8.46649 22.549 8.46649 22.3407 8.33847 22.2127L8.2676 22.1418C8.22185 22.096 8.19897 22.0361 8.19897 21.9761C8.19897 21.9161 8.22185 21.8561 8.2676 21.8103C8.35915 21.7188 8.50751 21.7188 8.59905 21.8103L8.66993 21.8812C8.79785 22.0092 9.00616 22.0092 9.13422 21.8812L9.2051 21.8103C9.29665 21.7188 9.44501 21.7188 9.53655 21.8103C9.5823 21.8561 9.60518 21.9161 9.60518 21.9761C9.60518 22.0361 9.5823 22.096 9.53655 22.1418L9.46568 22.2127C9.40366 22.2747 9.36949 22.3572 9.36949 22.4448C9.36949 22.5325 9.40366 22.6149 9.46563 22.6769L9.53655 22.7478C9.5823 22.7936 9.60518 22.8536 9.60518 22.9136C9.60518 22.9736 9.5823 23.0335 9.53655 23.0793C9.49076 23.125 9.4308 23.1479 9.3708 23.1479Z" fill="#FF9C33"/>
                                         
                                        </svg>
                                            
                                              
                                    </div>
                                    <div class="content-right">
                                        <div class="title">
                                            <h3 class="fw_4 secondary_color">Shopping</h3>
                                            <span class="secondary_color fw_4">25 Min Ago</span>
                                        </div>
                                        <div class="desc">
                                            <p class="secondary_color fw_4">Alipay gives you 20% offcoupon for all bills, applicable for bills paid through Alipay wallet!</p>
                                        </div>
                                    </div>
                                </div>
                                <div class="noti-list">
                                    <div class="icon-box bg_service-3">
                                        <svg width="16" height="16" viewBox="0 0 25 24" fill="none" xmlns="http://www.w3.org/2000/svg">
                                            <path d="M24.2838 7.48567C22.5636 -5.34697 15.3153 2.01241 6.99199 5.99402C4.62414 7.12675 1.38339 7.13603 0.529097 10.1115C-0.458746 13.5521 2.49213 15.7224 4.86696 17.5562C7.726 19.7638 7.32082 24.1061 11.9929 23.7198C12.874 23.647 13.9302 23.7352 14.4994 23.0587C16.8551 20.2588 17.5094 16.0487 20.5731 13.8156C22.7339 12.2406 24.6702 10.3686 24.2838 7.48567V7.48567Z" fill="url(#paint0_linear_4516_5327)"/>
                                            <path d="M11.1101 8.50233C10.8512 8.50233 10.6413 8.29243 10.6413 8.03358V4.51604C10.6413 3.36872 9.70791 2.4353 8.56059 2.4353C7.41328 2.4353 6.47986 3.36872 6.47986 4.51604V8.03358C6.47986 8.29243 6.27 8.50233 6.01111 8.50233C5.75222 8.50233 5.54236 8.29243 5.54236 8.03358V4.51604C5.54236 2.85179 6.89634 1.4978 8.56059 1.4978C10.2248 1.4978 11.5788 2.85179 11.5788 4.51604V8.03358C11.5788 8.29248 11.369 8.50233 11.1101 8.50233V8.50233Z" fill="#FFC498"/>
                                            <path d="M4.77612 20.4084H2.87707C2.74085 20.4084 2.63332 20.2927 2.64335 20.1568L3.59196 7.27699C3.60096 7.15455 3.70296 7.05981 3.82568 7.05981H5.72482L4.77612 20.4084Z" fill="#FF7300"/>
                                            <path d="M10.2019 1.98511C9.70002 2.02945 9.26681 2.20284 8.90198 2.46379C9.5587 2.57269 10.1121 2.99006 10.4085 3.56161C10.4256 3.56119 10.4425 3.56029 10.4596 3.56029C10.8392 3.56029 11.1951 3.663 11.5018 3.84131C11.3243 3.06712 10.8485 2.40586 10.2019 1.98511V1.98511Z" fill="#FFAA66"/>
                                            <path d="M13.3223 5.13473C14.475 5.29359 15.5495 5.49229 16.5249 5.72507C16.6042 5.74396 16.6598 5.81503 16.6598 5.8965V9.13706C16.6598 9.26034 16.5367 9.34537 16.4213 9.30168C15.46 8.93756 14.4044 8.66198 13.2743 8.50078C13.1872 8.48836 13.1222 8.41434 13.1222 8.3264V5.30939C13.1222 5.2027 13.2166 5.12015 13.3223 5.13473V5.13473Z" fill="#9393FF"/>
                                            <path d="M19.934 11.522C19.3646 10.9961 18.6909 10.5108 17.9281 10.086C17.8721 10.0548 17.837 9.99604 17.837 9.93201V6.37448C17.837 6.25486 17.9539 6.16978 18.0677 6.20672C20.528 7.0057 22.0239 8.06062 22.0239 9.21736L21.8832 11.1587L19.934 11.522Z" fill="#9393FF"/>
                                            <path d="M22.0238 13.3463L21.8386 14.0752L22.0238 14.2763V14.5922L21.9179 15.2644L22.0238 15.5222V16.0791C22.0238 17.1707 20.6922 18.5447 18.4754 19.6873C18.2885 19.7836 18.0657 19.6472 18.0657 19.4369V12.4824C18.0657 12.3314 18.1622 12.1974 18.3052 12.1486C20.6241 11.3602 22.0238 10.3364 22.0238 9.21753V13.3463Z" fill="#D8D8FF"/>
                                            <path d="M22.0238 14.592V15.522C21.4594 16.2172 20.5032 16.8463 19.4996 17.4355C19.4625 17.4575 19.4217 17.4678 19.3814 17.4678C19.3008 17.4678 19.2225 17.4266 19.1789 17.352C19.1133 17.2405 19.1508 17.0966 19.2624 17.0314C20.9536 16.0386 21.8133 15.2853 22.0238 14.592V14.592Z" fill="#9393FF"/>
                                            <path d="M22.0238 13.3462V14.2762C21.4589 14.9713 20.5032 15.6004 19.4996 16.1896C19.4625 16.2112 19.4217 16.2215 19.3814 16.2215C19.3008 16.2215 19.2225 16.1803 19.1789 16.1062C19.1133 15.9942 19.1508 15.8507 19.2624 15.7851C20.9536 14.7923 21.8133 14.0395 22.0238 13.3462Z" fill="#9393FF"/>
                                            <path d="M19.3813 15.2074C19.3025 15.2074 19.2256 15.1678 19.1813 15.0957C19.1136 14.9854 19.148 14.8411 19.2583 14.7734C19.5345 14.6037 19.7758 14.4484 19.996 14.2986C20.1032 14.2258 20.2489 14.2537 20.3216 14.3607C20.3944 14.4678 20.3666 14.6136 20.2596 14.6863C20.0333 14.8401 19.786 14.9993 19.5037 15.1727C19.4655 15.1962 19.4231 15.2074 19.3813 15.2074V15.2074Z" fill="#9393FF"/>
                                            <path d="M19.3812 13.4436C19.2918 13.4436 19.2064 13.3922 19.1674 13.3054C19.1142 13.1874 19.1668 13.0486 19.2848 12.9955C19.6547 12.8289 19.9883 12.6536 20.2766 12.4743C20.3866 12.406 20.5311 12.4397 20.5994 12.5495C20.6677 12.6595 20.634 12.804 20.5242 12.8724C20.2183 13.0626 19.8661 13.2478 19.4773 13.4229C19.4461 13.4369 19.4134 13.4436 19.3812 13.4436V13.4436Z" fill="#FF9393"/>
                                            <path d="M18.0681 6.20699C17.9542 6.17001 17.837 6.2549 17.837 6.37462V9.93215C17.837 9.99623 17.8721 10.055 17.9281 10.0862C18.6779 10.5038 19.3408 10.9801 19.904 11.4957C19.4371 11.7274 18.9017 11.946 18.3048 12.149C18.1621 12.1976 18.0658 12.3317 18.0658 12.4826V19.437C18.0658 19.6473 18.2886 19.7838 18.4756 19.6874C20.6923 18.5446 22.0239 17.1709 22.0239 16.0793V9.21749C22.0239 8.0608 20.5282 7.00593 18.0681 6.20699Z" fill="url(#paint1_linear_4516_5327)"/>
                                            <path d="M16.1433 20.4084H4.77616C4.63975 20.4084 4.53241 20.2926 4.54225 20.1567L5.491 7.27685C5.49991 7.1545 5.6021 7.05981 5.72491 7.05981H15.1946C15.3174 7.05981 15.4191 7.1545 15.4285 7.27685L16.3768 20.1567C16.3871 20.2926 16.2793 20.4084 16.1433 20.4084Z" fill="#FFAA66"/>
                                            <path d="M11.0447 10.5326C10.9228 10.6545 10.7608 10.7216 10.5884 10.7216C10.4161 10.7216 10.2541 10.6545 10.1322 10.5326C10.0104 10.4107 9.94324 10.2487 9.94324 10.0763C9.94324 9.90399 10.0104 9.74199 10.1322 9.62011C10.3838 9.36849 10.7932 9.36854 11.0447 9.62011L11.2104 9.78586L11.5419 9.45441L11.3761 9.28866C11.2188 9.13135 11.0257 9.03188 10.8228 8.98847V8.53955H10.3541V8.98852C10.1512 9.03188 9.95805 9.13139 9.80074 9.28866C9.59036 9.49908 9.47449 9.77883 9.47449 10.0763C9.47449 10.3739 9.59036 10.6537 9.80074 10.864C9.95472 11.018 10.146 11.1211 10.3541 11.1655V11.6131H10.8228V11.1655C11.0309 11.1211 11.2221 11.018 11.3761 10.864L11.5419 10.6983L11.2104 10.3668L11.0447 10.5326Z" fill="white"/>
                                            <path d="M7.44153 7.05981H8.37903V8.87763C8.37903 9.13638 8.16903 9.34638 7.91028 9.34638C7.65153 9.34638 7.44153 9.13638 7.44153 8.87763V7.05981Z" fill="#FF9C33"/>
                                            <path d="M13.4781 7.05981V8.87763C13.4781 9.13638 13.2681 9.34638 13.0094 9.34638C12.7502 9.34638 12.5406 9.13638 12.5406 8.87763V7.05981H13.4781Z" fill="#FF9C33"/>
                                            <path d="M10.9984 13.5775C12.884 13.4304 14.6278 13.183 16.1577 12.8558C16.3769 12.8089 16.5833 12.9764 16.5833 13.2005V20.4353C16.5833 20.5874 16.4858 20.7222 16.3414 20.7701C14.7835 21.2871 12.9957 21.6755 11.0566 21.8444C10.8508 21.8623 10.6738 21.6995 10.6738 21.4929V13.9288C10.6738 13.745 10.8151 13.5918 10.9984 13.5775V13.5775Z" fill="#D8D8FF"/>
                                            <path d="M15.4929 20.1811C15.3913 20.1811 15.2977 20.1146 15.2679 20.0122C15.2318 19.8879 15.3032 19.7578 15.4274 19.7216C15.4987 19.7009 15.5694 19.6798 15.6398 19.6586C15.7636 19.621 15.8946 19.6911 15.9321 19.815C15.9696 19.9389 15.8995 20.0697 15.7756 20.1072C15.7036 20.129 15.6313 20.1505 15.5584 20.1717C15.5366 20.1781 15.5146 20.1811 15.4929 20.1811V20.1811Z" fill="#8282FF"/>
                                            <path d="M15.4929 19.4651C15.3913 19.4651 15.2977 19.3986 15.2679 19.2961C15.2318 19.1719 15.3032 19.0418 15.4274 19.0056C15.4987 18.9848 15.5694 18.9638 15.6398 18.9425C15.7636 18.9049 15.8946 18.9751 15.9321 19.0989C15.9696 19.2228 15.8995 19.3537 15.7756 19.3912C15.7036 19.413 15.6313 19.4344 15.5584 19.4556C15.5366 19.462 15.5146 19.4651 15.4929 19.4651V19.4651Z" fill="#8282FF"/>
                                            <path d="M16.0011 15.6087L14.8434 14.5739C14.8277 14.5598 14.8076 14.5527 14.7878 14.5541L14.2639 14.5906C14.2315 14.5929 14.2048 14.6166 14.1978 14.6498C14.1563 14.846 13.9983 14.997 13.7931 15.013C13.586 15.0292 13.3922 14.9033 13.3049 14.713C13.29 14.6807 13.2572 14.6607 13.2233 14.6631L12.6622 14.7021C12.6407 14.7036 12.6207 14.714 12.6071 14.7308L11.5495 16.0345C11.5196 16.0715 11.5257 16.1262 11.5632 16.1566L12.2405 16.7049C12.2768 16.7343 12.3301 16.7283 12.359 16.6915L12.7033 16.2534L12.643 18.6497C12.6416 18.7057 12.6911 18.7494 12.7465 18.7411L15.0027 18.4026C15.0469 18.396 15.0795 18.3579 15.0794 18.3132L15.074 16.0106L15.4573 16.3438C15.4903 16.3725 15.5408 16.3668 15.5666 16.3314L16.0137 15.7194C16.038 15.6862 16.0324 15.6366 16.0011 15.6087V15.6087Z" fill="#FFAA66"/>
                                            <path d="M12.9243 20.3039C13.5523 20.3039 14.0615 19.7948 14.0615 19.1667C14.0615 18.5387 13.5523 18.0295 12.9243 18.0295C12.2962 18.0295 11.7871 18.5387 11.7871 19.1667C11.7871 19.7948 12.2962 20.3039 12.9243 20.3039Z" fill="#FF6C6C"/>
                                            <path d="M12.7735 19.6973C12.7114 19.6973 12.6518 19.6726 12.6078 19.6287L12.3171 19.3379C12.2255 19.2464 12.2255 19.098 12.3171 19.0065C12.4086 18.915 12.5571 18.915 12.6485 19.0065L12.7735 19.1315L13.2002 18.7049C13.2917 18.6134 13.4402 18.6134 13.5316 18.7049C13.6232 18.7964 13.6232 18.9448 13.5316 19.0363L12.9392 19.6287C12.8953 19.6726 12.8357 19.6973 12.7735 19.6973V19.6973Z" fill="white"/>
                                            <path d="M14.3828 16.2914C14.2533 16.2914 14.1484 16.1864 14.1484 16.057V15.9878C14.1484 15.8584 14.2533 15.7534 14.3828 15.7534C14.5123 15.7534 14.6172 15.8584 14.6172 15.9878V16.057C14.6172 16.1864 14.5122 16.2914 14.3828 16.2914Z" fill="#FFD5BA"/>
                                            <path d="M13.0091 8.50233C12.7502 8.50233 12.5404 8.29243 12.5404 8.03358V4.51604C12.5404 3.36872 11.607 2.4353 10.4596 2.4353C9.31233 2.4353 8.37891 3.36872 8.37891 4.51604V8.03358C8.37891 8.29243 8.16905 8.50233 7.91016 8.50233C7.65127 8.50233 7.44141 8.29243 7.44141 8.03358V4.51604C7.44141 2.85179 8.79539 1.4978 10.4596 1.4978C12.1239 1.4978 13.4779 2.85179 13.4779 4.51604V8.03358C13.4779 8.29248 13.268 8.50233 13.0091 8.50233Z" fill="#FFD5BA"/>
                                            <path d="M8.8133 19.1614H6.17639C6.04697 19.1614 5.94202 19.0564 5.94202 18.927C5.94202 18.7976 6.04697 18.6926 6.17639 18.6926H8.8133C8.94272 18.6926 9.04767 18.7976 9.04767 18.927C9.04767 19.0564 8.94272 19.1614 8.8133 19.1614Z" fill="#FFD5BA"/>
                                            <path d="M8.86591 18.2642H6.229C6.09958 18.2642 5.99463 18.1592 5.99463 18.0298C5.99463 17.9004 6.09958 17.7954 6.229 17.7954H8.86591C8.99533 17.7954 9.10028 17.9004 9.10028 18.0298C9.10028 18.1592 8.99533 18.2642 8.86591 18.2642Z" fill="#FFD5BA"/>
                                            <path d="M7.0261 17.3667H6.28149C6.15207 17.3667 6.04712 17.2617 6.04712 17.1323C6.04712 17.0029 6.15207 16.8979 6.28149 16.8979H7.0261C7.15553 16.8979 7.26048 17.0029 7.26048 17.1323C7.26048 17.2617 7.15553 17.3667 7.0261 17.3667Z" fill="#FFD5BA"/>
                                            <path d="M16.525 5.72504C15.5939 5.5028 14.5715 5.31202 13.478 5.15696V4.51604C13.478 2.85179 12.124 1.4978 10.4597 1.4978C10.128 1.4978 9.80901 1.55237 9.51023 1.65169C9.21145 1.55237 8.89242 1.4978 8.56073 1.4978C6.89648 1.4978 5.5425 2.85179 5.5425 4.51604V7.05976H3.82584C3.70307 7.05976 3.60112 7.15449 3.59212 7.27693L2.64347 20.1568C2.63348 20.2927 2.74097 20.4084 2.87723 20.4084H10.6739V21.4929C10.6739 21.6995 10.8509 21.8623 11.0567 21.8444C12.9958 21.6755 14.7836 21.2871 16.3415 20.7701C16.4859 20.7222 16.5833 20.5874 16.5833 20.4353V13.2006C16.5833 12.9764 16.377 12.809 16.1578 12.8558C16.0543 12.878 15.9496 12.8997 15.8441 12.9211L15.5559 9.00638C15.852 9.09694 16.1408 9.19538 16.4214 9.30165C16.5367 9.34533 16.6598 9.2603 16.6598 9.13702V5.89646C16.6598 5.81504 16.6042 5.74397 16.525 5.72504V5.72504ZM7.4415 7.05976H6.48V4.51604C6.48 3.47265 7.25207 2.6064 8.25487 2.45799C7.75087 2.99757 7.4415 3.72118 7.4415 4.51604V7.05976ZM8.379 4.51604C8.379 3.71068 8.83926 3.01126 9.51023 2.66555C10.1812 3.01126 10.6415 3.71068 10.6415 4.51604V7.05976H8.379V4.51604ZM12.5405 7.05976H11.579V4.51604C11.579 3.72118 11.2696 2.99757 10.7656 2.45799C11.7684 2.6064 12.5405 3.47265 12.5405 4.51604V7.05976Z" fill="url(#paint2_linear_4516_5327)"/>
                                            <path d="M2.97083 3.40723H2.50208C2.24361 3.40723 2.03333 3.19695 2.03333 2.93848V2.46973C2.03333 2.21126 2.24361 2.00098 2.50208 2.00098H2.97083C3.22929 2.00098 3.43958 2.21126 3.43958 2.46973V2.93848C3.43958 3.19695 3.22929 3.40723 2.97083 3.40723V3.40723ZM2.50208 2.46973V2.93876L2.97083 2.93848V2.46973H2.50208Z" fill="#FF6C6C"/>
                                            <path d="M22.1149 20.8145H21.6461C21.3876 20.8145 21.1774 20.6042 21.1774 20.3457V19.877C21.1774 19.6185 21.3876 19.4082 21.6461 19.4082H22.1149C22.3733 19.4082 22.5836 19.6185 22.5836 19.877V20.3457C22.5836 20.6042 22.3733 20.8145 22.1149 20.8145ZM21.6461 19.877V20.346L22.1149 20.3457V19.877H21.6461Z" fill="#FF6C6C"/>
                                            <path d="M16.8109 4.39062H16.3422C16.0837 4.39062 15.8734 4.18034 15.8734 3.92188V3.45312C15.8734 3.19466 16.0837 2.98438 16.3422 2.98438H16.8109C17.0694 2.98438 17.2797 3.19466 17.2797 3.45312V3.92188C17.2797 4.18034 17.0694 4.39062 16.8109 4.39062ZM16.3422 3.45312V3.92216L16.8109 3.92188V3.45312H16.3422Z" fill="#6C6CFF"/>
                                            <path d="M3.7439 5.73242C3.6839 5.73242 3.62394 5.70955 3.57815 5.6638L3.50727 5.59292C3.37935 5.46495 3.17104 5.46495 3.04297 5.59292L2.9721 5.6638C2.88055 5.7553 2.73219 5.7553 2.64065 5.6638C2.5949 5.618 2.57202 5.55805 2.57202 5.49805C2.57202 5.43805 2.5949 5.37809 2.64065 5.3323L2.71152 5.26142C2.77354 5.19941 2.80771 5.11695 2.80771 5.0293C2.80771 4.94164 2.77354 4.85919 2.71157 4.79717L2.64065 4.7263C2.5949 4.6805 2.57202 4.62055 2.57202 4.56055C2.57202 4.50055 2.5949 4.44059 2.64065 4.3948C2.73219 4.3033 2.88055 4.3033 2.9721 4.3948L3.04297 4.46567C3.17094 4.59364 3.37926 4.59364 3.50722 4.46567L3.5781 4.3948C3.66965 4.3033 3.81801 4.3033 3.90955 4.3948C3.9553 4.44059 3.97818 4.50055 3.97818 4.56055C3.97818 4.62055 3.9553 4.6805 3.90955 4.7263L3.83868 4.79717C3.71066 4.92514 3.71066 5.13345 3.83868 5.26142L3.90955 5.3323C3.9553 5.37809 3.97818 5.43805 3.97818 5.49805C3.97818 5.55805 3.9553 5.618 3.90955 5.6638C3.86385 5.70955 3.8039 5.73242 3.7439 5.73242V5.73242Z" fill="#FF9C33"/>
                                            <path d="M9.3708 23.1479C9.3108 23.1479 9.25085 23.1251 9.20505 23.0793L9.13418 23.0084C9.00621 22.8805 8.7979 22.8805 8.66993 23.0084L8.59905 23.0793C8.50751 23.1708 8.35915 23.1708 8.2676 23.0793C8.22185 23.0335 8.19897 22.9736 8.19897 22.9136C8.19897 22.8536 8.22185 22.7936 8.2676 22.7478L8.33847 22.6769C8.46649 22.549 8.46649 22.3407 8.33847 22.2127L8.2676 22.1418C8.22185 22.096 8.19897 22.0361 8.19897 21.9761C8.19897 21.9161 8.22185 21.8561 8.2676 21.8103C8.35915 21.7188 8.50751 21.7188 8.59905 21.8103L8.66993 21.8812C8.79785 22.0092 9.00616 22.0092 9.13422 21.8812L9.2051 21.8103C9.29665 21.7188 9.44501 21.7188 9.53655 21.8103C9.5823 21.8561 9.60518 21.9161 9.60518 21.9761C9.60518 22.0361 9.5823 22.096 9.53655 22.1418L9.46568 22.2127C9.40366 22.2747 9.36949 22.3572 9.36949 22.4448C9.36949 22.5325 9.40366 22.6149 9.46563 22.6769L9.53655 22.7478C9.5823 22.7936 9.60518 22.8536 9.60518 22.9136C9.60518 22.9736 9.5823 23.0335 9.53655 23.0793C9.49076 23.125 9.4308 23.1479 9.3708 23.1479Z" fill="#FF9C33"/>
                                         
                                        </svg>
                                            
                                              
                                    </div>
                                    <div class="content-right">
                                        <div class="title">
                                            <h3 class="fw_6">Shopping</h3>
                                            <span class="fw_6 on_surface_color">1 Hour  Ago</span>
                                        </div>
                                        <div class="desc">
                                            <p class="on_surface_color fw_4">Alipay gives you 20% offcoupon for all bills, applicable for bills paid through Alipay wallet!</p>
                                            <i class="dot"></i>
                                        </div>
                                    </div>
                                </div>
                                <div class="noti-list">
                                    <div class="icon-box bg_service-7">
                                        <svg width="16" height="16" viewBox="0 0 25 22" fill="none" xmlns="http://www.w3.org/2000/svg">
                                            <path d="M5.10792 2.89151V3.71843H2.76196V2.89151C2.76196 2.64696 2.9602 2.44873 3.20474 2.44873H4.66513C4.90968 2.44873 5.10792 2.64696 5.10792 2.89151Z" fill="#6D6D6D"/>
                                            <path d="M21.9048 2.89151V3.71843H19.5588V2.89151C19.5588 2.64696 19.7571 2.44873 20.0016 2.44873H21.462C21.7066 2.44873 21.9048 2.64696 21.9048 2.89151Z" fill="#6D6D6D"/>
                                            <path d="M15.7525 5.0683H8.91426C8.63245 5.0683 8.40393 4.83978 8.40393 4.55797V1.85661C8.40393 1.15315 8.97632 0.580811 9.67973 0.580811H14.987C15.6905 0.580811 16.2628 1.1532 16.2628 1.85661V4.55797C16.2628 4.83978 16.0343 5.0683 15.7525 5.0683ZM9.42454 4.04764H15.2421V1.85661C15.2421 1.71584 15.1276 1.60147 14.987 1.60147H9.67973C9.53906 1.60147 9.42459 1.71584 9.42459 1.85661V4.04764H9.42454Z" fill="#6D6D6D"/>
                                            <path d="M5.39564 19.5364V20.9087C5.39564 21.1906 5.16718 21.4191 4.88532 21.4191H2.62739C2.34553 21.4191 2.11707 21.1906 2.11707 20.9087V19.5364H5.39564Z" fill="#EA4E4E"/>
                                            <path d="M22.5498 19.5364V20.9087C22.5498 21.1906 22.3213 21.4191 22.0395 21.4191H19.7816C19.4997 21.4191 19.2712 21.1906 19.2712 20.9087V19.5364H22.5498Z" fill="#EA4E4E"/>
                                            <path d="M24.326 4.50845V19.2502C24.326 19.8139 23.869 20.2709 23.3053 20.2709H1.36148C0.797805 20.2709 0.34082 19.8139 0.34082 19.2502V4.50845C0.34082 3.94478 0.797758 3.48779 1.36148 3.48779H23.3053C23.869 3.48779 24.326 3.94478 24.326 4.50845Z" fill="#F96464"/>
                                            <g opacity="0.4">
                                            <path d="M1.91377 7.6168C1.63191 7.6168 1.40344 7.38834 1.40344 7.10648V5.27498C1.40344 4.99312 1.63191 4.76465 1.91377 4.76465C2.19563 4.76465 2.4241 4.99312 2.4241 5.27498V7.10648C2.4241 7.38834 2.19563 7.6168 1.91377 7.6168Z" fill="white"/>
                                            </g>
                                            <g opacity="0.08">
                                            <path d="M24.326 4.50943V19.2501C24.326 19.814 23.8693 20.2707 23.3054 20.2707H21.5116C22.0755 20.2707 22.5323 19.814 22.5323 19.2501V4.50943C22.5323 3.94552 22.0755 3.48877 21.5116 3.48877H23.3054C23.8693 3.48877 24.326 3.94552 24.326 4.50943Z" fill="black"/>
                                            </g>
                                            <path d="M12.3335 17.3581C15.3597 17.3581 17.8129 14.9048 17.8129 11.8786C17.8129 8.8524 15.3597 6.39917 12.3335 6.39917C9.30724 6.39917 6.854 8.8524 6.854 11.8786C6.854 14.9048 9.30724 17.3581 12.3335 17.3581Z" fill="#F2F0F0"/>
                                            <path d="M16.0116 11.3237V12.4362C16.0116 12.718 15.7831 12.9465 15.5012 12.9465H13.3987V15.0464C13.3987 15.3283 13.1702 15.5568 12.8884 15.5568H11.7758C11.494 15.5568 11.2655 15.3283 11.2655 15.0464V12.9465H9.1656C8.88374 12.9465 8.65527 12.718 8.65527 12.4362V11.3237C8.65527 11.0418 8.88374 10.8133 9.1656 10.8133H11.2656V8.71077C11.2656 8.42891 11.494 8.20044 11.7759 8.20044H12.8884C13.1703 8.20044 13.3987 8.42891 13.3987 8.71077V10.8133H15.5013C15.7831 10.8133 16.0116 11.0418 16.0116 11.3237Z" fill="#F96464"/>
                                        </svg>
                                    </div>
                                    <div class="content-right">
                                        <div class="title">
                                            <h3 class="fw_4 secondary_color">Medical</h3>
                                            <span class="secondary_color fw_4">15 Hour Ago</span>
                                        </div>
                                        <div class="desc">
                                            <p class="secondary_color fw_4">Alipay gives you 20% offcoupon for all bills, applicable for bills paid through Alipay wallet!</p>
                                        </div>
                                    </div>
                                </div>
                                <div class="noti-list">
                                    <div class="icon-box bg_service-6">
                                        <svg width="16" height="16" viewBox="0 0 16 16" fill="none" xmlns="http://www.w3.org/2000/svg">
                                            <path d="M7.99995 14.7062C12.0609 14.7062 15.353 11.4141 15.353 7.35309C15.353 3.29209 12.0609 0 7.99995 0C3.93894 0 0.646851 3.29209 0.646851 7.35309C0.646851 11.4141 3.93894 14.7062 7.99995 14.7062Z" fill="#F7B239"/>
                                            <path d="M7.99997 12.1931C10.673 12.1931 12.8399 10.0261 12.8399 7.35312C12.8399 4.6801 10.673 2.51318 7.99997 2.51318C5.32695 2.51318 3.16003 4.6801 3.16003 7.35312C3.16003 10.0261 5.32695 12.1931 7.99997 12.1931Z" fill="#E09B2D"/>
                                            <path d="M14.6157 15.1809C14.6307 15.2373 14.638 15.294 14.638 15.3495C14.638 15.637 14.4463 15.8997 14.1558 15.9776C13.8089 16.0706 13.4521 15.8646 13.3591 15.5178L12.2661 11.4386C12.1731 11.0918 12.3791 10.7349 12.726 10.6419C13.0732 10.549 13.4297 10.755 13.5227 11.1022L14.6157 15.1809Z" fill="#F24C8F"/>
                                            <path d="M2.4596 11.5182L3.01855 11.668L4.49394 6.16149L3.93499 6.01173L2.4596 11.5182Z" fill="#CCCCCC"/>
                                            <path d="M11.6446 7.71971L12.4469 10.7156L13.0059 10.5659L12.2036 7.57L11.6446 7.71971Z" fill="#CCCCCC"/>
                                            <path d="M5.26403 2.1712C6.18881 2.41888 6.60972 3.8456 6.20463 5.3572C5.79953 6.86917 4.88478 7.28545 3.96 7.03776C3.03559 6.79007 2.4515 5.97217 2.85659 4.4602C3.26169 2.94823 4.33963 1.92351 5.26403 2.1712Z" fill="#E6E6E6"/>
                                            <path d="M2.9944 10.642C3.34162 10.7349 3.54727 11.0918 3.45427 11.4386L2.36168 15.5178C2.28374 15.8083 2.02099 16 1.73359 16C1.67802 16 1.6213 15.9927 1.56499 15.9776C1.21777 15.8847 1.01174 15.5278 1.10471 15.181L2.19771 11.1022C2.29068 10.755 2.64755 10.549 2.9944 10.642Z" fill="#F24C8F"/>
                                            <path d="M13.0658 6.02202L12.141 2.57046C12.1045 2.4344 11.9629 2.35446 11.8268 2.39515C11.6951 2.43455 11.6237 2.57771 11.6592 2.71046L12.3966 5.46168C12.4517 5.66743 12.3296 5.87893 12.1239 5.93408L12.1235 5.93415C11.9177 5.98937 11.7061 5.86721 11.651 5.66143L10.911 2.89987C10.8745 2.76371 10.7327 2.6838 10.5967 2.72458C10.465 2.76405 10.3937 2.90718 10.4293 3.0399L11.1666 5.79137C11.2217 5.99715 11.0996 6.20865 10.8938 6.26383C10.688 6.31896 10.4766 6.19687 10.4214 5.99108L9.68139 3.22937C9.64493 3.09324 9.5033 3.01337 9.36721 3.05405C9.23552 3.09346 9.16408 3.23658 9.19964 3.36933L10.1216 6.81049C10.2269 7.20383 10.479 7.53255 10.8316 7.73615C11.0665 7.87177 11.327 7.94102 11.5912 7.94102C11.7236 7.94102 11.857 7.92358 11.9883 7.8884C12.6534 7.71015 13.1178 7.10524 13.1178 6.4174C13.1178 6.28349 13.1003 6.15027 13.0658 6.02202Z" fill="#E6E6E6"/>
                                        </svg>
                                            
                                              
                                    </div>
                                    <div class="content-right">
                                        <div class="title">
                                            <h3 class="fw_4 secondary_color">Travel</h3>
                                            <span class="secondary_color fw_4">1 Day Ago</span>
                                        </div>
                                        <div class="desc">
                                            <p class="secondary_color fw_4">Alipay gives you 20% offcoupon for all bills, applicable for bills paid through Alipay wallet!</p>
                                        </div>
                                    </div>
                                </div>
                                <div class="noti-list">
                                    <div class="icon-box bg_service-3">
                                        <svg width="16" height="16" viewBox="0 0 25 24" fill="none" xmlns="http://www.w3.org/2000/svg">
                                            <path d="M24.2838 7.48567C22.5636 -5.34697 15.3153 2.01241 6.99199 5.99402C4.62414 7.12675 1.38339 7.13603 0.529097 10.1115C-0.458746 13.5521 2.49213 15.7224 4.86696 17.5562C7.726 19.7638 7.32082 24.1061 11.9929 23.7198C12.874 23.647 13.9302 23.7352 14.4994 23.0587C16.8551 20.2588 17.5094 16.0487 20.5731 13.8156C22.7339 12.2406 24.6702 10.3686 24.2838 7.48567V7.48567Z" fill="url(#paint0_linear_4516_5327)"/>
                                            <path d="M11.1101 8.50233C10.8512 8.50233 10.6413 8.29243 10.6413 8.03358V4.51604C10.6413 3.36872 9.70791 2.4353 8.56059 2.4353C7.41328 2.4353 6.47986 3.36872 6.47986 4.51604V8.03358C6.47986 8.29243 6.27 8.50233 6.01111 8.50233C5.75222 8.50233 5.54236 8.29243 5.54236 8.03358V4.51604C5.54236 2.85179 6.89634 1.4978 8.56059 1.4978C10.2248 1.4978 11.5788 2.85179 11.5788 4.51604V8.03358C11.5788 8.29248 11.369 8.50233 11.1101 8.50233V8.50233Z" fill="#FFC498"/>
                                            <path d="M4.77612 20.4084H2.87707C2.74085 20.4084 2.63332 20.2927 2.64335 20.1568L3.59196 7.27699C3.60096 7.15455 3.70296 7.05981 3.82568 7.05981H5.72482L4.77612 20.4084Z" fill="#FF7300"/>
                                            <path d="M10.2019 1.98511C9.70002 2.02945 9.26681 2.20284 8.90198 2.46379C9.5587 2.57269 10.1121 2.99006 10.4085 3.56161C10.4256 3.56119 10.4425 3.56029 10.4596 3.56029C10.8392 3.56029 11.1951 3.663 11.5018 3.84131C11.3243 3.06712 10.8485 2.40586 10.2019 1.98511V1.98511Z" fill="#FFAA66"/>
                                            <path d="M13.3223 5.13473C14.475 5.29359 15.5495 5.49229 16.5249 5.72507C16.6042 5.74396 16.6598 5.81503 16.6598 5.8965V9.13706C16.6598 9.26034 16.5367 9.34537 16.4213 9.30168C15.46 8.93756 14.4044 8.66198 13.2743 8.50078C13.1872 8.48836 13.1222 8.41434 13.1222 8.3264V5.30939C13.1222 5.2027 13.2166 5.12015 13.3223 5.13473V5.13473Z" fill="#9393FF"/>
                                            <path d="M19.934 11.522C19.3646 10.9961 18.6909 10.5108 17.9281 10.086C17.8721 10.0548 17.837 9.99604 17.837 9.93201V6.37448C17.837 6.25486 17.9539 6.16978 18.0677 6.20672C20.528 7.0057 22.0239 8.06062 22.0239 9.21736L21.8832 11.1587L19.934 11.522Z" fill="#9393FF"/>
                                            <path d="M22.0238 13.3463L21.8386 14.0752L22.0238 14.2763V14.5922L21.9179 15.2644L22.0238 15.5222V16.0791C22.0238 17.1707 20.6922 18.5447 18.4754 19.6873C18.2885 19.7836 18.0657 19.6472 18.0657 19.4369V12.4824C18.0657 12.3314 18.1622 12.1974 18.3052 12.1486C20.6241 11.3602 22.0238 10.3364 22.0238 9.21753V13.3463Z" fill="#D8D8FF"/>
                                            <path d="M22.0238 14.592V15.522C21.4594 16.2172 20.5032 16.8463 19.4996 17.4355C19.4625 17.4575 19.4217 17.4678 19.3814 17.4678C19.3008 17.4678 19.2225 17.4266 19.1789 17.352C19.1133 17.2405 19.1508 17.0966 19.2624 17.0314C20.9536 16.0386 21.8133 15.2853 22.0238 14.592V14.592Z" fill="#9393FF"/>
                                            <path d="M22.0238 13.3462V14.2762C21.4589 14.9713 20.5032 15.6004 19.4996 16.1896C19.4625 16.2112 19.4217 16.2215 19.3814 16.2215C19.3008 16.2215 19.2225 16.1803 19.1789 16.1062C19.1133 15.9942 19.1508 15.8507 19.2624 15.7851C20.9536 14.7923 21.8133 14.0395 22.0238 13.3462Z" fill="#9393FF"/>
                                            <path d="M19.3813 15.2074C19.3025 15.2074 19.2256 15.1678 19.1813 15.0957C19.1136 14.9854 19.148 14.8411 19.2583 14.7734C19.5345 14.6037 19.7758 14.4484 19.996 14.2986C20.1032 14.2258 20.2489 14.2537 20.3216 14.3607C20.3944 14.4678 20.3666 14.6136 20.2596 14.6863C20.0333 14.8401 19.786 14.9993 19.5037 15.1727C19.4655 15.1962 19.4231 15.2074 19.3813 15.2074V15.2074Z" fill="#9393FF"/>
                                            <path d="M19.3812 13.4436C19.2918 13.4436 19.2064 13.3922 19.1674 13.3054C19.1142 13.1874 19.1668 13.0486 19.2848 12.9955C19.6547 12.8289 19.9883 12.6536 20.2766 12.4743C20.3866 12.406 20.5311 12.4397 20.5994 12.5495C20.6677 12.6595 20.634 12.804 20.5242 12.8724C20.2183 13.0626 19.8661 13.2478 19.4773 13.4229C19.4461 13.4369 19.4134 13.4436 19.3812 13.4436V13.4436Z" fill="#FF9393"/>
                                            <path d="M18.0681 6.20699C17.9542 6.17001 17.837 6.2549 17.837 6.37462V9.93215C17.837 9.99623 17.8721 10.055 17.9281 10.0862C18.6779 10.5038 19.3408 10.9801 19.904 11.4957C19.4371 11.7274 18.9017 11.946 18.3048 12.149C18.1621 12.1976 18.0658 12.3317 18.0658 12.4826V19.437C18.0658 19.6473 18.2886 19.7838 18.4756 19.6874C20.6923 18.5446 22.0239 17.1709 22.0239 16.0793V9.21749C22.0239 8.0608 20.5282 7.00593 18.0681 6.20699Z" fill="url(#paint1_linear_4516_5327)"/>
                                            <path d="M16.1433 20.4084H4.77616C4.63975 20.4084 4.53241 20.2926 4.54225 20.1567L5.491 7.27685C5.49991 7.1545 5.6021 7.05981 5.72491 7.05981H15.1946C15.3174 7.05981 15.4191 7.1545 15.4285 7.27685L16.3768 20.1567C16.3871 20.2926 16.2793 20.4084 16.1433 20.4084Z" fill="#FFAA66"/>
                                            <path d="M11.0447 10.5326C10.9228 10.6545 10.7608 10.7216 10.5884 10.7216C10.4161 10.7216 10.2541 10.6545 10.1322 10.5326C10.0104 10.4107 9.94324 10.2487 9.94324 10.0763C9.94324 9.90399 10.0104 9.74199 10.1322 9.62011C10.3838 9.36849 10.7932 9.36854 11.0447 9.62011L11.2104 9.78586L11.5419 9.45441L11.3761 9.28866C11.2188 9.13135 11.0257 9.03188 10.8228 8.98847V8.53955H10.3541V8.98852C10.1512 9.03188 9.95805 9.13139 9.80074 9.28866C9.59036 9.49908 9.47449 9.77883 9.47449 10.0763C9.47449 10.3739 9.59036 10.6537 9.80074 10.864C9.95472 11.018 10.146 11.1211 10.3541 11.1655V11.6131H10.8228V11.1655C11.0309 11.1211 11.2221 11.018 11.3761 10.864L11.5419 10.6983L11.2104 10.3668L11.0447 10.5326Z" fill="white"/>
                                            <path d="M7.44153 7.05981H8.37903V8.87763C8.37903 9.13638 8.16903 9.34638 7.91028 9.34638C7.65153 9.34638 7.44153 9.13638 7.44153 8.87763V7.05981Z" fill="#FF9C33"/>
                                            <path d="M13.4781 7.05981V8.87763C13.4781 9.13638 13.2681 9.34638 13.0094 9.34638C12.7502 9.34638 12.5406 9.13638 12.5406 8.87763V7.05981H13.4781Z" fill="#FF9C33"/>
                                            <path d="M10.9984 13.5775C12.884 13.4304 14.6278 13.183 16.1577 12.8558C16.3769 12.8089 16.5833 12.9764 16.5833 13.2005V20.4353C16.5833 20.5874 16.4858 20.7222 16.3414 20.7701C14.7835 21.2871 12.9957 21.6755 11.0566 21.8444C10.8508 21.8623 10.6738 21.6995 10.6738 21.4929V13.9288C10.6738 13.745 10.8151 13.5918 10.9984 13.5775V13.5775Z" fill="#D8D8FF"/>
                                            <path d="M15.4929 20.1811C15.3913 20.1811 15.2977 20.1146 15.2679 20.0122C15.2318 19.8879 15.3032 19.7578 15.4274 19.7216C15.4987 19.7009 15.5694 19.6798 15.6398 19.6586C15.7636 19.621 15.8946 19.6911 15.9321 19.815C15.9696 19.9389 15.8995 20.0697 15.7756 20.1072C15.7036 20.129 15.6313 20.1505 15.5584 20.1717C15.5366 20.1781 15.5146 20.1811 15.4929 20.1811V20.1811Z" fill="#8282FF"/>
                                            <path d="M15.4929 19.4651C15.3913 19.4651 15.2977 19.3986 15.2679 19.2961C15.2318 19.1719 15.3032 19.0418 15.4274 19.0056C15.4987 18.9848 15.5694 18.9638 15.6398 18.9425C15.7636 18.9049 15.8946 18.9751 15.9321 19.0989C15.9696 19.2228 15.8995 19.3537 15.7756 19.3912C15.7036 19.413 15.6313 19.4344 15.5584 19.4556C15.5366 19.462 15.5146 19.4651 15.4929 19.4651V19.4651Z" fill="#8282FF"/>
                                            <path d="M16.0011 15.6087L14.8434 14.5739C14.8277 14.5598 14.8076 14.5527 14.7878 14.5541L14.2639 14.5906C14.2315 14.5929 14.2048 14.6166 14.1978 14.6498C14.1563 14.846 13.9983 14.997 13.7931 15.013C13.586 15.0292 13.3922 14.9033 13.3049 14.713C13.29 14.6807 13.2572 14.6607 13.2233 14.6631L12.6622 14.7021C12.6407 14.7036 12.6207 14.714 12.6071 14.7308L11.5495 16.0345C11.5196 16.0715 11.5257 16.1262 11.5632 16.1566L12.2405 16.7049C12.2768 16.7343 12.3301 16.7283 12.359 16.6915L12.7033 16.2534L12.643 18.6497C12.6416 18.7057 12.6911 18.7494 12.7465 18.7411L15.0027 18.4026C15.0469 18.396 15.0795 18.3579 15.0794 18.3132L15.074 16.0106L15.4573 16.3438C15.4903 16.3725 15.5408 16.3668 15.5666 16.3314L16.0137 15.7194C16.038 15.6862 16.0324 15.6366 16.0011 15.6087V15.6087Z" fill="#FFAA66"/>
                                            <path d="M12.9243 20.3039C13.5523 20.3039 14.0615 19.7948 14.0615 19.1667C14.0615 18.5387 13.5523 18.0295 12.9243 18.0295C12.2962 18.0295 11.7871 18.5387 11.7871 19.1667C11.7871 19.7948 12.2962 20.3039 12.9243 20.3039Z" fill="#FF6C6C"/>
                                            <path d="M12.7735 19.6973C12.7114 19.6973 12.6518 19.6726 12.6078 19.6287L12.3171 19.3379C12.2255 19.2464 12.2255 19.098 12.3171 19.0065C12.4086 18.915 12.5571 18.915 12.6485 19.0065L12.7735 19.1315L13.2002 18.7049C13.2917 18.6134 13.4402 18.6134 13.5316 18.7049C13.6232 18.7964 13.6232 18.9448 13.5316 19.0363L12.9392 19.6287C12.8953 19.6726 12.8357 19.6973 12.7735 19.6973V19.6973Z" fill="white"/>
                                            <path d="M14.3828 16.2914C14.2533 16.2914 14.1484 16.1864 14.1484 16.057V15.9878C14.1484 15.8584 14.2533 15.7534 14.3828 15.7534C14.5123 15.7534 14.6172 15.8584 14.6172 15.9878V16.057C14.6172 16.1864 14.5122 16.2914 14.3828 16.2914Z" fill="#FFD5BA"/>
                                            <path d="M13.0091 8.50233C12.7502 8.50233 12.5404 8.29243 12.5404 8.03358V4.51604C12.5404 3.36872 11.607 2.4353 10.4596 2.4353C9.31233 2.4353 8.37891 3.36872 8.37891 4.51604V8.03358C8.37891 8.29243 8.16905 8.50233 7.91016 8.50233C7.65127 8.50233 7.44141 8.29243 7.44141 8.03358V4.51604C7.44141 2.85179 8.79539 1.4978 10.4596 1.4978C12.1239 1.4978 13.4779 2.85179 13.4779 4.51604V8.03358C13.4779 8.29248 13.268 8.50233 13.0091 8.50233Z" fill="#FFD5BA"/>
                                            <path d="M8.8133 19.1614H6.17639C6.04697 19.1614 5.94202 19.0564 5.94202 18.927C5.94202 18.7976 6.04697 18.6926 6.17639 18.6926H8.8133C8.94272 18.6926 9.04767 18.7976 9.04767 18.927C9.04767 19.0564 8.94272 19.1614 8.8133 19.1614Z" fill="#FFD5BA"/>
                                            <path d="M8.86591 18.2642H6.229C6.09958 18.2642 5.99463 18.1592 5.99463 18.0298C5.99463 17.9004 6.09958 17.7954 6.229 17.7954H8.86591C8.99533 17.7954 9.10028 17.9004 9.10028 18.0298C9.10028 18.1592 8.99533 18.2642 8.86591 18.2642Z" fill="#FFD5BA"/>
                                            <path d="M7.0261 17.3667H6.28149C6.15207 17.3667 6.04712 17.2617 6.04712 17.1323C6.04712 17.0029 6.15207 16.8979 6.28149 16.8979H7.0261C7.15553 16.8979 7.26048 17.0029 7.26048 17.1323C7.26048 17.2617 7.15553 17.3667 7.0261 17.3667Z" fill="#FFD5BA"/>
                                            <path d="M16.525 5.72504C15.5939 5.5028 14.5715 5.31202 13.478 5.15696V4.51604C13.478 2.85179 12.124 1.4978 10.4597 1.4978C10.128 1.4978 9.80901 1.55237 9.51023 1.65169C9.21145 1.55237 8.89242 1.4978 8.56073 1.4978C6.89648 1.4978 5.5425 2.85179 5.5425 4.51604V7.05976H3.82584C3.70307 7.05976 3.60112 7.15449 3.59212 7.27693L2.64347 20.1568C2.63348 20.2927 2.74097 20.4084 2.87723 20.4084H10.6739V21.4929C10.6739 21.6995 10.8509 21.8623 11.0567 21.8444C12.9958 21.6755 14.7836 21.2871 16.3415 20.7701C16.4859 20.7222 16.5833 20.5874 16.5833 20.4353V13.2006C16.5833 12.9764 16.377 12.809 16.1578 12.8558C16.0543 12.878 15.9496 12.8997 15.8441 12.9211L15.5559 9.00638C15.852 9.09694 16.1408 9.19538 16.4214 9.30165C16.5367 9.34533 16.6598 9.2603 16.6598 9.13702V5.89646C16.6598 5.81504 16.6042 5.74397 16.525 5.72504V5.72504ZM7.4415 7.05976H6.48V4.51604C6.48 3.47265 7.25207 2.6064 8.25487 2.45799C7.75087 2.99757 7.4415 3.72118 7.4415 4.51604V7.05976ZM8.379 4.51604C8.379 3.71068 8.83926 3.01126 9.51023 2.66555C10.1812 3.01126 10.6415 3.71068 10.6415 4.51604V7.05976H8.379V4.51604ZM12.5405 7.05976H11.579V4.51604C11.579 3.72118 11.2696 2.99757 10.7656 2.45799C11.7684 2.6064 12.5405 3.47265 12.5405 4.51604V7.05976Z" fill="url(#paint2_linear_4516_5327)"/>
                                            <path d="M2.97083 3.40723H2.50208C2.24361 3.40723 2.03333 3.19695 2.03333 2.93848V2.46973C2.03333 2.21126 2.24361 2.00098 2.50208 2.00098H2.97083C3.22929 2.00098 3.43958 2.21126 3.43958 2.46973V2.93848C3.43958 3.19695 3.22929 3.40723 2.97083 3.40723V3.40723ZM2.50208 2.46973V2.93876L2.97083 2.93848V2.46973H2.50208Z" fill="#FF6C6C"/>
                                            <path d="M22.1149 20.8145H21.6461C21.3876 20.8145 21.1774 20.6042 21.1774 20.3457V19.877C21.1774 19.6185 21.3876 19.4082 21.6461 19.4082H22.1149C22.3733 19.4082 22.5836 19.6185 22.5836 19.877V20.3457C22.5836 20.6042 22.3733 20.8145 22.1149 20.8145ZM21.6461 19.877V20.346L22.1149 20.3457V19.877H21.6461Z" fill="#FF6C6C"/>
                                            <path d="M16.8109 4.39062H16.3422C16.0837 4.39062 15.8734 4.18034 15.8734 3.92188V3.45312C15.8734 3.19466 16.0837 2.98438 16.3422 2.98438H16.8109C17.0694 2.98438 17.2797 3.19466 17.2797 3.45312V3.92188C17.2797 4.18034 17.0694 4.39062 16.8109 4.39062ZM16.3422 3.45312V3.92216L16.8109 3.92188V3.45312H16.3422Z" fill="#6C6CFF"/>
                                            <path d="M3.7439 5.73242C3.6839 5.73242 3.62394 5.70955 3.57815 5.6638L3.50727 5.59292C3.37935 5.46495 3.17104 5.46495 3.04297 5.59292L2.9721 5.6638C2.88055 5.7553 2.73219 5.7553 2.64065 5.6638C2.5949 5.618 2.57202 5.55805 2.57202 5.49805C2.57202 5.43805 2.5949 5.37809 2.64065 5.3323L2.71152 5.26142C2.77354 5.19941 2.80771 5.11695 2.80771 5.0293C2.80771 4.94164 2.77354 4.85919 2.71157 4.79717L2.64065 4.7263C2.5949 4.6805 2.57202 4.62055 2.57202 4.56055C2.57202 4.50055 2.5949 4.44059 2.64065 4.3948C2.73219 4.3033 2.88055 4.3033 2.9721 4.3948L3.04297 4.46567C3.17094 4.59364 3.37926 4.59364 3.50722 4.46567L3.5781 4.3948C3.66965 4.3033 3.81801 4.3033 3.90955 4.3948C3.9553 4.44059 3.97818 4.50055 3.97818 4.56055C3.97818 4.62055 3.9553 4.6805 3.90955 4.7263L3.83868 4.79717C3.71066 4.92514 3.71066 5.13345 3.83868 5.26142L3.90955 5.3323C3.9553 5.37809 3.97818 5.43805 3.97818 5.49805C3.97818 5.55805 3.9553 5.618 3.90955 5.6638C3.86385 5.70955 3.8039 5.73242 3.7439 5.73242V5.73242Z" fill="#FF9C33"/>
                                            <path d="M9.3708 23.1479C9.3108 23.1479 9.25085 23.1251 9.20505 23.0793L9.13418 23.0084C9.00621 22.8805 8.7979 22.8805 8.66993 23.0084L8.59905 23.0793C8.50751 23.1708 8.35915 23.1708 8.2676 23.0793C8.22185 23.0335 8.19897 22.9736 8.19897 22.9136C8.19897 22.8536 8.22185 22.7936 8.2676 22.7478L8.33847 22.6769C8.46649 22.549 8.46649 22.3407 8.33847 22.2127L8.2676 22.1418C8.22185 22.096 8.19897 22.0361 8.19897 21.9761C8.19897 21.9161 8.22185 21.8561 8.2676 21.8103C8.35915 21.7188 8.50751 21.7188 8.59905 21.8103L8.66993 21.8812C8.79785 22.0092 9.00616 22.0092 9.13422 21.8812L9.2051 21.8103C9.29665 21.7188 9.44501 21.7188 9.53655 21.8103C9.5823 21.8561 9.60518 21.9161 9.60518 21.9761C9.60518 22.0361 9.5823 22.096 9.53655 22.1418L9.46568 22.2127C9.40366 22.2747 9.36949 22.3572 9.36949 22.4448C9.36949 22.5325 9.40366 22.6149 9.46563 22.6769L9.53655 22.7478C9.5823 22.7936 9.60518 22.8536 9.60518 22.9136C9.60518 22.9736 9.5823 23.0335 9.53655 23.0793C9.49076 23.125 9.4308 23.1479 9.3708 23.1479Z" fill="#FF9C33"/>
                                         
                                        </svg>
                                            
                                              
                                    </div>
                                    <div class="content-right">
                                        <div class="title">
                                            <h3 class="fw_6">Shopping</h3>
                                            <span class="fw_6 on_surface_color">9/1/2023</span>
                                        </div>
                                        <div class="desc">
                                            <p class="on_surface_color fw_4">Alipay gives you 20% offcoupon for all bills, applicable for bills paid through Alipay wallet!</p>
                                            <i class="dot"></i>
                                        </div>
                                    </div>
                                </div>
                                <div class="noti-list">
                                    <div class="icon-box bg_service-3">
                                        <svg width="16" height="16" viewBox="0 0 25 24" fill="none" xmlns="http://www.w3.org/2000/svg">
                                            <path d="M24.2838 7.48567C22.5636 -5.34697 15.3153 2.01241 6.99199 5.99402C4.62414 7.12675 1.38339 7.13603 0.529097 10.1115C-0.458746 13.5521 2.49213 15.7224 4.86696 17.5562C7.726 19.7638 7.32082 24.1061 11.9929 23.7198C12.874 23.647 13.9302 23.7352 14.4994 23.0587C16.8551 20.2588 17.5094 16.0487 20.5731 13.8156C22.7339 12.2406 24.6702 10.3686 24.2838 7.48567V7.48567Z" fill="url(#paint0_linear_4516_5327)"/>
                                            <path d="M11.1101 8.50233C10.8512 8.50233 10.6413 8.29243 10.6413 8.03358V4.51604C10.6413 3.36872 9.70791 2.4353 8.56059 2.4353C7.41328 2.4353 6.47986 3.36872 6.47986 4.51604V8.03358C6.47986 8.29243 6.27 8.50233 6.01111 8.50233C5.75222 8.50233 5.54236 8.29243 5.54236 8.03358V4.51604C5.54236 2.85179 6.89634 1.4978 8.56059 1.4978C10.2248 1.4978 11.5788 2.85179 11.5788 4.51604V8.03358C11.5788 8.29248 11.369 8.50233 11.1101 8.50233V8.50233Z" fill="#FFC498"/>
                                            <path d="M4.77612 20.4084H2.87707C2.74085 20.4084 2.63332 20.2927 2.64335 20.1568L3.59196 7.27699C3.60096 7.15455 3.70296 7.05981 3.82568 7.05981H5.72482L4.77612 20.4084Z" fill="#FF7300"/>
                                            <path d="M10.2019 1.98511C9.70002 2.02945 9.26681 2.20284 8.90198 2.46379C9.5587 2.57269 10.1121 2.99006 10.4085 3.56161C10.4256 3.56119 10.4425 3.56029 10.4596 3.56029C10.8392 3.56029 11.1951 3.663 11.5018 3.84131C11.3243 3.06712 10.8485 2.40586 10.2019 1.98511V1.98511Z" fill="#FFAA66"/>
                                            <path d="M13.3223 5.13473C14.475 5.29359 15.5495 5.49229 16.5249 5.72507C16.6042 5.74396 16.6598 5.81503 16.6598 5.8965V9.13706C16.6598 9.26034 16.5367 9.34537 16.4213 9.30168C15.46 8.93756 14.4044 8.66198 13.2743 8.50078C13.1872 8.48836 13.1222 8.41434 13.1222 8.3264V5.30939C13.1222 5.2027 13.2166 5.12015 13.3223 5.13473V5.13473Z" fill="#9393FF"/>
                                            <path d="M19.934 11.522C19.3646 10.9961 18.6909 10.5108 17.9281 10.086C17.8721 10.0548 17.837 9.99604 17.837 9.93201V6.37448C17.837 6.25486 17.9539 6.16978 18.0677 6.20672C20.528 7.0057 22.0239 8.06062 22.0239 9.21736L21.8832 11.1587L19.934 11.522Z" fill="#9393FF"/>
                                            <path d="M22.0238 13.3463L21.8386 14.0752L22.0238 14.2763V14.5922L21.9179 15.2644L22.0238 15.5222V16.0791C22.0238 17.1707 20.6922 18.5447 18.4754 19.6873C18.2885 19.7836 18.0657 19.6472 18.0657 19.4369V12.4824C18.0657 12.3314 18.1622 12.1974 18.3052 12.1486C20.6241 11.3602 22.0238 10.3364 22.0238 9.21753V13.3463Z" fill="#D8D8FF"/>
                                            <path d="M22.0238 14.592V15.522C21.4594 16.2172 20.5032 16.8463 19.4996 17.4355C19.4625 17.4575 19.4217 17.4678 19.3814 17.4678C19.3008 17.4678 19.2225 17.4266 19.1789 17.352C19.1133 17.2405 19.1508 17.0966 19.2624 17.0314C20.9536 16.0386 21.8133 15.2853 22.0238 14.592V14.592Z" fill="#9393FF"/>
                                            <path d="M22.0238 13.3462V14.2762C21.4589 14.9713 20.5032 15.6004 19.4996 16.1896C19.4625 16.2112 19.4217 16.2215 19.3814 16.2215C19.3008 16.2215 19.2225 16.1803 19.1789 16.1062C19.1133 15.9942 19.1508 15.8507 19.2624 15.7851C20.9536 14.7923 21.8133 14.0395 22.0238 13.3462Z" fill="#9393FF"/>
                                            <path d="M19.3813 15.2074C19.3025 15.2074 19.2256 15.1678 19.1813 15.0957C19.1136 14.9854 19.148 14.8411 19.2583 14.7734C19.5345 14.6037 19.7758 14.4484 19.996 14.2986C20.1032 14.2258 20.2489 14.2537 20.3216 14.3607C20.3944 14.4678 20.3666 14.6136 20.2596 14.6863C20.0333 14.8401 19.786 14.9993 19.5037 15.1727C19.4655 15.1962 19.4231 15.2074 19.3813 15.2074V15.2074Z" fill="#9393FF"/>
                                            <path d="M19.3812 13.4436C19.2918 13.4436 19.2064 13.3922 19.1674 13.3054C19.1142 13.1874 19.1668 13.0486 19.2848 12.9955C19.6547 12.8289 19.9883 12.6536 20.2766 12.4743C20.3866 12.406 20.5311 12.4397 20.5994 12.5495C20.6677 12.6595 20.634 12.804 20.5242 12.8724C20.2183 13.0626 19.8661 13.2478 19.4773 13.4229C19.4461 13.4369 19.4134 13.4436 19.3812 13.4436V13.4436Z" fill="#FF9393"/>
                                            <path d="M18.0681 6.20699C17.9542 6.17001 17.837 6.2549 17.837 6.37462V9.93215C17.837 9.99623 17.8721 10.055 17.9281 10.0862C18.6779 10.5038 19.3408 10.9801 19.904 11.4957C19.4371 11.7274 18.9017 11.946 18.3048 12.149C18.1621 12.1976 18.0658 12.3317 18.0658 12.4826V19.437C18.0658 19.6473 18.2886 19.7838 18.4756 19.6874C20.6923 18.5446 22.0239 17.1709 22.0239 16.0793V9.21749C22.0239 8.0608 20.5282 7.00593 18.0681 6.20699Z" fill="url(#paint1_linear_4516_5327)"/>
                                            <path d="M16.1433 20.4084H4.77616C4.63975 20.4084 4.53241 20.2926 4.54225 20.1567L5.491 7.27685C5.49991 7.1545 5.6021 7.05981 5.72491 7.05981H15.1946C15.3174 7.05981 15.4191 7.1545 15.4285 7.27685L16.3768 20.1567C16.3871 20.2926 16.2793 20.4084 16.1433 20.4084Z" fill="#FFAA66"/>
                                            <path d="M11.0447 10.5326C10.9228 10.6545 10.7608 10.7216 10.5884 10.7216C10.4161 10.7216 10.2541 10.6545 10.1322 10.5326C10.0104 10.4107 9.94324 10.2487 9.94324 10.0763C9.94324 9.90399 10.0104 9.74199 10.1322 9.62011C10.3838 9.36849 10.7932 9.36854 11.0447 9.62011L11.2104 9.78586L11.5419 9.45441L11.3761 9.28866C11.2188 9.13135 11.0257 9.03188 10.8228 8.98847V8.53955H10.3541V8.98852C10.1512 9.03188 9.95805 9.13139 9.80074 9.28866C9.59036 9.49908 9.47449 9.77883 9.47449 10.0763C9.47449 10.3739 9.59036 10.6537 9.80074 10.864C9.95472 11.018 10.146 11.1211 10.3541 11.1655V11.6131H10.8228V11.1655C11.0309 11.1211 11.2221 11.018 11.3761 10.864L11.5419 10.6983L11.2104 10.3668L11.0447 10.5326Z" fill="white"/>
                                            <path d="M7.44153 7.05981H8.37903V8.87763C8.37903 9.13638 8.16903 9.34638 7.91028 9.34638C7.65153 9.34638 7.44153 9.13638 7.44153 8.87763V7.05981Z" fill="#FF9C33"/>
                                            <path d="M13.4781 7.05981V8.87763C13.4781 9.13638 13.2681 9.34638 13.0094 9.34638C12.7502 9.34638 12.5406 9.13638 12.5406 8.87763V7.05981H13.4781Z" fill="#FF9C33"/>
                                            <path d="M10.9984 13.5775C12.884 13.4304 14.6278 13.183 16.1577 12.8558C16.3769 12.8089 16.5833 12.9764 16.5833 13.2005V20.4353C16.5833 20.5874 16.4858 20.7222 16.3414 20.7701C14.7835 21.2871 12.9957 21.6755 11.0566 21.8444C10.8508 21.8623 10.6738 21.6995 10.6738 21.4929V13.9288C10.6738 13.745 10.8151 13.5918 10.9984 13.5775V13.5775Z" fill="#D8D8FF"/>
                                            <path d="M15.4929 20.1811C15.3913 20.1811 15.2977 20.1146 15.2679 20.0122C15.2318 19.8879 15.3032 19.7578 15.4274 19.7216C15.4987 19.7009 15.5694 19.6798 15.6398 19.6586C15.7636 19.621 15.8946 19.6911 15.9321 19.815C15.9696 19.9389 15.8995 20.0697 15.7756 20.1072C15.7036 20.129 15.6313 20.1505 15.5584 20.1717C15.5366 20.1781 15.5146 20.1811 15.4929 20.1811V20.1811Z" fill="#8282FF"/>
                                            <path d="M15.4929 19.4651C15.3913 19.4651 15.2977 19.3986 15.2679 19.2961C15.2318 19.1719 15.3032 19.0418 15.4274 19.0056C15.4987 18.9848 15.5694 18.9638 15.6398 18.9425C15.7636 18.9049 15.8946 18.9751 15.9321 19.0989C15.9696 19.2228 15.8995 19.3537 15.7756 19.3912C15.7036 19.413 15.6313 19.4344 15.5584 19.4556C15.5366 19.462 15.5146 19.4651 15.4929 19.4651V19.4651Z" fill="#8282FF"/>
                                            <path d="M16.0011 15.6087L14.8434 14.5739C14.8277 14.5598 14.8076 14.5527 14.7878 14.5541L14.2639 14.5906C14.2315 14.5929 14.2048 14.6166 14.1978 14.6498C14.1563 14.846 13.9983 14.997 13.7931 15.013C13.586 15.0292 13.3922 14.9033 13.3049 14.713C13.29 14.6807 13.2572 14.6607 13.2233 14.6631L12.6622 14.7021C12.6407 14.7036 12.6207 14.714 12.6071 14.7308L11.5495 16.0345C11.5196 16.0715 11.5257 16.1262 11.5632 16.1566L12.2405 16.7049C12.2768 16.7343 12.3301 16.7283 12.359 16.6915L12.7033 16.2534L12.643 18.6497C12.6416 18.7057 12.6911 18.7494 12.7465 18.7411L15.0027 18.4026C15.0469 18.396 15.0795 18.3579 15.0794 18.3132L15.074 16.0106L15.4573 16.3438C15.4903 16.3725 15.5408 16.3668 15.5666 16.3314L16.0137 15.7194C16.038 15.6862 16.0324 15.6366 16.0011 15.6087V15.6087Z" fill="#FFAA66"/>
                                            <path d="M12.9243 20.3039C13.5523 20.3039 14.0615 19.7948 14.0615 19.1667C14.0615 18.5387 13.5523 18.0295 12.9243 18.0295C12.2962 18.0295 11.7871 18.5387 11.7871 19.1667C11.7871 19.7948 12.2962 20.3039 12.9243 20.3039Z" fill="#FF6C6C"/>
                                            <path d="M12.7735 19.6973C12.7114 19.6973 12.6518 19.6726 12.6078 19.6287L12.3171 19.3379C12.2255 19.2464 12.2255 19.098 12.3171 19.0065C12.4086 18.915 12.5571 18.915 12.6485 19.0065L12.7735 19.1315L13.2002 18.7049C13.2917 18.6134 13.4402 18.6134 13.5316 18.7049C13.6232 18.7964 13.6232 18.9448 13.5316 19.0363L12.9392 19.6287C12.8953 19.6726 12.8357 19.6973 12.7735 19.6973V19.6973Z" fill="white"/>
                                            <path d="M14.3828 16.2914C14.2533 16.2914 14.1484 16.1864 14.1484 16.057V15.9878C14.1484 15.8584 14.2533 15.7534 14.3828 15.7534C14.5123 15.7534 14.6172 15.8584 14.6172 15.9878V16.057C14.6172 16.1864 14.5122 16.2914 14.3828 16.2914Z" fill="#FFD5BA"/>
                                            <path d="M13.0091 8.50233C12.7502 8.50233 12.5404 8.29243 12.5404 8.03358V4.51604C12.5404 3.36872 11.607 2.4353 10.4596 2.4353C9.31233 2.4353 8.37891 3.36872 8.37891 4.51604V8.03358C8.37891 8.29243 8.16905 8.50233 7.91016 8.50233C7.65127 8.50233 7.44141 8.29243 7.44141 8.03358V4.51604C7.44141 2.85179 8.79539 1.4978 10.4596 1.4978C12.1239 1.4978 13.4779 2.85179 13.4779 4.51604V8.03358C13.4779 8.29248 13.268 8.50233 13.0091 8.50233Z" fill="#FFD5BA"/>
                                            <path d="M8.8133 19.1614H6.17639C6.04697 19.1614 5.94202 19.0564 5.94202 18.927C5.94202 18.7976 6.04697 18.6926 6.17639 18.6926H8.8133C8.94272 18.6926 9.04767 18.7976 9.04767 18.927C9.04767 19.0564 8.94272 19.1614 8.8133 19.1614Z" fill="#FFD5BA"/>
                                            <path d="M8.86591 18.2642H6.229C6.09958 18.2642 5.99463 18.1592 5.99463 18.0298C5.99463 17.9004 6.09958 17.7954 6.229 17.7954H8.86591C8.99533 17.7954 9.10028 17.9004 9.10028 18.0298C9.10028 18.1592 8.99533 18.2642 8.86591 18.2642Z" fill="#FFD5BA"/>
                                            <path d="M7.0261 17.3667H6.28149C6.15207 17.3667 6.04712 17.2617 6.04712 17.1323C6.04712 17.0029 6.15207 16.8979 6.28149 16.8979H7.0261C7.15553 16.8979 7.26048 17.0029 7.26048 17.1323C7.26048 17.2617 7.15553 17.3667 7.0261 17.3667Z" fill="#FFD5BA"/>
                                            <path d="M16.525 5.72504C15.5939 5.5028 14.5715 5.31202 13.478 5.15696V4.51604C13.478 2.85179 12.124 1.4978 10.4597 1.4978C10.128 1.4978 9.80901 1.55237 9.51023 1.65169C9.21145 1.55237 8.89242 1.4978 8.56073 1.4978C6.89648 1.4978 5.5425 2.85179 5.5425 4.51604V7.05976H3.82584C3.70307 7.05976 3.60112 7.15449 3.59212 7.27693L2.64347 20.1568C2.63348 20.2927 2.74097 20.4084 2.87723 20.4084H10.6739V21.4929C10.6739 21.6995 10.8509 21.8623 11.0567 21.8444C12.9958 21.6755 14.7836 21.2871 16.3415 20.7701C16.4859 20.7222 16.5833 20.5874 16.5833 20.4353V13.2006C16.5833 12.9764 16.377 12.809 16.1578 12.8558C16.0543 12.878 15.9496 12.8997 15.8441 12.9211L15.5559 9.00638C15.852 9.09694 16.1408 9.19538 16.4214 9.30165C16.5367 9.34533 16.6598 9.2603 16.6598 9.13702V5.89646C16.6598 5.81504 16.6042 5.74397 16.525 5.72504V5.72504ZM7.4415 7.05976H6.48V4.51604C6.48 3.47265 7.25207 2.6064 8.25487 2.45799C7.75087 2.99757 7.4415 3.72118 7.4415 4.51604V7.05976ZM8.379 4.51604C8.379 3.71068 8.83926 3.01126 9.51023 2.66555C10.1812 3.01126 10.6415 3.71068 10.6415 4.51604V7.05976H8.379V4.51604ZM12.5405 7.05976H11.579V4.51604C11.579 3.72118 11.2696 2.99757 10.7656 2.45799C11.7684 2.6064 12.5405 3.47265 12.5405 4.51604V7.05976Z" fill="url(#paint2_linear_4516_5327)"/>
                                            <path d="M2.97083 3.40723H2.50208C2.24361 3.40723 2.03333 3.19695 2.03333 2.93848V2.46973C2.03333 2.21126 2.24361 2.00098 2.50208 2.00098H2.97083C3.22929 2.00098 3.43958 2.21126 3.43958 2.46973V2.93848C3.43958 3.19695 3.22929 3.40723 2.97083 3.40723V3.40723ZM2.50208 2.46973V2.93876L2.97083 2.93848V2.46973H2.50208Z" fill="#FF6C6C"/>
                                            <path d="M22.1149 20.8145H21.6461C21.3876 20.8145 21.1774 20.6042 21.1774 20.3457V19.877C21.1774 19.6185 21.3876 19.4082 21.6461 19.4082H22.1149C22.3733 19.4082 22.5836 19.6185 22.5836 19.877V20.3457C22.5836 20.6042 22.3733 20.8145 22.1149 20.8145ZM21.6461 19.877V20.346L22.1149 20.3457V19.877H21.6461Z" fill="#FF6C6C"/>
                                            <path d="M16.8109 4.39062H16.3422C16.0837 4.39062 15.8734 4.18034 15.8734 3.92188V3.45312C15.8734 3.19466 16.0837 2.98438 16.3422 2.98438H16.8109C17.0694 2.98438 17.2797 3.19466 17.2797 3.45312V3.92188C17.2797 4.18034 17.0694 4.39062 16.8109 4.39062ZM16.3422 3.45312V3.92216L16.8109 3.92188V3.45312H16.3422Z" fill="#6C6CFF"/>
                                            <path d="M3.7439 5.73242C3.6839 5.73242 3.62394 5.70955 3.57815 5.6638L3.50727 5.59292C3.37935 5.46495 3.17104 5.46495 3.04297 5.59292L2.9721 5.6638C2.88055 5.7553 2.73219 5.7553 2.64065 5.6638C2.5949 5.618 2.57202 5.55805 2.57202 5.49805C2.57202 5.43805 2.5949 5.37809 2.64065 5.3323L2.71152 5.26142C2.77354 5.19941 2.80771 5.11695 2.80771 5.0293C2.80771 4.94164 2.77354 4.85919 2.71157 4.79717L2.64065 4.7263C2.5949 4.6805 2.57202 4.62055 2.57202 4.56055C2.57202 4.50055 2.5949 4.44059 2.64065 4.3948C2.73219 4.3033 2.88055 4.3033 2.9721 4.3948L3.04297 4.46567C3.17094 4.59364 3.37926 4.59364 3.50722 4.46567L3.5781 4.3948C3.66965 4.3033 3.81801 4.3033 3.90955 4.3948C3.9553 4.44059 3.97818 4.50055 3.97818 4.56055C3.97818 4.62055 3.9553 4.6805 3.90955 4.7263L3.83868 4.79717C3.71066 4.92514 3.71066 5.13345 3.83868 5.26142L3.90955 5.3323C3.9553 5.37809 3.97818 5.43805 3.97818 5.49805C3.97818 5.55805 3.9553 5.618 3.90955 5.6638C3.86385 5.70955 3.8039 5.73242 3.7439 5.73242V5.73242Z" fill="#FF9C33"/>
                                            <path d="M9.3708 23.1479C9.3108 23.1479 9.25085 23.1251 9.20505 23.0793L9.13418 23.0084C9.00621 22.8805 8.7979 22.8805 8.66993 23.0084L8.59905 23.0793C8.50751 23.1708 8.35915 23.1708 8.2676 23.0793C8.22185 23.0335 8.19897 22.9736 8.19897 22.9136C8.19897 22.8536 8.22185 22.7936 8.2676 22.7478L8.33847 22.6769C8.46649 22.549 8.46649 22.3407 8.33847 22.2127L8.2676 22.1418C8.22185 22.096 8.19897 22.0361 8.19897 21.9761C8.19897 21.9161 8.22185 21.8561 8.2676 21.8103C8.35915 21.7188 8.50751 21.7188 8.59905 21.8103L8.66993 21.8812C8.79785 22.0092 9.00616 22.0092 9.13422 21.8812L9.2051 21.8103C9.29665 21.7188 9.44501 21.7188 9.53655 21.8103C9.5823 21.8561 9.60518 21.9161 9.60518 21.9761C9.60518 22.0361 9.5823 22.096 9.53655 22.1418L9.46568 22.2127C9.40366 22.2747 9.36949 22.3572 9.36949 22.4448C9.36949 22.5325 9.40366 22.6149 9.46563 22.6769L9.53655 22.7478C9.5823 22.7936 9.60518 22.8536 9.60518 22.9136C9.60518 22.9736 9.5823 23.0335 9.53655 23.0793C9.49076 23.125 9.4308 23.1479 9.3708 23.1479Z" fill="#FF9C33"/>
                                         
                                        </svg>
                                            
                                              
                                    </div>
                                    <div class="content-right">
                                        <div class="title">
                                            <h3 class="fw_4 secondary_color">Shopping</h3>
                                            <span class="secondary_color fw_4">7/1/2023</span>
                                        </div>
                                        <div class="desc">
                                            <p class="secondary_color fw_4">Alipay gives you 20% offcoupon for all bills, applicable for bills paid through Alipay wallet!</p>
                                        </div>
                                    </div>
                                </div>
                                <div class="noti-list">
                                    <div class="icon-box bg_service-6">
                                        <svg width="16" height="16" viewBox="0 0 16 16" fill="none" xmlns="http://www.w3.org/2000/svg">
                                            <path d="M7.99995 14.7062C12.0609 14.7062 15.353 11.4141 15.353 7.35309C15.353 3.29209 12.0609 0 7.99995 0C3.93894 0 0.646851 3.29209 0.646851 7.35309C0.646851 11.4141 3.93894 14.7062 7.99995 14.7062Z" fill="#F7B239"/>
                                            <path d="M7.99997 12.1931C10.673 12.1931 12.8399 10.0261 12.8399 7.35312C12.8399 4.6801 10.673 2.51318 7.99997 2.51318C5.32695 2.51318 3.16003 4.6801 3.16003 7.35312C3.16003 10.0261 5.32695 12.1931 7.99997 12.1931Z" fill="#E09B2D"/>
                                            <path d="M14.6157 15.1809C14.6307 15.2373 14.638 15.294 14.638 15.3495C14.638 15.637 14.4463 15.8997 14.1558 15.9776C13.8089 16.0706 13.4521 15.8646 13.3591 15.5178L12.2661 11.4386C12.1731 11.0918 12.3791 10.7349 12.726 10.6419C13.0732 10.549 13.4297 10.755 13.5227 11.1022L14.6157 15.1809Z" fill="#F24C8F"/>
                                            <path d="M2.4596 11.5182L3.01855 11.668L4.49394 6.16149L3.93499 6.01173L2.4596 11.5182Z" fill="#CCCCCC"/>
                                            <path d="M11.6446 7.71971L12.4469 10.7156L13.0059 10.5659L12.2036 7.57L11.6446 7.71971Z" fill="#CCCCCC"/>
                                            <path d="M5.26403 2.1712C6.18881 2.41888 6.60972 3.8456 6.20463 5.3572C5.79953 6.86917 4.88478 7.28545 3.96 7.03776C3.03559 6.79007 2.4515 5.97217 2.85659 4.4602C3.26169 2.94823 4.33963 1.92351 5.26403 2.1712Z" fill="#E6E6E6"/>
                                            <path d="M2.9944 10.642C3.34162 10.7349 3.54727 11.0918 3.45427 11.4386L2.36168 15.5178C2.28374 15.8083 2.02099 16 1.73359 16C1.67802 16 1.6213 15.9927 1.56499 15.9776C1.21777 15.8847 1.01174 15.5278 1.10471 15.181L2.19771 11.1022C2.29068 10.755 2.64755 10.549 2.9944 10.642Z" fill="#F24C8F"/>
                                            <path d="M13.0658 6.02202L12.141 2.57046C12.1045 2.4344 11.9629 2.35446 11.8268 2.39515C11.6951 2.43455 11.6237 2.57771 11.6592 2.71046L12.3966 5.46168C12.4517 5.66743 12.3296 5.87893 12.1239 5.93408L12.1235 5.93415C11.9177 5.98937 11.7061 5.86721 11.651 5.66143L10.911 2.89987C10.8745 2.76371 10.7327 2.6838 10.5967 2.72458C10.465 2.76405 10.3937 2.90718 10.4293 3.0399L11.1666 5.79137C11.2217 5.99715 11.0996 6.20865 10.8938 6.26383C10.688 6.31896 10.4766 6.19687 10.4214 5.99108L9.68139 3.22937C9.64493 3.09324 9.5033 3.01337 9.36721 3.05405C9.23552 3.09346 9.16408 3.23658 9.19964 3.36933L10.1216 6.81049C10.2269 7.20383 10.479 7.53255 10.8316 7.73615C11.0665 7.87177 11.327 7.94102 11.5912 7.94102C11.7236 7.94102 11.857 7.92358 11.9883 7.8884C12.6534 7.71015 13.1178 7.10524 13.1178 6.4174C13.1178 6.28349 13.1003 6.15027 13.0658 6.02202Z" fill="#E6E6E6"/>
                                        </svg>
                                            
                                              
                                    </div>
                                    <div class="content-right">
                                        <div class="title">
                                            <h3 class="fw_4 secondary_color">Travel</h3>
                                            <span class="secondary_color fw_4">1 Day Ago</span>
                                        </div>
                                        <div class="desc">
                                            <p class="secondary_color fw_4">Alipay gives you 20% offcoupon for all bills, applicable for bills paid through Alipay wallet!</p>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <!-- 2 -->
                            <div class="noti-box">
                                <div class="noti-list">
                                    <div class="icon-box bg_service-4">
                                        <svg width="16" height="16" viewBox="0 0 16 16" fill="none" xmlns="http://www.w3.org/2000/svg">
                                            <path d="M7.99995 14.7062C12.0609 14.7062 15.353 11.4141 15.353 7.35309C15.353 3.29209 12.0609 0 7.99995 0C3.93894 0 0.646851 3.29209 0.646851 7.35309C0.646851 11.4141 3.93894 14.7062 7.99995 14.7062Z" fill="#F7B239"/>
                                            <path d="M7.99997 12.1931C10.673 12.1931 12.8399 10.0261 12.8399 7.35312C12.8399 4.6801 10.673 2.51318 7.99997 2.51318C5.32695 2.51318 3.16003 4.6801 3.16003 7.35312C3.16003 10.0261 5.32695 12.1931 7.99997 12.1931Z" fill="#E09B2D"/>
                                            <path d="M14.6157 15.1809C14.6307 15.2373 14.638 15.294 14.638 15.3495C14.638 15.637 14.4463 15.8997 14.1558 15.9776C13.8089 16.0706 13.4521 15.8646 13.3591 15.5178L12.2661 11.4386C12.1731 11.0918 12.3791 10.7349 12.726 10.6419C13.0732 10.549 13.4297 10.755 13.5227 11.1022L14.6157 15.1809Z" fill="#F24C8F"/>
                                            <path d="M2.4596 11.5182L3.01855 11.668L4.49394 6.16149L3.93499 6.01173L2.4596 11.5182Z" fill="#CCCCCC"/>
                                            <path d="M11.6446 7.71971L12.4469 10.7156L13.0059 10.5659L12.2036 7.57L11.6446 7.71971Z" fill="#CCCCCC"/>
                                            <path d="M5.26403 2.1712C6.18881 2.41888 6.60972 3.8456 6.20463 5.3572C5.79953 6.86917 4.88478 7.28545 3.96 7.03776C3.03559 6.79007 2.4515 5.97217 2.85659 4.4602C3.26169 2.94823 4.33963 1.92351 5.26403 2.1712Z" fill="#E6E6E6"/>
                                            <path d="M2.9944 10.642C3.34162 10.7349 3.54727 11.0918 3.45427 11.4386L2.36168 15.5178C2.28374 15.8083 2.02099 16 1.73359 16C1.67802 16 1.6213 15.9927 1.56499 15.9776C1.21777 15.8847 1.01174 15.5278 1.10471 15.181L2.19771 11.1022C2.29068 10.755 2.64755 10.549 2.9944 10.642Z" fill="#F24C8F"/>
                                            <path d="M13.0658 6.02202L12.141 2.57046C12.1045 2.4344 11.9629 2.35446 11.8268 2.39515C11.6951 2.43455 11.6237 2.57771 11.6592 2.71046L12.3966 5.46168C12.4517 5.66743 12.3296 5.87893 12.1239 5.93408L12.1235 5.93415C11.9177 5.98937 11.7061 5.86721 11.651 5.66143L10.911 2.89987C10.8745 2.76371 10.7327 2.6838 10.5967 2.72458C10.465 2.76405 10.3937 2.90718 10.4293 3.0399L11.1666 5.79137C11.2217 5.99715 11.0996 6.20865 10.8938 6.26383C10.688 6.31896 10.4766 6.19687 10.4214 5.99108L9.68139 3.22937C9.64493 3.09324 9.5033 3.01337 9.36721 3.05405C9.23552 3.09346 9.16408 3.23658 9.19964 3.36933L10.1216 6.81049C10.2269 7.20383 10.479 7.53255 10.8316 7.73615C11.0665 7.87177 11.327 7.94102 11.5912 7.94102C11.7236 7.94102 11.857 7.92358 11.9883 7.8884C12.6534 7.71015 13.1178 7.10524 13.1178 6.4174C13.1178 6.28349 13.1003 6.15027 13.0658 6.02202Z" fill="#E6E6E6"/>
                                        </svg>
                                            
                                    </div>
                                    <div class="content-right">
                                        <div class="title">
                                            <h3 class="fw_6">Restaurant</h3>
                                            <span class="fw_6 on_surface_color">5 Min Ago</span>
                                        </div>
                                        <div class="desc">
                                            <p class="on_surface_color fw_4">Alipay gives you 20% offcoupon for all bills, applicable for bills paid through Alipay wallet!</p>
                                            <i class="dot"></i>
                                        </div>
                                    </div>
                                </div>
                                <div class="noti-list">
                                    <div class="icon-box bg_service-3">
                                        <svg width="16" height="16" viewBox="0 0 25 24" fill="none" xmlns="http://www.w3.org/2000/svg">
                                            <path d="M24.2838 7.48567C22.5636 -5.34697 15.3153 2.01241 6.99199 5.99402C4.62414 7.12675 1.38339 7.13603 0.529097 10.1115C-0.458746 13.5521 2.49213 15.7224 4.86696 17.5562C7.726 19.7638 7.32082 24.1061 11.9929 23.7198C12.874 23.647 13.9302 23.7352 14.4994 23.0587C16.8551 20.2588 17.5094 16.0487 20.5731 13.8156C22.7339 12.2406 24.6702 10.3686 24.2838 7.48567V7.48567Z" fill="url(#paint0_linear_4516_5327)"/>
                                            <path d="M11.1101 8.50233C10.8512 8.50233 10.6413 8.29243 10.6413 8.03358V4.51604C10.6413 3.36872 9.70791 2.4353 8.56059 2.4353C7.41328 2.4353 6.47986 3.36872 6.47986 4.51604V8.03358C6.47986 8.29243 6.27 8.50233 6.01111 8.50233C5.75222 8.50233 5.54236 8.29243 5.54236 8.03358V4.51604C5.54236 2.85179 6.89634 1.4978 8.56059 1.4978C10.2248 1.4978 11.5788 2.85179 11.5788 4.51604V8.03358C11.5788 8.29248 11.369 8.50233 11.1101 8.50233V8.50233Z" fill="#FFC498"/>
                                            <path d="M4.77612 20.4084H2.87707C2.74085 20.4084 2.63332 20.2927 2.64335 20.1568L3.59196 7.27699C3.60096 7.15455 3.70296 7.05981 3.82568 7.05981H5.72482L4.77612 20.4084Z" fill="#FF7300"/>
                                            <path d="M10.2019 1.98511C9.70002 2.02945 9.26681 2.20284 8.90198 2.46379C9.5587 2.57269 10.1121 2.99006 10.4085 3.56161C10.4256 3.56119 10.4425 3.56029 10.4596 3.56029C10.8392 3.56029 11.1951 3.663 11.5018 3.84131C11.3243 3.06712 10.8485 2.40586 10.2019 1.98511V1.98511Z" fill="#FFAA66"/>
                                            <path d="M13.3223 5.13473C14.475 5.29359 15.5495 5.49229 16.5249 5.72507C16.6042 5.74396 16.6598 5.81503 16.6598 5.8965V9.13706C16.6598 9.26034 16.5367 9.34537 16.4213 9.30168C15.46 8.93756 14.4044 8.66198 13.2743 8.50078C13.1872 8.48836 13.1222 8.41434 13.1222 8.3264V5.30939C13.1222 5.2027 13.2166 5.12015 13.3223 5.13473V5.13473Z" fill="#9393FF"/>
                                            <path d="M19.934 11.522C19.3646 10.9961 18.6909 10.5108 17.9281 10.086C17.8721 10.0548 17.837 9.99604 17.837 9.93201V6.37448C17.837 6.25486 17.9539 6.16978 18.0677 6.20672C20.528 7.0057 22.0239 8.06062 22.0239 9.21736L21.8832 11.1587L19.934 11.522Z" fill="#9393FF"/>
                                            <path d="M22.0238 13.3463L21.8386 14.0752L22.0238 14.2763V14.5922L21.9179 15.2644L22.0238 15.5222V16.0791C22.0238 17.1707 20.6922 18.5447 18.4754 19.6873C18.2885 19.7836 18.0657 19.6472 18.0657 19.4369V12.4824C18.0657 12.3314 18.1622 12.1974 18.3052 12.1486C20.6241 11.3602 22.0238 10.3364 22.0238 9.21753V13.3463Z" fill="#D8D8FF"/>
                                            <path d="M22.0238 14.592V15.522C21.4594 16.2172 20.5032 16.8463 19.4996 17.4355C19.4625 17.4575 19.4217 17.4678 19.3814 17.4678C19.3008 17.4678 19.2225 17.4266 19.1789 17.352C19.1133 17.2405 19.1508 17.0966 19.2624 17.0314C20.9536 16.0386 21.8133 15.2853 22.0238 14.592V14.592Z" fill="#9393FF"/>
                                            <path d="M22.0238 13.3462V14.2762C21.4589 14.9713 20.5032 15.6004 19.4996 16.1896C19.4625 16.2112 19.4217 16.2215 19.3814 16.2215C19.3008 16.2215 19.2225 16.1803 19.1789 16.1062C19.1133 15.9942 19.1508 15.8507 19.2624 15.7851C20.9536 14.7923 21.8133 14.0395 22.0238 13.3462Z" fill="#9393FF"/>
                                            <path d="M19.3813 15.2074C19.3025 15.2074 19.2256 15.1678 19.1813 15.0957C19.1136 14.9854 19.148 14.8411 19.2583 14.7734C19.5345 14.6037 19.7758 14.4484 19.996 14.2986C20.1032 14.2258 20.2489 14.2537 20.3216 14.3607C20.3944 14.4678 20.3666 14.6136 20.2596 14.6863C20.0333 14.8401 19.786 14.9993 19.5037 15.1727C19.4655 15.1962 19.4231 15.2074 19.3813 15.2074V15.2074Z" fill="#9393FF"/>
                                            <path d="M19.3812 13.4436C19.2918 13.4436 19.2064 13.3922 19.1674 13.3054C19.1142 13.1874 19.1668 13.0486 19.2848 12.9955C19.6547 12.8289 19.9883 12.6536 20.2766 12.4743C20.3866 12.406 20.5311 12.4397 20.5994 12.5495C20.6677 12.6595 20.634 12.804 20.5242 12.8724C20.2183 13.0626 19.8661 13.2478 19.4773 13.4229C19.4461 13.4369 19.4134 13.4436 19.3812 13.4436V13.4436Z" fill="#FF9393"/>
                                            <path d="M18.0681 6.20699C17.9542 6.17001 17.837 6.2549 17.837 6.37462V9.93215C17.837 9.99623 17.8721 10.055 17.9281 10.0862C18.6779 10.5038 19.3408 10.9801 19.904 11.4957C19.4371 11.7274 18.9017 11.946 18.3048 12.149C18.1621 12.1976 18.0658 12.3317 18.0658 12.4826V19.437C18.0658 19.6473 18.2886 19.7838 18.4756 19.6874C20.6923 18.5446 22.0239 17.1709 22.0239 16.0793V9.21749C22.0239 8.0608 20.5282 7.00593 18.0681 6.20699Z" fill="url(#paint1_linear_4516_5327)"/>
                                            <path d="M16.1433 20.4084H4.77616C4.63975 20.4084 4.53241 20.2926 4.54225 20.1567L5.491 7.27685C5.49991 7.1545 5.6021 7.05981 5.72491 7.05981H15.1946C15.3174 7.05981 15.4191 7.1545 15.4285 7.27685L16.3768 20.1567C16.3871 20.2926 16.2793 20.4084 16.1433 20.4084Z" fill="#FFAA66"/>
                                            <path d="M11.0447 10.5326C10.9228 10.6545 10.7608 10.7216 10.5884 10.7216C10.4161 10.7216 10.2541 10.6545 10.1322 10.5326C10.0104 10.4107 9.94324 10.2487 9.94324 10.0763C9.94324 9.90399 10.0104 9.74199 10.1322 9.62011C10.3838 9.36849 10.7932 9.36854 11.0447 9.62011L11.2104 9.78586L11.5419 9.45441L11.3761 9.28866C11.2188 9.13135 11.0257 9.03188 10.8228 8.98847V8.53955H10.3541V8.98852C10.1512 9.03188 9.95805 9.13139 9.80074 9.28866C9.59036 9.49908 9.47449 9.77883 9.47449 10.0763C9.47449 10.3739 9.59036 10.6537 9.80074 10.864C9.95472 11.018 10.146 11.1211 10.3541 11.1655V11.6131H10.8228V11.1655C11.0309 11.1211 11.2221 11.018 11.3761 10.864L11.5419 10.6983L11.2104 10.3668L11.0447 10.5326Z" fill="white"/>
                                            <path d="M7.44153 7.05981H8.37903V8.87763C8.37903 9.13638 8.16903 9.34638 7.91028 9.34638C7.65153 9.34638 7.44153 9.13638 7.44153 8.87763V7.05981Z" fill="#FF9C33"/>
                                            <path d="M13.4781 7.05981V8.87763C13.4781 9.13638 13.2681 9.34638 13.0094 9.34638C12.7502 9.34638 12.5406 9.13638 12.5406 8.87763V7.05981H13.4781Z" fill="#FF9C33"/>
                                            <path d="M10.9984 13.5775C12.884 13.4304 14.6278 13.183 16.1577 12.8558C16.3769 12.8089 16.5833 12.9764 16.5833 13.2005V20.4353C16.5833 20.5874 16.4858 20.7222 16.3414 20.7701C14.7835 21.2871 12.9957 21.6755 11.0566 21.8444C10.8508 21.8623 10.6738 21.6995 10.6738 21.4929V13.9288C10.6738 13.745 10.8151 13.5918 10.9984 13.5775V13.5775Z" fill="#D8D8FF"/>
                                            <path d="M15.4929 20.1811C15.3913 20.1811 15.2977 20.1146 15.2679 20.0122C15.2318 19.8879 15.3032 19.7578 15.4274 19.7216C15.4987 19.7009 15.5694 19.6798 15.6398 19.6586C15.7636 19.621 15.8946 19.6911 15.9321 19.815C15.9696 19.9389 15.8995 20.0697 15.7756 20.1072C15.7036 20.129 15.6313 20.1505 15.5584 20.1717C15.5366 20.1781 15.5146 20.1811 15.4929 20.1811V20.1811Z" fill="#8282FF"/>
                                            <path d="M15.4929 19.4651C15.3913 19.4651 15.2977 19.3986 15.2679 19.2961C15.2318 19.1719 15.3032 19.0418 15.4274 19.0056C15.4987 18.9848 15.5694 18.9638 15.6398 18.9425C15.7636 18.9049 15.8946 18.9751 15.9321 19.0989C15.9696 19.2228 15.8995 19.3537 15.7756 19.3912C15.7036 19.413 15.6313 19.4344 15.5584 19.4556C15.5366 19.462 15.5146 19.4651 15.4929 19.4651V19.4651Z" fill="#8282FF"/>
                                            <path d="M16.0011 15.6087L14.8434 14.5739C14.8277 14.5598 14.8076 14.5527 14.7878 14.5541L14.2639 14.5906C14.2315 14.5929 14.2048 14.6166 14.1978 14.6498C14.1563 14.846 13.9983 14.997 13.7931 15.013C13.586 15.0292 13.3922 14.9033 13.3049 14.713C13.29 14.6807 13.2572 14.6607 13.2233 14.6631L12.6622 14.7021C12.6407 14.7036 12.6207 14.714 12.6071 14.7308L11.5495 16.0345C11.5196 16.0715 11.5257 16.1262 11.5632 16.1566L12.2405 16.7049C12.2768 16.7343 12.3301 16.7283 12.359 16.6915L12.7033 16.2534L12.643 18.6497C12.6416 18.7057 12.6911 18.7494 12.7465 18.7411L15.0027 18.4026C15.0469 18.396 15.0795 18.3579 15.0794 18.3132L15.074 16.0106L15.4573 16.3438C15.4903 16.3725 15.5408 16.3668 15.5666 16.3314L16.0137 15.7194C16.038 15.6862 16.0324 15.6366 16.0011 15.6087V15.6087Z" fill="#FFAA66"/>
                                            <path d="M12.9243 20.3039C13.5523 20.3039 14.0615 19.7948 14.0615 19.1667C14.0615 18.5387 13.5523 18.0295 12.9243 18.0295C12.2962 18.0295 11.7871 18.5387 11.7871 19.1667C11.7871 19.7948 12.2962 20.3039 12.9243 20.3039Z" fill="#FF6C6C"/>
                                            <path d="M12.7735 19.6973C12.7114 19.6973 12.6518 19.6726 12.6078 19.6287L12.3171 19.3379C12.2255 19.2464 12.2255 19.098 12.3171 19.0065C12.4086 18.915 12.5571 18.915 12.6485 19.0065L12.7735 19.1315L13.2002 18.7049C13.2917 18.6134 13.4402 18.6134 13.5316 18.7049C13.6232 18.7964 13.6232 18.9448 13.5316 19.0363L12.9392 19.6287C12.8953 19.6726 12.8357 19.6973 12.7735 19.6973V19.6973Z" fill="white"/>
                                            <path d="M14.3828 16.2914C14.2533 16.2914 14.1484 16.1864 14.1484 16.057V15.9878C14.1484 15.8584 14.2533 15.7534 14.3828 15.7534C14.5123 15.7534 14.6172 15.8584 14.6172 15.9878V16.057C14.6172 16.1864 14.5122 16.2914 14.3828 16.2914Z" fill="#FFD5BA"/>
                                            <path d="M13.0091 8.50233C12.7502 8.50233 12.5404 8.29243 12.5404 8.03358V4.51604C12.5404 3.36872 11.607 2.4353 10.4596 2.4353C9.31233 2.4353 8.37891 3.36872 8.37891 4.51604V8.03358C8.37891 8.29243 8.16905 8.50233 7.91016 8.50233C7.65127 8.50233 7.44141 8.29243 7.44141 8.03358V4.51604C7.44141 2.85179 8.79539 1.4978 10.4596 1.4978C12.1239 1.4978 13.4779 2.85179 13.4779 4.51604V8.03358C13.4779 8.29248 13.268 8.50233 13.0091 8.50233Z" fill="#FFD5BA"/>
                                            <path d="M8.8133 19.1614H6.17639C6.04697 19.1614 5.94202 19.0564 5.94202 18.927C5.94202 18.7976 6.04697 18.6926 6.17639 18.6926H8.8133C8.94272 18.6926 9.04767 18.7976 9.04767 18.927C9.04767 19.0564 8.94272 19.1614 8.8133 19.1614Z" fill="#FFD5BA"/>
                                            <path d="M8.86591 18.2642H6.229C6.09958 18.2642 5.99463 18.1592 5.99463 18.0298C5.99463 17.9004 6.09958 17.7954 6.229 17.7954H8.86591C8.99533 17.7954 9.10028 17.9004 9.10028 18.0298C9.10028 18.1592 8.99533 18.2642 8.86591 18.2642Z" fill="#FFD5BA"/>
                                            <path d="M7.0261 17.3667H6.28149C6.15207 17.3667 6.04712 17.2617 6.04712 17.1323C6.04712 17.0029 6.15207 16.8979 6.28149 16.8979H7.0261C7.15553 16.8979 7.26048 17.0029 7.26048 17.1323C7.26048 17.2617 7.15553 17.3667 7.0261 17.3667Z" fill="#FFD5BA"/>
                                            <path d="M16.525 5.72504C15.5939 5.5028 14.5715 5.31202 13.478 5.15696V4.51604C13.478 2.85179 12.124 1.4978 10.4597 1.4978C10.128 1.4978 9.80901 1.55237 9.51023 1.65169C9.21145 1.55237 8.89242 1.4978 8.56073 1.4978C6.89648 1.4978 5.5425 2.85179 5.5425 4.51604V7.05976H3.82584C3.70307 7.05976 3.60112 7.15449 3.59212 7.27693L2.64347 20.1568C2.63348 20.2927 2.74097 20.4084 2.87723 20.4084H10.6739V21.4929C10.6739 21.6995 10.8509 21.8623 11.0567 21.8444C12.9958 21.6755 14.7836 21.2871 16.3415 20.7701C16.4859 20.7222 16.5833 20.5874 16.5833 20.4353V13.2006C16.5833 12.9764 16.377 12.809 16.1578 12.8558C16.0543 12.878 15.9496 12.8997 15.8441 12.9211L15.5559 9.00638C15.852 9.09694 16.1408 9.19538 16.4214 9.30165C16.5367 9.34533 16.6598 9.2603 16.6598 9.13702V5.89646C16.6598 5.81504 16.6042 5.74397 16.525 5.72504V5.72504ZM7.4415 7.05976H6.48V4.51604C6.48 3.47265 7.25207 2.6064 8.25487 2.45799C7.75087 2.99757 7.4415 3.72118 7.4415 4.51604V7.05976ZM8.379 4.51604C8.379 3.71068 8.83926 3.01126 9.51023 2.66555C10.1812 3.01126 10.6415 3.71068 10.6415 4.51604V7.05976H8.379V4.51604ZM12.5405 7.05976H11.579V4.51604C11.579 3.72118 11.2696 2.99757 10.7656 2.45799C11.7684 2.6064 12.5405 3.47265 12.5405 4.51604V7.05976Z" fill="url(#paint2_linear_4516_5327)"/>
                                            <path d="M2.97083 3.40723H2.50208C2.24361 3.40723 2.03333 3.19695 2.03333 2.93848V2.46973C2.03333 2.21126 2.24361 2.00098 2.50208 2.00098H2.97083C3.22929 2.00098 3.43958 2.21126 3.43958 2.46973V2.93848C3.43958 3.19695 3.22929 3.40723 2.97083 3.40723V3.40723ZM2.50208 2.46973V2.93876L2.97083 2.93848V2.46973H2.50208Z" fill="#FF6C6C"/>
                                            <path d="M22.1149 20.8145H21.6461C21.3876 20.8145 21.1774 20.6042 21.1774 20.3457V19.877C21.1774 19.6185 21.3876 19.4082 21.6461 19.4082H22.1149C22.3733 19.4082 22.5836 19.6185 22.5836 19.877V20.3457C22.5836 20.6042 22.3733 20.8145 22.1149 20.8145ZM21.6461 19.877V20.346L22.1149 20.3457V19.877H21.6461Z" fill="#FF6C6C"/>
                                            <path d="M16.8109 4.39062H16.3422C16.0837 4.39062 15.8734 4.18034 15.8734 3.92188V3.45312C15.8734 3.19466 16.0837 2.98438 16.3422 2.98438H16.8109C17.0694 2.98438 17.2797 3.19466 17.2797 3.45312V3.92188C17.2797 4.18034 17.0694 4.39062 16.8109 4.39062ZM16.3422 3.45312V3.92216L16.8109 3.92188V3.45312H16.3422Z" fill="#6C6CFF"/>
                                            <path d="M3.7439 5.73242C3.6839 5.73242 3.62394 5.70955 3.57815 5.6638L3.50727 5.59292C3.37935 5.46495 3.17104 5.46495 3.04297 5.59292L2.9721 5.6638C2.88055 5.7553 2.73219 5.7553 2.64065 5.6638C2.5949 5.618 2.57202 5.55805 2.57202 5.49805C2.57202 5.43805 2.5949 5.37809 2.64065 5.3323L2.71152 5.26142C2.77354 5.19941 2.80771 5.11695 2.80771 5.0293C2.80771 4.94164 2.77354 4.85919 2.71157 4.79717L2.64065 4.7263C2.5949 4.6805 2.57202 4.62055 2.57202 4.56055C2.57202 4.50055 2.5949 4.44059 2.64065 4.3948C2.73219 4.3033 2.88055 4.3033 2.9721 4.3948L3.04297 4.46567C3.17094 4.59364 3.37926 4.59364 3.50722 4.46567L3.5781 4.3948C3.66965 4.3033 3.81801 4.3033 3.90955 4.3948C3.9553 4.44059 3.97818 4.50055 3.97818 4.56055C3.97818 4.62055 3.9553 4.6805 3.90955 4.7263L3.83868 4.79717C3.71066 4.92514 3.71066 5.13345 3.83868 5.26142L3.90955 5.3323C3.9553 5.37809 3.97818 5.43805 3.97818 5.49805C3.97818 5.55805 3.9553 5.618 3.90955 5.6638C3.86385 5.70955 3.8039 5.73242 3.7439 5.73242V5.73242Z" fill="#FF9C33"/>
                                            <path d="M9.3708 23.1479C9.3108 23.1479 9.25085 23.1251 9.20505 23.0793L9.13418 23.0084C9.00621 22.8805 8.7979 22.8805 8.66993 23.0084L8.59905 23.0793C8.50751 23.1708 8.35915 23.1708 8.2676 23.0793C8.22185 23.0335 8.19897 22.9736 8.19897 22.9136C8.19897 22.8536 8.22185 22.7936 8.2676 22.7478L8.33847 22.6769C8.46649 22.549 8.46649 22.3407 8.33847 22.2127L8.2676 22.1418C8.22185 22.096 8.19897 22.0361 8.19897 21.9761C8.19897 21.9161 8.22185 21.8561 8.2676 21.8103C8.35915 21.7188 8.50751 21.7188 8.59905 21.8103L8.66993 21.8812C8.79785 22.0092 9.00616 22.0092 9.13422 21.8812L9.2051 21.8103C9.29665 21.7188 9.44501 21.7188 9.53655 21.8103C9.5823 21.8561 9.60518 21.9161 9.60518 21.9761C9.60518 22.0361 9.5823 22.096 9.53655 22.1418L9.46568 22.2127C9.40366 22.2747 9.36949 22.3572 9.36949 22.4448C9.36949 22.5325 9.40366 22.6149 9.46563 22.6769L9.53655 22.7478C9.5823 22.7936 9.60518 22.8536 9.60518 22.9136C9.60518 22.9736 9.5823 23.0335 9.53655 23.0793C9.49076 23.125 9.4308 23.1479 9.3708 23.1479Z" fill="#FF9C33"/>
                                         
                                        </svg>
                                            
                                              
                                    </div>
                                    <div class="content-right">
                                        <div class="title">
                                            <h3 class="fw_4 secondary_color">Shopping</h3>
                                            <span class="secondary_color fw_4">25 Min Ago</span>
                                        </div>
                                        <div class="desc">
                                            <p class="secondary_color fw_4">Alipay gives you 20% offcoupon for all bills, applicable for bills paid through Alipay wallet!</p>
                                        </div>
                                    </div>
                                </div>
                                <div class="noti-list">
                                    <div class="icon-box bg_service-3">
                                        <svg width="16" height="16" viewBox="0 0 25 24" fill="none" xmlns="http://www.w3.org/2000/svg">
                                            <path d="M24.2838 7.48567C22.5636 -5.34697 15.3153 2.01241 6.99199 5.99402C4.62414 7.12675 1.38339 7.13603 0.529097 10.1115C-0.458746 13.5521 2.49213 15.7224 4.86696 17.5562C7.726 19.7638 7.32082 24.1061 11.9929 23.7198C12.874 23.647 13.9302 23.7352 14.4994 23.0587C16.8551 20.2588 17.5094 16.0487 20.5731 13.8156C22.7339 12.2406 24.6702 10.3686 24.2838 7.48567V7.48567Z" fill="url(#paint0_linear_4516_5327)"/>
                                            <path d="M11.1101 8.50233C10.8512 8.50233 10.6413 8.29243 10.6413 8.03358V4.51604C10.6413 3.36872 9.70791 2.4353 8.56059 2.4353C7.41328 2.4353 6.47986 3.36872 6.47986 4.51604V8.03358C6.47986 8.29243 6.27 8.50233 6.01111 8.50233C5.75222 8.50233 5.54236 8.29243 5.54236 8.03358V4.51604C5.54236 2.85179 6.89634 1.4978 8.56059 1.4978C10.2248 1.4978 11.5788 2.85179 11.5788 4.51604V8.03358C11.5788 8.29248 11.369 8.50233 11.1101 8.50233V8.50233Z" fill="#FFC498"/>
                                            <path d="M4.77612 20.4084H2.87707C2.74085 20.4084 2.63332 20.2927 2.64335 20.1568L3.59196 7.27699C3.60096 7.15455 3.70296 7.05981 3.82568 7.05981H5.72482L4.77612 20.4084Z" fill="#FF7300"/>
                                            <path d="M10.2019 1.98511C9.70002 2.02945 9.26681 2.20284 8.90198 2.46379C9.5587 2.57269 10.1121 2.99006 10.4085 3.56161C10.4256 3.56119 10.4425 3.56029 10.4596 3.56029C10.8392 3.56029 11.1951 3.663 11.5018 3.84131C11.3243 3.06712 10.8485 2.40586 10.2019 1.98511V1.98511Z" fill="#FFAA66"/>
                                            <path d="M13.3223 5.13473C14.475 5.29359 15.5495 5.49229 16.5249 5.72507C16.6042 5.74396 16.6598 5.81503 16.6598 5.8965V9.13706C16.6598 9.26034 16.5367 9.34537 16.4213 9.30168C15.46 8.93756 14.4044 8.66198 13.2743 8.50078C13.1872 8.48836 13.1222 8.41434 13.1222 8.3264V5.30939C13.1222 5.2027 13.2166 5.12015 13.3223 5.13473V5.13473Z" fill="#9393FF"/>
                                            <path d="M19.934 11.522C19.3646 10.9961 18.6909 10.5108 17.9281 10.086C17.8721 10.0548 17.837 9.99604 17.837 9.93201V6.37448C17.837 6.25486 17.9539 6.16978 18.0677 6.20672C20.528 7.0057 22.0239 8.06062 22.0239 9.21736L21.8832 11.1587L19.934 11.522Z" fill="#9393FF"/>
                                            <path d="M22.0238 13.3463L21.8386 14.0752L22.0238 14.2763V14.5922L21.9179 15.2644L22.0238 15.5222V16.0791C22.0238 17.1707 20.6922 18.5447 18.4754 19.6873C18.2885 19.7836 18.0657 19.6472 18.0657 19.4369V12.4824C18.0657 12.3314 18.1622 12.1974 18.3052 12.1486C20.6241 11.3602 22.0238 10.3364 22.0238 9.21753V13.3463Z" fill="#D8D8FF"/>
                                            <path d="M22.0238 14.592V15.522C21.4594 16.2172 20.5032 16.8463 19.4996 17.4355C19.4625 17.4575 19.4217 17.4678 19.3814 17.4678C19.3008 17.4678 19.2225 17.4266 19.1789 17.352C19.1133 17.2405 19.1508 17.0966 19.2624 17.0314C20.9536 16.0386 21.8133 15.2853 22.0238 14.592V14.592Z" fill="#9393FF"/>
                                            <path d="M22.0238 13.3462V14.2762C21.4589 14.9713 20.5032 15.6004 19.4996 16.1896C19.4625 16.2112 19.4217 16.2215 19.3814 16.2215C19.3008 16.2215 19.2225 16.1803 19.1789 16.1062C19.1133 15.9942 19.1508 15.8507 19.2624 15.7851C20.9536 14.7923 21.8133 14.0395 22.0238 13.3462Z" fill="#9393FF"/>
                                            <path d="M19.3813 15.2074C19.3025 15.2074 19.2256 15.1678 19.1813 15.0957C19.1136 14.9854 19.148 14.8411 19.2583 14.7734C19.5345 14.6037 19.7758 14.4484 19.996 14.2986C20.1032 14.2258 20.2489 14.2537 20.3216 14.3607C20.3944 14.4678 20.3666 14.6136 20.2596 14.6863C20.0333 14.8401 19.786 14.9993 19.5037 15.1727C19.4655 15.1962 19.4231 15.2074 19.3813 15.2074V15.2074Z" fill="#9393FF"/>
                                            <path d="M19.3812 13.4436C19.2918 13.4436 19.2064 13.3922 19.1674 13.3054C19.1142 13.1874 19.1668 13.0486 19.2848 12.9955C19.6547 12.8289 19.9883 12.6536 20.2766 12.4743C20.3866 12.406 20.5311 12.4397 20.5994 12.5495C20.6677 12.6595 20.634 12.804 20.5242 12.8724C20.2183 13.0626 19.8661 13.2478 19.4773 13.4229C19.4461 13.4369 19.4134 13.4436 19.3812 13.4436V13.4436Z" fill="#FF9393"/>
                                            <path d="M18.0681 6.20699C17.9542 6.17001 17.837 6.2549 17.837 6.37462V9.93215C17.837 9.99623 17.8721 10.055 17.9281 10.0862C18.6779 10.5038 19.3408 10.9801 19.904 11.4957C19.4371 11.7274 18.9017 11.946 18.3048 12.149C18.1621 12.1976 18.0658 12.3317 18.0658 12.4826V19.437C18.0658 19.6473 18.2886 19.7838 18.4756 19.6874C20.6923 18.5446 22.0239 17.1709 22.0239 16.0793V9.21749C22.0239 8.0608 20.5282 7.00593 18.0681 6.20699Z" fill="url(#paint1_linear_4516_5327)"/>
                                            <path d="M16.1433 20.4084H4.77616C4.63975 20.4084 4.53241 20.2926 4.54225 20.1567L5.491 7.27685C5.49991 7.1545 5.6021 7.05981 5.72491 7.05981H15.1946C15.3174 7.05981 15.4191 7.1545 15.4285 7.27685L16.3768 20.1567C16.3871 20.2926 16.2793 20.4084 16.1433 20.4084Z" fill="#FFAA66"/>
                                            <path d="M11.0447 10.5326C10.9228 10.6545 10.7608 10.7216 10.5884 10.7216C10.4161 10.7216 10.2541 10.6545 10.1322 10.5326C10.0104 10.4107 9.94324 10.2487 9.94324 10.0763C9.94324 9.90399 10.0104 9.74199 10.1322 9.62011C10.3838 9.36849 10.7932 9.36854 11.0447 9.62011L11.2104 9.78586L11.5419 9.45441L11.3761 9.28866C11.2188 9.13135 11.0257 9.03188 10.8228 8.98847V8.53955H10.3541V8.98852C10.1512 9.03188 9.95805 9.13139 9.80074 9.28866C9.59036 9.49908 9.47449 9.77883 9.47449 10.0763C9.47449 10.3739 9.59036 10.6537 9.80074 10.864C9.95472 11.018 10.146 11.1211 10.3541 11.1655V11.6131H10.8228V11.1655C11.0309 11.1211 11.2221 11.018 11.3761 10.864L11.5419 10.6983L11.2104 10.3668L11.0447 10.5326Z" fill="white"/>
                                            <path d="M7.44153 7.05981H8.37903V8.87763C8.37903 9.13638 8.16903 9.34638 7.91028 9.34638C7.65153 9.34638 7.44153 9.13638 7.44153 8.87763V7.05981Z" fill="#FF9C33"/>
                                            <path d="M13.4781 7.05981V8.87763C13.4781 9.13638 13.2681 9.34638 13.0094 9.34638C12.7502 9.34638 12.5406 9.13638 12.5406 8.87763V7.05981H13.4781Z" fill="#FF9C33"/>
                                            <path d="M10.9984 13.5775C12.884 13.4304 14.6278 13.183 16.1577 12.8558C16.3769 12.8089 16.5833 12.9764 16.5833 13.2005V20.4353C16.5833 20.5874 16.4858 20.7222 16.3414 20.7701C14.7835 21.2871 12.9957 21.6755 11.0566 21.8444C10.8508 21.8623 10.6738 21.6995 10.6738 21.4929V13.9288C10.6738 13.745 10.8151 13.5918 10.9984 13.5775V13.5775Z" fill="#D8D8FF"/>
                                            <path d="M15.4929 20.1811C15.3913 20.1811 15.2977 20.1146 15.2679 20.0122C15.2318 19.8879 15.3032 19.7578 15.4274 19.7216C15.4987 19.7009 15.5694 19.6798 15.6398 19.6586C15.7636 19.621 15.8946 19.6911 15.9321 19.815C15.9696 19.9389 15.8995 20.0697 15.7756 20.1072C15.7036 20.129 15.6313 20.1505 15.5584 20.1717C15.5366 20.1781 15.5146 20.1811 15.4929 20.1811V20.1811Z" fill="#8282FF"/>
                                            <path d="M15.4929 19.4651C15.3913 19.4651 15.2977 19.3986 15.2679 19.2961C15.2318 19.1719 15.3032 19.0418 15.4274 19.0056C15.4987 18.9848 15.5694 18.9638 15.6398 18.9425C15.7636 18.9049 15.8946 18.9751 15.9321 19.0989C15.9696 19.2228 15.8995 19.3537 15.7756 19.3912C15.7036 19.413 15.6313 19.4344 15.5584 19.4556C15.5366 19.462 15.5146 19.4651 15.4929 19.4651V19.4651Z" fill="#8282FF"/>
                                            <path d="M16.0011 15.6087L14.8434 14.5739C14.8277 14.5598 14.8076 14.5527 14.7878 14.5541L14.2639 14.5906C14.2315 14.5929 14.2048 14.6166 14.1978 14.6498C14.1563 14.846 13.9983 14.997 13.7931 15.013C13.586 15.0292 13.3922 14.9033 13.3049 14.713C13.29 14.6807 13.2572 14.6607 13.2233 14.6631L12.6622 14.7021C12.6407 14.7036 12.6207 14.714 12.6071 14.7308L11.5495 16.0345C11.5196 16.0715 11.5257 16.1262 11.5632 16.1566L12.2405 16.7049C12.2768 16.7343 12.3301 16.7283 12.359 16.6915L12.7033 16.2534L12.643 18.6497C12.6416 18.7057 12.6911 18.7494 12.7465 18.7411L15.0027 18.4026C15.0469 18.396 15.0795 18.3579 15.0794 18.3132L15.074 16.0106L15.4573 16.3438C15.4903 16.3725 15.5408 16.3668 15.5666 16.3314L16.0137 15.7194C16.038 15.6862 16.0324 15.6366 16.0011 15.6087V15.6087Z" fill="#FFAA66"/>
                                            <path d="M12.9243 20.3039C13.5523 20.3039 14.0615 19.7948 14.0615 19.1667C14.0615 18.5387 13.5523 18.0295 12.9243 18.0295C12.2962 18.0295 11.7871 18.5387 11.7871 19.1667C11.7871 19.7948 12.2962 20.3039 12.9243 20.3039Z" fill="#FF6C6C"/>
                                            <path d="M12.7735 19.6973C12.7114 19.6973 12.6518 19.6726 12.6078 19.6287L12.3171 19.3379C12.2255 19.2464 12.2255 19.098 12.3171 19.0065C12.4086 18.915 12.5571 18.915 12.6485 19.0065L12.7735 19.1315L13.2002 18.7049C13.2917 18.6134 13.4402 18.6134 13.5316 18.7049C13.6232 18.7964 13.6232 18.9448 13.5316 19.0363L12.9392 19.6287C12.8953 19.6726 12.8357 19.6973 12.7735 19.6973V19.6973Z" fill="white"/>
                                            <path d="M14.3828 16.2914C14.2533 16.2914 14.1484 16.1864 14.1484 16.057V15.9878C14.1484 15.8584 14.2533 15.7534 14.3828 15.7534C14.5123 15.7534 14.6172 15.8584 14.6172 15.9878V16.057C14.6172 16.1864 14.5122 16.2914 14.3828 16.2914Z" fill="#FFD5BA"/>
                                            <path d="M13.0091 8.50233C12.7502 8.50233 12.5404 8.29243 12.5404 8.03358V4.51604C12.5404 3.36872 11.607 2.4353 10.4596 2.4353C9.31233 2.4353 8.37891 3.36872 8.37891 4.51604V8.03358C8.37891 8.29243 8.16905 8.50233 7.91016 8.50233C7.65127 8.50233 7.44141 8.29243 7.44141 8.03358V4.51604C7.44141 2.85179 8.79539 1.4978 10.4596 1.4978C12.1239 1.4978 13.4779 2.85179 13.4779 4.51604V8.03358C13.4779 8.29248 13.268 8.50233 13.0091 8.50233Z" fill="#FFD5BA"/>
                                            <path d="M8.8133 19.1614H6.17639C6.04697 19.1614 5.94202 19.0564 5.94202 18.927C5.94202 18.7976 6.04697 18.6926 6.17639 18.6926H8.8133C8.94272 18.6926 9.04767 18.7976 9.04767 18.927C9.04767 19.0564 8.94272 19.1614 8.8133 19.1614Z" fill="#FFD5BA"/>
                                            <path d="M8.86591 18.2642H6.229C6.09958 18.2642 5.99463 18.1592 5.99463 18.0298C5.99463 17.9004 6.09958 17.7954 6.229 17.7954H8.86591C8.99533 17.7954 9.10028 17.9004 9.10028 18.0298C9.10028 18.1592 8.99533 18.2642 8.86591 18.2642Z" fill="#FFD5BA"/>
                                            <path d="M7.0261 17.3667H6.28149C6.15207 17.3667 6.04712 17.2617 6.04712 17.1323C6.04712 17.0029 6.15207 16.8979 6.28149 16.8979H7.0261C7.15553 16.8979 7.26048 17.0029 7.26048 17.1323C7.26048 17.2617 7.15553 17.3667 7.0261 17.3667Z" fill="#FFD5BA"/>
                                            <path d="M16.525 5.72504C15.5939 5.5028 14.5715 5.31202 13.478 5.15696V4.51604C13.478 2.85179 12.124 1.4978 10.4597 1.4978C10.128 1.4978 9.80901 1.55237 9.51023 1.65169C9.21145 1.55237 8.89242 1.4978 8.56073 1.4978C6.89648 1.4978 5.5425 2.85179 5.5425 4.51604V7.05976H3.82584C3.70307 7.05976 3.60112 7.15449 3.59212 7.27693L2.64347 20.1568C2.63348 20.2927 2.74097 20.4084 2.87723 20.4084H10.6739V21.4929C10.6739 21.6995 10.8509 21.8623 11.0567 21.8444C12.9958 21.6755 14.7836 21.2871 16.3415 20.7701C16.4859 20.7222 16.5833 20.5874 16.5833 20.4353V13.2006C16.5833 12.9764 16.377 12.809 16.1578 12.8558C16.0543 12.878 15.9496 12.8997 15.8441 12.9211L15.5559 9.00638C15.852 9.09694 16.1408 9.19538 16.4214 9.30165C16.5367 9.34533 16.6598 9.2603 16.6598 9.13702V5.89646C16.6598 5.81504 16.6042 5.74397 16.525 5.72504V5.72504ZM7.4415 7.05976H6.48V4.51604C6.48 3.47265 7.25207 2.6064 8.25487 2.45799C7.75087 2.99757 7.4415 3.72118 7.4415 4.51604V7.05976ZM8.379 4.51604C8.379 3.71068 8.83926 3.01126 9.51023 2.66555C10.1812 3.01126 10.6415 3.71068 10.6415 4.51604V7.05976H8.379V4.51604ZM12.5405 7.05976H11.579V4.51604C11.579 3.72118 11.2696 2.99757 10.7656 2.45799C11.7684 2.6064 12.5405 3.47265 12.5405 4.51604V7.05976Z" fill="url(#paint2_linear_4516_5327)"/>
                                            <path d="M2.97083 3.40723H2.50208C2.24361 3.40723 2.03333 3.19695 2.03333 2.93848V2.46973C2.03333 2.21126 2.24361 2.00098 2.50208 2.00098H2.97083C3.22929 2.00098 3.43958 2.21126 3.43958 2.46973V2.93848C3.43958 3.19695 3.22929 3.40723 2.97083 3.40723V3.40723ZM2.50208 2.46973V2.93876L2.97083 2.93848V2.46973H2.50208Z" fill="#FF6C6C"/>
                                            <path d="M22.1149 20.8145H21.6461C21.3876 20.8145 21.1774 20.6042 21.1774 20.3457V19.877C21.1774 19.6185 21.3876 19.4082 21.6461 19.4082H22.1149C22.3733 19.4082 22.5836 19.6185 22.5836 19.877V20.3457C22.5836 20.6042 22.3733 20.8145 22.1149 20.8145ZM21.6461 19.877V20.346L22.1149 20.3457V19.877H21.6461Z" fill="#FF6C6C"/>
                                            <path d="M16.8109 4.39062H16.3422C16.0837 4.39062 15.8734 4.18034 15.8734 3.92188V3.45312C15.8734 3.19466 16.0837 2.98438 16.3422 2.98438H16.8109C17.0694 2.98438 17.2797 3.19466 17.2797 3.45312V3.92188C17.2797 4.18034 17.0694 4.39062 16.8109 4.39062ZM16.3422 3.45312V3.92216L16.8109 3.92188V3.45312H16.3422Z" fill="#6C6CFF"/>
                                            <path d="M3.7439 5.73242C3.6839 5.73242 3.62394 5.70955 3.57815 5.6638L3.50727 5.59292C3.37935 5.46495 3.17104 5.46495 3.04297 5.59292L2.9721 5.6638C2.88055 5.7553 2.73219 5.7553 2.64065 5.6638C2.5949 5.618 2.57202 5.55805 2.57202 5.49805C2.57202 5.43805 2.5949 5.37809 2.64065 5.3323L2.71152 5.26142C2.77354 5.19941 2.80771 5.11695 2.80771 5.0293C2.80771 4.94164 2.77354 4.85919 2.71157 4.79717L2.64065 4.7263C2.5949 4.6805 2.57202 4.62055 2.57202 4.56055C2.57202 4.50055 2.5949 4.44059 2.64065 4.3948C2.73219 4.3033 2.88055 4.3033 2.9721 4.3948L3.04297 4.46567C3.17094 4.59364 3.37926 4.59364 3.50722 4.46567L3.5781 4.3948C3.66965 4.3033 3.81801 4.3033 3.90955 4.3948C3.9553 4.44059 3.97818 4.50055 3.97818 4.56055C3.97818 4.62055 3.9553 4.6805 3.90955 4.7263L3.83868 4.79717C3.71066 4.92514 3.71066 5.13345 3.83868 5.26142L3.90955 5.3323C3.9553 5.37809 3.97818 5.43805 3.97818 5.49805C3.97818 5.55805 3.9553 5.618 3.90955 5.6638C3.86385 5.70955 3.8039 5.73242 3.7439 5.73242V5.73242Z" fill="#FF9C33"/>
                                            <path d="M9.3708 23.1479C9.3108 23.1479 9.25085 23.1251 9.20505 23.0793L9.13418 23.0084C9.00621 22.8805 8.7979 22.8805 8.66993 23.0084L8.59905 23.0793C8.50751 23.1708 8.35915 23.1708 8.2676 23.0793C8.22185 23.0335 8.19897 22.9736 8.19897 22.9136C8.19897 22.8536 8.22185 22.7936 8.2676 22.7478L8.33847 22.6769C8.46649 22.549 8.46649 22.3407 8.33847 22.2127L8.2676 22.1418C8.22185 22.096 8.19897 22.0361 8.19897 21.9761C8.19897 21.9161 8.22185 21.8561 8.2676 21.8103C8.35915 21.7188 8.50751 21.7188 8.59905 21.8103L8.66993 21.8812C8.79785 22.0092 9.00616 22.0092 9.13422 21.8812L9.2051 21.8103C9.29665 21.7188 9.44501 21.7188 9.53655 21.8103C9.5823 21.8561 9.60518 21.9161 9.60518 21.9761C9.60518 22.0361 9.5823 22.096 9.53655 22.1418L9.46568 22.2127C9.40366 22.2747 9.36949 22.3572 9.36949 22.4448C9.36949 22.5325 9.40366 22.6149 9.46563 22.6769L9.53655 22.7478C9.5823 22.7936 9.60518 22.8536 9.60518 22.9136C9.60518 22.9736 9.5823 23.0335 9.53655 23.0793C9.49076 23.125 9.4308 23.1479 9.3708 23.1479Z" fill="#FF9C33"/>
                                         
                                        </svg>
                                            
                                              
                                    </div>
                                    <div class="content-right">
                                        <div class="title">
                                            <h3 class="fw_6">Shopping</h3>
                                            <span class="fw_6 on_surface_color">1 Hour  Ago</span>
                                        </div>
                                        <div class="desc">
                                            <p class="on_surface_color fw_4">Alipay gives you 20% offcoupon for all bills, applicable for bills paid through Alipay wallet!</p>
                                            <i class="dot"></i>
                                        </div>
                                    </div>
                                </div>
                                <div class="noti-list">
                                    <div class="icon-box bg_service-7">
                                        <svg width="16" height="16" viewBox="0 0 25 22" fill="none" xmlns="http://www.w3.org/2000/svg">
                                            <path d="M5.10792 2.89151V3.71843H2.76196V2.89151C2.76196 2.64696 2.9602 2.44873 3.20474 2.44873H4.66513C4.90968 2.44873 5.10792 2.64696 5.10792 2.89151Z" fill="#6D6D6D"/>
                                            <path d="M21.9048 2.89151V3.71843H19.5588V2.89151C19.5588 2.64696 19.7571 2.44873 20.0016 2.44873H21.462C21.7066 2.44873 21.9048 2.64696 21.9048 2.89151Z" fill="#6D6D6D"/>
                                            <path d="M15.7525 5.0683H8.91426C8.63245 5.0683 8.40393 4.83978 8.40393 4.55797V1.85661C8.40393 1.15315 8.97632 0.580811 9.67973 0.580811H14.987C15.6905 0.580811 16.2628 1.1532 16.2628 1.85661V4.55797C16.2628 4.83978 16.0343 5.0683 15.7525 5.0683ZM9.42454 4.04764H15.2421V1.85661C15.2421 1.71584 15.1276 1.60147 14.987 1.60147H9.67973C9.53906 1.60147 9.42459 1.71584 9.42459 1.85661V4.04764H9.42454Z" fill="#6D6D6D"/>
                                            <path d="M5.39564 19.5364V20.9087C5.39564 21.1906 5.16718 21.4191 4.88532 21.4191H2.62739C2.34553 21.4191 2.11707 21.1906 2.11707 20.9087V19.5364H5.39564Z" fill="#EA4E4E"/>
                                            <path d="M22.5498 19.5364V20.9087C22.5498 21.1906 22.3213 21.4191 22.0395 21.4191H19.7816C19.4997 21.4191 19.2712 21.1906 19.2712 20.9087V19.5364H22.5498Z" fill="#EA4E4E"/>
                                            <path d="M24.326 4.50845V19.2502C24.326 19.8139 23.869 20.2709 23.3053 20.2709H1.36148C0.797805 20.2709 0.34082 19.8139 0.34082 19.2502V4.50845C0.34082 3.94478 0.797758 3.48779 1.36148 3.48779H23.3053C23.869 3.48779 24.326 3.94478 24.326 4.50845Z" fill="#F96464"/>
                                            <g opacity="0.4">
                                            <path d="M1.91377 7.6168C1.63191 7.6168 1.40344 7.38834 1.40344 7.10648V5.27498C1.40344 4.99312 1.63191 4.76465 1.91377 4.76465C2.19563 4.76465 2.4241 4.99312 2.4241 5.27498V7.10648C2.4241 7.38834 2.19563 7.6168 1.91377 7.6168Z" fill="white"/>
                                            </g>
                                            <g opacity="0.08">
                                            <path d="M24.326 4.50943V19.2501C24.326 19.814 23.8693 20.2707 23.3054 20.2707H21.5116C22.0755 20.2707 22.5323 19.814 22.5323 19.2501V4.50943C22.5323 3.94552 22.0755 3.48877 21.5116 3.48877H23.3054C23.8693 3.48877 24.326 3.94552 24.326 4.50943Z" fill="black"/>
                                            </g>
                                            <path d="M12.3335 17.3581C15.3597 17.3581 17.8129 14.9048 17.8129 11.8786C17.8129 8.8524 15.3597 6.39917 12.3335 6.39917C9.30724 6.39917 6.854 8.8524 6.854 11.8786C6.854 14.9048 9.30724 17.3581 12.3335 17.3581Z" fill="#F2F0F0"/>
                                            <path d="M16.0116 11.3237V12.4362C16.0116 12.718 15.7831 12.9465 15.5012 12.9465H13.3987V15.0464C13.3987 15.3283 13.1702 15.5568 12.8884 15.5568H11.7758C11.494 15.5568 11.2655 15.3283 11.2655 15.0464V12.9465H9.1656C8.88374 12.9465 8.65527 12.718 8.65527 12.4362V11.3237C8.65527 11.0418 8.88374 10.8133 9.1656 10.8133H11.2656V8.71077C11.2656 8.42891 11.494 8.20044 11.7759 8.20044H12.8884C13.1703 8.20044 13.3987 8.42891 13.3987 8.71077V10.8133H15.5013C15.7831 10.8133 16.0116 11.0418 16.0116 11.3237Z" fill="#F96464"/>
                                        </svg>
                                    </div>
                                    <div class="content-right">
                                        <div class="title">
                                            <h3 class="fw_4 secondary_color">Medical</h3>
                                            <span class="secondary_color fw_4">15 Hour Ago</span>
                                        </div>
                                        <div class="desc">
                                            <p class="secondary_color fw_4">Alipay gives you 20% offcoupon for all bills, applicable for bills paid through Alipay wallet!</p>
                                        </div>
                                    </div>
                                </div>
                                <div class="noti-list">
                                    <div class="icon-box bg_service-6">
                                        <svg width="16" height="16" viewBox="0 0 16 16" fill="none" xmlns="http://www.w3.org/2000/svg">
                                            <path d="M7.99995 14.7062C12.0609 14.7062 15.353 11.4141 15.353 7.35309C15.353 3.29209 12.0609 0 7.99995 0C3.93894 0 0.646851 3.29209 0.646851 7.35309C0.646851 11.4141 3.93894 14.7062 7.99995 14.7062Z" fill="#F7B239"/>
                                            <path d="M7.99997 12.1931C10.673 12.1931 12.8399 10.0261 12.8399 7.35312C12.8399 4.6801 10.673 2.51318 7.99997 2.51318C5.32695 2.51318 3.16003 4.6801 3.16003 7.35312C3.16003 10.0261 5.32695 12.1931 7.99997 12.1931Z" fill="#E09B2D"/>
                                            <path d="M14.6157 15.1809C14.6307 15.2373 14.638 15.294 14.638 15.3495C14.638 15.637 14.4463 15.8997 14.1558 15.9776C13.8089 16.0706 13.4521 15.8646 13.3591 15.5178L12.2661 11.4386C12.1731 11.0918 12.3791 10.7349 12.726 10.6419C13.0732 10.549 13.4297 10.755 13.5227 11.1022L14.6157 15.1809Z" fill="#F24C8F"/>
                                            <path d="M2.4596 11.5182L3.01855 11.668L4.49394 6.16149L3.93499 6.01173L2.4596 11.5182Z" fill="#CCCCCC"/>
                                            <path d="M11.6446 7.71971L12.4469 10.7156L13.0059 10.5659L12.2036 7.57L11.6446 7.71971Z" fill="#CCCCCC"/>
                                            <path d="M5.26403 2.1712C6.18881 2.41888 6.60972 3.8456 6.20463 5.3572C5.79953 6.86917 4.88478 7.28545 3.96 7.03776C3.03559 6.79007 2.4515 5.97217 2.85659 4.4602C3.26169 2.94823 4.33963 1.92351 5.26403 2.1712Z" fill="#E6E6E6"/>
                                            <path d="M2.9944 10.642C3.34162 10.7349 3.54727 11.0918 3.45427 11.4386L2.36168 15.5178C2.28374 15.8083 2.02099 16 1.73359 16C1.67802 16 1.6213 15.9927 1.56499 15.9776C1.21777 15.8847 1.01174 15.5278 1.10471 15.181L2.19771 11.1022C2.29068 10.755 2.64755 10.549 2.9944 10.642Z" fill="#F24C8F"/>
                                            <path d="M13.0658 6.02202L12.141 2.57046C12.1045 2.4344 11.9629 2.35446 11.8268 2.39515C11.6951 2.43455 11.6237 2.57771 11.6592 2.71046L12.3966 5.46168C12.4517 5.66743 12.3296 5.87893 12.1239 5.93408L12.1235 5.93415C11.9177 5.98937 11.7061 5.86721 11.651 5.66143L10.911 2.89987C10.8745 2.76371 10.7327 2.6838 10.5967 2.72458C10.465 2.76405 10.3937 2.90718 10.4293 3.0399L11.1666 5.79137C11.2217 5.99715 11.0996 6.20865 10.8938 6.26383C10.688 6.31896 10.4766 6.19687 10.4214 5.99108L9.68139 3.22937C9.64493 3.09324 9.5033 3.01337 9.36721 3.05405C9.23552 3.09346 9.16408 3.23658 9.19964 3.36933L10.1216 6.81049C10.2269 7.20383 10.479 7.53255 10.8316 7.73615C11.0665 7.87177 11.327 7.94102 11.5912 7.94102C11.7236 7.94102 11.857 7.92358 11.9883 7.8884C12.6534 7.71015 13.1178 7.10524 13.1178 6.4174C13.1178 6.28349 13.1003 6.15027 13.0658 6.02202Z" fill="#E6E6E6"/>
                                        </svg>
                                            
                                              
                                    </div>
                                    <div class="content-right">
                                        <div class="title">
                                            <h3 class="fw_4 secondary_color">Travel</h3>
                                            <span class="secondary_color fw_4">1 Day Ago</span>
                                        </div>
                                        <div class="desc">
                                            <p class="secondary_color fw_4">Alipay gives you 20% offcoupon for all bills, applicable for bills paid through Alipay wallet!</p>
                                        </div>
                                    </div>
                                </div>
                                <div class="noti-list">
                                    <div class="icon-box bg_service-3">
                                        <svg width="16" height="16" viewBox="0 0 25 24" fill="none" xmlns="http://www.w3.org/2000/svg">
                                            <path d="M24.2838 7.48567C22.5636 -5.34697 15.3153 2.01241 6.99199 5.99402C4.62414 7.12675 1.38339 7.13603 0.529097 10.1115C-0.458746 13.5521 2.49213 15.7224 4.86696 17.5562C7.726 19.7638 7.32082 24.1061 11.9929 23.7198C12.874 23.647 13.9302 23.7352 14.4994 23.0587C16.8551 20.2588 17.5094 16.0487 20.5731 13.8156C22.7339 12.2406 24.6702 10.3686 24.2838 7.48567V7.48567Z" fill="url(#paint0_linear_4516_5327)"/>
                                            <path d="M11.1101 8.50233C10.8512 8.50233 10.6413 8.29243 10.6413 8.03358V4.51604C10.6413 3.36872 9.70791 2.4353 8.56059 2.4353C7.41328 2.4353 6.47986 3.36872 6.47986 4.51604V8.03358C6.47986 8.29243 6.27 8.50233 6.01111 8.50233C5.75222 8.50233 5.54236 8.29243 5.54236 8.03358V4.51604C5.54236 2.85179 6.89634 1.4978 8.56059 1.4978C10.2248 1.4978 11.5788 2.85179 11.5788 4.51604V8.03358C11.5788 8.29248 11.369 8.50233 11.1101 8.50233V8.50233Z" fill="#FFC498"/>
                                            <path d="M4.77612 20.4084H2.87707C2.74085 20.4084 2.63332 20.2927 2.64335 20.1568L3.59196 7.27699C3.60096 7.15455 3.70296 7.05981 3.82568 7.05981H5.72482L4.77612 20.4084Z" fill="#FF7300"/>
                                            <path d="M10.2019 1.98511C9.70002 2.02945 9.26681 2.20284 8.90198 2.46379C9.5587 2.57269 10.1121 2.99006 10.4085 3.56161C10.4256 3.56119 10.4425 3.56029 10.4596 3.56029C10.8392 3.56029 11.1951 3.663 11.5018 3.84131C11.3243 3.06712 10.8485 2.40586 10.2019 1.98511V1.98511Z" fill="#FFAA66"/>
                                            <path d="M13.3223 5.13473C14.475 5.29359 15.5495 5.49229 16.5249 5.72507C16.6042 5.74396 16.6598 5.81503 16.6598 5.8965V9.13706C16.6598 9.26034 16.5367 9.34537 16.4213 9.30168C15.46 8.93756 14.4044 8.66198 13.2743 8.50078C13.1872 8.48836 13.1222 8.41434 13.1222 8.3264V5.30939C13.1222 5.2027 13.2166 5.12015 13.3223 5.13473V5.13473Z" fill="#9393FF"/>
                                            <path d="M19.934 11.522C19.3646 10.9961 18.6909 10.5108 17.9281 10.086C17.8721 10.0548 17.837 9.99604 17.837 9.93201V6.37448C17.837 6.25486 17.9539 6.16978 18.0677 6.20672C20.528 7.0057 22.0239 8.06062 22.0239 9.21736L21.8832 11.1587L19.934 11.522Z" fill="#9393FF"/>
                                            <path d="M22.0238 13.3463L21.8386 14.0752L22.0238 14.2763V14.5922L21.9179 15.2644L22.0238 15.5222V16.0791C22.0238 17.1707 20.6922 18.5447 18.4754 19.6873C18.2885 19.7836 18.0657 19.6472 18.0657 19.4369V12.4824C18.0657 12.3314 18.1622 12.1974 18.3052 12.1486C20.6241 11.3602 22.0238 10.3364 22.0238 9.21753V13.3463Z" fill="#D8D8FF"/>
                                            <path d="M22.0238 14.592V15.522C21.4594 16.2172 20.5032 16.8463 19.4996 17.4355C19.4625 17.4575 19.4217 17.4678 19.3814 17.4678C19.3008 17.4678 19.2225 17.4266 19.1789 17.352C19.1133 17.2405 19.1508 17.0966 19.2624 17.0314C20.9536 16.0386 21.8133 15.2853 22.0238 14.592V14.592Z" fill="#9393FF"/>
                                            <path d="M22.0238 13.3462V14.2762C21.4589 14.9713 20.5032 15.6004 19.4996 16.1896C19.4625 16.2112 19.4217 16.2215 19.3814 16.2215C19.3008 16.2215 19.2225 16.1803 19.1789 16.1062C19.1133 15.9942 19.1508 15.8507 19.2624 15.7851C20.9536 14.7923 21.8133 14.0395 22.0238 13.3462Z" fill="#9393FF"/>
                                            <path d="M19.3813 15.2074C19.3025 15.2074 19.2256 15.1678 19.1813 15.0957C19.1136 14.9854 19.148 14.8411 19.2583 14.7734C19.5345 14.6037 19.7758 14.4484 19.996 14.2986C20.1032 14.2258 20.2489 14.2537 20.3216 14.3607C20.3944 14.4678 20.3666 14.6136 20.2596 14.6863C20.0333 14.8401 19.786 14.9993 19.5037 15.1727C19.4655 15.1962 19.4231 15.2074 19.3813 15.2074V15.2074Z" fill="#9393FF"/>
                                            <path d="M19.3812 13.4436C19.2918 13.4436 19.2064 13.3922 19.1674 13.3054C19.1142 13.1874 19.1668 13.0486 19.2848 12.9955C19.6547 12.8289 19.9883 12.6536 20.2766 12.4743C20.3866 12.406 20.5311 12.4397 20.5994 12.5495C20.6677 12.6595 20.634 12.804 20.5242 12.8724C20.2183 13.0626 19.8661 13.2478 19.4773 13.4229C19.4461 13.4369 19.4134 13.4436 19.3812 13.4436V13.4436Z" fill="#FF9393"/>
                                            <path d="M18.0681 6.20699C17.9542 6.17001 17.837 6.2549 17.837 6.37462V9.93215C17.837 9.99623 17.8721 10.055 17.9281 10.0862C18.6779 10.5038 19.3408 10.9801 19.904 11.4957C19.4371 11.7274 18.9017 11.946 18.3048 12.149C18.1621 12.1976 18.0658 12.3317 18.0658 12.4826V19.437C18.0658 19.6473 18.2886 19.7838 18.4756 19.6874C20.6923 18.5446 22.0239 17.1709 22.0239 16.0793V9.21749C22.0239 8.0608 20.5282 7.00593 18.0681 6.20699Z" fill="url(#paint1_linear_4516_5327)"/>
                                            <path d="M16.1433 20.4084H4.77616C4.63975 20.4084 4.53241 20.2926 4.54225 20.1567L5.491 7.27685C5.49991 7.1545 5.6021 7.05981 5.72491 7.05981H15.1946C15.3174 7.05981 15.4191 7.1545 15.4285 7.27685L16.3768 20.1567C16.3871 20.2926 16.2793 20.4084 16.1433 20.4084Z" fill="#FFAA66"/>
                                            <path d="M11.0447 10.5326C10.9228 10.6545 10.7608 10.7216 10.5884 10.7216C10.4161 10.7216 10.2541 10.6545 10.1322 10.5326C10.0104 10.4107 9.94324 10.2487 9.94324 10.0763C9.94324 9.90399 10.0104 9.74199 10.1322 9.62011C10.3838 9.36849 10.7932 9.36854 11.0447 9.62011L11.2104 9.78586L11.5419 9.45441L11.3761 9.28866C11.2188 9.13135 11.0257 9.03188 10.8228 8.98847V8.53955H10.3541V8.98852C10.1512 9.03188 9.95805 9.13139 9.80074 9.28866C9.59036 9.49908 9.47449 9.77883 9.47449 10.0763C9.47449 10.3739 9.59036 10.6537 9.80074 10.864C9.95472 11.018 10.146 11.1211 10.3541 11.1655V11.6131H10.8228V11.1655C11.0309 11.1211 11.2221 11.018 11.3761 10.864L11.5419 10.6983L11.2104 10.3668L11.0447 10.5326Z" fill="white"/>
                                            <path d="M7.44153 7.05981H8.37903V8.87763C8.37903 9.13638 8.16903 9.34638 7.91028 9.34638C7.65153 9.34638 7.44153 9.13638 7.44153 8.87763V7.05981Z" fill="#FF9C33"/>
                                            <path d="M13.4781 7.05981V8.87763C13.4781 9.13638 13.2681 9.34638 13.0094 9.34638C12.7502 9.34638 12.5406 9.13638 12.5406 8.87763V7.05981H13.4781Z" fill="#FF9C33"/>
                                            <path d="M10.9984 13.5775C12.884 13.4304 14.6278 13.183 16.1577 12.8558C16.3769 12.8089 16.5833 12.9764 16.5833 13.2005V20.4353C16.5833 20.5874 16.4858 20.7222 16.3414 20.7701C14.7835 21.2871 12.9957 21.6755 11.0566 21.8444C10.8508 21.8623 10.6738 21.6995 10.6738 21.4929V13.9288C10.6738 13.745 10.8151 13.5918 10.9984 13.5775V13.5775Z" fill="#D8D8FF"/>
                                            <path d="M15.4929 20.1811C15.3913 20.1811 15.2977 20.1146 15.2679 20.0122C15.2318 19.8879 15.3032 19.7578 15.4274 19.7216C15.4987 19.7009 15.5694 19.6798 15.6398 19.6586C15.7636 19.621 15.8946 19.6911 15.9321 19.815C15.9696 19.9389 15.8995 20.0697 15.7756 20.1072C15.7036 20.129 15.6313 20.1505 15.5584 20.1717C15.5366 20.1781 15.5146 20.1811 15.4929 20.1811V20.1811Z" fill="#8282FF"/>
                                            <path d="M15.4929 19.4651C15.3913 19.4651 15.2977 19.3986 15.2679 19.2961C15.2318 19.1719 15.3032 19.0418 15.4274 19.0056C15.4987 18.9848 15.5694 18.9638 15.6398 18.9425C15.7636 18.9049 15.8946 18.9751 15.9321 19.0989C15.9696 19.2228 15.8995 19.3537 15.7756 19.3912C15.7036 19.413 15.6313 19.4344 15.5584 19.4556C15.5366 19.462 15.5146 19.4651 15.4929 19.4651V19.4651Z" fill="#8282FF"/>
                                            <path d="M16.0011 15.6087L14.8434 14.5739C14.8277 14.5598 14.8076 14.5527 14.7878 14.5541L14.2639 14.5906C14.2315 14.5929 14.2048 14.6166 14.1978 14.6498C14.1563 14.846 13.9983 14.997 13.7931 15.013C13.586 15.0292 13.3922 14.9033 13.3049 14.713C13.29 14.6807 13.2572 14.6607 13.2233 14.6631L12.6622 14.7021C12.6407 14.7036 12.6207 14.714 12.6071 14.7308L11.5495 16.0345C11.5196 16.0715 11.5257 16.1262 11.5632 16.1566L12.2405 16.7049C12.2768 16.7343 12.3301 16.7283 12.359 16.6915L12.7033 16.2534L12.643 18.6497C12.6416 18.7057 12.6911 18.7494 12.7465 18.7411L15.0027 18.4026C15.0469 18.396 15.0795 18.3579 15.0794 18.3132L15.074 16.0106L15.4573 16.3438C15.4903 16.3725 15.5408 16.3668 15.5666 16.3314L16.0137 15.7194C16.038 15.6862 16.0324 15.6366 16.0011 15.6087V15.6087Z" fill="#FFAA66"/>
                                            <path d="M12.9243 20.3039C13.5523 20.3039 14.0615 19.7948 14.0615 19.1667C14.0615 18.5387 13.5523 18.0295 12.9243 18.0295C12.2962 18.0295 11.7871 18.5387 11.7871 19.1667C11.7871 19.7948 12.2962 20.3039 12.9243 20.3039Z" fill="#FF6C6C"/>
                                            <path d="M12.7735 19.6973C12.7114 19.6973 12.6518 19.6726 12.6078 19.6287L12.3171 19.3379C12.2255 19.2464 12.2255 19.098 12.3171 19.0065C12.4086 18.915 12.5571 18.915 12.6485 19.0065L12.7735 19.1315L13.2002 18.7049C13.2917 18.6134 13.4402 18.6134 13.5316 18.7049C13.6232 18.7964 13.6232 18.9448 13.5316 19.0363L12.9392 19.6287C12.8953 19.6726 12.8357 19.6973 12.7735 19.6973V19.6973Z" fill="white"/>
                                            <path d="M14.3828 16.2914C14.2533 16.2914 14.1484 16.1864 14.1484 16.057V15.9878C14.1484 15.8584 14.2533 15.7534 14.3828 15.7534C14.5123 15.7534 14.6172 15.8584 14.6172 15.9878V16.057C14.6172 16.1864 14.5122 16.2914 14.3828 16.2914Z" fill="#FFD5BA"/>
                                            <path d="M13.0091 8.50233C12.7502 8.50233 12.5404 8.29243 12.5404 8.03358V4.51604C12.5404 3.36872 11.607 2.4353 10.4596 2.4353C9.31233 2.4353 8.37891 3.36872 8.37891 4.51604V8.03358C8.37891 8.29243 8.16905 8.50233 7.91016 8.50233C7.65127 8.50233 7.44141 8.29243 7.44141 8.03358V4.51604C7.44141 2.85179 8.79539 1.4978 10.4596 1.4978C12.1239 1.4978 13.4779 2.85179 13.4779 4.51604V8.03358C13.4779 8.29248 13.268 8.50233 13.0091 8.50233Z" fill="#FFD5BA"/>
                                            <path d="M8.8133 19.1614H6.17639C6.04697 19.1614 5.94202 19.0564 5.94202 18.927C5.94202 18.7976 6.04697 18.6926 6.17639 18.6926H8.8133C8.94272 18.6926 9.04767 18.7976 9.04767 18.927C9.04767 19.0564 8.94272 19.1614 8.8133 19.1614Z" fill="#FFD5BA"/>
                                            <path d="M8.86591 18.2642H6.229C6.09958 18.2642 5.99463 18.1592 5.99463 18.0298C5.99463 17.9004 6.09958 17.7954 6.229 17.7954H8.86591C8.99533 17.7954 9.10028 17.9004 9.10028 18.0298C9.10028 18.1592 8.99533 18.2642 8.86591 18.2642Z" fill="#FFD5BA"/>
                                            <path d="M7.0261 17.3667H6.28149C6.15207 17.3667 6.04712 17.2617 6.04712 17.1323C6.04712 17.0029 6.15207 16.8979 6.28149 16.8979H7.0261C7.15553 16.8979 7.26048 17.0029 7.26048 17.1323C7.26048 17.2617 7.15553 17.3667 7.0261 17.3667Z" fill="#FFD5BA"/>
                                            <path d="M16.525 5.72504C15.5939 5.5028 14.5715 5.31202 13.478 5.15696V4.51604C13.478 2.85179 12.124 1.4978 10.4597 1.4978C10.128 1.4978 9.80901 1.55237 9.51023 1.65169C9.21145 1.55237 8.89242 1.4978 8.56073 1.4978C6.89648 1.4978 5.5425 2.85179 5.5425 4.51604V7.05976H3.82584C3.70307 7.05976 3.60112 7.15449 3.59212 7.27693L2.64347 20.1568C2.63348 20.2927 2.74097 20.4084 2.87723 20.4084H10.6739V21.4929C10.6739 21.6995 10.8509 21.8623 11.0567 21.8444C12.9958 21.6755 14.7836 21.2871 16.3415 20.7701C16.4859 20.7222 16.5833 20.5874 16.5833 20.4353V13.2006C16.5833 12.9764 16.377 12.809 16.1578 12.8558C16.0543 12.878 15.9496 12.8997 15.8441 12.9211L15.5559 9.00638C15.852 9.09694 16.1408 9.19538 16.4214 9.30165C16.5367 9.34533 16.6598 9.2603 16.6598 9.13702V5.89646C16.6598 5.81504 16.6042 5.74397 16.525 5.72504V5.72504ZM7.4415 7.05976H6.48V4.51604C6.48 3.47265 7.25207 2.6064 8.25487 2.45799C7.75087 2.99757 7.4415 3.72118 7.4415 4.51604V7.05976ZM8.379 4.51604C8.379 3.71068 8.83926 3.01126 9.51023 2.66555C10.1812 3.01126 10.6415 3.71068 10.6415 4.51604V7.05976H8.379V4.51604ZM12.5405 7.05976H11.579V4.51604C11.579 3.72118 11.2696 2.99757 10.7656 2.45799C11.7684 2.6064 12.5405 3.47265 12.5405 4.51604V7.05976Z" fill="url(#paint2_linear_4516_5327)"/>
                                            <path d="M2.97083 3.40723H2.50208C2.24361 3.40723 2.03333 3.19695 2.03333 2.93848V2.46973C2.03333 2.21126 2.24361 2.00098 2.50208 2.00098H2.97083C3.22929 2.00098 3.43958 2.21126 3.43958 2.46973V2.93848C3.43958 3.19695 3.22929 3.40723 2.97083 3.40723V3.40723ZM2.50208 2.46973V2.93876L2.97083 2.93848V2.46973H2.50208Z" fill="#FF6C6C"/>
                                            <path d="M22.1149 20.8145H21.6461C21.3876 20.8145 21.1774 20.6042 21.1774 20.3457V19.877C21.1774 19.6185 21.3876 19.4082 21.6461 19.4082H22.1149C22.3733 19.4082 22.5836 19.6185 22.5836 19.877V20.3457C22.5836 20.6042 22.3733 20.8145 22.1149 20.8145ZM21.6461 19.877V20.346L22.1149 20.3457V19.877H21.6461Z" fill="#FF6C6C"/>
                                            <path d="M16.8109 4.39062H16.3422C16.0837 4.39062 15.8734 4.18034 15.8734 3.92188V3.45312C15.8734 3.19466 16.0837 2.98438 16.3422 2.98438H16.8109C17.0694 2.98438 17.2797 3.19466 17.2797 3.45312V3.92188C17.2797 4.18034 17.0694 4.39062 16.8109 4.39062ZM16.3422 3.45312V3.92216L16.8109 3.92188V3.45312H16.3422Z" fill="#6C6CFF"/>
                                            <path d="M3.7439 5.73242C3.6839 5.73242 3.62394 5.70955 3.57815 5.6638L3.50727 5.59292C3.37935 5.46495 3.17104 5.46495 3.04297 5.59292L2.9721 5.6638C2.88055 5.7553 2.73219 5.7553 2.64065 5.6638C2.5949 5.618 2.57202 5.55805 2.57202 5.49805C2.57202 5.43805 2.5949 5.37809 2.64065 5.3323L2.71152 5.26142C2.77354 5.19941 2.80771 5.11695 2.80771 5.0293C2.80771 4.94164 2.77354 4.85919 2.71157 4.79717L2.64065 4.7263C2.5949 4.6805 2.57202 4.62055 2.57202 4.56055C2.57202 4.50055 2.5949 4.44059 2.64065 4.3948C2.73219 4.3033 2.88055 4.3033 2.9721 4.3948L3.04297 4.46567C3.17094 4.59364 3.37926 4.59364 3.50722 4.46567L3.5781 4.3948C3.66965 4.3033 3.81801 4.3033 3.90955 4.3948C3.9553 4.44059 3.97818 4.50055 3.97818 4.56055C3.97818 4.62055 3.9553 4.6805 3.90955 4.7263L3.83868 4.79717C3.71066 4.92514 3.71066 5.13345 3.83868 5.26142L3.90955 5.3323C3.9553 5.37809 3.97818 5.43805 3.97818 5.49805C3.97818 5.55805 3.9553 5.618 3.90955 5.6638C3.86385 5.70955 3.8039 5.73242 3.7439 5.73242V5.73242Z" fill="#FF9C33"/>
                                            <path d="M9.3708 23.1479C9.3108 23.1479 9.25085 23.1251 9.20505 23.0793L9.13418 23.0084C9.00621 22.8805 8.7979 22.8805 8.66993 23.0084L8.59905 23.0793C8.50751 23.1708 8.35915 23.1708 8.2676 23.0793C8.22185 23.0335 8.19897 22.9736 8.19897 22.9136C8.19897 22.8536 8.22185 22.7936 8.2676 22.7478L8.33847 22.6769C8.46649 22.549 8.46649 22.3407 8.33847 22.2127L8.2676 22.1418C8.22185 22.096 8.19897 22.0361 8.19897 21.9761C8.19897 21.9161 8.22185 21.8561 8.2676 21.8103C8.35915 21.7188 8.50751 21.7188 8.59905 21.8103L8.66993 21.8812C8.79785 22.0092 9.00616 22.0092 9.13422 21.8812L9.2051 21.8103C9.29665 21.7188 9.44501 21.7188 9.53655 21.8103C9.5823 21.8561 9.60518 21.9161 9.60518 21.9761C9.60518 22.0361 9.5823 22.096 9.53655 22.1418L9.46568 22.2127C9.40366 22.2747 9.36949 22.3572 9.36949 22.4448C9.36949 22.5325 9.40366 22.6149 9.46563 22.6769L9.53655 22.7478C9.5823 22.7936 9.60518 22.8536 9.60518 22.9136C9.60518 22.9736 9.5823 23.0335 9.53655 23.0793C9.49076 23.125 9.4308 23.1479 9.3708 23.1479Z" fill="#FF9C33"/>
                                         
                                        </svg>
                                            
                                              
                                    </div>
                                    <div class="content-right">
                                        <div class="title">
                                            <h3 class="fw_6">Shopping</h3>
                                            <span class="fw_6 on_surface_color">9/1/2023</span>
                                        </div>
                                        <div class="desc">
                                            <p class="on_surface_color fw_4">Alipay gives you 20% offcoupon for all bills, applicable for bills paid through Alipay wallet!</p>
                                            <i class="dot"></i>
                                        </div>
                                    </div>
                                </div>
                                <div class="noti-list">
                                    <div class="icon-box bg_service-3">
                                        <svg width="16" height="16" viewBox="0 0 25 24" fill="none" xmlns="http://www.w3.org/2000/svg">
                                            <path d="M24.2838 7.48567C22.5636 -5.34697 15.3153 2.01241 6.99199 5.99402C4.62414 7.12675 1.38339 7.13603 0.529097 10.1115C-0.458746 13.5521 2.49213 15.7224 4.86696 17.5562C7.726 19.7638 7.32082 24.1061 11.9929 23.7198C12.874 23.647 13.9302 23.7352 14.4994 23.0587C16.8551 20.2588 17.5094 16.0487 20.5731 13.8156C22.7339 12.2406 24.6702 10.3686 24.2838 7.48567V7.48567Z" fill="url(#paint0_linear_4516_5327)"/>
                                            <path d="M11.1101 8.50233C10.8512 8.50233 10.6413 8.29243 10.6413 8.03358V4.51604C10.6413 3.36872 9.70791 2.4353 8.56059 2.4353C7.41328 2.4353 6.47986 3.36872 6.47986 4.51604V8.03358C6.47986 8.29243 6.27 8.50233 6.01111 8.50233C5.75222 8.50233 5.54236 8.29243 5.54236 8.03358V4.51604C5.54236 2.85179 6.89634 1.4978 8.56059 1.4978C10.2248 1.4978 11.5788 2.85179 11.5788 4.51604V8.03358C11.5788 8.29248 11.369 8.50233 11.1101 8.50233V8.50233Z" fill="#FFC498"/>
                                            <path d="M4.77612 20.4084H2.87707C2.74085 20.4084 2.63332 20.2927 2.64335 20.1568L3.59196 7.27699C3.60096 7.15455 3.70296 7.05981 3.82568 7.05981H5.72482L4.77612 20.4084Z" fill="#FF7300"/>
                                            <path d="M10.2019 1.98511C9.70002 2.02945 9.26681 2.20284 8.90198 2.46379C9.5587 2.57269 10.1121 2.99006 10.4085 3.56161C10.4256 3.56119 10.4425 3.56029 10.4596 3.56029C10.8392 3.56029 11.1951 3.663 11.5018 3.84131C11.3243 3.06712 10.8485 2.40586 10.2019 1.98511V1.98511Z" fill="#FFAA66"/>
                                            <path d="M13.3223 5.13473C14.475 5.29359 15.5495 5.49229 16.5249 5.72507C16.6042 5.74396 16.6598 5.81503 16.6598 5.8965V9.13706C16.6598 9.26034 16.5367 9.34537 16.4213 9.30168C15.46 8.93756 14.4044 8.66198 13.2743 8.50078C13.1872 8.48836 13.1222 8.41434 13.1222 8.3264V5.30939C13.1222 5.2027 13.2166 5.12015 13.3223 5.13473V5.13473Z" fill="#9393FF"/>
                                            <path d="M19.934 11.522C19.3646 10.9961 18.6909 10.5108 17.9281 10.086C17.8721 10.0548 17.837 9.99604 17.837 9.93201V6.37448C17.837 6.25486 17.9539 6.16978 18.0677 6.20672C20.528 7.0057 22.0239 8.06062 22.0239 9.21736L21.8832 11.1587L19.934 11.522Z" fill="#9393FF"/>
                                            <path d="M22.0238 13.3463L21.8386 14.0752L22.0238 14.2763V14.5922L21.9179 15.2644L22.0238 15.5222V16.0791C22.0238 17.1707 20.6922 18.5447 18.4754 19.6873C18.2885 19.7836 18.0657 19.6472 18.0657 19.4369V12.4824C18.0657 12.3314 18.1622 12.1974 18.3052 12.1486C20.6241 11.3602 22.0238 10.3364 22.0238 9.21753V13.3463Z" fill="#D8D8FF"/>
                                            <path d="M22.0238 14.592V15.522C21.4594 16.2172 20.5032 16.8463 19.4996 17.4355C19.4625 17.4575 19.4217 17.4678 19.3814 17.4678C19.3008 17.4678 19.2225 17.4266 19.1789 17.352C19.1133 17.2405 19.1508 17.0966 19.2624 17.0314C20.9536 16.0386 21.8133 15.2853 22.0238 14.592V14.592Z" fill="#9393FF"/>
                                            <path d="M22.0238 13.3462V14.2762C21.4589 14.9713 20.5032 15.6004 19.4996 16.1896C19.4625 16.2112 19.4217 16.2215 19.3814 16.2215C19.3008 16.2215 19.2225 16.1803 19.1789 16.1062C19.1133 15.9942 19.1508 15.8507 19.2624 15.7851C20.9536 14.7923 21.8133 14.0395 22.0238 13.3462Z" fill="#9393FF"/>
                                            <path d="M19.3813 15.2074C19.3025 15.2074 19.2256 15.1678 19.1813 15.0957C19.1136 14.9854 19.148 14.8411 19.2583 14.7734C19.5345 14.6037 19.7758 14.4484 19.996 14.2986C20.1032 14.2258 20.2489 14.2537 20.3216 14.3607C20.3944 14.4678 20.3666 14.6136 20.2596 14.6863C20.0333 14.8401 19.786 14.9993 19.5037 15.1727C19.4655 15.1962 19.4231 15.2074 19.3813 15.2074V15.2074Z" fill="#9393FF"/>
                                            <path d="M19.3812 13.4436C19.2918 13.4436 19.2064 13.3922 19.1674 13.3054C19.1142 13.1874 19.1668 13.0486 19.2848 12.9955C19.6547 12.8289 19.9883 12.6536 20.2766 12.4743C20.3866 12.406 20.5311 12.4397 20.5994 12.5495C20.6677 12.6595 20.634 12.804 20.5242 12.8724C20.2183 13.0626 19.8661 13.2478 19.4773 13.4229C19.4461 13.4369 19.4134 13.4436 19.3812 13.4436V13.4436Z" fill="#FF9393"/>
                                            <path d="M18.0681 6.20699C17.9542 6.17001 17.837 6.2549 17.837 6.37462V9.93215C17.837 9.99623 17.8721 10.055 17.9281 10.0862C18.6779 10.5038 19.3408 10.9801 19.904 11.4957C19.4371 11.7274 18.9017 11.946 18.3048 12.149C18.1621 12.1976 18.0658 12.3317 18.0658 12.4826V19.437C18.0658 19.6473 18.2886 19.7838 18.4756 19.6874C20.6923 18.5446 22.0239 17.1709 22.0239 16.0793V9.21749C22.0239 8.0608 20.5282 7.00593 18.0681 6.20699Z" fill="url(#paint1_linear_4516_5327)"/>
                                            <path d="M16.1433 20.4084H4.77616C4.63975 20.4084 4.53241 20.2926 4.54225 20.1567L5.491 7.27685C5.49991 7.1545 5.6021 7.05981 5.72491 7.05981H15.1946C15.3174 7.05981 15.4191 7.1545 15.4285 7.27685L16.3768 20.1567C16.3871 20.2926 16.2793 20.4084 16.1433 20.4084Z" fill="#FFAA66"/>
                                            <path d="M11.0447 10.5326C10.9228 10.6545 10.7608 10.7216 10.5884 10.7216C10.4161 10.7216 10.2541 10.6545 10.1322 10.5326C10.0104 10.4107 9.94324 10.2487 9.94324 10.0763C9.94324 9.90399 10.0104 9.74199 10.1322 9.62011C10.3838 9.36849 10.7932 9.36854 11.0447 9.62011L11.2104 9.78586L11.5419 9.45441L11.3761 9.28866C11.2188 9.13135 11.0257 9.03188 10.8228 8.98847V8.53955H10.3541V8.98852C10.1512 9.03188 9.95805 9.13139 9.80074 9.28866C9.59036 9.49908 9.47449 9.77883 9.47449 10.0763C9.47449 10.3739 9.59036 10.6537 9.80074 10.864C9.95472 11.018 10.146 11.1211 10.3541 11.1655V11.6131H10.8228V11.1655C11.0309 11.1211 11.2221 11.018 11.3761 10.864L11.5419 10.6983L11.2104 10.3668L11.0447 10.5326Z" fill="white"/>
                                            <path d="M7.44153 7.05981H8.37903V8.87763C8.37903 9.13638 8.16903 9.34638 7.91028 9.34638C7.65153 9.34638 7.44153 9.13638 7.44153 8.87763V7.05981Z" fill="#FF9C33"/>
                                            <path d="M13.4781 7.05981V8.87763C13.4781 9.13638 13.2681 9.34638 13.0094 9.34638C12.7502 9.34638 12.5406 9.13638 12.5406 8.87763V7.05981H13.4781Z" fill="#FF9C33"/>
                                            <path d="M10.9984 13.5775C12.884 13.4304 14.6278 13.183 16.1577 12.8558C16.3769 12.8089 16.5833 12.9764 16.5833 13.2005V20.4353C16.5833 20.5874 16.4858 20.7222 16.3414 20.7701C14.7835 21.2871 12.9957 21.6755 11.0566 21.8444C10.8508 21.8623 10.6738 21.6995 10.6738 21.4929V13.9288C10.6738 13.745 10.8151 13.5918 10.9984 13.5775V13.5775Z" fill="#D8D8FF"/>
                                            <path d="M15.4929 20.1811C15.3913 20.1811 15.2977 20.1146 15.2679 20.0122C15.2318 19.8879 15.3032 19.7578 15.4274 19.7216C15.4987 19.7009 15.5694 19.6798 15.6398 19.6586C15.7636 19.621 15.8946 19.6911 15.9321 19.815C15.9696 19.9389 15.8995 20.0697 15.7756 20.1072C15.7036 20.129 15.6313 20.1505 15.5584 20.1717C15.5366 20.1781 15.5146 20.1811 15.4929 20.1811V20.1811Z" fill="#8282FF"/>
                                            <path d="M15.4929 19.4651C15.3913 19.4651 15.2977 19.3986 15.2679 19.2961C15.2318 19.1719 15.3032 19.0418 15.4274 19.0056C15.4987 18.9848 15.5694 18.9638 15.6398 18.9425C15.7636 18.9049 15.8946 18.9751 15.9321 19.0989C15.9696 19.2228 15.8995 19.3537 15.7756 19.3912C15.7036 19.413 15.6313 19.4344 15.5584 19.4556C15.5366 19.462 15.5146 19.4651 15.4929 19.4651V19.4651Z" fill="#8282FF"/>
                                            <path d="M16.0011 15.6087L14.8434 14.5739C14.8277 14.5598 14.8076 14.5527 14.7878 14.5541L14.2639 14.5906C14.2315 14.5929 14.2048 14.6166 14.1978 14.6498C14.1563 14.846 13.9983 14.997 13.7931 15.013C13.586 15.0292 13.3922 14.9033 13.3049 14.713C13.29 14.6807 13.2572 14.6607 13.2233 14.6631L12.6622 14.7021C12.6407 14.7036 12.6207 14.714 12.6071 14.7308L11.5495 16.0345C11.5196 16.0715 11.5257 16.1262 11.5632 16.1566L12.2405 16.7049C12.2768 16.7343 12.3301 16.7283 12.359 16.6915L12.7033 16.2534L12.643 18.6497C12.6416 18.7057 12.6911 18.7494 12.7465 18.7411L15.0027 18.4026C15.0469 18.396 15.0795 18.3579 15.0794 18.3132L15.074 16.0106L15.4573 16.3438C15.4903 16.3725 15.5408 16.3668 15.5666 16.3314L16.0137 15.7194C16.038 15.6862 16.0324 15.6366 16.0011 15.6087V15.6087Z" fill="#FFAA66"/>
                                            <path d="M12.9243 20.3039C13.5523 20.3039 14.0615 19.7948 14.0615 19.1667C14.0615 18.5387 13.5523 18.0295 12.9243 18.0295C12.2962 18.0295 11.7871 18.5387 11.7871 19.1667C11.7871 19.7948 12.2962 20.3039 12.9243 20.3039Z" fill="#FF6C6C"/>
                                            <path d="M12.7735 19.6973C12.7114 19.6973 12.6518 19.6726 12.6078 19.6287L12.3171 19.3379C12.2255 19.2464 12.2255 19.098 12.3171 19.0065C12.4086 18.915 12.5571 18.915 12.6485 19.0065L12.7735 19.1315L13.2002 18.7049C13.2917 18.6134 13.4402 18.6134 13.5316 18.7049C13.6232 18.7964 13.6232 18.9448 13.5316 19.0363L12.9392 19.6287C12.8953 19.6726 12.8357 19.6973 12.7735 19.6973V19.6973Z" fill="white"/>
                                            <path d="M14.3828 16.2914C14.2533 16.2914 14.1484 16.1864 14.1484 16.057V15.9878C14.1484 15.8584 14.2533 15.7534 14.3828 15.7534C14.5123 15.7534 14.6172 15.8584 14.6172 15.9878V16.057C14.6172 16.1864 14.5122 16.2914 14.3828 16.2914Z" fill="#FFD5BA"/>
                                            <path d="M13.0091 8.50233C12.7502 8.50233 12.5404 8.29243 12.5404 8.03358V4.51604C12.5404 3.36872 11.607 2.4353 10.4596 2.4353C9.31233 2.4353 8.37891 3.36872 8.37891 4.51604V8.03358C8.37891 8.29243 8.16905 8.50233 7.91016 8.50233C7.65127 8.50233 7.44141 8.29243 7.44141 8.03358V4.51604C7.44141 2.85179 8.79539 1.4978 10.4596 1.4978C12.1239 1.4978 13.4779 2.85179 13.4779 4.51604V8.03358C13.4779 8.29248 13.268 8.50233 13.0091 8.50233Z" fill="#FFD5BA"/>
                                            <path d="M8.8133 19.1614H6.17639C6.04697 19.1614 5.94202 19.0564 5.94202 18.927C5.94202 18.7976 6.04697 18.6926 6.17639 18.6926H8.8133C8.94272 18.6926 9.04767 18.7976 9.04767 18.927C9.04767 19.0564 8.94272 19.1614 8.8133 19.1614Z" fill="#FFD5BA"/>
                                            <path d="M8.86591 18.2642H6.229C6.09958 18.2642 5.99463 18.1592 5.99463 18.0298C5.99463 17.9004 6.09958 17.7954 6.229 17.7954H8.86591C8.99533 17.7954 9.10028 17.9004 9.10028 18.0298C9.10028 18.1592 8.99533 18.2642 8.86591 18.2642Z" fill="#FFD5BA"/>
                                            <path d="M7.0261 17.3667H6.28149C6.15207 17.3667 6.04712 17.2617 6.04712 17.1323C6.04712 17.0029 6.15207 16.8979 6.28149 16.8979H7.0261C7.15553 16.8979 7.26048 17.0029 7.26048 17.1323C7.26048 17.2617 7.15553 17.3667 7.0261 17.3667Z" fill="#FFD5BA"/>
                                            <path d="M16.525 5.72504C15.5939 5.5028 14.5715 5.31202 13.478 5.15696V4.51604C13.478 2.85179 12.124 1.4978 10.4597 1.4978C10.128 1.4978 9.80901 1.55237 9.51023 1.65169C9.21145 1.55237 8.89242 1.4978 8.56073 1.4978C6.89648 1.4978 5.5425 2.85179 5.5425 4.51604V7.05976H3.82584C3.70307 7.05976 3.60112 7.15449 3.59212 7.27693L2.64347 20.1568C2.63348 20.2927 2.74097 20.4084 2.87723 20.4084H10.6739V21.4929C10.6739 21.6995 10.8509 21.8623 11.0567 21.8444C12.9958 21.6755 14.7836 21.2871 16.3415 20.7701C16.4859 20.7222 16.5833 20.5874 16.5833 20.4353V13.2006C16.5833 12.9764 16.377 12.809 16.1578 12.8558C16.0543 12.878 15.9496 12.8997 15.8441 12.9211L15.5559 9.00638C15.852 9.09694 16.1408 9.19538 16.4214 9.30165C16.5367 9.34533 16.6598 9.2603 16.6598 9.13702V5.89646C16.6598 5.81504 16.6042 5.74397 16.525 5.72504V5.72504ZM7.4415 7.05976H6.48V4.51604C6.48 3.47265 7.25207 2.6064 8.25487 2.45799C7.75087 2.99757 7.4415 3.72118 7.4415 4.51604V7.05976ZM8.379 4.51604C8.379 3.71068 8.83926 3.01126 9.51023 2.66555C10.1812 3.01126 10.6415 3.71068 10.6415 4.51604V7.05976H8.379V4.51604ZM12.5405 7.05976H11.579V4.51604C11.579 3.72118 11.2696 2.99757 10.7656 2.45799C11.7684 2.6064 12.5405 3.47265 12.5405 4.51604V7.05976Z" fill="url(#paint2_linear_4516_5327)"/>
                                            <path d="M2.97083 3.40723H2.50208C2.24361 3.40723 2.03333 3.19695 2.03333 2.93848V2.46973C2.03333 2.21126 2.24361 2.00098 2.50208 2.00098H2.97083C3.22929 2.00098 3.43958 2.21126 3.43958 2.46973V2.93848C3.43958 3.19695 3.22929 3.40723 2.97083 3.40723V3.40723ZM2.50208 2.46973V2.93876L2.97083 2.93848V2.46973H2.50208Z" fill="#FF6C6C"/>
                                            <path d="M22.1149 20.8145H21.6461C21.3876 20.8145 21.1774 20.6042 21.1774 20.3457V19.877C21.1774 19.6185 21.3876 19.4082 21.6461 19.4082H22.1149C22.3733 19.4082 22.5836 19.6185 22.5836 19.877V20.3457C22.5836 20.6042 22.3733 20.8145 22.1149 20.8145ZM21.6461 19.877V20.346L22.1149 20.3457V19.877H21.6461Z" fill="#FF6C6C"/>
                                            <path d="M16.8109 4.39062H16.3422C16.0837 4.39062 15.8734 4.18034 15.8734 3.92188V3.45312C15.8734 3.19466 16.0837 2.98438 16.3422 2.98438H16.8109C17.0694 2.98438 17.2797 3.19466 17.2797 3.45312V3.92188C17.2797 4.18034 17.0694 4.39062 16.8109 4.39062ZM16.3422 3.45312V3.92216L16.8109 3.92188V3.45312H16.3422Z" fill="#6C6CFF"/>
                                            <path d="M3.7439 5.73242C3.6839 5.73242 3.62394 5.70955 3.57815 5.6638L3.50727 5.59292C3.37935 5.46495 3.17104 5.46495 3.04297 5.59292L2.9721 5.6638C2.88055 5.7553 2.73219 5.7553 2.64065 5.6638C2.5949 5.618 2.57202 5.55805 2.57202 5.49805C2.57202 5.43805 2.5949 5.37809 2.64065 5.3323L2.71152 5.26142C2.77354 5.19941 2.80771 5.11695 2.80771 5.0293C2.80771 4.94164 2.77354 4.85919 2.71157 4.79717L2.64065 4.7263C2.5949 4.6805 2.57202 4.62055 2.57202 4.56055C2.57202 4.50055 2.5949 4.44059 2.64065 4.3948C2.73219 4.3033 2.88055 4.3033 2.9721 4.3948L3.04297 4.46567C3.17094 4.59364 3.37926 4.59364 3.50722 4.46567L3.5781 4.3948C3.66965 4.3033 3.81801 4.3033 3.90955 4.3948C3.9553 4.44059 3.97818 4.50055 3.97818 4.56055C3.97818 4.62055 3.9553 4.6805 3.90955 4.7263L3.83868 4.79717C3.71066 4.92514 3.71066 5.13345 3.83868 5.26142L3.90955 5.3323C3.9553 5.37809 3.97818 5.43805 3.97818 5.49805C3.97818 5.55805 3.9553 5.618 3.90955 5.6638C3.86385 5.70955 3.8039 5.73242 3.7439 5.73242V5.73242Z" fill="#FF9C33"/>
                                            <path d="M9.3708 23.1479C9.3108 23.1479 9.25085 23.1251 9.20505 23.0793L9.13418 23.0084C9.00621 22.8805 8.7979 22.8805 8.66993 23.0084L8.59905 23.0793C8.50751 23.1708 8.35915 23.1708 8.2676 23.0793C8.22185 23.0335 8.19897 22.9736 8.19897 22.9136C8.19897 22.8536 8.22185 22.7936 8.2676 22.7478L8.33847 22.6769C8.46649 22.549 8.46649 22.3407 8.33847 22.2127L8.2676 22.1418C8.22185 22.096 8.19897 22.0361 8.19897 21.9761C8.19897 21.9161 8.22185 21.8561 8.2676 21.8103C8.35915 21.7188 8.50751 21.7188 8.59905 21.8103L8.66993 21.8812C8.79785 22.0092 9.00616 22.0092 9.13422 21.8812L9.2051 21.8103C9.29665 21.7188 9.44501 21.7188 9.53655 21.8103C9.5823 21.8561 9.60518 21.9161 9.60518 21.9761C9.60518 22.0361 9.5823 22.096 9.53655 22.1418L9.46568 22.2127C9.40366 22.2747 9.36949 22.3572 9.36949 22.4448C9.36949 22.5325 9.40366 22.6149 9.46563 22.6769L9.53655 22.7478C9.5823 22.7936 9.60518 22.8536 9.60518 22.9136C9.60518 22.9736 9.5823 23.0335 9.53655 23.0793C9.49076 23.125 9.4308 23.1479 9.3708 23.1479Z" fill="#FF9C33"/>
                                         
                                        </svg>
                                            
                                              
                                    </div>
                                    <div class="content-right">
                                        <div class="title">
                                            <h3 class="fw_4 secondary_color">Shopping</h3>
                                            <span class="secondary_color fw_4">7/1/2023</span>
                                        </div>
                                        <div class="desc">
                                            <p class="secondary_color fw_4">Alipay gives you 20% offcoupon for all bills, applicable for bills paid through Alipay wallet!</p>
                                        </div>
                                    </div>
                                </div>
                                <div class="noti-list">
                                    <div class="icon-box bg_service-6">
                                        <svg width="16" height="16" viewBox="0 0 16 16" fill="none" xmlns="http://www.w3.org/2000/svg">
                                            <path d="M7.99995 14.7062C12.0609 14.7062 15.353 11.4141 15.353 7.35309C15.353 3.29209 12.0609 0 7.99995 0C3.93894 0 0.646851 3.29209 0.646851 7.35309C0.646851 11.4141 3.93894 14.7062 7.99995 14.7062Z" fill="#F7B239"/>
                                            <path d="M7.99997 12.1931C10.673 12.1931 12.8399 10.0261 12.8399 7.35312C12.8399 4.6801 10.673 2.51318 7.99997 2.51318C5.32695 2.51318 3.16003 4.6801 3.16003 7.35312C3.16003 10.0261 5.32695 12.1931 7.99997 12.1931Z" fill="#E09B2D"/>
                                            <path d="M14.6157 15.1809C14.6307 15.2373 14.638 15.294 14.638 15.3495C14.638 15.637 14.4463 15.8997 14.1558 15.9776C13.8089 16.0706 13.4521 15.8646 13.3591 15.5178L12.2661 11.4386C12.1731 11.0918 12.3791 10.7349 12.726 10.6419C13.0732 10.549 13.4297 10.755 13.5227 11.1022L14.6157 15.1809Z" fill="#F24C8F"/>
                                            <path d="M2.4596 11.5182L3.01855 11.668L4.49394 6.16149L3.93499 6.01173L2.4596 11.5182Z" fill="#CCCCCC"/>
                                            <path d="M11.6446 7.71971L12.4469 10.7156L13.0059 10.5659L12.2036 7.57L11.6446 7.71971Z" fill="#CCCCCC"/>
                                            <path d="M5.26403 2.1712C6.18881 2.41888 6.60972 3.8456 6.20463 5.3572C5.79953 6.86917 4.88478 7.28545 3.96 7.03776C3.03559 6.79007 2.4515 5.97217 2.85659 4.4602C3.26169 2.94823 4.33963 1.92351 5.26403 2.1712Z" fill="#E6E6E6"/>
                                            <path d="M2.9944 10.642C3.34162 10.7349 3.54727 11.0918 3.45427 11.4386L2.36168 15.5178C2.28374 15.8083 2.02099 16 1.73359 16C1.67802 16 1.6213 15.9927 1.56499 15.9776C1.21777 15.8847 1.01174 15.5278 1.10471 15.181L2.19771 11.1022C2.29068 10.755 2.64755 10.549 2.9944 10.642Z" fill="#F24C8F"/>
                                            <path d="M13.0658 6.02202L12.141 2.57046C12.1045 2.4344 11.9629 2.35446 11.8268 2.39515C11.6951 2.43455 11.6237 2.57771 11.6592 2.71046L12.3966 5.46168C12.4517 5.66743 12.3296 5.87893 12.1239 5.93408L12.1235 5.93415C11.9177 5.98937 11.7061 5.86721 11.651 5.66143L10.911 2.89987C10.8745 2.76371 10.7327 2.6838 10.5967 2.72458C10.465 2.76405 10.3937 2.90718 10.4293 3.0399L11.1666 5.79137C11.2217 5.99715 11.0996 6.20865 10.8938 6.26383C10.688 6.31896 10.4766 6.19687 10.4214 5.99108L9.68139 3.22937C9.64493 3.09324 9.5033 3.01337 9.36721 3.05405C9.23552 3.09346 9.16408 3.23658 9.19964 3.36933L10.1216 6.81049C10.2269 7.20383 10.479 7.53255 10.8316 7.73615C11.0665 7.87177 11.327 7.94102 11.5912 7.94102C11.7236 7.94102 11.857 7.92358 11.9883 7.8884C12.6534 7.71015 13.1178 7.10524 13.1178 6.4174C13.1178 6.28349 13.1003 6.15027 13.0658 6.02202Z" fill="#E6E6E6"/>
                                        </svg>
                                            
                                              
                                    </div>
                                    <div class="content-right">
                                        <div class="title">
                                            <h3 class="fw_4 secondary_color">Travel</h3>
                                            <span class="secondary_color fw_4">1 Day Ago</span>
                                        </div>
                                        <div class="desc">
                                            <p class="secondary_color fw_4">Alipay gives you 20% offcoupon for all bills, applicable for bills paid through Alipay wallet!</p>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <!-- 3 -->
                            <div class="noti-box">
                                <div class="noti-list">
                                    <div class="icon-box bg_service-4">
                                        <svg width="16" height="16" viewBox="0 0 16 16" fill="none" xmlns="http://www.w3.org/2000/svg">
                                            <path d="M7.99995 14.7062C12.0609 14.7062 15.353 11.4141 15.353 7.35309C15.353 3.29209 12.0609 0 7.99995 0C3.93894 0 0.646851 3.29209 0.646851 7.35309C0.646851 11.4141 3.93894 14.7062 7.99995 14.7062Z" fill="#F7B239"/>
                                            <path d="M7.99997 12.1931C10.673 12.1931 12.8399 10.0261 12.8399 7.35312C12.8399 4.6801 10.673 2.51318 7.99997 2.51318C5.32695 2.51318 3.16003 4.6801 3.16003 7.35312C3.16003 10.0261 5.32695 12.1931 7.99997 12.1931Z" fill="#E09B2D"/>
                                            <path d="M14.6157 15.1809C14.6307 15.2373 14.638 15.294 14.638 15.3495C14.638 15.637 14.4463 15.8997 14.1558 15.9776C13.8089 16.0706 13.4521 15.8646 13.3591 15.5178L12.2661 11.4386C12.1731 11.0918 12.3791 10.7349 12.726 10.6419C13.0732 10.549 13.4297 10.755 13.5227 11.1022L14.6157 15.1809Z" fill="#F24C8F"/>
                                            <path d="M2.4596 11.5182L3.01855 11.668L4.49394 6.16149L3.93499 6.01173L2.4596 11.5182Z" fill="#CCCCCC"/>
                                            <path d="M11.6446 7.71971L12.4469 10.7156L13.0059 10.5659L12.2036 7.57L11.6446 7.71971Z" fill="#CCCCCC"/>
                                            <path d="M5.26403 2.1712C6.18881 2.41888 6.60972 3.8456 6.20463 5.3572C5.79953 6.86917 4.88478 7.28545 3.96 7.03776C3.03559 6.79007 2.4515 5.97217 2.85659 4.4602C3.26169 2.94823 4.33963 1.92351 5.26403 2.1712Z" fill="#E6E6E6"/>
                                            <path d="M2.9944 10.642C3.34162 10.7349 3.54727 11.0918 3.45427 11.4386L2.36168 15.5178C2.28374 15.8083 2.02099 16 1.73359 16C1.67802 16 1.6213 15.9927 1.56499 15.9776C1.21777 15.8847 1.01174 15.5278 1.10471 15.181L2.19771 11.1022C2.29068 10.755 2.64755 10.549 2.9944 10.642Z" fill="#F24C8F"/>
                                            <path d="M13.0658 6.02202L12.141 2.57046C12.1045 2.4344 11.9629 2.35446 11.8268 2.39515C11.6951 2.43455 11.6237 2.57771 11.6592 2.71046L12.3966 5.46168C12.4517 5.66743 12.3296 5.87893 12.1239 5.93408L12.1235 5.93415C11.9177 5.98937 11.7061 5.86721 11.651 5.66143L10.911 2.89987C10.8745 2.76371 10.7327 2.6838 10.5967 2.72458C10.465 2.76405 10.3937 2.90718 10.4293 3.0399L11.1666 5.79137C11.2217 5.99715 11.0996 6.20865 10.8938 6.26383C10.688 6.31896 10.4766 6.19687 10.4214 5.99108L9.68139 3.22937C9.64493 3.09324 9.5033 3.01337 9.36721 3.05405C9.23552 3.09346 9.16408 3.23658 9.19964 3.36933L10.1216 6.81049C10.2269 7.20383 10.479 7.53255 10.8316 7.73615C11.0665 7.87177 11.327 7.94102 11.5912 7.94102C11.7236 7.94102 11.857 7.92358 11.9883 7.8884C12.6534 7.71015 13.1178 7.10524 13.1178 6.4174C13.1178 6.28349 13.1003 6.15027 13.0658 6.02202Z" fill="#E6E6E6"/>
                                        </svg>
                                            
                                    </div>
                                    <div class="content-right">
                                        <div class="title">
                                            <h3 class="fw_6">Restaurant</h3>
                                            <span class="fw_6 on_surface_color">5 Min Ago</span>
                                        </div>
                                        <div class="desc">
                                            <p class="on_surface_color fw_4">Alipay gives you 20% offcoupon for all bills, applicable for bills paid through Alipay wallet!</p>
                                            <i class="dot"></i>
                                        </div>
                                    </div>
                                </div>
                                <div class="noti-list">
                                    <div class="icon-box bg_service-3">
                                        <svg width="16" height="16" viewBox="0 0 25 24" fill="none" xmlns="http://www.w3.org/2000/svg">
                                            <path d="M24.2838 7.48567C22.5636 -5.34697 15.3153 2.01241 6.99199 5.99402C4.62414 7.12675 1.38339 7.13603 0.529097 10.1115C-0.458746 13.5521 2.49213 15.7224 4.86696 17.5562C7.726 19.7638 7.32082 24.1061 11.9929 23.7198C12.874 23.647 13.9302 23.7352 14.4994 23.0587C16.8551 20.2588 17.5094 16.0487 20.5731 13.8156C22.7339 12.2406 24.6702 10.3686 24.2838 7.48567V7.48567Z" fill="url(#paint0_linear_4516_5327)"/>
                                            <path d="M11.1101 8.50233C10.8512 8.50233 10.6413 8.29243 10.6413 8.03358V4.51604C10.6413 3.36872 9.70791 2.4353 8.56059 2.4353C7.41328 2.4353 6.47986 3.36872 6.47986 4.51604V8.03358C6.47986 8.29243 6.27 8.50233 6.01111 8.50233C5.75222 8.50233 5.54236 8.29243 5.54236 8.03358V4.51604C5.54236 2.85179 6.89634 1.4978 8.56059 1.4978C10.2248 1.4978 11.5788 2.85179 11.5788 4.51604V8.03358C11.5788 8.29248 11.369 8.50233 11.1101 8.50233V8.50233Z" fill="#FFC498"/>
                                            <path d="M4.77612 20.4084H2.87707C2.74085 20.4084 2.63332 20.2927 2.64335 20.1568L3.59196 7.27699C3.60096 7.15455 3.70296 7.05981 3.82568 7.05981H5.72482L4.77612 20.4084Z" fill="#FF7300"/>
                                            <path d="M10.2019 1.98511C9.70002 2.02945 9.26681 2.20284 8.90198 2.46379C9.5587 2.57269 10.1121 2.99006 10.4085 3.56161C10.4256 3.56119 10.4425 3.56029 10.4596 3.56029C10.8392 3.56029 11.1951 3.663 11.5018 3.84131C11.3243 3.06712 10.8485 2.40586 10.2019 1.98511V1.98511Z" fill="#FFAA66"/>
                                            <path d="M13.3223 5.13473C14.475 5.29359 15.5495 5.49229 16.5249 5.72507C16.6042 5.74396 16.6598 5.81503 16.6598 5.8965V9.13706C16.6598 9.26034 16.5367 9.34537 16.4213 9.30168C15.46 8.93756 14.4044 8.66198 13.2743 8.50078C13.1872 8.48836 13.1222 8.41434 13.1222 8.3264V5.30939C13.1222 5.2027 13.2166 5.12015 13.3223 5.13473V5.13473Z" fill="#9393FF"/>
                                            <path d="M19.934 11.522C19.3646 10.9961 18.6909 10.5108 17.9281 10.086C17.8721 10.0548 17.837 9.99604 17.837 9.93201V6.37448C17.837 6.25486 17.9539 6.16978 18.0677 6.20672C20.528 7.0057 22.0239 8.06062 22.0239 9.21736L21.8832 11.1587L19.934 11.522Z" fill="#9393FF"/>
                                            <path d="M22.0238 13.3463L21.8386 14.0752L22.0238 14.2763V14.5922L21.9179 15.2644L22.0238 15.5222V16.0791C22.0238 17.1707 20.6922 18.5447 18.4754 19.6873C18.2885 19.7836 18.0657 19.6472 18.0657 19.4369V12.4824C18.0657 12.3314 18.1622 12.1974 18.3052 12.1486C20.6241 11.3602 22.0238 10.3364 22.0238 9.21753V13.3463Z" fill="#D8D8FF"/>
                                            <path d="M22.0238 14.592V15.522C21.4594 16.2172 20.5032 16.8463 19.4996 17.4355C19.4625 17.4575 19.4217 17.4678 19.3814 17.4678C19.3008 17.4678 19.2225 17.4266 19.1789 17.352C19.1133 17.2405 19.1508 17.0966 19.2624 17.0314C20.9536 16.0386 21.8133 15.2853 22.0238 14.592V14.592Z" fill="#9393FF"/>
                                            <path d="M22.0238 13.3462V14.2762C21.4589 14.9713 20.5032 15.6004 19.4996 16.1896C19.4625 16.2112 19.4217 16.2215 19.3814 16.2215C19.3008 16.2215 19.2225 16.1803 19.1789 16.1062C19.1133 15.9942 19.1508 15.8507 19.2624 15.7851C20.9536 14.7923 21.8133 14.0395 22.0238 13.3462Z" fill="#9393FF"/>
                                            <path d="M19.3813 15.2074C19.3025 15.2074 19.2256 15.1678 19.1813 15.0957C19.1136 14.9854 19.148 14.8411 19.2583 14.7734C19.5345 14.6037 19.7758 14.4484 19.996 14.2986C20.1032 14.2258 20.2489 14.2537 20.3216 14.3607C20.3944 14.4678 20.3666 14.6136 20.2596 14.6863C20.0333 14.8401 19.786 14.9993 19.5037 15.1727C19.4655 15.1962 19.4231 15.2074 19.3813 15.2074V15.2074Z" fill="#9393FF"/>
                                            <path d="M19.3812 13.4436C19.2918 13.4436 19.2064 13.3922 19.1674 13.3054C19.1142 13.1874 19.1668 13.0486 19.2848 12.9955C19.6547 12.8289 19.9883 12.6536 20.2766 12.4743C20.3866 12.406 20.5311 12.4397 20.5994 12.5495C20.6677 12.6595 20.634 12.804 20.5242 12.8724C20.2183 13.0626 19.8661 13.2478 19.4773 13.4229C19.4461 13.4369 19.4134 13.4436 19.3812 13.4436V13.4436Z" fill="#FF9393"/>
                                            <path d="M18.0681 6.20699C17.9542 6.17001 17.837 6.2549 17.837 6.37462V9.93215C17.837 9.99623 17.8721 10.055 17.9281 10.0862C18.6779 10.5038 19.3408 10.9801 19.904 11.4957C19.4371 11.7274 18.9017 11.946 18.3048 12.149C18.1621 12.1976 18.0658 12.3317 18.0658 12.4826V19.437C18.0658 19.6473 18.2886 19.7838 18.4756 19.6874C20.6923 18.5446 22.0239 17.1709 22.0239 16.0793V9.21749C22.0239 8.0608 20.5282 7.00593 18.0681 6.20699Z" fill="url(#paint1_linear_4516_5327)"/>
                                            <path d="M16.1433 20.4084H4.77616C4.63975 20.4084 4.53241 20.2926 4.54225 20.1567L5.491 7.27685C5.49991 7.1545 5.6021 7.05981 5.72491 7.05981H15.1946C15.3174 7.05981 15.4191 7.1545 15.4285 7.27685L16.3768 20.1567C16.3871 20.2926 16.2793 20.4084 16.1433 20.4084Z" fill="#FFAA66"/>
                                            <path d="M11.0447 10.5326C10.9228 10.6545 10.7608 10.7216 10.5884 10.7216C10.4161 10.7216 10.2541 10.6545 10.1322 10.5326C10.0104 10.4107 9.94324 10.2487 9.94324 10.0763C9.94324 9.90399 10.0104 9.74199 10.1322 9.62011C10.3838 9.36849 10.7932 9.36854 11.0447 9.62011L11.2104 9.78586L11.5419 9.45441L11.3761 9.28866C11.2188 9.13135 11.0257 9.03188 10.8228 8.98847V8.53955H10.3541V8.98852C10.1512 9.03188 9.95805 9.13139 9.80074 9.28866C9.59036 9.49908 9.47449 9.77883 9.47449 10.0763C9.47449 10.3739 9.59036 10.6537 9.80074 10.864C9.95472 11.018 10.146 11.1211 10.3541 11.1655V11.6131H10.8228V11.1655C11.0309 11.1211 11.2221 11.018 11.3761 10.864L11.5419 10.6983L11.2104 10.3668L11.0447 10.5326Z" fill="white"/>
                                            <path d="M7.44153 7.05981H8.37903V8.87763C8.37903 9.13638 8.16903 9.34638 7.91028 9.34638C7.65153 9.34638 7.44153 9.13638 7.44153 8.87763V7.05981Z" fill="#FF9C33"/>
                                            <path d="M13.4781 7.05981V8.87763C13.4781 9.13638 13.2681 9.34638 13.0094 9.34638C12.7502 9.34638 12.5406 9.13638 12.5406 8.87763V7.05981H13.4781Z" fill="#FF9C33"/>
                                            <path d="M10.9984 13.5775C12.884 13.4304 14.6278 13.183 16.1577 12.8558C16.3769 12.8089 16.5833 12.9764 16.5833 13.2005V20.4353C16.5833 20.5874 16.4858 20.7222 16.3414 20.7701C14.7835 21.2871 12.9957 21.6755 11.0566 21.8444C10.8508 21.8623 10.6738 21.6995 10.6738 21.4929V13.9288C10.6738 13.745 10.8151 13.5918 10.9984 13.5775V13.5775Z" fill="#D8D8FF"/>
                                            <path d="M15.4929 20.1811C15.3913 20.1811 15.2977 20.1146 15.2679 20.0122C15.2318 19.8879 15.3032 19.7578 15.4274 19.7216C15.4987 19.7009 15.5694 19.6798 15.6398 19.6586C15.7636 19.621 15.8946 19.6911 15.9321 19.815C15.9696 19.9389 15.8995 20.0697 15.7756 20.1072C15.7036 20.129 15.6313 20.1505 15.5584 20.1717C15.5366 20.1781 15.5146 20.1811 15.4929 20.1811V20.1811Z" fill="#8282FF"/>
                                            <path d="M15.4929 19.4651C15.3913 19.4651 15.2977 19.3986 15.2679 19.2961C15.2318 19.1719 15.3032 19.0418 15.4274 19.0056C15.4987 18.9848 15.5694 18.9638 15.6398 18.9425C15.7636 18.9049 15.8946 18.9751 15.9321 19.0989C15.9696 19.2228 15.8995 19.3537 15.7756 19.3912C15.7036 19.413 15.6313 19.4344 15.5584 19.4556C15.5366 19.462 15.5146 19.4651 15.4929 19.4651V19.4651Z" fill="#8282FF"/>
                                            <path d="M16.0011 15.6087L14.8434 14.5739C14.8277 14.5598 14.8076 14.5527 14.7878 14.5541L14.2639 14.5906C14.2315 14.5929 14.2048 14.6166 14.1978 14.6498C14.1563 14.846 13.9983 14.997 13.7931 15.013C13.586 15.0292 13.3922 14.9033 13.3049 14.713C13.29 14.6807 13.2572 14.6607 13.2233 14.6631L12.6622 14.7021C12.6407 14.7036 12.6207 14.714 12.6071 14.7308L11.5495 16.0345C11.5196 16.0715 11.5257 16.1262 11.5632 16.1566L12.2405 16.7049C12.2768 16.7343 12.3301 16.7283 12.359 16.6915L12.7033 16.2534L12.643 18.6497C12.6416 18.7057 12.6911 18.7494 12.7465 18.7411L15.0027 18.4026C15.0469 18.396 15.0795 18.3579 15.0794 18.3132L15.074 16.0106L15.4573 16.3438C15.4903 16.3725 15.5408 16.3668 15.5666 16.3314L16.0137 15.7194C16.038 15.6862 16.0324 15.6366 16.0011 15.6087V15.6087Z" fill="#FFAA66"/>
                                            <path d="M12.9243 20.3039C13.5523 20.3039 14.0615 19.7948 14.0615 19.1667C14.0615 18.5387 13.5523 18.0295 12.9243 18.0295C12.2962 18.0295 11.7871 18.5387 11.7871 19.1667C11.7871 19.7948 12.2962 20.3039 12.9243 20.3039Z" fill="#FF6C6C"/>
                                            <path d="M12.7735 19.6973C12.7114 19.6973 12.6518 19.6726 12.6078 19.6287L12.3171 19.3379C12.2255 19.2464 12.2255 19.098 12.3171 19.0065C12.4086 18.915 12.5571 18.915 12.6485 19.0065L12.7735 19.1315L13.2002 18.7049C13.2917 18.6134 13.4402 18.6134 13.5316 18.7049C13.6232 18.7964 13.6232 18.9448 13.5316 19.0363L12.9392 19.6287C12.8953 19.6726 12.8357 19.6973 12.7735 19.6973V19.6973Z" fill="white"/>
                                            <path d="M14.3828 16.2914C14.2533 16.2914 14.1484 16.1864 14.1484 16.057V15.9878C14.1484 15.8584 14.2533 15.7534 14.3828 15.7534C14.5123 15.7534 14.6172 15.8584 14.6172 15.9878V16.057C14.6172 16.1864 14.5122 16.2914 14.3828 16.2914Z" fill="#FFD5BA"/>
                                            <path d="M13.0091 8.50233C12.7502 8.50233 12.5404 8.29243 12.5404 8.03358V4.51604C12.5404 3.36872 11.607 2.4353 10.4596 2.4353C9.31233 2.4353 8.37891 3.36872 8.37891 4.51604V8.03358C8.37891 8.29243 8.16905 8.50233 7.91016 8.50233C7.65127 8.50233 7.44141 8.29243 7.44141 8.03358V4.51604C7.44141 2.85179 8.79539 1.4978 10.4596 1.4978C12.1239 1.4978 13.4779 2.85179 13.4779 4.51604V8.03358C13.4779 8.29248 13.268 8.50233 13.0091 8.50233Z" fill="#FFD5BA"/>
                                            <path d="M8.8133 19.1614H6.17639C6.04697 19.1614 5.94202 19.0564 5.94202 18.927C5.94202 18.7976 6.04697 18.6926 6.17639 18.6926H8.8133C8.94272 18.6926 9.04767 18.7976 9.04767 18.927C9.04767 19.0564 8.94272 19.1614 8.8133 19.1614Z" fill="#FFD5BA"/>
                                            <path d="M8.86591 18.2642H6.229C6.09958 18.2642 5.99463 18.1592 5.99463 18.0298C5.99463 17.9004 6.09958 17.7954 6.229 17.7954H8.86591C8.99533 17.7954 9.10028 17.9004 9.10028 18.0298C9.10028 18.1592 8.99533 18.2642 8.86591 18.2642Z" fill="#FFD5BA"/>
                                            <path d="M7.0261 17.3667H6.28149C6.15207 17.3667 6.04712 17.2617 6.04712 17.1323C6.04712 17.0029 6.15207 16.8979 6.28149 16.8979H7.0261C7.15553 16.8979 7.26048 17.0029 7.26048 17.1323C7.26048 17.2617 7.15553 17.3667 7.0261 17.3667Z" fill="#FFD5BA"/>
                                            <path d="M16.525 5.72504C15.5939 5.5028 14.5715 5.31202 13.478 5.15696V4.51604C13.478 2.85179 12.124 1.4978 10.4597 1.4978C10.128 1.4978 9.80901 1.55237 9.51023 1.65169C9.21145 1.55237 8.89242 1.4978 8.56073 1.4978C6.89648 1.4978 5.5425 2.85179 5.5425 4.51604V7.05976H3.82584C3.70307 7.05976 3.60112 7.15449 3.59212 7.27693L2.64347 20.1568C2.63348 20.2927 2.74097 20.4084 2.87723 20.4084H10.6739V21.4929C10.6739 21.6995 10.8509 21.8623 11.0567 21.8444C12.9958 21.6755 14.7836 21.2871 16.3415 20.7701C16.4859 20.7222 16.5833 20.5874 16.5833 20.4353V13.2006C16.5833 12.9764 16.377 12.809 16.1578 12.8558C16.0543 12.878 15.9496 12.8997 15.8441 12.9211L15.5559 9.00638C15.852 9.09694 16.1408 9.19538 16.4214 9.30165C16.5367 9.34533 16.6598 9.2603 16.6598 9.13702V5.89646C16.6598 5.81504 16.6042 5.74397 16.525 5.72504V5.72504ZM7.4415 7.05976H6.48V4.51604C6.48 3.47265 7.25207 2.6064 8.25487 2.45799C7.75087 2.99757 7.4415 3.72118 7.4415 4.51604V7.05976ZM8.379 4.51604C8.379 3.71068 8.83926 3.01126 9.51023 2.66555C10.1812 3.01126 10.6415 3.71068 10.6415 4.51604V7.05976H8.379V4.51604ZM12.5405 7.05976H11.579V4.51604C11.579 3.72118 11.2696 2.99757 10.7656 2.45799C11.7684 2.6064 12.5405 3.47265 12.5405 4.51604V7.05976Z" fill="url(#paint2_linear_4516_5327)"/>
                                            <path d="M2.97083 3.40723H2.50208C2.24361 3.40723 2.03333 3.19695 2.03333 2.93848V2.46973C2.03333 2.21126 2.24361 2.00098 2.50208 2.00098H2.97083C3.22929 2.00098 3.43958 2.21126 3.43958 2.46973V2.93848C3.43958 3.19695 3.22929 3.40723 2.97083 3.40723V3.40723ZM2.50208 2.46973V2.93876L2.97083 2.93848V2.46973H2.50208Z" fill="#FF6C6C"/>
                                            <path d="M22.1149 20.8145H21.6461C21.3876 20.8145 21.1774 20.6042 21.1774 20.3457V19.877C21.1774 19.6185 21.3876 19.4082 21.6461 19.4082H22.1149C22.3733 19.4082 22.5836 19.6185 22.5836 19.877V20.3457C22.5836 20.6042 22.3733 20.8145 22.1149 20.8145ZM21.6461 19.877V20.346L22.1149 20.3457V19.877H21.6461Z" fill="#FF6C6C"/>
                                            <path d="M16.8109 4.39062H16.3422C16.0837 4.39062 15.8734 4.18034 15.8734 3.92188V3.45312C15.8734 3.19466 16.0837 2.98438 16.3422 2.98438H16.8109C17.0694 2.98438 17.2797 3.19466 17.2797 3.45312V3.92188C17.2797 4.18034 17.0694 4.39062 16.8109 4.39062ZM16.3422 3.45312V3.92216L16.8109 3.92188V3.45312H16.3422Z" fill="#6C6CFF"/>
                                            <path d="M3.7439 5.73242C3.6839 5.73242 3.62394 5.70955 3.57815 5.6638L3.50727 5.59292C3.37935 5.46495 3.17104 5.46495 3.04297 5.59292L2.9721 5.6638C2.88055 5.7553 2.73219 5.7553 2.64065 5.6638C2.5949 5.618 2.57202 5.55805 2.57202 5.49805C2.57202 5.43805 2.5949 5.37809 2.64065 5.3323L2.71152 5.26142C2.77354 5.19941 2.80771 5.11695 2.80771 5.0293C2.80771 4.94164 2.77354 4.85919 2.71157 4.79717L2.64065 4.7263C2.5949 4.6805 2.57202 4.62055 2.57202 4.56055C2.57202 4.50055 2.5949 4.44059 2.64065 4.3948C2.73219 4.3033 2.88055 4.3033 2.9721 4.3948L3.04297 4.46567C3.17094 4.59364 3.37926 4.59364 3.50722 4.46567L3.5781 4.3948C3.66965 4.3033 3.81801 4.3033 3.90955 4.3948C3.9553 4.44059 3.97818 4.50055 3.97818 4.56055C3.97818 4.62055 3.9553 4.6805 3.90955 4.7263L3.83868 4.79717C3.71066 4.92514 3.71066 5.13345 3.83868 5.26142L3.90955 5.3323C3.9553 5.37809 3.97818 5.43805 3.97818 5.49805C3.97818 5.55805 3.9553 5.618 3.90955 5.6638C3.86385 5.70955 3.8039 5.73242 3.7439 5.73242V5.73242Z" fill="#FF9C33"/>
                                            <path d="M9.3708 23.1479C9.3108 23.1479 9.25085 23.1251 9.20505 23.0793L9.13418 23.0084C9.00621 22.8805 8.7979 22.8805 8.66993 23.0084L8.59905 23.0793C8.50751 23.1708 8.35915 23.1708 8.2676 23.0793C8.22185 23.0335 8.19897 22.9736 8.19897 22.9136C8.19897 22.8536 8.22185 22.7936 8.2676 22.7478L8.33847 22.6769C8.46649 22.549 8.46649 22.3407 8.33847 22.2127L8.2676 22.1418C8.22185 22.096 8.19897 22.0361 8.19897 21.9761C8.19897 21.9161 8.22185 21.8561 8.2676 21.8103C8.35915 21.7188 8.50751 21.7188 8.59905 21.8103L8.66993 21.8812C8.79785 22.0092 9.00616 22.0092 9.13422 21.8812L9.2051 21.8103C9.29665 21.7188 9.44501 21.7188 9.53655 21.8103C9.5823 21.8561 9.60518 21.9161 9.60518 21.9761C9.60518 22.0361 9.5823 22.096 9.53655 22.1418L9.46568 22.2127C9.40366 22.2747 9.36949 22.3572 9.36949 22.4448C9.36949 22.5325 9.40366 22.6149 9.46563 22.6769L9.53655 22.7478C9.5823 22.7936 9.60518 22.8536 9.60518 22.9136C9.60518 22.9736 9.5823 23.0335 9.53655 23.0793C9.49076 23.125 9.4308 23.1479 9.3708 23.1479Z" fill="#FF9C33"/>
                                         
                                        </svg>
                                            
                                              
                                    </div>
                                    <div class="content-right">
                                        <div class="title">
                                            <h3 class="fw_4 secondary_color">Shopping</h3>
                                            <span class="secondary_color fw_4">25 Min Ago</span>
                                        </div>
                                        <div class="desc">
                                            <p class="secondary_color fw_4">Alipay gives you 20% offcoupon for all bills, applicable for bills paid through Alipay wallet!</p>
                                        </div>
                                    </div>
                                </div>
                                <div class="noti-list">
                                    <div class="icon-box bg_service-3">
                                        <svg width="16" height="16" viewBox="0 0 25 24" fill="none" xmlns="http://www.w3.org/2000/svg">
                                            <path d="M24.2838 7.48567C22.5636 -5.34697 15.3153 2.01241 6.99199 5.99402C4.62414 7.12675 1.38339 7.13603 0.529097 10.1115C-0.458746 13.5521 2.49213 15.7224 4.86696 17.5562C7.726 19.7638 7.32082 24.1061 11.9929 23.7198C12.874 23.647 13.9302 23.7352 14.4994 23.0587C16.8551 20.2588 17.5094 16.0487 20.5731 13.8156C22.7339 12.2406 24.6702 10.3686 24.2838 7.48567V7.48567Z" fill="url(#paint0_linear_4516_5327)"/>
                                            <path d="M11.1101 8.50233C10.8512 8.50233 10.6413 8.29243 10.6413 8.03358V4.51604C10.6413 3.36872 9.70791 2.4353 8.56059 2.4353C7.41328 2.4353 6.47986 3.36872 6.47986 4.51604V8.03358C6.47986 8.29243 6.27 8.50233 6.01111 8.50233C5.75222 8.50233 5.54236 8.29243 5.54236 8.03358V4.51604C5.54236 2.85179 6.89634 1.4978 8.56059 1.4978C10.2248 1.4978 11.5788 2.85179 11.5788 4.51604V8.03358C11.5788 8.29248 11.369 8.50233 11.1101 8.50233V8.50233Z" fill="#FFC498"/>
                                            <path d="M4.77612 20.4084H2.87707C2.74085 20.4084 2.63332 20.2927 2.64335 20.1568L3.59196 7.27699C3.60096 7.15455 3.70296 7.05981 3.82568 7.05981H5.72482L4.77612 20.4084Z" fill="#FF7300"/>
                                            <path d="M10.2019 1.98511C9.70002 2.02945 9.26681 2.20284 8.90198 2.46379C9.5587 2.57269 10.1121 2.99006 10.4085 3.56161C10.4256 3.56119 10.4425 3.56029 10.4596 3.56029C10.8392 3.56029 11.1951 3.663 11.5018 3.84131C11.3243 3.06712 10.8485 2.40586 10.2019 1.98511V1.98511Z" fill="#FFAA66"/>
                                            <path d="M13.3223 5.13473C14.475 5.29359 15.5495 5.49229 16.5249 5.72507C16.6042 5.74396 16.6598 5.81503 16.6598 5.8965V9.13706C16.6598 9.26034 16.5367 9.34537 16.4213 9.30168C15.46 8.93756 14.4044 8.66198 13.2743 8.50078C13.1872 8.48836 13.1222 8.41434 13.1222 8.3264V5.30939C13.1222 5.2027 13.2166 5.12015 13.3223 5.13473V5.13473Z" fill="#9393FF"/>
                                            <path d="M19.934 11.522C19.3646 10.9961 18.6909 10.5108 17.9281 10.086C17.8721 10.0548 17.837 9.99604 17.837 9.93201V6.37448C17.837 6.25486 17.9539 6.16978 18.0677 6.20672C20.528 7.0057 22.0239 8.06062 22.0239 9.21736L21.8832 11.1587L19.934 11.522Z" fill="#9393FF"/>
                                            <path d="M22.0238 13.3463L21.8386 14.0752L22.0238 14.2763V14.5922L21.9179 15.2644L22.0238 15.5222V16.0791C22.0238 17.1707 20.6922 18.5447 18.4754 19.6873C18.2885 19.7836 18.0657 19.6472 18.0657 19.4369V12.4824C18.0657 12.3314 18.1622 12.1974 18.3052 12.1486C20.6241 11.3602 22.0238 10.3364 22.0238 9.21753V13.3463Z" fill="#D8D8FF"/>
                                            <path d="M22.0238 14.592V15.522C21.4594 16.2172 20.5032 16.8463 19.4996 17.4355C19.4625 17.4575 19.4217 17.4678 19.3814 17.4678C19.3008 17.4678 19.2225 17.4266 19.1789 17.352C19.1133 17.2405 19.1508 17.0966 19.2624 17.0314C20.9536 16.0386 21.8133 15.2853 22.0238 14.592V14.592Z" fill="#9393FF"/>
                                            <path d="M22.0238 13.3462V14.2762C21.4589 14.9713 20.5032 15.6004 19.4996 16.1896C19.4625 16.2112 19.4217 16.2215 19.3814 16.2215C19.3008 16.2215 19.2225 16.1803 19.1789 16.1062C19.1133 15.9942 19.1508 15.8507 19.2624 15.7851C20.9536 14.7923 21.8133 14.0395 22.0238 13.3462Z" fill="#9393FF"/>
                                            <path d="M19.3813 15.2074C19.3025 15.2074 19.2256 15.1678 19.1813 15.0957C19.1136 14.9854 19.148 14.8411 19.2583 14.7734C19.5345 14.6037 19.7758 14.4484 19.996 14.2986C20.1032 14.2258 20.2489 14.2537 20.3216 14.3607C20.3944 14.4678 20.3666 14.6136 20.2596 14.6863C20.0333 14.8401 19.786 14.9993 19.5037 15.1727C19.4655 15.1962 19.4231 15.2074 19.3813 15.2074V15.2074Z" fill="#9393FF"/>
                                            <path d="M19.3812 13.4436C19.2918 13.4436 19.2064 13.3922 19.1674 13.3054C19.1142 13.1874 19.1668 13.0486 19.2848 12.9955C19.6547 12.8289 19.9883 12.6536 20.2766 12.4743C20.3866 12.406 20.5311 12.4397 20.5994 12.5495C20.6677 12.6595 20.634 12.804 20.5242 12.8724C20.2183 13.0626 19.8661 13.2478 19.4773 13.4229C19.4461 13.4369 19.4134 13.4436 19.3812 13.4436V13.4436Z" fill="#FF9393"/>
                                            <path d="M18.0681 6.20699C17.9542 6.17001 17.837 6.2549 17.837 6.37462V9.93215C17.837 9.99623 17.8721 10.055 17.9281 10.0862C18.6779 10.5038 19.3408 10.9801 19.904 11.4957C19.4371 11.7274 18.9017 11.946 18.3048 12.149C18.1621 12.1976 18.0658 12.3317 18.0658 12.4826V19.437C18.0658 19.6473 18.2886 19.7838 18.4756 19.6874C20.6923 18.5446 22.0239 17.1709 22.0239 16.0793V9.21749C22.0239 8.0608 20.5282 7.00593 18.0681 6.20699Z" fill="url(#paint1_linear_4516_5327)"/>
                                            <path d="M16.1433 20.4084H4.77616C4.63975 20.4084 4.53241 20.2926 4.54225 20.1567L5.491 7.27685C5.49991 7.1545 5.6021 7.05981 5.72491 7.05981H15.1946C15.3174 7.05981 15.4191 7.1545 15.4285 7.27685L16.3768 20.1567C16.3871 20.2926 16.2793 20.4084 16.1433 20.4084Z" fill="#FFAA66"/>
                                            <path d="M11.0447 10.5326C10.9228 10.6545 10.7608 10.7216 10.5884 10.7216C10.4161 10.7216 10.2541 10.6545 10.1322 10.5326C10.0104 10.4107 9.94324 10.2487 9.94324 10.0763C9.94324 9.90399 10.0104 9.74199 10.1322 9.62011C10.3838 9.36849 10.7932 9.36854 11.0447 9.62011L11.2104 9.78586L11.5419 9.45441L11.3761 9.28866C11.2188 9.13135 11.0257 9.03188 10.8228 8.98847V8.53955H10.3541V8.98852C10.1512 9.03188 9.95805 9.13139 9.80074 9.28866C9.59036 9.49908 9.47449 9.77883 9.47449 10.0763C9.47449 10.3739 9.59036 10.6537 9.80074 10.864C9.95472 11.018 10.146 11.1211 10.3541 11.1655V11.6131H10.8228V11.1655C11.0309 11.1211 11.2221 11.018 11.3761 10.864L11.5419 10.6983L11.2104 10.3668L11.0447 10.5326Z" fill="white"/>
                                            <path d="M7.44153 7.05981H8.37903V8.87763C8.37903 9.13638 8.16903 9.34638 7.91028 9.34638C7.65153 9.34638 7.44153 9.13638 7.44153 8.87763V7.05981Z" fill="#FF9C33"/>
                                            <path d="M13.4781 7.05981V8.87763C13.4781 9.13638 13.2681 9.34638 13.0094 9.34638C12.7502 9.34638 12.5406 9.13638 12.5406 8.87763V7.05981H13.4781Z" fill="#FF9C33"/>
                                            <path d="M10.9984 13.5775C12.884 13.4304 14.6278 13.183 16.1577 12.8558C16.3769 12.8089 16.5833 12.9764 16.5833 13.2005V20.4353C16.5833 20.5874 16.4858 20.7222 16.3414 20.7701C14.7835 21.2871 12.9957 21.6755 11.0566 21.8444C10.8508 21.8623 10.6738 21.6995 10.6738 21.4929V13.9288C10.6738 13.745 10.8151 13.5918 10.9984 13.5775V13.5775Z" fill="#D8D8FF"/>
                                            <path d="M15.4929 20.1811C15.3913 20.1811 15.2977 20.1146 15.2679 20.0122C15.2318 19.8879 15.3032 19.7578 15.4274 19.7216C15.4987 19.7009 15.5694 19.6798 15.6398 19.6586C15.7636 19.621 15.8946 19.6911 15.9321 19.815C15.9696 19.9389 15.8995 20.0697 15.7756 20.1072C15.7036 20.129 15.6313 20.1505 15.5584 20.1717C15.5366 20.1781 15.5146 20.1811 15.4929 20.1811V20.1811Z" fill="#8282FF"/>
                                            <path d="M15.4929 19.4651C15.3913 19.4651 15.2977 19.3986 15.2679 19.2961C15.2318 19.1719 15.3032 19.0418 15.4274 19.0056C15.4987 18.9848 15.5694 18.9638 15.6398 18.9425C15.7636 18.9049 15.8946 18.9751 15.9321 19.0989C15.9696 19.2228 15.8995 19.3537 15.7756 19.3912C15.7036 19.413 15.6313 19.4344 15.5584 19.4556C15.5366 19.462 15.5146 19.4651 15.4929 19.4651V19.4651Z" fill="#8282FF"/>
                                            <path d="M16.0011 15.6087L14.8434 14.5739C14.8277 14.5598 14.8076 14.5527 14.7878 14.5541L14.2639 14.5906C14.2315 14.5929 14.2048 14.6166 14.1978 14.6498C14.1563 14.846 13.9983 14.997 13.7931 15.013C13.586 15.0292 13.3922 14.9033 13.3049 14.713C13.29 14.6807 13.2572 14.6607 13.2233 14.6631L12.6622 14.7021C12.6407 14.7036 12.6207 14.714 12.6071 14.7308L11.5495 16.0345C11.5196 16.0715 11.5257 16.1262 11.5632 16.1566L12.2405 16.7049C12.2768 16.7343 12.3301 16.7283 12.359 16.6915L12.7033 16.2534L12.643 18.6497C12.6416 18.7057 12.6911 18.7494 12.7465 18.7411L15.0027 18.4026C15.0469 18.396 15.0795 18.3579 15.0794 18.3132L15.074 16.0106L15.4573 16.3438C15.4903 16.3725 15.5408 16.3668 15.5666 16.3314L16.0137 15.7194C16.038 15.6862 16.0324 15.6366 16.0011 15.6087V15.6087Z" fill="#FFAA66"/>
                                            <path d="M12.9243 20.3039C13.5523 20.3039 14.0615 19.7948 14.0615 19.1667C14.0615 18.5387 13.5523 18.0295 12.9243 18.0295C12.2962 18.0295 11.7871 18.5387 11.7871 19.1667C11.7871 19.7948 12.2962 20.3039 12.9243 20.3039Z" fill="#FF6C6C"/>
                                            <path d="M12.7735 19.6973C12.7114 19.6973 12.6518 19.6726 12.6078 19.6287L12.3171 19.3379C12.2255 19.2464 12.2255 19.098 12.3171 19.0065C12.4086 18.915 12.5571 18.915 12.6485 19.0065L12.7735 19.1315L13.2002 18.7049C13.2917 18.6134 13.4402 18.6134 13.5316 18.7049C13.6232 18.7964 13.6232 18.9448 13.5316 19.0363L12.9392 19.6287C12.8953 19.6726 12.8357 19.6973 12.7735 19.6973V19.6973Z" fill="white"/>
                                            <path d="M14.3828 16.2914C14.2533 16.2914 14.1484 16.1864 14.1484 16.057V15.9878C14.1484 15.8584 14.2533 15.7534 14.3828 15.7534C14.5123 15.7534 14.6172 15.8584 14.6172 15.9878V16.057C14.6172 16.1864 14.5122 16.2914 14.3828 16.2914Z" fill="#FFD5BA"/>
                                            <path d="M13.0091 8.50233C12.7502 8.50233 12.5404 8.29243 12.5404 8.03358V4.51604C12.5404 3.36872 11.607 2.4353 10.4596 2.4353C9.31233 2.4353 8.37891 3.36872 8.37891 4.51604V8.03358C8.37891 8.29243 8.16905 8.50233 7.91016 8.50233C7.65127 8.50233 7.44141 8.29243 7.44141 8.03358V4.51604C7.44141 2.85179 8.79539 1.4978 10.4596 1.4978C12.1239 1.4978 13.4779 2.85179 13.4779 4.51604V8.03358C13.4779 8.29248 13.268 8.50233 13.0091 8.50233Z" fill="#FFD5BA"/>
                                            <path d="M8.8133 19.1614H6.17639C6.04697 19.1614 5.94202 19.0564 5.94202 18.927C5.94202 18.7976 6.04697 18.6926 6.17639 18.6926H8.8133C8.94272 18.6926 9.04767 18.7976 9.04767 18.927C9.04767 19.0564 8.94272 19.1614 8.8133 19.1614Z" fill="#FFD5BA"/>
                                            <path d="M8.86591 18.2642H6.229C6.09958 18.2642 5.99463 18.1592 5.99463 18.0298C5.99463 17.9004 6.09958 17.7954 6.229 17.7954H8.86591C8.99533 17.7954 9.10028 17.9004 9.10028 18.0298C9.10028 18.1592 8.99533 18.2642 8.86591 18.2642Z" fill="#FFD5BA"/>
                                            <path d="M7.0261 17.3667H6.28149C6.15207 17.3667 6.04712 17.2617 6.04712 17.1323C6.04712 17.0029 6.15207 16.8979 6.28149 16.8979H7.0261C7.15553 16.8979 7.26048 17.0029 7.26048 17.1323C7.26048 17.2617 7.15553 17.3667 7.0261 17.3667Z" fill="#FFD5BA"/>
                                            <path d="M16.525 5.72504C15.5939 5.5028 14.5715 5.31202 13.478 5.15696V4.51604C13.478 2.85179 12.124 1.4978 10.4597 1.4978C10.128 1.4978 9.80901 1.55237 9.51023 1.65169C9.21145 1.55237 8.89242 1.4978 8.56073 1.4978C6.89648 1.4978 5.5425 2.85179 5.5425 4.51604V7.05976H3.82584C3.70307 7.05976 3.60112 7.15449 3.59212 7.27693L2.64347 20.1568C2.63348 20.2927 2.74097 20.4084 2.87723 20.4084H10.6739V21.4929C10.6739 21.6995 10.8509 21.8623 11.0567 21.8444C12.9958 21.6755 14.7836 21.2871 16.3415 20.7701C16.4859 20.7222 16.5833 20.5874 16.5833 20.4353V13.2006C16.5833 12.9764 16.377 12.809 16.1578 12.8558C16.0543 12.878 15.9496 12.8997 15.8441 12.9211L15.5559 9.00638C15.852 9.09694 16.1408 9.19538 16.4214 9.30165C16.5367 9.34533 16.6598 9.2603 16.6598 9.13702V5.89646C16.6598 5.81504 16.6042 5.74397 16.525 5.72504V5.72504ZM7.4415 7.05976H6.48V4.51604C6.48 3.47265 7.25207 2.6064 8.25487 2.45799C7.75087 2.99757 7.4415 3.72118 7.4415 4.51604V7.05976ZM8.379 4.51604C8.379 3.71068 8.83926 3.01126 9.51023 2.66555C10.1812 3.01126 10.6415 3.71068 10.6415 4.51604V7.05976H8.379V4.51604ZM12.5405 7.05976H11.579V4.51604C11.579 3.72118 11.2696 2.99757 10.7656 2.45799C11.7684 2.6064 12.5405 3.47265 12.5405 4.51604V7.05976Z" fill="url(#paint2_linear_4516_5327)"/>
                                            <path d="M2.97083 3.40723H2.50208C2.24361 3.40723 2.03333 3.19695 2.03333 2.93848V2.46973C2.03333 2.21126 2.24361 2.00098 2.50208 2.00098H2.97083C3.22929 2.00098 3.43958 2.21126 3.43958 2.46973V2.93848C3.43958 3.19695 3.22929 3.40723 2.97083 3.40723V3.40723ZM2.50208 2.46973V2.93876L2.97083 2.93848V2.46973H2.50208Z" fill="#FF6C6C"/>
                                            <path d="M22.1149 20.8145H21.6461C21.3876 20.8145 21.1774 20.6042 21.1774 20.3457V19.877C21.1774 19.6185 21.3876 19.4082 21.6461 19.4082H22.1149C22.3733 19.4082 22.5836 19.6185 22.5836 19.877V20.3457C22.5836 20.6042 22.3733 20.8145 22.1149 20.8145ZM21.6461 19.877V20.346L22.1149 20.3457V19.877H21.6461Z" fill="#FF6C6C"/>
                                            <path d="M16.8109 4.39062H16.3422C16.0837 4.39062 15.8734 4.18034 15.8734 3.92188V3.45312C15.8734 3.19466 16.0837 2.98438 16.3422 2.98438H16.8109C17.0694 2.98438 17.2797 3.19466 17.2797 3.45312V3.92188C17.2797 4.18034 17.0694 4.39062 16.8109 4.39062ZM16.3422 3.45312V3.92216L16.8109 3.92188V3.45312H16.3422Z" fill="#6C6CFF"/>
                                            <path d="M3.7439 5.73242C3.6839 5.73242 3.62394 5.70955 3.57815 5.6638L3.50727 5.59292C3.37935 5.46495 3.17104 5.46495 3.04297 5.59292L2.9721 5.6638C2.88055 5.7553 2.73219 5.7553 2.64065 5.6638C2.5949 5.618 2.57202 5.55805 2.57202 5.49805C2.57202 5.43805 2.5949 5.37809 2.64065 5.3323L2.71152 5.26142C2.77354 5.19941 2.80771 5.11695 2.80771 5.0293C2.80771 4.94164 2.77354 4.85919 2.71157 4.79717L2.64065 4.7263C2.5949 4.6805 2.57202 4.62055 2.57202 4.56055C2.57202 4.50055 2.5949 4.44059 2.64065 4.3948C2.73219 4.3033 2.88055 4.3033 2.9721 4.3948L3.04297 4.46567C3.17094 4.59364 3.37926 4.59364 3.50722 4.46567L3.5781 4.3948C3.66965 4.3033 3.81801 4.3033 3.90955 4.3948C3.9553 4.44059 3.97818 4.50055 3.97818 4.56055C3.97818 4.62055 3.9553 4.6805 3.90955 4.7263L3.83868 4.79717C3.71066 4.92514 3.71066 5.13345 3.83868 5.26142L3.90955 5.3323C3.9553 5.37809 3.97818 5.43805 3.97818 5.49805C3.97818 5.55805 3.9553 5.618 3.90955 5.6638C3.86385 5.70955 3.8039 5.73242 3.7439 5.73242V5.73242Z" fill="#FF9C33"/>
                                            <path d="M9.3708 23.1479C9.3108 23.1479 9.25085 23.1251 9.20505 23.0793L9.13418 23.0084C9.00621 22.8805 8.7979 22.8805 8.66993 23.0084L8.59905 23.0793C8.50751 23.1708 8.35915 23.1708 8.2676 23.0793C8.22185 23.0335 8.19897 22.9736 8.19897 22.9136C8.19897 22.8536 8.22185 22.7936 8.2676 22.7478L8.33847 22.6769C8.46649 22.549 8.46649 22.3407 8.33847 22.2127L8.2676 22.1418C8.22185 22.096 8.19897 22.0361 8.19897 21.9761C8.19897 21.9161 8.22185 21.8561 8.2676 21.8103C8.35915 21.7188 8.50751 21.7188 8.59905 21.8103L8.66993 21.8812C8.79785 22.0092 9.00616 22.0092 9.13422 21.8812L9.2051 21.8103C9.29665 21.7188 9.44501 21.7188 9.53655 21.8103C9.5823 21.8561 9.60518 21.9161 9.60518 21.9761C9.60518 22.0361 9.5823 22.096 9.53655 22.1418L9.46568 22.2127C9.40366 22.2747 9.36949 22.3572 9.36949 22.4448C9.36949 22.5325 9.40366 22.6149 9.46563 22.6769L9.53655 22.7478C9.5823 22.7936 9.60518 22.8536 9.60518 22.9136C9.60518 22.9736 9.5823 23.0335 9.53655 23.0793C9.49076 23.125 9.4308 23.1479 9.3708 23.1479Z" fill="#FF9C33"/>
                                         
                                        </svg>
                                            
                                              
                                    </div>
                                    <div class="content-right">
                                        <div class="title">
                                            <h3 class="fw_6">Shopping</h3>
                                            <span class="fw_6 on_surface_color">1 Hour  Ago</span>
                                        </div>
                                        <div class="desc">
                                            <p class="on_surface_color fw_4">Alipay gives you 20% offcoupon for all bills, applicable for bills paid through Alipay wallet!</p>
                                            <i class="dot"></i>
                                        </div>
                                    </div>
                                </div>
                                <div class="noti-list">
                                    <div class="icon-box bg_service-7">
                                        <svg width="16" height="16" viewBox="0 0 25 22" fill="none" xmlns="http://www.w3.org/2000/svg">
                                            <path d="M5.10792 2.89151V3.71843H2.76196V2.89151C2.76196 2.64696 2.9602 2.44873 3.20474 2.44873H4.66513C4.90968 2.44873 5.10792 2.64696 5.10792 2.89151Z" fill="#6D6D6D"/>
                                            <path d="M21.9048 2.89151V3.71843H19.5588V2.89151C19.5588 2.64696 19.7571 2.44873 20.0016 2.44873H21.462C21.7066 2.44873 21.9048 2.64696 21.9048 2.89151Z" fill="#6D6D6D"/>
                                            <path d="M15.7525 5.0683H8.91426C8.63245 5.0683 8.40393 4.83978 8.40393 4.55797V1.85661C8.40393 1.15315 8.97632 0.580811 9.67973 0.580811H14.987C15.6905 0.580811 16.2628 1.1532 16.2628 1.85661V4.55797C16.2628 4.83978 16.0343 5.0683 15.7525 5.0683ZM9.42454 4.04764H15.2421V1.85661C15.2421 1.71584 15.1276 1.60147 14.987 1.60147H9.67973C9.53906 1.60147 9.42459 1.71584 9.42459 1.85661V4.04764H9.42454Z" fill="#6D6D6D"/>
                                            <path d="M5.39564 19.5364V20.9087C5.39564 21.1906 5.16718 21.4191 4.88532 21.4191H2.62739C2.34553 21.4191 2.11707 21.1906 2.11707 20.9087V19.5364H5.39564Z" fill="#EA4E4E"/>
                                            <path d="M22.5498 19.5364V20.9087C22.5498 21.1906 22.3213 21.4191 22.0395 21.4191H19.7816C19.4997 21.4191 19.2712 21.1906 19.2712 20.9087V19.5364H22.5498Z" fill="#EA4E4E"/>
                                            <path d="M24.326 4.50845V19.2502C24.326 19.8139 23.869 20.2709 23.3053 20.2709H1.36148C0.797805 20.2709 0.34082 19.8139 0.34082 19.2502V4.50845C0.34082 3.94478 0.797758 3.48779 1.36148 3.48779H23.3053C23.869 3.48779 24.326 3.94478 24.326 4.50845Z" fill="#F96464"/>
                                            <g opacity="0.4">
                                            <path d="M1.91377 7.6168C1.63191 7.6168 1.40344 7.38834 1.40344 7.10648V5.27498C1.40344 4.99312 1.63191 4.76465 1.91377 4.76465C2.19563 4.76465 2.4241 4.99312 2.4241 5.27498V7.10648C2.4241 7.38834 2.19563 7.6168 1.91377 7.6168Z" fill="white"/>
                                            </g>
                                            <g opacity="0.08">
                                            <path d="M24.326 4.50943V19.2501C24.326 19.814 23.8693 20.2707 23.3054 20.2707H21.5116C22.0755 20.2707 22.5323 19.814 22.5323 19.2501V4.50943C22.5323 3.94552 22.0755 3.48877 21.5116 3.48877H23.3054C23.8693 3.48877 24.326 3.94552 24.326 4.50943Z" fill="black"/>
                                            </g>
                                            <path d="M12.3335 17.3581C15.3597 17.3581 17.8129 14.9048 17.8129 11.8786C17.8129 8.8524 15.3597 6.39917 12.3335 6.39917C9.30724 6.39917 6.854 8.8524 6.854 11.8786C6.854 14.9048 9.30724 17.3581 12.3335 17.3581Z" fill="#F2F0F0"/>
                                            <path d="M16.0116 11.3237V12.4362C16.0116 12.718 15.7831 12.9465 15.5012 12.9465H13.3987V15.0464C13.3987 15.3283 13.1702 15.5568 12.8884 15.5568H11.7758C11.494 15.5568 11.2655 15.3283 11.2655 15.0464V12.9465H9.1656C8.88374 12.9465 8.65527 12.718 8.65527 12.4362V11.3237C8.65527 11.0418 8.88374 10.8133 9.1656 10.8133H11.2656V8.71077C11.2656 8.42891 11.494 8.20044 11.7759 8.20044H12.8884C13.1703 8.20044 13.3987 8.42891 13.3987 8.71077V10.8133H15.5013C15.7831 10.8133 16.0116 11.0418 16.0116 11.3237Z" fill="#F96464"/>
                                        </svg>
                                    </div>
                                    <div class="content-right">
                                        <div class="title">
                                            <h3 class="fw_4 secondary_color">Medical</h3>
                                            <span class="secondary_color fw_4">15 Hour Ago</span>
                                        </div>
                                        <div class="desc">
                                            <p class="secondary_color fw_4">Alipay gives you 20% offcoupon for all bills, applicable for bills paid through Alipay wallet!</p>
                                        </div>
                                    </div>
                                </div>
                                <div class="noti-list">
                                    <div class="icon-box bg_service-6">
                                        <svg width="16" height="16" viewBox="0 0 16 16" fill="none" xmlns="http://www.w3.org/2000/svg">
                                            <path d="M7.99995 14.7062C12.0609 14.7062 15.353 11.4141 15.353 7.35309C15.353 3.29209 12.0609 0 7.99995 0C3.93894 0 0.646851 3.29209 0.646851 7.35309C0.646851 11.4141 3.93894 14.7062 7.99995 14.7062Z" fill="#F7B239"/>
                                            <path d="M7.99997 12.1931C10.673 12.1931 12.8399 10.0261 12.8399 7.35312C12.8399 4.6801 10.673 2.51318 7.99997 2.51318C5.32695 2.51318 3.16003 4.6801 3.16003 7.35312C3.16003 10.0261 5.32695 12.1931 7.99997 12.1931Z" fill="#E09B2D"/>
                                            <path d="M14.6157 15.1809C14.6307 15.2373 14.638 15.294 14.638 15.3495C14.638 15.637 14.4463 15.8997 14.1558 15.9776C13.8089 16.0706 13.4521 15.8646 13.3591 15.5178L12.2661 11.4386C12.1731 11.0918 12.3791 10.7349 12.726 10.6419C13.0732 10.549 13.4297 10.755 13.5227 11.1022L14.6157 15.1809Z" fill="#F24C8F"/>
                                            <path d="M2.4596 11.5182L3.01855 11.668L4.49394 6.16149L3.93499 6.01173L2.4596 11.5182Z" fill="#CCCCCC"/>
                                            <path d="M11.6446 7.71971L12.4469 10.7156L13.0059 10.5659L12.2036 7.57L11.6446 7.71971Z" fill="#CCCCCC"/>
                                            <path d="M5.26403 2.1712C6.18881 2.41888 6.60972 3.8456 6.20463 5.3572C5.79953 6.86917 4.88478 7.28545 3.96 7.03776C3.03559 6.79007 2.4515 5.97217 2.85659 4.4602C3.26169 2.94823 4.33963 1.92351 5.26403 2.1712Z" fill="#E6E6E6"/>
                                            <path d="M2.9944 10.642C3.34162 10.7349 3.54727 11.0918 3.45427 11.4386L2.36168 15.5178C2.28374 15.8083 2.02099 16 1.73359 16C1.67802 16 1.6213 15.9927 1.56499 15.9776C1.21777 15.8847 1.01174 15.5278 1.10471 15.181L2.19771 11.1022C2.29068 10.755 2.64755 10.549 2.9944 10.642Z" fill="#F24C8F"/>
                                            <path d="M13.0658 6.02202L12.141 2.57046C12.1045 2.4344 11.9629 2.35446 11.8268 2.39515C11.6951 2.43455 11.6237 2.57771 11.6592 2.71046L12.3966 5.46168C12.4517 5.66743 12.3296 5.87893 12.1239 5.93408L12.1235 5.93415C11.9177 5.98937 11.7061 5.86721 11.651 5.66143L10.911 2.89987C10.8745 2.76371 10.7327 2.6838 10.5967 2.72458C10.465 2.76405 10.3937 2.90718 10.4293 3.0399L11.1666 5.79137C11.2217 5.99715 11.0996 6.20865 10.8938 6.26383C10.688 6.31896 10.4766 6.19687 10.4214 5.99108L9.68139 3.22937C9.64493 3.09324 9.5033 3.01337 9.36721 3.05405C9.23552 3.09346 9.16408 3.23658 9.19964 3.36933L10.1216 6.81049C10.2269 7.20383 10.479 7.53255 10.8316 7.73615C11.0665 7.87177 11.327 7.94102 11.5912 7.94102C11.7236 7.94102 11.857 7.92358 11.9883 7.8884C12.6534 7.71015 13.1178 7.10524 13.1178 6.4174C13.1178 6.28349 13.1003 6.15027 13.0658 6.02202Z" fill="#E6E6E6"/>
                                        </svg>
                                            
                                              
                                    </div>
                                    <div class="content-right">
                                        <div class="title">
                                            <h3 class="fw_4 secondary_color">Travel</h3>
                                            <span class="secondary_color fw_4">1 Day Ago</span>
                                        </div>
                                        <div class="desc">
                                            <p class="secondary_color fw_4">Alipay gives you 20% offcoupon for all bills, applicable for bills paid through Alipay wallet!</p>
                                        </div>
                                    </div>
                                </div>
                                <div class="noti-list">
                                    <div class="icon-box bg_service-3">
                                        <svg width="16" height="16" viewBox="0 0 25 24" fill="none" xmlns="http://www.w3.org/2000/svg">
                                            <path d="M24.2838 7.48567C22.5636 -5.34697 15.3153 2.01241 6.99199 5.99402C4.62414 7.12675 1.38339 7.13603 0.529097 10.1115C-0.458746 13.5521 2.49213 15.7224 4.86696 17.5562C7.726 19.7638 7.32082 24.1061 11.9929 23.7198C12.874 23.647 13.9302 23.7352 14.4994 23.0587C16.8551 20.2588 17.5094 16.0487 20.5731 13.8156C22.7339 12.2406 24.6702 10.3686 24.2838 7.48567V7.48567Z" fill="url(#paint0_linear_4516_5327)"/>
                                            <path d="M11.1101 8.50233C10.8512 8.50233 10.6413 8.29243 10.6413 8.03358V4.51604C10.6413 3.36872 9.70791 2.4353 8.56059 2.4353C7.41328 2.4353 6.47986 3.36872 6.47986 4.51604V8.03358C6.47986 8.29243 6.27 8.50233 6.01111 8.50233C5.75222 8.50233 5.54236 8.29243 5.54236 8.03358V4.51604C5.54236 2.85179 6.89634 1.4978 8.56059 1.4978C10.2248 1.4978 11.5788 2.85179 11.5788 4.51604V8.03358C11.5788 8.29248 11.369 8.50233 11.1101 8.50233V8.50233Z" fill="#FFC498"/>
                                            <path d="M4.77612 20.4084H2.87707C2.74085 20.4084 2.63332 20.2927 2.64335 20.1568L3.59196 7.27699C3.60096 7.15455 3.70296 7.05981 3.82568 7.05981H5.72482L4.77612 20.4084Z" fill="#FF7300"/>
                                            <path d="M10.2019 1.98511C9.70002 2.02945 9.26681 2.20284 8.90198 2.46379C9.5587 2.57269 10.1121 2.99006 10.4085 3.56161C10.4256 3.56119 10.4425 3.56029 10.4596 3.56029C10.8392 3.56029 11.1951 3.663 11.5018 3.84131C11.3243 3.06712 10.8485 2.40586 10.2019 1.98511V1.98511Z" fill="#FFAA66"/>
                                            <path d="M13.3223 5.13473C14.475 5.29359 15.5495 5.49229 16.5249 5.72507C16.6042 5.74396 16.6598 5.81503 16.6598 5.8965V9.13706C16.6598 9.26034 16.5367 9.34537 16.4213 9.30168C15.46 8.93756 14.4044 8.66198 13.2743 8.50078C13.1872 8.48836 13.1222 8.41434 13.1222 8.3264V5.30939C13.1222 5.2027 13.2166 5.12015 13.3223 5.13473V5.13473Z" fill="#9393FF"/>
                                            <path d="M19.934 11.522C19.3646 10.9961 18.6909 10.5108 17.9281 10.086C17.8721 10.0548 17.837 9.99604 17.837 9.93201V6.37448C17.837 6.25486 17.9539 6.16978 18.0677 6.20672C20.528 7.0057 22.0239 8.06062 22.0239 9.21736L21.8832 11.1587L19.934 11.522Z" fill="#9393FF"/>
                                            <path d="M22.0238 13.3463L21.8386 14.0752L22.0238 14.2763V14.5922L21.9179 15.2644L22.0238 15.5222V16.0791C22.0238 17.1707 20.6922 18.5447 18.4754 19.6873C18.2885 19.7836 18.0657 19.6472 18.0657 19.4369V12.4824C18.0657 12.3314 18.1622 12.1974 18.3052 12.1486C20.6241 11.3602 22.0238 10.3364 22.0238 9.21753V13.3463Z" fill="#D8D8FF"/>
                                            <path d="M22.0238 14.592V15.522C21.4594 16.2172 20.5032 16.8463 19.4996 17.4355C19.4625 17.4575 19.4217 17.4678 19.3814 17.4678C19.3008 17.4678 19.2225 17.4266 19.1789 17.352C19.1133 17.2405 19.1508 17.0966 19.2624 17.0314C20.9536 16.0386 21.8133 15.2853 22.0238 14.592V14.592Z" fill="#9393FF"/>
                                            <path d="M22.0238 13.3462V14.2762C21.4589 14.9713 20.5032 15.6004 19.4996 16.1896C19.4625 16.2112 19.4217 16.2215 19.3814 16.2215C19.3008 16.2215 19.2225 16.1803 19.1789 16.1062C19.1133 15.9942 19.1508 15.8507 19.2624 15.7851C20.9536 14.7923 21.8133 14.0395 22.0238 13.3462Z" fill="#9393FF"/>
                                            <path d="M19.3813 15.2074C19.3025 15.2074 19.2256 15.1678 19.1813 15.0957C19.1136 14.9854 19.148 14.8411 19.2583 14.7734C19.5345 14.6037 19.7758 14.4484 19.996 14.2986C20.1032 14.2258 20.2489 14.2537 20.3216 14.3607C20.3944 14.4678 20.3666 14.6136 20.2596 14.6863C20.0333 14.8401 19.786 14.9993 19.5037 15.1727C19.4655 15.1962 19.4231 15.2074 19.3813 15.2074V15.2074Z" fill="#9393FF"/>
                                            <path d="M19.3812 13.4436C19.2918 13.4436 19.2064 13.3922 19.1674 13.3054C19.1142 13.1874 19.1668 13.0486 19.2848 12.9955C19.6547 12.8289 19.9883 12.6536 20.2766 12.4743C20.3866 12.406 20.5311 12.4397 20.5994 12.5495C20.6677 12.6595 20.634 12.804 20.5242 12.8724C20.2183 13.0626 19.8661 13.2478 19.4773 13.4229C19.4461 13.4369 19.4134 13.4436 19.3812 13.4436V13.4436Z" fill="#FF9393"/>
                                            <path d="M18.0681 6.20699C17.9542 6.17001 17.837 6.2549 17.837 6.37462V9.93215C17.837 9.99623 17.8721 10.055 17.9281 10.0862C18.6779 10.5038 19.3408 10.9801 19.904 11.4957C19.4371 11.7274 18.9017 11.946 18.3048 12.149C18.1621 12.1976 18.0658 12.3317 18.0658 12.4826V19.437C18.0658 19.6473 18.2886 19.7838 18.4756 19.6874C20.6923 18.5446 22.0239 17.1709 22.0239 16.0793V9.21749C22.0239 8.0608 20.5282 7.00593 18.0681 6.20699Z" fill="url(#paint1_linear_4516_5327)"/>
                                            <path d="M16.1433 20.4084H4.77616C4.63975 20.4084 4.53241 20.2926 4.54225 20.1567L5.491 7.27685C5.49991 7.1545 5.6021 7.05981 5.72491 7.05981H15.1946C15.3174 7.05981 15.4191 7.1545 15.4285 7.27685L16.3768 20.1567C16.3871 20.2926 16.2793 20.4084 16.1433 20.4084Z" fill="#FFAA66"/>
                                            <path d="M11.0447 10.5326C10.9228 10.6545 10.7608 10.7216 10.5884 10.7216C10.4161 10.7216 10.2541 10.6545 10.1322 10.5326C10.0104 10.4107 9.94324 10.2487 9.94324 10.0763C9.94324 9.90399 10.0104 9.74199 10.1322 9.62011C10.3838 9.36849 10.7932 9.36854 11.0447 9.62011L11.2104 9.78586L11.5419 9.45441L11.3761 9.28866C11.2188 9.13135 11.0257 9.03188 10.8228 8.98847V8.53955H10.3541V8.98852C10.1512 9.03188 9.95805 9.13139 9.80074 9.28866C9.59036 9.49908 9.47449 9.77883 9.47449 10.0763C9.47449 10.3739 9.59036 10.6537 9.80074 10.864C9.95472 11.018 10.146 11.1211 10.3541 11.1655V11.6131H10.8228V11.1655C11.0309 11.1211 11.2221 11.018 11.3761 10.864L11.5419 10.6983L11.2104 10.3668L11.0447 10.5326Z" fill="white"/>
                                            <path d="M7.44153 7.05981H8.37903V8.87763C8.37903 9.13638 8.16903 9.34638 7.91028 9.34638C7.65153 9.34638 7.44153 9.13638 7.44153 8.87763V7.05981Z" fill="#FF9C33"/>
                                            <path d="M13.4781 7.05981V8.87763C13.4781 9.13638 13.2681 9.34638 13.0094 9.34638C12.7502 9.34638 12.5406 9.13638 12.5406 8.87763V7.05981H13.4781Z" fill="#FF9C33"/>
                                            <path d="M10.9984 13.5775C12.884 13.4304 14.6278 13.183 16.1577 12.8558C16.3769 12.8089 16.5833 12.9764 16.5833 13.2005V20.4353C16.5833 20.5874 16.4858 20.7222 16.3414 20.7701C14.7835 21.2871 12.9957 21.6755 11.0566 21.8444C10.8508 21.8623 10.6738 21.6995 10.6738 21.4929V13.9288C10.6738 13.745 10.8151 13.5918 10.9984 13.5775V13.5775Z" fill="#D8D8FF"/>
                                            <path d="M15.4929 20.1811C15.3913 20.1811 15.2977 20.1146 15.2679 20.0122C15.2318 19.8879 15.3032 19.7578 15.4274 19.7216C15.4987 19.7009 15.5694 19.6798 15.6398 19.6586C15.7636 19.621 15.8946 19.6911 15.9321 19.815C15.9696 19.9389 15.8995 20.0697 15.7756 20.1072C15.7036 20.129 15.6313 20.1505 15.5584 20.1717C15.5366 20.1781 15.5146 20.1811 15.4929 20.1811V20.1811Z" fill="#8282FF"/>
                                            <path d="M15.4929 19.4651C15.3913 19.4651 15.2977 19.3986 15.2679 19.2961C15.2318 19.1719 15.3032 19.0418 15.4274 19.0056C15.4987 18.9848 15.5694 18.9638 15.6398 18.9425C15.7636 18.9049 15.8946 18.9751 15.9321 19.0989C15.9696 19.2228 15.8995 19.3537 15.7756 19.3912C15.7036 19.413 15.6313 19.4344 15.5584 19.4556C15.5366 19.462 15.5146 19.4651 15.4929 19.4651V19.4651Z" fill="#8282FF"/>
                                            <path d="M16.0011 15.6087L14.8434 14.5739C14.8277 14.5598 14.8076 14.5527 14.7878 14.5541L14.2639 14.5906C14.2315 14.5929 14.2048 14.6166 14.1978 14.6498C14.1563 14.846 13.9983 14.997 13.7931 15.013C13.586 15.0292 13.3922 14.9033 13.3049 14.713C13.29 14.6807 13.2572 14.6607 13.2233 14.6631L12.6622 14.7021C12.6407 14.7036 12.6207 14.714 12.6071 14.7308L11.5495 16.0345C11.5196 16.0715 11.5257 16.1262 11.5632 16.1566L12.2405 16.7049C12.2768 16.7343 12.3301 16.7283 12.359 16.6915L12.7033 16.2534L12.643 18.6497C12.6416 18.7057 12.6911 18.7494 12.7465 18.7411L15.0027 18.4026C15.0469 18.396 15.0795 18.3579 15.0794 18.3132L15.074 16.0106L15.4573 16.3438C15.4903 16.3725 15.5408 16.3668 15.5666 16.3314L16.0137 15.7194C16.038 15.6862 16.0324 15.6366 16.0011 15.6087V15.6087Z" fill="#FFAA66"/>
                                            <path d="M12.9243 20.3039C13.5523 20.3039 14.0615 19.7948 14.0615 19.1667C14.0615 18.5387 13.5523 18.0295 12.9243 18.0295C12.2962 18.0295 11.7871 18.5387 11.7871 19.1667C11.7871 19.7948 12.2962 20.3039 12.9243 20.3039Z" fill="#FF6C6C"/>
                                            <path d="M12.7735 19.6973C12.7114 19.6973 12.6518 19.6726 12.6078 19.6287L12.3171 19.3379C12.2255 19.2464 12.2255 19.098 12.3171 19.0065C12.4086 18.915 12.5571 18.915 12.6485 19.0065L12.7735 19.1315L13.2002 18.7049C13.2917 18.6134 13.4402 18.6134 13.5316 18.7049C13.6232 18.7964 13.6232 18.9448 13.5316 19.0363L12.9392 19.6287C12.8953 19.6726 12.8357 19.6973 12.7735 19.6973V19.6973Z" fill="white"/>
                                            <path d="M14.3828 16.2914C14.2533 16.2914 14.1484 16.1864 14.1484 16.057V15.9878C14.1484 15.8584 14.2533 15.7534 14.3828 15.7534C14.5123 15.7534 14.6172 15.8584 14.6172 15.9878V16.057C14.6172 16.1864 14.5122 16.2914 14.3828 16.2914Z" fill="#FFD5BA"/>
                                            <path d="M13.0091 8.50233C12.7502 8.50233 12.5404 8.29243 12.5404 8.03358V4.51604C12.5404 3.36872 11.607 2.4353 10.4596 2.4353C9.31233 2.4353 8.37891 3.36872 8.37891 4.51604V8.03358C8.37891 8.29243 8.16905 8.50233 7.91016 8.50233C7.65127 8.50233 7.44141 8.29243 7.44141 8.03358V4.51604C7.44141 2.85179 8.79539 1.4978 10.4596 1.4978C12.1239 1.4978 13.4779 2.85179 13.4779 4.51604V8.03358C13.4779 8.29248 13.268 8.50233 13.0091 8.50233Z" fill="#FFD5BA"/>
                                            <path d="M8.8133 19.1614H6.17639C6.04697 19.1614 5.94202 19.0564 5.94202 18.927C5.94202 18.7976 6.04697 18.6926 6.17639 18.6926H8.8133C8.94272 18.6926 9.04767 18.7976 9.04767 18.927C9.04767 19.0564 8.94272 19.1614 8.8133 19.1614Z" fill="#FFD5BA"/>
                                            <path d="M8.86591 18.2642H6.229C6.09958 18.2642 5.99463 18.1592 5.99463 18.0298C5.99463 17.9004 6.09958 17.7954 6.229 17.7954H8.86591C8.99533 17.7954 9.10028 17.9004 9.10028 18.0298C9.10028 18.1592 8.99533 18.2642 8.86591 18.2642Z" fill="#FFD5BA"/>
                                            <path d="M7.0261 17.3667H6.28149C6.15207 17.3667 6.04712 17.2617 6.04712 17.1323C6.04712 17.0029 6.15207 16.8979 6.28149 16.8979H7.0261C7.15553 16.8979 7.26048 17.0029 7.26048 17.1323C7.26048 17.2617 7.15553 17.3667 7.0261 17.3667Z" fill="#FFD5BA"/>
                                            <path d="M16.525 5.72504C15.5939 5.5028 14.5715 5.31202 13.478 5.15696V4.51604C13.478 2.85179 12.124 1.4978 10.4597 1.4978C10.128 1.4978 9.80901 1.55237 9.51023 1.65169C9.21145 1.55237 8.89242 1.4978 8.56073 1.4978C6.89648 1.4978 5.5425 2.85179 5.5425 4.51604V7.05976H3.82584C3.70307 7.05976 3.60112 7.15449 3.59212 7.27693L2.64347 20.1568C2.63348 20.2927 2.74097 20.4084 2.87723 20.4084H10.6739V21.4929C10.6739 21.6995 10.8509 21.8623 11.0567 21.8444C12.9958 21.6755 14.7836 21.2871 16.3415 20.7701C16.4859 20.7222 16.5833 20.5874 16.5833 20.4353V13.2006C16.5833 12.9764 16.377 12.809 16.1578 12.8558C16.0543 12.878 15.9496 12.8997 15.8441 12.9211L15.5559 9.00638C15.852 9.09694 16.1408 9.19538 16.4214 9.30165C16.5367 9.34533 16.6598 9.2603 16.6598 9.13702V5.89646C16.6598 5.81504 16.6042 5.74397 16.525 5.72504V5.72504ZM7.4415 7.05976H6.48V4.51604C6.48 3.47265 7.25207 2.6064 8.25487 2.45799C7.75087 2.99757 7.4415 3.72118 7.4415 4.51604V7.05976ZM8.379 4.51604C8.379 3.71068 8.83926 3.01126 9.51023 2.66555C10.1812 3.01126 10.6415 3.71068 10.6415 4.51604V7.05976H8.379V4.51604ZM12.5405 7.05976H11.579V4.51604C11.579 3.72118 11.2696 2.99757 10.7656 2.45799C11.7684 2.6064 12.5405 3.47265 12.5405 4.51604V7.05976Z" fill="url(#paint2_linear_4516_5327)"/>
                                            <path d="M2.97083 3.40723H2.50208C2.24361 3.40723 2.03333 3.19695 2.03333 2.93848V2.46973C2.03333 2.21126 2.24361 2.00098 2.50208 2.00098H2.97083C3.22929 2.00098 3.43958 2.21126 3.43958 2.46973V2.93848C3.43958 3.19695 3.22929 3.40723 2.97083 3.40723V3.40723ZM2.50208 2.46973V2.93876L2.97083 2.93848V2.46973H2.50208Z" fill="#FF6C6C"/>
                                            <path d="M22.1149 20.8145H21.6461C21.3876 20.8145 21.1774 20.6042 21.1774 20.3457V19.877C21.1774 19.6185 21.3876 19.4082 21.6461 19.4082H22.1149C22.3733 19.4082 22.5836 19.6185 22.5836 19.877V20.3457C22.5836 20.6042 22.3733 20.8145 22.1149 20.8145ZM21.6461 19.877V20.346L22.1149 20.3457V19.877H21.6461Z" fill="#FF6C6C"/>
                                            <path d="M16.8109 4.39062H16.3422C16.0837 4.39062 15.8734 4.18034 15.8734 3.92188V3.45312C15.8734 3.19466 16.0837 2.98438 16.3422 2.98438H16.8109C17.0694 2.98438 17.2797 3.19466 17.2797 3.45312V3.92188C17.2797 4.18034 17.0694 4.39062 16.8109 4.39062ZM16.3422 3.45312V3.92216L16.8109 3.92188V3.45312H16.3422Z" fill="#6C6CFF"/>
                                            <path d="M3.7439 5.73242C3.6839 5.73242 3.62394 5.70955 3.57815 5.6638L3.50727 5.59292C3.37935 5.46495 3.17104 5.46495 3.04297 5.59292L2.9721 5.6638C2.88055 5.7553 2.73219 5.7553 2.64065 5.6638C2.5949 5.618 2.57202 5.55805 2.57202 5.49805C2.57202 5.43805 2.5949 5.37809 2.64065 5.3323L2.71152 5.26142C2.77354 5.19941 2.80771 5.11695 2.80771 5.0293C2.80771 4.94164 2.77354 4.85919 2.71157 4.79717L2.64065 4.7263C2.5949 4.6805 2.57202 4.62055 2.57202 4.56055C2.57202 4.50055 2.5949 4.44059 2.64065 4.3948C2.73219 4.3033 2.88055 4.3033 2.9721 4.3948L3.04297 4.46567C3.17094 4.59364 3.37926 4.59364 3.50722 4.46567L3.5781 4.3948C3.66965 4.3033 3.81801 4.3033 3.90955 4.3948C3.9553 4.44059 3.97818 4.50055 3.97818 4.56055C3.97818 4.62055 3.9553 4.6805 3.90955 4.7263L3.83868 4.79717C3.71066 4.92514 3.71066 5.13345 3.83868 5.26142L3.90955 5.3323C3.9553 5.37809 3.97818 5.43805 3.97818 5.49805C3.97818 5.55805 3.9553 5.618 3.90955 5.6638C3.86385 5.70955 3.8039 5.73242 3.7439 5.73242V5.73242Z" fill="#FF9C33"/>
                                            <path d="M9.3708 23.1479C9.3108 23.1479 9.25085 23.1251 9.20505 23.0793L9.13418 23.0084C9.00621 22.8805 8.7979 22.8805 8.66993 23.0084L8.59905 23.0793C8.50751 23.1708 8.35915 23.1708 8.2676 23.0793C8.22185 23.0335 8.19897 22.9736 8.19897 22.9136C8.19897 22.8536 8.22185 22.7936 8.2676 22.7478L8.33847 22.6769C8.46649 22.549 8.46649 22.3407 8.33847 22.2127L8.2676 22.1418C8.22185 22.096 8.19897 22.0361 8.19897 21.9761C8.19897 21.9161 8.22185 21.8561 8.2676 21.8103C8.35915 21.7188 8.50751 21.7188 8.59905 21.8103L8.66993 21.8812C8.79785 22.0092 9.00616 22.0092 9.13422 21.8812L9.2051 21.8103C9.29665 21.7188 9.44501 21.7188 9.53655 21.8103C9.5823 21.8561 9.60518 21.9161 9.60518 21.9761C9.60518 22.0361 9.5823 22.096 9.53655 22.1418L9.46568 22.2127C9.40366 22.2747 9.36949 22.3572 9.36949 22.4448C9.36949 22.5325 9.40366 22.6149 9.46563 22.6769L9.53655 22.7478C9.5823 22.7936 9.60518 22.8536 9.60518 22.9136C9.60518 22.9736 9.5823 23.0335 9.53655 23.0793C9.49076 23.125 9.4308 23.1479 9.3708 23.1479Z" fill="#FF9C33"/>
                                         
                                        </svg>
                                            
                                              
                                    </div>
                                    <div class="content-right">
                                        <div class="title">
                                            <h3 class="fw_6">Shopping</h3>
                                            <span class="fw_6 on_surface_color">9/1/2023</span>
                                        </div>
                                        <div class="desc">
                                            <p class="on_surface_color fw_4">Alipay gives you 20% offcoupon for all bills, applicable for bills paid through Alipay wallet!</p>
                                            <i class="dot"></i>
                                        </div>
                                    </div>
                                </div>
                                <div class="noti-list">
                                    <div class="icon-box bg_service-3">
                                        <svg width="16" height="16" viewBox="0 0 25 24" fill="none" xmlns="http://www.w3.org/2000/svg">
                                            <path d="M24.2838 7.48567C22.5636 -5.34697 15.3153 2.01241 6.99199 5.99402C4.62414 7.12675 1.38339 7.13603 0.529097 10.1115C-0.458746 13.5521 2.49213 15.7224 4.86696 17.5562C7.726 19.7638 7.32082 24.1061 11.9929 23.7198C12.874 23.647 13.9302 23.7352 14.4994 23.0587C16.8551 20.2588 17.5094 16.0487 20.5731 13.8156C22.7339 12.2406 24.6702 10.3686 24.2838 7.48567V7.48567Z" fill="url(#paint0_linear_4516_5327)"/>
                                            <path d="M11.1101 8.50233C10.8512 8.50233 10.6413 8.29243 10.6413 8.03358V4.51604C10.6413 3.36872 9.70791 2.4353 8.56059 2.4353C7.41328 2.4353 6.47986 3.36872 6.47986 4.51604V8.03358C6.47986 8.29243 6.27 8.50233 6.01111 8.50233C5.75222 8.50233 5.54236 8.29243 5.54236 8.03358V4.51604C5.54236 2.85179 6.89634 1.4978 8.56059 1.4978C10.2248 1.4978 11.5788 2.85179 11.5788 4.51604V8.03358C11.5788 8.29248 11.369 8.50233 11.1101 8.50233V8.50233Z" fill="#FFC498"/>
                                            <path d="M4.77612 20.4084H2.87707C2.74085 20.4084 2.63332 20.2927 2.64335 20.1568L3.59196 7.27699C3.60096 7.15455 3.70296 7.05981 3.82568 7.05981H5.72482L4.77612 20.4084Z" fill="#FF7300"/>
                                            <path d="M10.2019 1.98511C9.70002 2.02945 9.26681 2.20284 8.90198 2.46379C9.5587 2.57269 10.1121 2.99006 10.4085 3.56161C10.4256 3.56119 10.4425 3.56029 10.4596 3.56029C10.8392 3.56029 11.1951 3.663 11.5018 3.84131C11.3243 3.06712 10.8485 2.40586 10.2019 1.98511V1.98511Z" fill="#FFAA66"/>
                                            <path d="M13.3223 5.13473C14.475 5.29359 15.5495 5.49229 16.5249 5.72507C16.6042 5.74396 16.6598 5.81503 16.6598 5.8965V9.13706C16.6598 9.26034 16.5367 9.34537 16.4213 9.30168C15.46 8.93756 14.4044 8.66198 13.2743 8.50078C13.1872 8.48836 13.1222 8.41434 13.1222 8.3264V5.30939C13.1222 5.2027 13.2166 5.12015 13.3223 5.13473V5.13473Z" fill="#9393FF"/>
                                            <path d="M19.934 11.522C19.3646 10.9961 18.6909 10.5108 17.9281 10.086C17.8721 10.0548 17.837 9.99604 17.837 9.93201V6.37448C17.837 6.25486 17.9539 6.16978 18.0677 6.20672C20.528 7.0057 22.0239 8.06062 22.0239 9.21736L21.8832 11.1587L19.934 11.522Z" fill="#9393FF"/>
                                            <path d="M22.0238 13.3463L21.8386 14.0752L22.0238 14.2763V14.5922L21.9179 15.2644L22.0238 15.5222V16.0791C22.0238 17.1707 20.6922 18.5447 18.4754 19.6873C18.2885 19.7836 18.0657 19.6472 18.0657 19.4369V12.4824C18.0657 12.3314 18.1622 12.1974 18.3052 12.1486C20.6241 11.3602 22.0238 10.3364 22.0238 9.21753V13.3463Z" fill="#D8D8FF"/>
                                            <path d="M22.0238 14.592V15.522C21.4594 16.2172 20.5032 16.8463 19.4996 17.4355C19.4625 17.4575 19.4217 17.4678 19.3814 17.4678C19.3008 17.4678 19.2225 17.4266 19.1789 17.352C19.1133 17.2405 19.1508 17.0966 19.2624 17.0314C20.9536 16.0386 21.8133 15.2853 22.0238 14.592V14.592Z" fill="#9393FF"/>
                                            <path d="M22.0238 13.3462V14.2762C21.4589 14.9713 20.5032 15.6004 19.4996 16.1896C19.4625 16.2112 19.4217 16.2215 19.3814 16.2215C19.3008 16.2215 19.2225 16.1803 19.1789 16.1062C19.1133 15.9942 19.1508 15.8507 19.2624 15.7851C20.9536 14.7923 21.8133 14.0395 22.0238 13.3462Z" fill="#9393FF"/>
                                            <path d="M19.3813 15.2074C19.3025 15.2074 19.2256 15.1678 19.1813 15.0957C19.1136 14.9854 19.148 14.8411 19.2583 14.7734C19.5345 14.6037 19.7758 14.4484 19.996 14.2986C20.1032 14.2258 20.2489 14.2537 20.3216 14.3607C20.3944 14.4678 20.3666 14.6136 20.2596 14.6863C20.0333 14.8401 19.786 14.9993 19.5037 15.1727C19.4655 15.1962 19.4231 15.2074 19.3813 15.2074V15.2074Z" fill="#9393FF"/>
                                            <path d="M19.3812 13.4436C19.2918 13.4436 19.2064 13.3922 19.1674 13.3054C19.1142 13.1874 19.1668 13.0486 19.2848 12.9955C19.6547 12.8289 19.9883 12.6536 20.2766 12.4743C20.3866 12.406 20.5311 12.4397 20.5994 12.5495C20.6677 12.6595 20.634 12.804 20.5242 12.8724C20.2183 13.0626 19.8661 13.2478 19.4773 13.4229C19.4461 13.4369 19.4134 13.4436 19.3812 13.4436V13.4436Z" fill="#FF9393"/>
                                            <path d="M18.0681 6.20699C17.9542 6.17001 17.837 6.2549 17.837 6.37462V9.93215C17.837 9.99623 17.8721 10.055 17.9281 10.0862C18.6779 10.5038 19.3408 10.9801 19.904 11.4957C19.4371 11.7274 18.9017 11.946 18.3048 12.149C18.1621 12.1976 18.0658 12.3317 18.0658 12.4826V19.437C18.0658 19.6473 18.2886 19.7838 18.4756 19.6874C20.6923 18.5446 22.0239 17.1709 22.0239 16.0793V9.21749C22.0239 8.0608 20.5282 7.00593 18.0681 6.20699Z" fill="url(#paint1_linear_4516_5327)"/>
                                            <path d="M16.1433 20.4084H4.77616C4.63975 20.4084 4.53241 20.2926 4.54225 20.1567L5.491 7.27685C5.49991 7.1545 5.6021 7.05981 5.72491 7.05981H15.1946C15.3174 7.05981 15.4191 7.1545 15.4285 7.27685L16.3768 20.1567C16.3871 20.2926 16.2793 20.4084 16.1433 20.4084Z" fill="#FFAA66"/>
                                            <path d="M11.0447 10.5326C10.9228 10.6545 10.7608 10.7216 10.5884 10.7216C10.4161 10.7216 10.2541 10.6545 10.1322 10.5326C10.0104 10.4107 9.94324 10.2487 9.94324 10.0763C9.94324 9.90399 10.0104 9.74199 10.1322 9.62011C10.3838 9.36849 10.7932 9.36854 11.0447 9.62011L11.2104 9.78586L11.5419 9.45441L11.3761 9.28866C11.2188 9.13135 11.0257 9.03188 10.8228 8.98847V8.53955H10.3541V8.98852C10.1512 9.03188 9.95805 9.13139 9.80074 9.28866C9.59036 9.49908 9.47449 9.77883 9.47449 10.0763C9.47449 10.3739 9.59036 10.6537 9.80074 10.864C9.95472 11.018 10.146 11.1211 10.3541 11.1655V11.6131H10.8228V11.1655C11.0309 11.1211 11.2221 11.018 11.3761 10.864L11.5419 10.6983L11.2104 10.3668L11.0447 10.5326Z" fill="white"/>
                                            <path d="M7.44153 7.05981H8.37903V8.87763C8.37903 9.13638 8.16903 9.34638 7.91028 9.34638C7.65153 9.34638 7.44153 9.13638 7.44153 8.87763V7.05981Z" fill="#FF9C33"/>
                                            <path d="M13.4781 7.05981V8.87763C13.4781 9.13638 13.2681 9.34638 13.0094 9.34638C12.7502 9.34638 12.5406 9.13638 12.5406 8.87763V7.05981H13.4781Z" fill="#FF9C33"/>
                                            <path d="M10.9984 13.5775C12.884 13.4304 14.6278 13.183 16.1577 12.8558C16.3769 12.8089 16.5833 12.9764 16.5833 13.2005V20.4353C16.5833 20.5874 16.4858 20.7222 16.3414 20.7701C14.7835 21.2871 12.9957 21.6755 11.0566 21.8444C10.8508 21.8623 10.6738 21.6995 10.6738 21.4929V13.9288C10.6738 13.745 10.8151 13.5918 10.9984 13.5775V13.5775Z" fill="#D8D8FF"/>
                                            <path d="M15.4929 20.1811C15.3913 20.1811 15.2977 20.1146 15.2679 20.0122C15.2318 19.8879 15.3032 19.7578 15.4274 19.7216C15.4987 19.7009 15.5694 19.6798 15.6398 19.6586C15.7636 19.621 15.8946 19.6911 15.9321 19.815C15.9696 19.9389 15.8995 20.0697 15.7756 20.1072C15.7036 20.129 15.6313 20.1505 15.5584 20.1717C15.5366 20.1781 15.5146 20.1811 15.4929 20.1811V20.1811Z" fill="#8282FF"/>
                                            <path d="M15.4929 19.4651C15.3913 19.4651 15.2977 19.3986 15.2679 19.2961C15.2318 19.1719 15.3032 19.0418 15.4274 19.0056C15.4987 18.9848 15.5694 18.9638 15.6398 18.9425C15.7636 18.9049 15.8946 18.9751 15.9321 19.0989C15.9696 19.2228 15.8995 19.3537 15.7756 19.3912C15.7036 19.413 15.6313 19.4344 15.5584 19.4556C15.5366 19.462 15.5146 19.4651 15.4929 19.4651V19.4651Z" fill="#8282FF"/>
                                            <path d="M16.0011 15.6087L14.8434 14.5739C14.8277 14.5598 14.8076 14.5527 14.7878 14.5541L14.2639 14.5906C14.2315 14.5929 14.2048 14.6166 14.1978 14.6498C14.1563 14.846 13.9983 14.997 13.7931 15.013C13.586 15.0292 13.3922 14.9033 13.3049 14.713C13.29 14.6807 13.2572 14.6607 13.2233 14.6631L12.6622 14.7021C12.6407 14.7036 12.6207 14.714 12.6071 14.7308L11.5495 16.0345C11.5196 16.0715 11.5257 16.1262 11.5632 16.1566L12.2405 16.7049C12.2768 16.7343 12.3301 16.7283 12.359 16.6915L12.7033 16.2534L12.643 18.6497C12.6416 18.7057 12.6911 18.7494 12.7465 18.7411L15.0027 18.4026C15.0469 18.396 15.0795 18.3579 15.0794 18.3132L15.074 16.0106L15.4573 16.3438C15.4903 16.3725 15.5408 16.3668 15.5666 16.3314L16.0137 15.7194C16.038 15.6862 16.0324 15.6366 16.0011 15.6087V15.6087Z" fill="#FFAA66"/>
                                            <path d="M12.9243 20.3039C13.5523 20.3039 14.0615 19.7948 14.0615 19.1667C14.0615 18.5387 13.5523 18.0295 12.9243 18.0295C12.2962 18.0295 11.7871 18.5387 11.7871 19.1667C11.7871 19.7948 12.2962 20.3039 12.9243 20.3039Z" fill="#FF6C6C"/>
                                            <path d="M12.7735 19.6973C12.7114 19.6973 12.6518 19.6726 12.6078 19.6287L12.3171 19.3379C12.2255 19.2464 12.2255 19.098 12.3171 19.0065C12.4086 18.915 12.5571 18.915 12.6485 19.0065L12.7735 19.1315L13.2002 18.7049C13.2917 18.6134 13.4402 18.6134 13.5316 18.7049C13.6232 18.7964 13.6232 18.9448 13.5316 19.0363L12.9392 19.6287C12.8953 19.6726 12.8357 19.6973 12.7735 19.6973V19.6973Z" fill="white"/>
                                            <path d="M14.3828 16.2914C14.2533 16.2914 14.1484 16.1864 14.1484 16.057V15.9878C14.1484 15.8584 14.2533 15.7534 14.3828 15.7534C14.5123 15.7534 14.6172 15.8584 14.6172 15.9878V16.057C14.6172 16.1864 14.5122 16.2914 14.3828 16.2914Z" fill="#FFD5BA"/>
                                            <path d="M13.0091 8.50233C12.7502 8.50233 12.5404 8.29243 12.5404 8.03358V4.51604C12.5404 3.36872 11.607 2.4353 10.4596 2.4353C9.31233 2.4353 8.37891 3.36872 8.37891 4.51604V8.03358C8.37891 8.29243 8.16905 8.50233 7.91016 8.50233C7.65127 8.50233 7.44141 8.29243 7.44141 8.03358V4.51604C7.44141 2.85179 8.79539 1.4978 10.4596 1.4978C12.1239 1.4978 13.4779 2.85179 13.4779 4.51604V8.03358C13.4779 8.29248 13.268 8.50233 13.0091 8.50233Z" fill="#FFD5BA"/>
                                            <path d="M8.8133 19.1614H6.17639C6.04697 19.1614 5.94202 19.0564 5.94202 18.927C5.94202 18.7976 6.04697 18.6926 6.17639 18.6926H8.8133C8.94272 18.6926 9.04767 18.7976 9.04767 18.927C9.04767 19.0564 8.94272 19.1614 8.8133 19.1614Z" fill="#FFD5BA"/>
                                            <path d="M8.86591 18.2642H6.229C6.09958 18.2642 5.99463 18.1592 5.99463 18.0298C5.99463 17.9004 6.09958 17.7954 6.229 17.7954H8.86591C8.99533 17.7954 9.10028 17.9004 9.10028 18.0298C9.10028 18.1592 8.99533 18.2642 8.86591 18.2642Z" fill="#FFD5BA"/>
                                            <path d="M7.0261 17.3667H6.28149C6.15207 17.3667 6.04712 17.2617 6.04712 17.1323C6.04712 17.0029 6.15207 16.8979 6.28149 16.8979H7.0261C7.15553 16.8979 7.26048 17.0029 7.26048 17.1323C7.26048 17.2617 7.15553 17.3667 7.0261 17.3667Z" fill="#FFD5BA"/>
                                            <path d="M16.525 5.72504C15.5939 5.5028 14.5715 5.31202 13.478 5.15696V4.51604C13.478 2.85179 12.124 1.4978 10.4597 1.4978C10.128 1.4978 9.80901 1.55237 9.51023 1.65169C9.21145 1.55237 8.89242 1.4978 8.56073 1.4978C6.89648 1.4978 5.5425 2.85179 5.5425 4.51604V7.05976H3.82584C3.70307 7.05976 3.60112 7.15449 3.59212 7.27693L2.64347 20.1568C2.63348 20.2927 2.74097 20.4084 2.87723 20.4084H10.6739V21.4929C10.6739 21.6995 10.8509 21.8623 11.0567 21.8444C12.9958 21.6755 14.7836 21.2871 16.3415 20.7701C16.4859 20.7222 16.5833 20.5874 16.5833 20.4353V13.2006C16.5833 12.9764 16.377 12.809 16.1578 12.8558C16.0543 12.878 15.9496 12.8997 15.8441 12.9211L15.5559 9.00638C15.852 9.09694 16.1408 9.19538 16.4214 9.30165C16.5367 9.34533 16.6598 9.2603 16.6598 9.13702V5.89646C16.6598 5.81504 16.6042 5.74397 16.525 5.72504V5.72504ZM7.4415 7.05976H6.48V4.51604C6.48 3.47265 7.25207 2.6064 8.25487 2.45799C7.75087 2.99757 7.4415 3.72118 7.4415 4.51604V7.05976ZM8.379 4.51604C8.379 3.71068 8.83926 3.01126 9.51023 2.66555C10.1812 3.01126 10.6415 3.71068 10.6415 4.51604V7.05976H8.379V4.51604ZM12.5405 7.05976H11.579V4.51604C11.579 3.72118 11.2696 2.99757 10.7656 2.45799C11.7684 2.6064 12.5405 3.47265 12.5405 4.51604V7.05976Z" fill="url(#paint2_linear_4516_5327)"/>
                                            <path d="M2.97083 3.40723H2.50208C2.24361 3.40723 2.03333 3.19695 2.03333 2.93848V2.46973C2.03333 2.21126 2.24361 2.00098 2.50208 2.00098H2.97083C3.22929 2.00098 3.43958 2.21126 3.43958 2.46973V2.93848C3.43958 3.19695 3.22929 3.40723 2.97083 3.40723V3.40723ZM2.50208 2.46973V2.93876L2.97083 2.93848V2.46973H2.50208Z" fill="#FF6C6C"/>
                                            <path d="M22.1149 20.8145H21.6461C21.3876 20.8145 21.1774 20.6042 21.1774 20.3457V19.877C21.1774 19.6185 21.3876 19.4082 21.6461 19.4082H22.1149C22.3733 19.4082 22.5836 19.6185 22.5836 19.877V20.3457C22.5836 20.6042 22.3733 20.8145 22.1149 20.8145ZM21.6461 19.877V20.346L22.1149 20.3457V19.877H21.6461Z" fill="#FF6C6C"/>
                                            <path d="M16.8109 4.39062H16.3422C16.0837 4.39062 15.8734 4.18034 15.8734 3.92188V3.45312C15.8734 3.19466 16.0837 2.98438 16.3422 2.98438H16.8109C17.0694 2.98438 17.2797 3.19466 17.2797 3.45312V3.92188C17.2797 4.18034 17.0694 4.39062 16.8109 4.39062ZM16.3422 3.45312V3.92216L16.8109 3.92188V3.45312H16.3422Z" fill="#6C6CFF"/>
                                            <path d="M3.7439 5.73242C3.6839 5.73242 3.62394 5.70955 3.57815 5.6638L3.50727 5.59292C3.37935 5.46495 3.17104 5.46495 3.04297 5.59292L2.9721 5.6638C2.88055 5.7553 2.73219 5.7553 2.64065 5.6638C2.5949 5.618 2.57202 5.55805 2.57202 5.49805C2.57202 5.43805 2.5949 5.37809 2.64065 5.3323L2.71152 5.26142C2.77354 5.19941 2.80771 5.11695 2.80771 5.0293C2.80771 4.94164 2.77354 4.85919 2.71157 4.79717L2.64065 4.7263C2.5949 4.6805 2.57202 4.62055 2.57202 4.56055C2.57202 4.50055 2.5949 4.44059 2.64065 4.3948C2.73219 4.3033 2.88055 4.3033 2.9721 4.3948L3.04297 4.46567C3.17094 4.59364 3.37926 4.59364 3.50722 4.46567L3.5781 4.3948C3.66965 4.3033 3.81801 4.3033 3.90955 4.3948C3.9553 4.44059 3.97818 4.50055 3.97818 4.56055C3.97818 4.62055 3.9553 4.6805 3.90955 4.7263L3.83868 4.79717C3.71066 4.92514 3.71066 5.13345 3.83868 5.26142L3.90955 5.3323C3.9553 5.37809 3.97818 5.43805 3.97818 5.49805C3.97818 5.55805 3.9553 5.618 3.90955 5.6638C3.86385 5.70955 3.8039 5.73242 3.7439 5.73242V5.73242Z" fill="#FF9C33"/>
                                            <path d="M9.3708 23.1479C9.3108 23.1479 9.25085 23.1251 9.20505 23.0793L9.13418 23.0084C9.00621 22.8805 8.7979 22.8805 8.66993 23.0084L8.59905 23.0793C8.50751 23.1708 8.35915 23.1708 8.2676 23.0793C8.22185 23.0335 8.19897 22.9736 8.19897 22.9136C8.19897 22.8536 8.22185 22.7936 8.2676 22.7478L8.33847 22.6769C8.46649 22.549 8.46649 22.3407 8.33847 22.2127L8.2676 22.1418C8.22185 22.096 8.19897 22.0361 8.19897 21.9761C8.19897 21.9161 8.22185 21.8561 8.2676 21.8103C8.35915 21.7188 8.50751 21.7188 8.59905 21.8103L8.66993 21.8812C8.79785 22.0092 9.00616 22.0092 9.13422 21.8812L9.2051 21.8103C9.29665 21.7188 9.44501 21.7188 9.53655 21.8103C9.5823 21.8561 9.60518 21.9161 9.60518 21.9761C9.60518 22.0361 9.5823 22.096 9.53655 22.1418L9.46568 22.2127C9.40366 22.2747 9.36949 22.3572 9.36949 22.4448C9.36949 22.5325 9.40366 22.6149 9.46563 22.6769L9.53655 22.7478C9.5823 22.7936 9.60518 22.8536 9.60518 22.9136C9.60518 22.9736 9.5823 23.0335 9.53655 23.0793C9.49076 23.125 9.4308 23.1479 9.3708 23.1479Z" fill="#FF9C33"/>
                                         
                                        </svg>
                                            
                                              
                                    </div>
                                    <div class="content-right">
                                        <div class="title">
                                            <h3 class="fw_4 secondary_color">Shopping</h3>
                                            <span class="secondary_color fw_4">7/1/2023</span>
                                        </div>
                                        <div class="desc">
                                            <p class="secondary_color fw_4">Alipay gives you 20% offcoupon for all bills, applicable for bills paid through Alipay wallet!</p>
                                        </div>
                                    </div>
                                </div>
                                <div class="noti-list">
                                    <div class="icon-box bg_service-6">
                                        <svg width="16" height="16" viewBox="0 0 16 16" fill="none" xmlns="http://www.w3.org/2000/svg">
                                            <path d="M7.99995 14.7062C12.0609 14.7062 15.353 11.4141 15.353 7.35309C15.353 3.29209 12.0609 0 7.99995 0C3.93894 0 0.646851 3.29209 0.646851 7.35309C0.646851 11.4141 3.93894 14.7062 7.99995 14.7062Z" fill="#F7B239"/>
                                            <path d="M7.99997 12.1931C10.673 12.1931 12.8399 10.0261 12.8399 7.35312C12.8399 4.6801 10.673 2.51318 7.99997 2.51318C5.32695 2.51318 3.16003 4.6801 3.16003 7.35312C3.16003 10.0261 5.32695 12.1931 7.99997 12.1931Z" fill="#E09B2D"/>
                                            <path d="M14.6157 15.1809C14.6307 15.2373 14.638 15.294 14.638 15.3495C14.638 15.637 14.4463 15.8997 14.1558 15.9776C13.8089 16.0706 13.4521 15.8646 13.3591 15.5178L12.2661 11.4386C12.1731 11.0918 12.3791 10.7349 12.726 10.6419C13.0732 10.549 13.4297 10.755 13.5227 11.1022L14.6157 15.1809Z" fill="#F24C8F"/>
                                            <path d="M2.4596 11.5182L3.01855 11.668L4.49394 6.16149L3.93499 6.01173L2.4596 11.5182Z" fill="#CCCCCC"/>
                                            <path d="M11.6446 7.71971L12.4469 10.7156L13.0059 10.5659L12.2036 7.57L11.6446 7.71971Z" fill="#CCCCCC"/>
                                            <path d="M5.26403 2.1712C6.18881 2.41888 6.60972 3.8456 6.20463 5.3572C5.79953 6.86917 4.88478 7.28545 3.96 7.03776C3.03559 6.79007 2.4515 5.97217 2.85659 4.4602C3.26169 2.94823 4.33963 1.92351 5.26403 2.1712Z" fill="#E6E6E6"/>
                                            <path d="M2.9944 10.642C3.34162 10.7349 3.54727 11.0918 3.45427 11.4386L2.36168 15.5178C2.28374 15.8083 2.02099 16 1.73359 16C1.67802 16 1.6213 15.9927 1.56499 15.9776C1.21777 15.8847 1.01174 15.5278 1.10471 15.181L2.19771 11.1022C2.29068 10.755 2.64755 10.549 2.9944 10.642Z" fill="#F24C8F"/>
                                            <path d="M13.0658 6.02202L12.141 2.57046C12.1045 2.4344 11.9629 2.35446 11.8268 2.39515C11.6951 2.43455 11.6237 2.57771 11.6592 2.71046L12.3966 5.46168C12.4517 5.66743 12.3296 5.87893 12.1239 5.93408L12.1235 5.93415C11.9177 5.98937 11.7061 5.86721 11.651 5.66143L10.911 2.89987C10.8745 2.76371 10.7327 2.6838 10.5967 2.72458C10.465 2.76405 10.3937 2.90718 10.4293 3.0399L11.1666 5.79137C11.2217 5.99715 11.0996 6.20865 10.8938 6.26383C10.688 6.31896 10.4766 6.19687 10.4214 5.99108L9.68139 3.22937C9.64493 3.09324 9.5033 3.01337 9.36721 3.05405C9.23552 3.09346 9.16408 3.23658 9.19964 3.36933L10.1216 6.81049C10.2269 7.20383 10.479 7.53255 10.8316 7.73615C11.0665 7.87177 11.327 7.94102 11.5912 7.94102C11.7236 7.94102 11.857 7.92358 11.9883 7.8884C12.6534 7.71015 13.1178 7.10524 13.1178 6.4174C13.1178 6.28349 13.1003 6.15027 13.0658 6.02202Z" fill="#E6E6E6"/>
                                        </svg>
                                            
                                              
                                    </div>
                                    <div class="content-right">
                                        <div class="title">
                                            <h3 class="fw_4 secondary_color">Travel</h3>
                                            <span class="secondary_color fw_4">1 Day Ago</span>
                                        </div>
                                        <div class="desc">
                                            <p class="secondary_color fw_4">Alipay gives you 20% offcoupon for all bills, applicable for bills paid through Alipay wallet!</p>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <!-- 4 -->
                            <div class="noti-box">
                                <div class="noti-list">
                                    <div class="icon-box bg_service-4">
                                        <svg width="16" height="16" viewBox="0 0 16 16" fill="none" xmlns="http://www.w3.org/2000/svg">
                                            <path d="M7.99995 14.7062C12.0609 14.7062 15.353 11.4141 15.353 7.35309C15.353 3.29209 12.0609 0 7.99995 0C3.93894 0 0.646851 3.29209 0.646851 7.35309C0.646851 11.4141 3.93894 14.7062 7.99995 14.7062Z" fill="#F7B239"/>
                                            <path d="M7.99997 12.1931C10.673 12.1931 12.8399 10.0261 12.8399 7.35312C12.8399 4.6801 10.673 2.51318 7.99997 2.51318C5.32695 2.51318 3.16003 4.6801 3.16003 7.35312C3.16003 10.0261 5.32695 12.1931 7.99997 12.1931Z" fill="#E09B2D"/>
                                            <path d="M14.6157 15.1809C14.6307 15.2373 14.638 15.294 14.638 15.3495C14.638 15.637 14.4463 15.8997 14.1558 15.9776C13.8089 16.0706 13.4521 15.8646 13.3591 15.5178L12.2661 11.4386C12.1731 11.0918 12.3791 10.7349 12.726 10.6419C13.0732 10.549 13.4297 10.755 13.5227 11.1022L14.6157 15.1809Z" fill="#F24C8F"/>
                                            <path d="M2.4596 11.5182L3.01855 11.668L4.49394 6.16149L3.93499 6.01173L2.4596 11.5182Z" fill="#CCCCCC"/>
                                            <path d="M11.6446 7.71971L12.4469 10.7156L13.0059 10.5659L12.2036 7.57L11.6446 7.71971Z" fill="#CCCCCC"/>
                                            <path d="M5.26403 2.1712C6.18881 2.41888 6.60972 3.8456 6.20463 5.3572C5.79953 6.86917 4.88478 7.28545 3.96 7.03776C3.03559 6.79007 2.4515 5.97217 2.85659 4.4602C3.26169 2.94823 4.33963 1.92351 5.26403 2.1712Z" fill="#E6E6E6"/>
                                            <path d="M2.9944 10.642C3.34162 10.7349 3.54727 11.0918 3.45427 11.4386L2.36168 15.5178C2.28374 15.8083 2.02099 16 1.73359 16C1.67802 16 1.6213 15.9927 1.56499 15.9776C1.21777 15.8847 1.01174 15.5278 1.10471 15.181L2.19771 11.1022C2.29068 10.755 2.64755 10.549 2.9944 10.642Z" fill="#F24C8F"/>
                                            <path d="M13.0658 6.02202L12.141 2.57046C12.1045 2.4344 11.9629 2.35446 11.8268 2.39515C11.6951 2.43455 11.6237 2.57771 11.6592 2.71046L12.3966 5.46168C12.4517 5.66743 12.3296 5.87893 12.1239 5.93408L12.1235 5.93415C11.9177 5.98937 11.7061 5.86721 11.651 5.66143L10.911 2.89987C10.8745 2.76371 10.7327 2.6838 10.5967 2.72458C10.465 2.76405 10.3937 2.90718 10.4293 3.0399L11.1666 5.79137C11.2217 5.99715 11.0996 6.20865 10.8938 6.26383C10.688 6.31896 10.4766 6.19687 10.4214 5.99108L9.68139 3.22937C9.64493 3.09324 9.5033 3.01337 9.36721 3.05405C9.23552 3.09346 9.16408 3.23658 9.19964 3.36933L10.1216 6.81049C10.2269 7.20383 10.479 7.53255 10.8316 7.73615C11.0665 7.87177 11.327 7.94102 11.5912 7.94102C11.7236 7.94102 11.857 7.92358 11.9883 7.8884C12.6534 7.71015 13.1178 7.10524 13.1178 6.4174C13.1178 6.28349 13.1003 6.15027 13.0658 6.02202Z" fill="#E6E6E6"/>
                                        </svg>
                                            
                                    </div>
                                    <div class="content-right">
                                        <div class="title">
                                            <h3 class="fw_6">Restaurant</h3>
                                            <span class="fw_6 on_surface_color">5 Min Ago</span>
                                        </div>
                                        <div class="desc">
                                            <p class="on_surface_color fw_4">Alipay gives you 20% offcoupon for all bills, applicable for bills paid through Alipay wallet!</p>
                                            <i class="dot"></i>
                                        </div>
                                    </div>
                                </div>
                                <div class="noti-list">
                                    <div class="icon-box bg_service-3">
                                        <svg width="16" height="16" viewBox="0 0 25 24" fill="none" xmlns="http://www.w3.org/2000/svg">
                                            <path d="M24.2838 7.48567C22.5636 -5.34697 15.3153 2.01241 6.99199 5.99402C4.62414 7.12675 1.38339 7.13603 0.529097 10.1115C-0.458746 13.5521 2.49213 15.7224 4.86696 17.5562C7.726 19.7638 7.32082 24.1061 11.9929 23.7198C12.874 23.647 13.9302 23.7352 14.4994 23.0587C16.8551 20.2588 17.5094 16.0487 20.5731 13.8156C22.7339 12.2406 24.6702 10.3686 24.2838 7.48567V7.48567Z" fill="url(#paint0_linear_4516_5327)"/>
                                            <path d="M11.1101 8.50233C10.8512 8.50233 10.6413 8.29243 10.6413 8.03358V4.51604C10.6413 3.36872 9.70791 2.4353 8.56059 2.4353C7.41328 2.4353 6.47986 3.36872 6.47986 4.51604V8.03358C6.47986 8.29243 6.27 8.50233 6.01111 8.50233C5.75222 8.50233 5.54236 8.29243 5.54236 8.03358V4.51604C5.54236 2.85179 6.89634 1.4978 8.56059 1.4978C10.2248 1.4978 11.5788 2.85179 11.5788 4.51604V8.03358C11.5788 8.29248 11.369 8.50233 11.1101 8.50233V8.50233Z" fill="#FFC498"/>
                                            <path d="M4.77612 20.4084H2.87707C2.74085 20.4084 2.63332 20.2927 2.64335 20.1568L3.59196 7.27699C3.60096 7.15455 3.70296 7.05981 3.82568 7.05981H5.72482L4.77612 20.4084Z" fill="#FF7300"/>
                                            <path d="M10.2019 1.98511C9.70002 2.02945 9.26681 2.20284 8.90198 2.46379C9.5587 2.57269 10.1121 2.99006 10.4085 3.56161C10.4256 3.56119 10.4425 3.56029 10.4596 3.56029C10.8392 3.56029 11.1951 3.663 11.5018 3.84131C11.3243 3.06712 10.8485 2.40586 10.2019 1.98511V1.98511Z" fill="#FFAA66"/>
                                            <path d="M13.3223 5.13473C14.475 5.29359 15.5495 5.49229 16.5249 5.72507C16.6042 5.74396 16.6598 5.81503 16.6598 5.8965V9.13706C16.6598 9.26034 16.5367 9.34537 16.4213 9.30168C15.46 8.93756 14.4044 8.66198 13.2743 8.50078C13.1872 8.48836 13.1222 8.41434 13.1222 8.3264V5.30939C13.1222 5.2027 13.2166 5.12015 13.3223 5.13473V5.13473Z" fill="#9393FF"/>
                                            <path d="M19.934 11.522C19.3646 10.9961 18.6909 10.5108 17.9281 10.086C17.8721 10.0548 17.837 9.99604 17.837 9.93201V6.37448C17.837 6.25486 17.9539 6.16978 18.0677 6.20672C20.528 7.0057 22.0239 8.06062 22.0239 9.21736L21.8832 11.1587L19.934 11.522Z" fill="#9393FF"/>
                                            <path d="M22.0238 13.3463L21.8386 14.0752L22.0238 14.2763V14.5922L21.9179 15.2644L22.0238 15.5222V16.0791C22.0238 17.1707 20.6922 18.5447 18.4754 19.6873C18.2885 19.7836 18.0657 19.6472 18.0657 19.4369V12.4824C18.0657 12.3314 18.1622 12.1974 18.3052 12.1486C20.6241 11.3602 22.0238 10.3364 22.0238 9.21753V13.3463Z" fill="#D8D8FF"/>
                                            <path d="M22.0238 14.592V15.522C21.4594 16.2172 20.5032 16.8463 19.4996 17.4355C19.4625 17.4575 19.4217 17.4678 19.3814 17.4678C19.3008 17.4678 19.2225 17.4266 19.1789 17.352C19.1133 17.2405 19.1508 17.0966 19.2624 17.0314C20.9536 16.0386 21.8133 15.2853 22.0238 14.592V14.592Z" fill="#9393FF"/>
                                            <path d="M22.0238 13.3462V14.2762C21.4589 14.9713 20.5032 15.6004 19.4996 16.1896C19.4625 16.2112 19.4217 16.2215 19.3814 16.2215C19.3008 16.2215 19.2225 16.1803 19.1789 16.1062C19.1133 15.9942 19.1508 15.8507 19.2624 15.7851C20.9536 14.7923 21.8133 14.0395 22.0238 13.3462Z" fill="#9393FF"/>
                                            <path d="M19.3813 15.2074C19.3025 15.2074 19.2256 15.1678 19.1813 15.0957C19.1136 14.9854 19.148 14.8411 19.2583 14.7734C19.5345 14.6037 19.7758 14.4484 19.996 14.2986C20.1032 14.2258 20.2489 14.2537 20.3216 14.3607C20.3944 14.4678 20.3666 14.6136 20.2596 14.6863C20.0333 14.8401 19.786 14.9993 19.5037 15.1727C19.4655 15.1962 19.4231 15.2074 19.3813 15.2074V15.2074Z" fill="#9393FF"/>
                                            <path d="M19.3812 13.4436C19.2918 13.4436 19.2064 13.3922 19.1674 13.3054C19.1142 13.1874 19.1668 13.0486 19.2848 12.9955C19.6547 12.8289 19.9883 12.6536 20.2766 12.4743C20.3866 12.406 20.5311 12.4397 20.5994 12.5495C20.6677 12.6595 20.634 12.804 20.5242 12.8724C20.2183 13.0626 19.8661 13.2478 19.4773 13.4229C19.4461 13.4369 19.4134 13.4436 19.3812 13.4436V13.4436Z" fill="#FF9393"/>
                                            <path d="M18.0681 6.20699C17.9542 6.17001 17.837 6.2549 17.837 6.37462V9.93215C17.837 9.99623 17.8721 10.055 17.9281 10.0862C18.6779 10.5038 19.3408 10.9801 19.904 11.4957C19.4371 11.7274 18.9017 11.946 18.3048 12.149C18.1621 12.1976 18.0658 12.3317 18.0658 12.4826V19.437C18.0658 19.6473 18.2886 19.7838 18.4756 19.6874C20.6923 18.5446 22.0239 17.1709 22.0239 16.0793V9.21749C22.0239 8.0608 20.5282 7.00593 18.0681 6.20699Z" fill="url(#paint1_linear_4516_5327)"/>
                                            <path d="M16.1433 20.4084H4.77616C4.63975 20.4084 4.53241 20.2926 4.54225 20.1567L5.491 7.27685C5.49991 7.1545 5.6021 7.05981 5.72491 7.05981H15.1946C15.3174 7.05981 15.4191 7.1545 15.4285 7.27685L16.3768 20.1567C16.3871 20.2926 16.2793 20.4084 16.1433 20.4084Z" fill="#FFAA66"/>
                                            <path d="M11.0447 10.5326C10.9228 10.6545 10.7608 10.7216 10.5884 10.7216C10.4161 10.7216 10.2541 10.6545 10.1322 10.5326C10.0104 10.4107 9.94324 10.2487 9.94324 10.0763C9.94324 9.90399 10.0104 9.74199 10.1322 9.62011C10.3838 9.36849 10.7932 9.36854 11.0447 9.62011L11.2104 9.78586L11.5419 9.45441L11.3761 9.28866C11.2188 9.13135 11.0257 9.03188 10.8228 8.98847V8.53955H10.3541V8.98852C10.1512 9.03188 9.95805 9.13139 9.80074 9.28866C9.59036 9.49908 9.47449 9.77883 9.47449 10.0763C9.47449 10.3739 9.59036 10.6537 9.80074 10.864C9.95472 11.018 10.146 11.1211 10.3541 11.1655V11.6131H10.8228V11.1655C11.0309 11.1211 11.2221 11.018 11.3761 10.864L11.5419 10.6983L11.2104 10.3668L11.0447 10.5326Z" fill="white"/>
                                            <path d="M7.44153 7.05981H8.37903V8.87763C8.37903 9.13638 8.16903 9.34638 7.91028 9.34638C7.65153 9.34638 7.44153 9.13638 7.44153 8.87763V7.05981Z" fill="#FF9C33"/>
                                            <path d="M13.4781 7.05981V8.87763C13.4781 9.13638 13.2681 9.34638 13.0094 9.34638C12.7502 9.34638 12.5406 9.13638 12.5406 8.87763V7.05981H13.4781Z" fill="#FF9C33"/>
                                            <path d="M10.9984 13.5775C12.884 13.4304 14.6278 13.183 16.1577 12.8558C16.3769 12.8089 16.5833 12.9764 16.5833 13.2005V20.4353C16.5833 20.5874 16.4858 20.7222 16.3414 20.7701C14.7835 21.2871 12.9957 21.6755 11.0566 21.8444C10.8508 21.8623 10.6738 21.6995 10.6738 21.4929V13.9288C10.6738 13.745 10.8151 13.5918 10.9984 13.5775V13.5775Z" fill="#D8D8FF"/>
                                            <path d="M15.4929 20.1811C15.3913 20.1811 15.2977 20.1146 15.2679 20.0122C15.2318 19.8879 15.3032 19.7578 15.4274 19.7216C15.4987 19.7009 15.5694 19.6798 15.6398 19.6586C15.7636 19.621 15.8946 19.6911 15.9321 19.815C15.9696 19.9389 15.8995 20.0697 15.7756 20.1072C15.7036 20.129 15.6313 20.1505 15.5584 20.1717C15.5366 20.1781 15.5146 20.1811 15.4929 20.1811V20.1811Z" fill="#8282FF"/>
                                            <path d="M15.4929 19.4651C15.3913 19.4651 15.2977 19.3986 15.2679 19.2961C15.2318 19.1719 15.3032 19.0418 15.4274 19.0056C15.4987 18.9848 15.5694 18.9638 15.6398 18.9425C15.7636 18.9049 15.8946 18.9751 15.9321 19.0989C15.9696 19.2228 15.8995 19.3537 15.7756 19.3912C15.7036 19.413 15.6313 19.4344 15.5584 19.4556C15.5366 19.462 15.5146 19.4651 15.4929 19.4651V19.4651Z" fill="#8282FF"/>
                                            <path d="M16.0011 15.6087L14.8434 14.5739C14.8277 14.5598 14.8076 14.5527 14.7878 14.5541L14.2639 14.5906C14.2315 14.5929 14.2048 14.6166 14.1978 14.6498C14.1563 14.846 13.9983 14.997 13.7931 15.013C13.586 15.0292 13.3922 14.9033 13.3049 14.713C13.29 14.6807 13.2572 14.6607 13.2233 14.6631L12.6622 14.7021C12.6407 14.7036 12.6207 14.714 12.6071 14.7308L11.5495 16.0345C11.5196 16.0715 11.5257 16.1262 11.5632 16.1566L12.2405 16.7049C12.2768 16.7343 12.3301 16.7283 12.359 16.6915L12.7033 16.2534L12.643 18.6497C12.6416 18.7057 12.6911 18.7494 12.7465 18.7411L15.0027 18.4026C15.0469 18.396 15.0795 18.3579 15.0794 18.3132L15.074 16.0106L15.4573 16.3438C15.4903 16.3725 15.5408 16.3668 15.5666 16.3314L16.0137 15.7194C16.038 15.6862 16.0324 15.6366 16.0011 15.6087V15.6087Z" fill="#FFAA66"/>
                                            <path d="M12.9243 20.3039C13.5523 20.3039 14.0615 19.7948 14.0615 19.1667C14.0615 18.5387 13.5523 18.0295 12.9243 18.0295C12.2962 18.0295 11.7871 18.5387 11.7871 19.1667C11.7871 19.7948 12.2962 20.3039 12.9243 20.3039Z" fill="#FF6C6C"/>
                                            <path d="M12.7735 19.6973C12.7114 19.6973 12.6518 19.6726 12.6078 19.6287L12.3171 19.3379C12.2255 19.2464 12.2255 19.098 12.3171 19.0065C12.4086 18.915 12.5571 18.915 12.6485 19.0065L12.7735 19.1315L13.2002 18.7049C13.2917 18.6134 13.4402 18.6134 13.5316 18.7049C13.6232 18.7964 13.6232 18.9448 13.5316 19.0363L12.9392 19.6287C12.8953 19.6726 12.8357 19.6973 12.7735 19.6973V19.6973Z" fill="white"/>
                                            <path d="M14.3828 16.2914C14.2533 16.2914 14.1484 16.1864 14.1484 16.057V15.9878C14.1484 15.8584 14.2533 15.7534 14.3828 15.7534C14.5123 15.7534 14.6172 15.8584 14.6172 15.9878V16.057C14.6172 16.1864 14.5122 16.2914 14.3828 16.2914Z" fill="#FFD5BA"/>
                                            <path d="M13.0091 8.50233C12.7502 8.50233 12.5404 8.29243 12.5404 8.03358V4.51604C12.5404 3.36872 11.607 2.4353 10.4596 2.4353C9.31233 2.4353 8.37891 3.36872 8.37891 4.51604V8.03358C8.37891 8.29243 8.16905 8.50233 7.91016 8.50233C7.65127 8.50233 7.44141 8.29243 7.44141 8.03358V4.51604C7.44141 2.85179 8.79539 1.4978 10.4596 1.4978C12.1239 1.4978 13.4779 2.85179 13.4779 4.51604V8.03358C13.4779 8.29248 13.268 8.50233 13.0091 8.50233Z" fill="#FFD5BA"/>
                                            <path d="M8.8133 19.1614H6.17639C6.04697 19.1614 5.94202 19.0564 5.94202 18.927C5.94202 18.7976 6.04697 18.6926 6.17639 18.6926H8.8133C8.94272 18.6926 9.04767 18.7976 9.04767 18.927C9.04767 19.0564 8.94272 19.1614 8.8133 19.1614Z" fill="#FFD5BA"/>
                                            <path d="M8.86591 18.2642H6.229C6.09958 18.2642 5.99463 18.1592 5.99463 18.0298C5.99463 17.9004 6.09958 17.7954 6.229 17.7954H8.86591C8.99533 17.7954 9.10028 17.9004 9.10028 18.0298C9.10028 18.1592 8.99533 18.2642 8.86591 18.2642Z" fill="#FFD5BA"/>
                                            <path d="M7.0261 17.3667H6.28149C6.15207 17.3667 6.04712 17.2617 6.04712 17.1323C6.04712 17.0029 6.15207 16.8979 6.28149 16.8979H7.0261C7.15553 16.8979 7.26048 17.0029 7.26048 17.1323C7.26048 17.2617 7.15553 17.3667 7.0261 17.3667Z" fill="#FFD5BA"/>
                                            <path d="M16.525 5.72504C15.5939 5.5028 14.5715 5.31202 13.478 5.15696V4.51604C13.478 2.85179 12.124 1.4978 10.4597 1.4978C10.128 1.4978 9.80901 1.55237 9.51023 1.65169C9.21145 1.55237 8.89242 1.4978 8.56073 1.4978C6.89648 1.4978 5.5425 2.85179 5.5425 4.51604V7.05976H3.82584C3.70307 7.05976 3.60112 7.15449 3.59212 7.27693L2.64347 20.1568C2.63348 20.2927 2.74097 20.4084 2.87723 20.4084H10.6739V21.4929C10.6739 21.6995 10.8509 21.8623 11.0567 21.8444C12.9958 21.6755 14.7836 21.2871 16.3415 20.7701C16.4859 20.7222 16.5833 20.5874 16.5833 20.4353V13.2006C16.5833 12.9764 16.377 12.809 16.1578 12.8558C16.0543 12.878 15.9496 12.8997 15.8441 12.9211L15.5559 9.00638C15.852 9.09694 16.1408 9.19538 16.4214 9.30165C16.5367 9.34533 16.6598 9.2603 16.6598 9.13702V5.89646C16.6598 5.81504 16.6042 5.74397 16.525 5.72504V5.72504ZM7.4415 7.05976H6.48V4.51604C6.48 3.47265 7.25207 2.6064 8.25487 2.45799C7.75087 2.99757 7.4415 3.72118 7.4415 4.51604V7.05976ZM8.379 4.51604C8.379 3.71068 8.83926 3.01126 9.51023 2.66555C10.1812 3.01126 10.6415 3.71068 10.6415 4.51604V7.05976H8.379V4.51604ZM12.5405 7.05976H11.579V4.51604C11.579 3.72118 11.2696 2.99757 10.7656 2.45799C11.7684 2.6064 12.5405 3.47265 12.5405 4.51604V7.05976Z" fill="url(#paint2_linear_4516_5327)"/>
                                            <path d="M2.97083 3.40723H2.50208C2.24361 3.40723 2.03333 3.19695 2.03333 2.93848V2.46973C2.03333 2.21126 2.24361 2.00098 2.50208 2.00098H2.97083C3.22929 2.00098 3.43958 2.21126 3.43958 2.46973V2.93848C3.43958 3.19695 3.22929 3.40723 2.97083 3.40723V3.40723ZM2.50208 2.46973V2.93876L2.97083 2.93848V2.46973H2.50208Z" fill="#FF6C6C"/>
                                            <path d="M22.1149 20.8145H21.6461C21.3876 20.8145 21.1774 20.6042 21.1774 20.3457V19.877C21.1774 19.6185 21.3876 19.4082 21.6461 19.4082H22.1149C22.3733 19.4082 22.5836 19.6185 22.5836 19.877V20.3457C22.5836 20.6042 22.3733 20.8145 22.1149 20.8145ZM21.6461 19.877V20.346L22.1149 20.3457V19.877H21.6461Z" fill="#FF6C6C"/>
                                            <path d="M16.8109 4.39062H16.3422C16.0837 4.39062 15.8734 4.18034 15.8734 3.92188V3.45312C15.8734 3.19466 16.0837 2.98438 16.3422 2.98438H16.8109C17.0694 2.98438 17.2797 3.19466 17.2797 3.45312V3.92188C17.2797 4.18034 17.0694 4.39062 16.8109 4.39062ZM16.3422 3.45312V3.92216L16.8109 3.92188V3.45312H16.3422Z" fill="#6C6CFF"/>
                                            <path d="M3.7439 5.73242C3.6839 5.73242 3.62394 5.70955 3.57815 5.6638L3.50727 5.59292C3.37935 5.46495 3.17104 5.46495 3.04297 5.59292L2.9721 5.6638C2.88055 5.7553 2.73219 5.7553 2.64065 5.6638C2.5949 5.618 2.57202 5.55805 2.57202 5.49805C2.57202 5.43805 2.5949 5.37809 2.64065 5.3323L2.71152 5.26142C2.77354 5.19941 2.80771 5.11695 2.80771 5.0293C2.80771 4.94164 2.77354 4.85919 2.71157 4.79717L2.64065 4.7263C2.5949 4.6805 2.57202 4.62055 2.57202 4.56055C2.57202 4.50055 2.5949 4.44059 2.64065 4.3948C2.73219 4.3033 2.88055 4.3033 2.9721 4.3948L3.04297 4.46567C3.17094 4.59364 3.37926 4.59364 3.50722 4.46567L3.5781 4.3948C3.66965 4.3033 3.81801 4.3033 3.90955 4.3948C3.9553 4.44059 3.97818 4.50055 3.97818 4.56055C3.97818 4.62055 3.9553 4.6805 3.90955 4.7263L3.83868 4.79717C3.71066 4.92514 3.71066 5.13345 3.83868 5.26142L3.90955 5.3323C3.9553 5.37809 3.97818 5.43805 3.97818 5.49805C3.97818 5.55805 3.9553 5.618 3.90955 5.6638C3.86385 5.70955 3.8039 5.73242 3.7439 5.73242V5.73242Z" fill="#FF9C33"/>
                                            <path d="M9.3708 23.1479C9.3108 23.1479 9.25085 23.1251 9.20505 23.0793L9.13418 23.0084C9.00621 22.8805 8.7979 22.8805 8.66993 23.0084L8.59905 23.0793C8.50751 23.1708 8.35915 23.1708 8.2676 23.0793C8.22185 23.0335 8.19897 22.9736 8.19897 22.9136C8.19897 22.8536 8.22185 22.7936 8.2676 22.7478L8.33847 22.6769C8.46649 22.549 8.46649 22.3407 8.33847 22.2127L8.2676 22.1418C8.22185 22.096 8.19897 22.0361 8.19897 21.9761C8.19897 21.9161 8.22185 21.8561 8.2676 21.8103C8.35915 21.7188 8.50751 21.7188 8.59905 21.8103L8.66993 21.8812C8.79785 22.0092 9.00616 22.0092 9.13422 21.8812L9.2051 21.8103C9.29665 21.7188 9.44501 21.7188 9.53655 21.8103C9.5823 21.8561 9.60518 21.9161 9.60518 21.9761C9.60518 22.0361 9.5823 22.096 9.53655 22.1418L9.46568 22.2127C9.40366 22.2747 9.36949 22.3572 9.36949 22.4448C9.36949 22.5325 9.40366 22.6149 9.46563 22.6769L9.53655 22.7478C9.5823 22.7936 9.60518 22.8536 9.60518 22.9136C9.60518 22.9736 9.5823 23.0335 9.53655 23.0793C9.49076 23.125 9.4308 23.1479 9.3708 23.1479Z" fill="#FF9C33"/>
                                         
                                        </svg>
                                            
                                              
                                    </div>
                                    <div class="content-right">
                                        <div class="title">
                                            <h3 class="fw_4 secondary_color">Shopping</h3>
                                            <span class="secondary_color fw_4">25 Min Ago</span>
                                        </div>
                                        <div class="desc">
                                            <p class="secondary_color fw_4">Alipay gives you 20% offcoupon for all bills, applicable for bills paid through Alipay wallet!</p>
                                        </div>
                                    </div>
                                </div>
                                <div class="noti-list">
                                    <div class="icon-box bg_service-3">
                                        <svg width="16" height="16" viewBox="0 0 25 24" fill="none" xmlns="http://www.w3.org/2000/svg">
                                            <path d="M24.2838 7.48567C22.5636 -5.34697 15.3153 2.01241 6.99199 5.99402C4.62414 7.12675 1.38339 7.13603 0.529097 10.1115C-0.458746 13.5521 2.49213 15.7224 4.86696 17.5562C7.726 19.7638 7.32082 24.1061 11.9929 23.7198C12.874 23.647 13.9302 23.7352 14.4994 23.0587C16.8551 20.2588 17.5094 16.0487 20.5731 13.8156C22.7339 12.2406 24.6702 10.3686 24.2838 7.48567V7.48567Z" fill="url(#paint0_linear_4516_5327)"/>
                                            <path d="M11.1101 8.50233C10.8512 8.50233 10.6413 8.29243 10.6413 8.03358V4.51604C10.6413 3.36872 9.70791 2.4353 8.56059 2.4353C7.41328 2.4353 6.47986 3.36872 6.47986 4.51604V8.03358C6.47986 8.29243 6.27 8.50233 6.01111 8.50233C5.75222 8.50233 5.54236 8.29243 5.54236 8.03358V4.51604C5.54236 2.85179 6.89634 1.4978 8.56059 1.4978C10.2248 1.4978 11.5788 2.85179 11.5788 4.51604V8.03358C11.5788 8.29248 11.369 8.50233 11.1101 8.50233V8.50233Z" fill="#FFC498"/>
                                            <path d="M4.77612 20.4084H2.87707C2.74085 20.4084 2.63332 20.2927 2.64335 20.1568L3.59196 7.27699C3.60096 7.15455 3.70296 7.05981 3.82568 7.05981H5.72482L4.77612 20.4084Z" fill="#FF7300"/>
                                            <path d="M10.2019 1.98511C9.70002 2.02945 9.26681 2.20284 8.90198 2.46379C9.5587 2.57269 10.1121 2.99006 10.4085 3.56161C10.4256 3.56119 10.4425 3.56029 10.4596 3.56029C10.8392 3.56029 11.1951 3.663 11.5018 3.84131C11.3243 3.06712 10.8485 2.40586 10.2019 1.98511V1.98511Z" fill="#FFAA66"/>
                                            <path d="M13.3223 5.13473C14.475 5.29359 15.5495 5.49229 16.5249 5.72507C16.6042 5.74396 16.6598 5.81503 16.6598 5.8965V9.13706C16.6598 9.26034 16.5367 9.34537 16.4213 9.30168C15.46 8.93756 14.4044 8.66198 13.2743 8.50078C13.1872 8.48836 13.1222 8.41434 13.1222 8.3264V5.30939C13.1222 5.2027 13.2166 5.12015 13.3223 5.13473V5.13473Z" fill="#9393FF"/>
                                            <path d="M19.934 11.522C19.3646 10.9961 18.6909 10.5108 17.9281 10.086C17.8721 10.0548 17.837 9.99604 17.837 9.93201V6.37448C17.837 6.25486 17.9539 6.16978 18.0677 6.20672C20.528 7.0057 22.0239 8.06062 22.0239 9.21736L21.8832 11.1587L19.934 11.522Z" fill="#9393FF"/>
                                            <path d="M22.0238 13.3463L21.8386 14.0752L22.0238 14.2763V14.5922L21.9179 15.2644L22.0238 15.5222V16.0791C22.0238 17.1707 20.6922 18.5447 18.4754 19.6873C18.2885 19.7836 18.0657 19.6472 18.0657 19.4369V12.4824C18.0657 12.3314 18.1622 12.1974 18.3052 12.1486C20.6241 11.3602 22.0238 10.3364 22.0238 9.21753V13.3463Z" fill="#D8D8FF"/>
                                            <path d="M22.0238 14.592V15.522C21.4594 16.2172 20.5032 16.8463 19.4996 17.4355C19.4625 17.4575 19.4217 17.4678 19.3814 17.4678C19.3008 17.4678 19.2225 17.4266 19.1789 17.352C19.1133 17.2405 19.1508 17.0966 19.2624 17.0314C20.9536 16.0386 21.8133 15.2853 22.0238 14.592V14.592Z" fill="#9393FF"/>
                                            <path d="M22.0238 13.3462V14.2762C21.4589 14.9713 20.5032 15.6004 19.4996 16.1896C19.4625 16.2112 19.4217 16.2215 19.3814 16.2215C19.3008 16.2215 19.2225 16.1803 19.1789 16.1062C19.1133 15.9942 19.1508 15.8507 19.2624 15.7851C20.9536 14.7923 21.8133 14.0395 22.0238 13.3462Z" fill="#9393FF"/>
                                            <path d="M19.3813 15.2074C19.3025 15.2074 19.2256 15.1678 19.1813 15.0957C19.1136 14.9854 19.148 14.8411 19.2583 14.7734C19.5345 14.6037 19.7758 14.4484 19.996 14.2986C20.1032 14.2258 20.2489 14.2537 20.3216 14.3607C20.3944 14.4678 20.3666 14.6136 20.2596 14.6863C20.0333 14.8401 19.786 14.9993 19.5037 15.1727C19.4655 15.1962 19.4231 15.2074 19.3813 15.2074V15.2074Z" fill="#9393FF"/>
                                            <path d="M19.3812 13.4436C19.2918 13.4436 19.2064 13.3922 19.1674 13.3054C19.1142 13.1874 19.1668 13.0486 19.2848 12.9955C19.6547 12.8289 19.9883 12.6536 20.2766 12.4743C20.3866 12.406 20.5311 12.4397 20.5994 12.5495C20.6677 12.6595 20.634 12.804 20.5242 12.8724C20.2183 13.0626 19.8661 13.2478 19.4773 13.4229C19.4461 13.4369 19.4134 13.4436 19.3812 13.4436V13.4436Z" fill="#FF9393"/>
                                            <path d="M18.0681 6.20699C17.9542 6.17001 17.837 6.2549 17.837 6.37462V9.93215C17.837 9.99623 17.8721 10.055 17.9281 10.0862C18.6779 10.5038 19.3408 10.9801 19.904 11.4957C19.4371 11.7274 18.9017 11.946 18.3048 12.149C18.1621 12.1976 18.0658 12.3317 18.0658 12.4826V19.437C18.0658 19.6473 18.2886 19.7838 18.4756 19.6874C20.6923 18.5446 22.0239 17.1709 22.0239 16.0793V9.21749C22.0239 8.0608 20.5282 7.00593 18.0681 6.20699Z" fill="url(#paint1_linear_4516_5327)"/>
                                            <path d="M16.1433 20.4084H4.77616C4.63975 20.4084 4.53241 20.2926 4.54225 20.1567L5.491 7.27685C5.49991 7.1545 5.6021 7.05981 5.72491 7.05981H15.1946C15.3174 7.05981 15.4191 7.1545 15.4285 7.27685L16.3768 20.1567C16.3871 20.2926 16.2793 20.4084 16.1433 20.4084Z" fill="#FFAA66"/>
                                            <path d="M11.0447 10.5326C10.9228 10.6545 10.7608 10.7216 10.5884 10.7216C10.4161 10.7216 10.2541 10.6545 10.1322 10.5326C10.0104 10.4107 9.94324 10.2487 9.94324 10.0763C9.94324 9.90399 10.0104 9.74199 10.1322 9.62011C10.3838 9.36849 10.7932 9.36854 11.0447 9.62011L11.2104 9.78586L11.5419 9.45441L11.3761 9.28866C11.2188 9.13135 11.0257 9.03188 10.8228 8.98847V8.53955H10.3541V8.98852C10.1512 9.03188 9.95805 9.13139 9.80074 9.28866C9.59036 9.49908 9.47449 9.77883 9.47449 10.0763C9.47449 10.3739 9.59036 10.6537 9.80074 10.864C9.95472 11.018 10.146 11.1211 10.3541 11.1655V11.6131H10.8228V11.1655C11.0309 11.1211 11.2221 11.018 11.3761 10.864L11.5419 10.6983L11.2104 10.3668L11.0447 10.5326Z" fill="white"/>
                                            <path d="M7.44153 7.05981H8.37903V8.87763C8.37903 9.13638 8.16903 9.34638 7.91028 9.34638C7.65153 9.34638 7.44153 9.13638 7.44153 8.87763V7.05981Z" fill="#FF9C33"/>
                                            <path d="M13.4781 7.05981V8.87763C13.4781 9.13638 13.2681 9.34638 13.0094 9.34638C12.7502 9.34638 12.5406 9.13638 12.5406 8.87763V7.05981H13.4781Z" fill="#FF9C33"/>
                                            <path d="M10.9984 13.5775C12.884 13.4304 14.6278 13.183 16.1577 12.8558C16.3769 12.8089 16.5833 12.9764 16.5833 13.2005V20.4353C16.5833 20.5874 16.4858 20.7222 16.3414 20.7701C14.7835 21.2871 12.9957 21.6755 11.0566 21.8444C10.8508 21.8623 10.6738 21.6995 10.6738 21.4929V13.9288C10.6738 13.745 10.8151 13.5918 10.9984 13.5775V13.5775Z" fill="#D8D8FF"/>
                                            <path d="M15.4929 20.1811C15.3913 20.1811 15.2977 20.1146 15.2679 20.0122C15.2318 19.8879 15.3032 19.7578 15.4274 19.7216C15.4987 19.7009 15.5694 19.6798 15.6398 19.6586C15.7636 19.621 15.8946 19.6911 15.9321 19.815C15.9696 19.9389 15.8995 20.0697 15.7756 20.1072C15.7036 20.129 15.6313 20.1505 15.5584 20.1717C15.5366 20.1781 15.5146 20.1811 15.4929 20.1811V20.1811Z" fill="#8282FF"/>
                                            <path d="M15.4929 19.4651C15.3913 19.4651 15.2977 19.3986 15.2679 19.2961C15.2318 19.1719 15.3032 19.0418 15.4274 19.0056C15.4987 18.9848 15.5694 18.9638 15.6398 18.9425C15.7636 18.9049 15.8946 18.9751 15.9321 19.0989C15.9696 19.2228 15.8995 19.3537 15.7756 19.3912C15.7036 19.413 15.6313 19.4344 15.5584 19.4556C15.5366 19.462 15.5146 19.4651 15.4929 19.4651V19.4651Z" fill="#8282FF"/>
                                            <path d="M16.0011 15.6087L14.8434 14.5739C14.8277 14.5598 14.8076 14.5527 14.7878 14.5541L14.2639 14.5906C14.2315 14.5929 14.2048 14.6166 14.1978 14.6498C14.1563 14.846 13.9983 14.997 13.7931 15.013C13.586 15.0292 13.3922 14.9033 13.3049 14.713C13.29 14.6807 13.2572 14.6607 13.2233 14.6631L12.6622 14.7021C12.6407 14.7036 12.6207 14.714 12.6071 14.7308L11.5495 16.0345C11.5196 16.0715 11.5257 16.1262 11.5632 16.1566L12.2405 16.7049C12.2768 16.7343 12.3301 16.7283 12.359 16.6915L12.7033 16.2534L12.643 18.6497C12.6416 18.7057 12.6911 18.7494 12.7465 18.7411L15.0027 18.4026C15.0469 18.396 15.0795 18.3579 15.0794 18.3132L15.074 16.0106L15.4573 16.3438C15.4903 16.3725 15.5408 16.3668 15.5666 16.3314L16.0137 15.7194C16.038 15.6862 16.0324 15.6366 16.0011 15.6087V15.6087Z" fill="#FFAA66"/>
                                            <path d="M12.9243 20.3039C13.5523 20.3039 14.0615 19.7948 14.0615 19.1667C14.0615 18.5387 13.5523 18.0295 12.9243 18.0295C12.2962 18.0295 11.7871 18.5387 11.7871 19.1667C11.7871 19.7948 12.2962 20.3039 12.9243 20.3039Z" fill="#FF6C6C"/>
                                            <path d="M12.7735 19.6973C12.7114 19.6973 12.6518 19.6726 12.6078 19.6287L12.3171 19.3379C12.2255 19.2464 12.2255 19.098 12.3171 19.0065C12.4086 18.915 12.5571 18.915 12.6485 19.0065L12.7735 19.1315L13.2002 18.7049C13.2917 18.6134 13.4402 18.6134 13.5316 18.7049C13.6232 18.7964 13.6232 18.9448 13.5316 19.0363L12.9392 19.6287C12.8953 19.6726 12.8357 19.6973 12.7735 19.6973V19.6973Z" fill="white"/>
                                            <path d="M14.3828 16.2914C14.2533 16.2914 14.1484 16.1864 14.1484 16.057V15.9878C14.1484 15.8584 14.2533 15.7534 14.3828 15.7534C14.5123 15.7534 14.6172 15.8584 14.6172 15.9878V16.057C14.6172 16.1864 14.5122 16.2914 14.3828 16.2914Z" fill="#FFD5BA"/>
                                            <path d="M13.0091 8.50233C12.7502 8.50233 12.5404 8.29243 12.5404 8.03358V4.51604C12.5404 3.36872 11.607 2.4353 10.4596 2.4353C9.31233 2.4353 8.37891 3.36872 8.37891 4.51604V8.03358C8.37891 8.29243 8.16905 8.50233 7.91016 8.50233C7.65127 8.50233 7.44141 8.29243 7.44141 8.03358V4.51604C7.44141 2.85179 8.79539 1.4978 10.4596 1.4978C12.1239 1.4978 13.4779 2.85179 13.4779 4.51604V8.03358C13.4779 8.29248 13.268 8.50233 13.0091 8.50233Z" fill="#FFD5BA"/>
                                            <path d="M8.8133 19.1614H6.17639C6.04697 19.1614 5.94202 19.0564 5.94202 18.927C5.94202 18.7976 6.04697 18.6926 6.17639 18.6926H8.8133C8.94272 18.6926 9.04767 18.7976 9.04767 18.927C9.04767 19.0564 8.94272 19.1614 8.8133 19.1614Z" fill="#FFD5BA"/>
                                            <path d="M8.86591 18.2642H6.229C6.09958 18.2642 5.99463 18.1592 5.99463 18.0298C5.99463 17.9004 6.09958 17.7954 6.229 17.7954H8.86591C8.99533 17.7954 9.10028 17.9004 9.10028 18.0298C9.10028 18.1592 8.99533 18.2642 8.86591 18.2642Z" fill="#FFD5BA"/>
                                            <path d="M7.0261 17.3667H6.28149C6.15207 17.3667 6.04712 17.2617 6.04712 17.1323C6.04712 17.0029 6.15207 16.8979 6.28149 16.8979H7.0261C7.15553 16.8979 7.26048 17.0029 7.26048 17.1323C7.26048 17.2617 7.15553 17.3667 7.0261 17.3667Z" fill="#FFD5BA"/>
                                            <path d="M16.525 5.72504C15.5939 5.5028 14.5715 5.31202 13.478 5.15696V4.51604C13.478 2.85179 12.124 1.4978 10.4597 1.4978C10.128 1.4978 9.80901 1.55237 9.51023 1.65169C9.21145 1.55237 8.89242 1.4978 8.56073 1.4978C6.89648 1.4978 5.5425 2.85179 5.5425 4.51604V7.05976H3.82584C3.70307 7.05976 3.60112 7.15449 3.59212 7.27693L2.64347 20.1568C2.63348 20.2927 2.74097 20.4084 2.87723 20.4084H10.6739V21.4929C10.6739 21.6995 10.8509 21.8623 11.0567 21.8444C12.9958 21.6755 14.7836 21.2871 16.3415 20.7701C16.4859 20.7222 16.5833 20.5874 16.5833 20.4353V13.2006C16.5833 12.9764 16.377 12.809 16.1578 12.8558C16.0543 12.878 15.9496 12.8997 15.8441 12.9211L15.5559 9.00638C15.852 9.09694 16.1408 9.19538 16.4214 9.30165C16.5367 9.34533 16.6598 9.2603 16.6598 9.13702V5.89646C16.6598 5.81504 16.6042 5.74397 16.525 5.72504V5.72504ZM7.4415 7.05976H6.48V4.51604C6.48 3.47265 7.25207 2.6064 8.25487 2.45799C7.75087 2.99757 7.4415 3.72118 7.4415 4.51604V7.05976ZM8.379 4.51604C8.379 3.71068 8.83926 3.01126 9.51023 2.66555C10.1812 3.01126 10.6415 3.71068 10.6415 4.51604V7.05976H8.379V4.51604ZM12.5405 7.05976H11.579V4.51604C11.579 3.72118 11.2696 2.99757 10.7656 2.45799C11.7684 2.6064 12.5405 3.47265 12.5405 4.51604V7.05976Z" fill="url(#paint2_linear_4516_5327)"/>
                                            <path d="M2.97083 3.40723H2.50208C2.24361 3.40723 2.03333 3.19695 2.03333 2.93848V2.46973C2.03333 2.21126 2.24361 2.00098 2.50208 2.00098H2.97083C3.22929 2.00098 3.43958 2.21126 3.43958 2.46973V2.93848C3.43958 3.19695 3.22929 3.40723 2.97083 3.40723V3.40723ZM2.50208 2.46973V2.93876L2.97083 2.93848V2.46973H2.50208Z" fill="#FF6C6C"/>
                                            <path d="M22.1149 20.8145H21.6461C21.3876 20.8145 21.1774 20.6042 21.1774 20.3457V19.877C21.1774 19.6185 21.3876 19.4082 21.6461 19.4082H22.1149C22.3733 19.4082 22.5836 19.6185 22.5836 19.877V20.3457C22.5836 20.6042 22.3733 20.8145 22.1149 20.8145ZM21.6461 19.877V20.346L22.1149 20.3457V19.877H21.6461Z" fill="#FF6C6C"/>
                                            <path d="M16.8109 4.39062H16.3422C16.0837 4.39062 15.8734 4.18034 15.8734 3.92188V3.45312C15.8734 3.19466 16.0837 2.98438 16.3422 2.98438H16.8109C17.0694 2.98438 17.2797 3.19466 17.2797 3.45312V3.92188C17.2797 4.18034 17.0694 4.39062 16.8109 4.39062ZM16.3422 3.45312V3.92216L16.8109 3.92188V3.45312H16.3422Z" fill="#6C6CFF"/>
                                            <path d="M3.7439 5.73242C3.6839 5.73242 3.62394 5.70955 3.57815 5.6638L3.50727 5.59292C3.37935 5.46495 3.17104 5.46495 3.04297 5.59292L2.9721 5.6638C2.88055 5.7553 2.73219 5.7553 2.64065 5.6638C2.5949 5.618 2.57202 5.55805 2.57202 5.49805C2.57202 5.43805 2.5949 5.37809 2.64065 5.3323L2.71152 5.26142C2.77354 5.19941 2.80771 5.11695 2.80771 5.0293C2.80771 4.94164 2.77354 4.85919 2.71157 4.79717L2.64065 4.7263C2.5949 4.6805 2.57202 4.62055 2.57202 4.56055C2.57202 4.50055 2.5949 4.44059 2.64065 4.3948C2.73219 4.3033 2.88055 4.3033 2.9721 4.3948L3.04297 4.46567C3.17094 4.59364 3.37926 4.59364 3.50722 4.46567L3.5781 4.3948C3.66965 4.3033 3.81801 4.3033 3.90955 4.3948C3.9553 4.44059 3.97818 4.50055 3.97818 4.56055C3.97818 4.62055 3.9553 4.6805 3.90955 4.7263L3.83868 4.79717C3.71066 4.92514 3.71066 5.13345 3.83868 5.26142L3.90955 5.3323C3.9553 5.37809 3.97818 5.43805 3.97818 5.49805C3.97818 5.55805 3.9553 5.618 3.90955 5.6638C3.86385 5.70955 3.8039 5.73242 3.7439 5.73242V5.73242Z" fill="#FF9C33"/>
                                            <path d="M9.3708 23.1479C9.3108 23.1479 9.25085 23.1251 9.20505 23.0793L9.13418 23.0084C9.00621 22.8805 8.7979 22.8805 8.66993 23.0084L8.59905 23.0793C8.50751 23.1708 8.35915 23.1708 8.2676 23.0793C8.22185 23.0335 8.19897 22.9736 8.19897 22.9136C8.19897 22.8536 8.22185 22.7936 8.2676 22.7478L8.33847 22.6769C8.46649 22.549 8.46649 22.3407 8.33847 22.2127L8.2676 22.1418C8.22185 22.096 8.19897 22.0361 8.19897 21.9761C8.19897 21.9161 8.22185 21.8561 8.2676 21.8103C8.35915 21.7188 8.50751 21.7188 8.59905 21.8103L8.66993 21.8812C8.79785 22.0092 9.00616 22.0092 9.13422 21.8812L9.2051 21.8103C9.29665 21.7188 9.44501 21.7188 9.53655 21.8103C9.5823 21.8561 9.60518 21.9161 9.60518 21.9761C9.60518 22.0361 9.5823 22.096 9.53655 22.1418L9.46568 22.2127C9.40366 22.2747 9.36949 22.3572 9.36949 22.4448C9.36949 22.5325 9.40366 22.6149 9.46563 22.6769L9.53655 22.7478C9.5823 22.7936 9.60518 22.8536 9.60518 22.9136C9.60518 22.9736 9.5823 23.0335 9.53655 23.0793C9.49076 23.125 9.4308 23.1479 9.3708 23.1479Z" fill="#FF9C33"/>
                                         
                                        </svg>
                                            
                                              
                                    </div>
                                    <div class="content-right">
                                        <div class="title">
                                            <h3 class="fw_6">Shopping</h3>
                                            <span class="fw_6 on_surface_color">1 Hour  Ago</span>
                                        </div>
                                        <div class="desc">
                                            <p class="on_surface_color fw_4">Alipay gives you 20% offcoupon for all bills, applicable for bills paid through Alipay wallet!</p>
                                            <i class="dot"></i>
                                        </div>
                                    </div>
                                </div>
                                <div class="noti-list">
                                    <div class="icon-box bg_service-7">
                                        <svg width="16" height="16" viewBox="0 0 25 22" fill="none" xmlns="http://www.w3.org/2000/svg">
                                            <path d="M5.10792 2.89151V3.71843H2.76196V2.89151C2.76196 2.64696 2.9602 2.44873 3.20474 2.44873H4.66513C4.90968 2.44873 5.10792 2.64696 5.10792 2.89151Z" fill="#6D6D6D"/>
                                            <path d="M21.9048 2.89151V3.71843H19.5588V2.89151C19.5588 2.64696 19.7571 2.44873 20.0016 2.44873H21.462C21.7066 2.44873 21.9048 2.64696 21.9048 2.89151Z" fill="#6D6D6D"/>
                                            <path d="M15.7525 5.0683H8.91426C8.63245 5.0683 8.40393 4.83978 8.40393 4.55797V1.85661C8.40393 1.15315 8.97632 0.580811 9.67973 0.580811H14.987C15.6905 0.580811 16.2628 1.1532 16.2628 1.85661V4.55797C16.2628 4.83978 16.0343 5.0683 15.7525 5.0683ZM9.42454 4.04764H15.2421V1.85661C15.2421 1.71584 15.1276 1.60147 14.987 1.60147H9.67973C9.53906 1.60147 9.42459 1.71584 9.42459 1.85661V4.04764H9.42454Z" fill="#6D6D6D"/>
                                            <path d="M5.39564 19.5364V20.9087C5.39564 21.1906 5.16718 21.4191 4.88532 21.4191H2.62739C2.34553 21.4191 2.11707 21.1906 2.11707 20.9087V19.5364H5.39564Z" fill="#EA4E4E"/>
                                            <path d="M22.5498 19.5364V20.9087C22.5498 21.1906 22.3213 21.4191 22.0395 21.4191H19.7816C19.4997 21.4191 19.2712 21.1906 19.2712 20.9087V19.5364H22.5498Z" fill="#EA4E4E"/>
                                            <path d="M24.326 4.50845V19.2502C24.326 19.8139 23.869 20.2709 23.3053 20.2709H1.36148C0.797805 20.2709 0.34082 19.8139 0.34082 19.2502V4.50845C0.34082 3.94478 0.797758 3.48779 1.36148 3.48779H23.3053C23.869 3.48779 24.326 3.94478 24.326 4.50845Z" fill="#F96464"/>
                                            <g opacity="0.4">
                                            <path d="M1.91377 7.6168C1.63191 7.6168 1.40344 7.38834 1.40344 7.10648V5.27498C1.40344 4.99312 1.63191 4.76465 1.91377 4.76465C2.19563 4.76465 2.4241 4.99312 2.4241 5.27498V7.10648C2.4241 7.38834 2.19563 7.6168 1.91377 7.6168Z" fill="white"/>
                                            </g>
                                            <g opacity="0.08">
                                            <path d="M24.326 4.50943V19.2501C24.326 19.814 23.8693 20.2707 23.3054 20.2707H21.5116C22.0755 20.2707 22.5323 19.814 22.5323 19.2501V4.50943C22.5323 3.94552 22.0755 3.48877 21.5116 3.48877H23.3054C23.8693 3.48877 24.326 3.94552 24.326 4.50943Z" fill="black"/>
                                            </g>
                                            <path d="M12.3335 17.3581C15.3597 17.3581 17.8129 14.9048 17.8129 11.8786C17.8129 8.8524 15.3597 6.39917 12.3335 6.39917C9.30724 6.39917 6.854 8.8524 6.854 11.8786C6.854 14.9048 9.30724 17.3581 12.3335 17.3581Z" fill="#F2F0F0"/>
                                            <path d="M16.0116 11.3237V12.4362C16.0116 12.718 15.7831 12.9465 15.5012 12.9465H13.3987V15.0464C13.3987 15.3283 13.1702 15.5568 12.8884 15.5568H11.7758C11.494 15.5568 11.2655 15.3283 11.2655 15.0464V12.9465H9.1656C8.88374 12.9465 8.65527 12.718 8.65527 12.4362V11.3237C8.65527 11.0418 8.88374 10.8133 9.1656 10.8133H11.2656V8.71077C11.2656 8.42891 11.494 8.20044 11.7759 8.20044H12.8884C13.1703 8.20044 13.3987 8.42891 13.3987 8.71077V10.8133H15.5013C15.7831 10.8133 16.0116 11.0418 16.0116 11.3237Z" fill="#F96464"/>
                                        </svg>
                                    </div>
                                    <div class="content-right">
                                        <div class="title">
                                            <h3 class="fw_4 secondary_color">Medical</h3>
                                            <span class="secondary_color fw_4">15 Hour Ago</span>
                                        </div>
                                        <div class="desc">
                                            <p class="secondary_color fw_4">Alipay gives you 20% offcoupon for all bills, applicable for bills paid through Alipay wallet!</p>
                                        </div>
                                    </div>
                                </div>
                                <div class="noti-list">
                                    <div class="icon-box bg_service-6">
                                        <svg width="16" height="16" viewBox="0 0 16 16" fill="none" xmlns="http://www.w3.org/2000/svg">
                                            <path d="M7.99995 14.7062C12.0609 14.7062 15.353 11.4141 15.353 7.35309C15.353 3.29209 12.0609 0 7.99995 0C3.93894 0 0.646851 3.29209 0.646851 7.35309C0.646851 11.4141 3.93894 14.7062 7.99995 14.7062Z" fill="#F7B239"/>
                                            <path d="M7.99997 12.1931C10.673 12.1931 12.8399 10.0261 12.8399 7.35312C12.8399 4.6801 10.673 2.51318 7.99997 2.51318C5.32695 2.51318 3.16003 4.6801 3.16003 7.35312C3.16003 10.0261 5.32695 12.1931 7.99997 12.1931Z" fill="#E09B2D"/>
                                            <path d="M14.6157 15.1809C14.6307 15.2373 14.638 15.294 14.638 15.3495C14.638 15.637 14.4463 15.8997 14.1558 15.9776C13.8089 16.0706 13.4521 15.8646 13.3591 15.5178L12.2661 11.4386C12.1731 11.0918 12.3791 10.7349 12.726 10.6419C13.0732 10.549 13.4297 10.755 13.5227 11.1022L14.6157 15.1809Z" fill="#F24C8F"/>
                                            <path d="M2.4596 11.5182L3.01855 11.668L4.49394 6.16149L3.93499 6.01173L2.4596 11.5182Z" fill="#CCCCCC"/>
                                            <path d="M11.6446 7.71971L12.4469 10.7156L13.0059 10.5659L12.2036 7.57L11.6446 7.71971Z" fill="#CCCCCC"/>
                                            <path d="M5.26403 2.1712C6.18881 2.41888 6.60972 3.8456 6.20463 5.3572C5.79953 6.86917 4.88478 7.28545 3.96 7.03776C3.03559 6.79007 2.4515 5.97217 2.85659 4.4602C3.26169 2.94823 4.33963 1.92351 5.26403 2.1712Z" fill="#E6E6E6"/>
                                            <path d="M2.9944 10.642C3.34162 10.7349 3.54727 11.0918 3.45427 11.4386L2.36168 15.5178C2.28374 15.8083 2.02099 16 1.73359 16C1.67802 16 1.6213 15.9927 1.56499 15.9776C1.21777 15.8847 1.01174 15.5278 1.10471 15.181L2.19771 11.1022C2.29068 10.755 2.64755 10.549 2.9944 10.642Z" fill="#F24C8F"/>
                                            <path d="M13.0658 6.02202L12.141 2.57046C12.1045 2.4344 11.9629 2.35446 11.8268 2.39515C11.6951 2.43455 11.6237 2.57771 11.6592 2.71046L12.3966 5.46168C12.4517 5.66743 12.3296 5.87893 12.1239 5.93408L12.1235 5.93415C11.9177 5.98937 11.7061 5.86721 11.651 5.66143L10.911 2.89987C10.8745 2.76371 10.7327 2.6838 10.5967 2.72458C10.465 2.76405 10.3937 2.90718 10.4293 3.0399L11.1666 5.79137C11.2217 5.99715 11.0996 6.20865 10.8938 6.26383C10.688 6.31896 10.4766 6.19687 10.4214 5.99108L9.68139 3.22937C9.64493 3.09324 9.5033 3.01337 9.36721 3.05405C9.23552 3.09346 9.16408 3.23658 9.19964 3.36933L10.1216 6.81049C10.2269 7.20383 10.479 7.53255 10.8316 7.73615C11.0665 7.87177 11.327 7.94102 11.5912 7.94102C11.7236 7.94102 11.857 7.92358 11.9883 7.8884C12.6534 7.71015 13.1178 7.10524 13.1178 6.4174C13.1178 6.28349 13.1003 6.15027 13.0658 6.02202Z" fill="#E6E6E6"/>
                                        </svg>
                                            
                                              
                                    </div>
                                    <div class="content-right">
                                        <div class="title">
                                            <h3 class="fw_4 secondary_color">Travel</h3>
                                            <span class="secondary_color fw_4">1 Day Ago</span>
                                        </div>
                                        <div class="desc">
                                            <p class="secondary_color fw_4">Alipay gives you 20% offcoupon for all bills, applicable for bills paid through Alipay wallet!</p>
                                        </div>
                                    </div>
                                </div>
                                <div class="noti-list">
                                    <div class="icon-box bg_service-3">
                                        <svg width="16" height="16" viewBox="0 0 25 24" fill="none" xmlns="http://www.w3.org/2000/svg">
                                            <path d="M24.2838 7.48567C22.5636 -5.34697 15.3153 2.01241 6.99199 5.99402C4.62414 7.12675 1.38339 7.13603 0.529097 10.1115C-0.458746 13.5521 2.49213 15.7224 4.86696 17.5562C7.726 19.7638 7.32082 24.1061 11.9929 23.7198C12.874 23.647 13.9302 23.7352 14.4994 23.0587C16.8551 20.2588 17.5094 16.0487 20.5731 13.8156C22.7339 12.2406 24.6702 10.3686 24.2838 7.48567V7.48567Z" fill="url(#paint0_linear_4516_5327)"/>
                                            <path d="M11.1101 8.50233C10.8512 8.50233 10.6413 8.29243 10.6413 8.03358V4.51604C10.6413 3.36872 9.70791 2.4353 8.56059 2.4353C7.41328 2.4353 6.47986 3.36872 6.47986 4.51604V8.03358C6.47986 8.29243 6.27 8.50233 6.01111 8.50233C5.75222 8.50233 5.54236 8.29243 5.54236 8.03358V4.51604C5.54236 2.85179 6.89634 1.4978 8.56059 1.4978C10.2248 1.4978 11.5788 2.85179 11.5788 4.51604V8.03358C11.5788 8.29248 11.369 8.50233 11.1101 8.50233V8.50233Z" fill="#FFC498"/>
                                            <path d="M4.77612 20.4084H2.87707C2.74085 20.4084 2.63332 20.2927 2.64335 20.1568L3.59196 7.27699C3.60096 7.15455 3.70296 7.05981 3.82568 7.05981H5.72482L4.77612 20.4084Z" fill="#FF7300"/>
                                            <path d="M10.2019 1.98511C9.70002 2.02945 9.26681 2.20284 8.90198 2.46379C9.5587 2.57269 10.1121 2.99006 10.4085 3.56161C10.4256 3.56119 10.4425 3.56029 10.4596 3.56029C10.8392 3.56029 11.1951 3.663 11.5018 3.84131C11.3243 3.06712 10.8485 2.40586 10.2019 1.98511V1.98511Z" fill="#FFAA66"/>
                                            <path d="M13.3223 5.13473C14.475 5.29359 15.5495 5.49229 16.5249 5.72507C16.6042 5.74396 16.6598 5.81503 16.6598 5.8965V9.13706C16.6598 9.26034 16.5367 9.34537 16.4213 9.30168C15.46 8.93756 14.4044 8.66198 13.2743 8.50078C13.1872 8.48836 13.1222 8.41434 13.1222 8.3264V5.30939C13.1222 5.2027 13.2166 5.12015 13.3223 5.13473V5.13473Z" fill="#9393FF"/>
                                            <path d="M19.934 11.522C19.3646 10.9961 18.6909 10.5108 17.9281 10.086C17.8721 10.0548 17.837 9.99604 17.837 9.93201V6.37448C17.837 6.25486 17.9539 6.16978 18.0677 6.20672C20.528 7.0057 22.0239 8.06062 22.0239 9.21736L21.8832 11.1587L19.934 11.522Z" fill="#9393FF"/>
                                            <path d="M22.0238 13.3463L21.8386 14.0752L22.0238 14.2763V14.5922L21.9179 15.2644L22.0238 15.5222V16.0791C22.0238 17.1707 20.6922 18.5447 18.4754 19.6873C18.2885 19.7836 18.0657 19.6472 18.0657 19.4369V12.4824C18.0657 12.3314 18.1622 12.1974 18.3052 12.1486C20.6241 11.3602 22.0238 10.3364 22.0238 9.21753V13.3463Z" fill="#D8D8FF"/>
                                            <path d="M22.0238 14.592V15.522C21.4594 16.2172 20.5032 16.8463 19.4996 17.4355C19.4625 17.4575 19.4217 17.4678 19.3814 17.4678C19.3008 17.4678 19.2225 17.4266 19.1789 17.352C19.1133 17.2405 19.1508 17.0966 19.2624 17.0314C20.9536 16.0386 21.8133 15.2853 22.0238 14.592V14.592Z" fill="#9393FF"/>
                                            <path d="M22.0238 13.3462V14.2762C21.4589 14.9713 20.5032 15.6004 19.4996 16.1896C19.4625 16.2112 19.4217 16.2215 19.3814 16.2215C19.3008 16.2215 19.2225 16.1803 19.1789 16.1062C19.1133 15.9942 19.1508 15.8507 19.2624 15.7851C20.9536 14.7923 21.8133 14.0395 22.0238 13.3462Z" fill="#9393FF"/>
                                            <path d="M19.3813 15.2074C19.3025 15.2074 19.2256 15.1678 19.1813 15.0957C19.1136 14.9854 19.148 14.8411 19.2583 14.7734C19.5345 14.6037 19.7758 14.4484 19.996 14.2986C20.1032 14.2258 20.2489 14.2537 20.3216 14.3607C20.3944 14.4678 20.3666 14.6136 20.2596 14.6863C20.0333 14.8401 19.786 14.9993 19.5037 15.1727C19.4655 15.1962 19.4231 15.2074 19.3813 15.2074V15.2074Z" fill="#9393FF"/>
                                            <path d="M19.3812 13.4436C19.2918 13.4436 19.2064 13.3922 19.1674 13.3054C19.1142 13.1874 19.1668 13.0486 19.2848 12.9955C19.6547 12.8289 19.9883 12.6536 20.2766 12.4743C20.3866 12.406 20.5311 12.4397 20.5994 12.5495C20.6677 12.6595 20.634 12.804 20.5242 12.8724C20.2183 13.0626 19.8661 13.2478 19.4773 13.4229C19.4461 13.4369 19.4134 13.4436 19.3812 13.4436V13.4436Z" fill="#FF9393"/>
                                            <path d="M18.0681 6.20699C17.9542 6.17001 17.837 6.2549 17.837 6.37462V9.93215C17.837 9.99623 17.8721 10.055 17.9281 10.0862C18.6779 10.5038 19.3408 10.9801 19.904 11.4957C19.4371 11.7274 18.9017 11.946 18.3048 12.149C18.1621 12.1976 18.0658 12.3317 18.0658 12.4826V19.437C18.0658 19.6473 18.2886 19.7838 18.4756 19.6874C20.6923 18.5446 22.0239 17.1709 22.0239 16.0793V9.21749C22.0239 8.0608 20.5282 7.00593 18.0681 6.20699Z" fill="url(#paint1_linear_4516_5327)"/>
                                            <path d="M16.1433 20.4084H4.77616C4.63975 20.4084 4.53241 20.2926 4.54225 20.1567L5.491 7.27685C5.49991 7.1545 5.6021 7.05981 5.72491 7.05981H15.1946C15.3174 7.05981 15.4191 7.1545 15.4285 7.27685L16.3768 20.1567C16.3871 20.2926 16.2793 20.4084 16.1433 20.4084Z" fill="#FFAA66"/>
                                            <path d="M11.0447 10.5326C10.9228 10.6545 10.7608 10.7216 10.5884 10.7216C10.4161 10.7216 10.2541 10.6545 10.1322 10.5326C10.0104 10.4107 9.94324 10.2487 9.94324 10.0763C9.94324 9.90399 10.0104 9.74199 10.1322 9.62011C10.3838 9.36849 10.7932 9.36854 11.0447 9.62011L11.2104 9.78586L11.5419 9.45441L11.3761 9.28866C11.2188 9.13135 11.0257 9.03188 10.8228 8.98847V8.53955H10.3541V8.98852C10.1512 9.03188 9.95805 9.13139 9.80074 9.28866C9.59036 9.49908 9.47449 9.77883 9.47449 10.0763C9.47449 10.3739 9.59036 10.6537 9.80074 10.864C9.95472 11.018 10.146 11.1211 10.3541 11.1655V11.6131H10.8228V11.1655C11.0309 11.1211 11.2221 11.018 11.3761 10.864L11.5419 10.6983L11.2104 10.3668L11.0447 10.5326Z" fill="white"/>
                                            <path d="M7.44153 7.05981H8.37903V8.87763C8.37903 9.13638 8.16903 9.34638 7.91028 9.34638C7.65153 9.34638 7.44153 9.13638 7.44153 8.87763V7.05981Z" fill="#FF9C33"/>
                                            <path d="M13.4781 7.05981V8.87763C13.4781 9.13638 13.2681 9.34638 13.0094 9.34638C12.7502 9.34638 12.5406 9.13638 12.5406 8.87763V7.05981H13.4781Z" fill="#FF9C33"/>
                                            <path d="M10.9984 13.5775C12.884 13.4304 14.6278 13.183 16.1577 12.8558C16.3769 12.8089 16.5833 12.9764 16.5833 13.2005V20.4353C16.5833 20.5874 16.4858 20.7222 16.3414 20.7701C14.7835 21.2871 12.9957 21.6755 11.0566 21.8444C10.8508 21.8623 10.6738 21.6995 10.6738 21.4929V13.9288C10.6738 13.745 10.8151 13.5918 10.9984 13.5775V13.5775Z" fill="#D8D8FF"/>
                                            <path d="M15.4929 20.1811C15.3913 20.1811 15.2977 20.1146 15.2679 20.0122C15.2318 19.8879 15.3032 19.7578 15.4274 19.7216C15.4987 19.7009 15.5694 19.6798 15.6398 19.6586C15.7636 19.621 15.8946 19.6911 15.9321 19.815C15.9696 19.9389 15.8995 20.0697 15.7756 20.1072C15.7036 20.129 15.6313 20.1505 15.5584 20.1717C15.5366 20.1781 15.5146 20.1811 15.4929 20.1811V20.1811Z" fill="#8282FF"/>
                                            <path d="M15.4929 19.4651C15.3913 19.4651 15.2977 19.3986 15.2679 19.2961C15.2318 19.1719 15.3032 19.0418 15.4274 19.0056C15.4987 18.9848 15.5694 18.9638 15.6398 18.9425C15.7636 18.9049 15.8946 18.9751 15.9321 19.0989C15.9696 19.2228 15.8995 19.3537 15.7756 19.3912C15.7036 19.413 15.6313 19.4344 15.5584 19.4556C15.5366 19.462 15.5146 19.4651 15.4929 19.4651V19.4651Z" fill="#8282FF"/>
                                            <path d="M16.0011 15.6087L14.8434 14.5739C14.8277 14.5598 14.8076 14.5527 14.7878 14.5541L14.2639 14.5906C14.2315 14.5929 14.2048 14.6166 14.1978 14.6498C14.1563 14.846 13.9983 14.997 13.7931 15.013C13.586 15.0292 13.3922 14.9033 13.3049 14.713C13.29 14.6807 13.2572 14.6607 13.2233 14.6631L12.6622 14.7021C12.6407 14.7036 12.6207 14.714 12.6071 14.7308L11.5495 16.0345C11.5196 16.0715 11.5257 16.1262 11.5632 16.1566L12.2405 16.7049C12.2768 16.7343 12.3301 16.7283 12.359 16.6915L12.7033 16.2534L12.643 18.6497C12.6416 18.7057 12.6911 18.7494 12.7465 18.7411L15.0027 18.4026C15.0469 18.396 15.0795 18.3579 15.0794 18.3132L15.074 16.0106L15.4573 16.3438C15.4903 16.3725 15.5408 16.3668 15.5666 16.3314L16.0137 15.7194C16.038 15.6862 16.0324 15.6366 16.0011 15.6087V15.6087Z" fill="#FFAA66"/>
                                            <path d="M12.9243 20.3039C13.5523 20.3039 14.0615 19.7948 14.0615 19.1667C14.0615 18.5387 13.5523 18.0295 12.9243 18.0295C12.2962 18.0295 11.7871 18.5387 11.7871 19.1667C11.7871 19.7948 12.2962 20.3039 12.9243 20.3039Z" fill="#FF6C6C"/>
                                            <path d="M12.7735 19.6973C12.7114 19.6973 12.6518 19.6726 12.6078 19.6287L12.3171 19.3379C12.2255 19.2464 12.2255 19.098 12.3171 19.0065C12.4086 18.915 12.5571 18.915 12.6485 19.0065L12.7735 19.1315L13.2002 18.7049C13.2917 18.6134 13.4402 18.6134 13.5316 18.7049C13.6232 18.7964 13.6232 18.9448 13.5316 19.0363L12.9392 19.6287C12.8953 19.6726 12.8357 19.6973 12.7735 19.6973V19.6973Z" fill="white"/>
                                            <path d="M14.3828 16.2914C14.2533 16.2914 14.1484 16.1864 14.1484 16.057V15.9878C14.1484 15.8584 14.2533 15.7534 14.3828 15.7534C14.5123 15.7534 14.6172 15.8584 14.6172 15.9878V16.057C14.6172 16.1864 14.5122 16.2914 14.3828 16.2914Z" fill="#FFD5BA"/>
                                            <path d="M13.0091 8.50233C12.7502 8.50233 12.5404 8.29243 12.5404 8.03358V4.51604C12.5404 3.36872 11.607 2.4353 10.4596 2.4353C9.31233 2.4353 8.37891 3.36872 8.37891 4.51604V8.03358C8.37891 8.29243 8.16905 8.50233 7.91016 8.50233C7.65127 8.50233 7.44141 8.29243 7.44141 8.03358V4.51604C7.44141 2.85179 8.79539 1.4978 10.4596 1.4978C12.1239 1.4978 13.4779 2.85179 13.4779 4.51604V8.03358C13.4779 8.29248 13.268 8.50233 13.0091 8.50233Z" fill="#FFD5BA"/>
                                            <path d="M8.8133 19.1614H6.17639C6.04697 19.1614 5.94202 19.0564 5.94202 18.927C5.94202 18.7976 6.04697 18.6926 6.17639 18.6926H8.8133C8.94272 18.6926 9.04767 18.7976 9.04767 18.927C9.04767 19.0564 8.94272 19.1614 8.8133 19.1614Z" fill="#FFD5BA"/>
                                            <path d="M8.86591 18.2642H6.229C6.09958 18.2642 5.99463 18.1592 5.99463 18.0298C5.99463 17.9004 6.09958 17.7954 6.229 17.7954H8.86591C8.99533 17.7954 9.10028 17.9004 9.10028 18.0298C9.10028 18.1592 8.99533 18.2642 8.86591 18.2642Z" fill="#FFD5BA"/>
                                            <path d="M7.0261 17.3667H6.28149C6.15207 17.3667 6.04712 17.2617 6.04712 17.1323C6.04712 17.0029 6.15207 16.8979 6.28149 16.8979H7.0261C7.15553 16.8979 7.26048 17.0029 7.26048 17.1323C7.26048 17.2617 7.15553 17.3667 7.0261 17.3667Z" fill="#FFD5BA"/>
                                            <path d="M16.525 5.72504C15.5939 5.5028 14.5715 5.31202 13.478 5.15696V4.51604C13.478 2.85179 12.124 1.4978 10.4597 1.4978C10.128 1.4978 9.80901 1.55237 9.51023 1.65169C9.21145 1.55237 8.89242 1.4978 8.56073 1.4978C6.89648 1.4978 5.5425 2.85179 5.5425 4.51604V7.05976H3.82584C3.70307 7.05976 3.60112 7.15449 3.59212 7.27693L2.64347 20.1568C2.63348 20.2927 2.74097 20.4084 2.87723 20.4084H10.6739V21.4929C10.6739 21.6995 10.8509 21.8623 11.0567 21.8444C12.9958 21.6755 14.7836 21.2871 16.3415 20.7701C16.4859 20.7222 16.5833 20.5874 16.5833 20.4353V13.2006C16.5833 12.9764 16.377 12.809 16.1578 12.8558C16.0543 12.878 15.9496 12.8997 15.8441 12.9211L15.5559 9.00638C15.852 9.09694 16.1408 9.19538 16.4214 9.30165C16.5367 9.34533 16.6598 9.2603 16.6598 9.13702V5.89646C16.6598 5.81504 16.6042 5.74397 16.525 5.72504V5.72504ZM7.4415 7.05976H6.48V4.51604C6.48 3.47265 7.25207 2.6064 8.25487 2.45799C7.75087 2.99757 7.4415 3.72118 7.4415 4.51604V7.05976ZM8.379 4.51604C8.379 3.71068 8.83926 3.01126 9.51023 2.66555C10.1812 3.01126 10.6415 3.71068 10.6415 4.51604V7.05976H8.379V4.51604ZM12.5405 7.05976H11.579V4.51604C11.579 3.72118 11.2696 2.99757 10.7656 2.45799C11.7684 2.6064 12.5405 3.47265 12.5405 4.51604V7.05976Z" fill="url(#paint2_linear_4516_5327)"/>
                                            <path d="M2.97083 3.40723H2.50208C2.24361 3.40723 2.03333 3.19695 2.03333 2.93848V2.46973C2.03333 2.21126 2.24361 2.00098 2.50208 2.00098H2.97083C3.22929 2.00098 3.43958 2.21126 3.43958 2.46973V2.93848C3.43958 3.19695 3.22929 3.40723 2.97083 3.40723V3.40723ZM2.50208 2.46973V2.93876L2.97083 2.93848V2.46973H2.50208Z" fill="#FF6C6C"/>
                                            <path d="M22.1149 20.8145H21.6461C21.3876 20.8145 21.1774 20.6042 21.1774 20.3457V19.877C21.1774 19.6185 21.3876 19.4082 21.6461 19.4082H22.1149C22.3733 19.4082 22.5836 19.6185 22.5836 19.877V20.3457C22.5836 20.6042 22.3733 20.8145 22.1149 20.8145ZM21.6461 19.877V20.346L22.1149 20.3457V19.877H21.6461Z" fill="#FF6C6C"/>
                                            <path d="M16.8109 4.39062H16.3422C16.0837 4.39062 15.8734 4.18034 15.8734 3.92188V3.45312C15.8734 3.19466 16.0837 2.98438 16.3422 2.98438H16.8109C17.0694 2.98438 17.2797 3.19466 17.2797 3.45312V3.92188C17.2797 4.18034 17.0694 4.39062 16.8109 4.39062ZM16.3422 3.45312V3.92216L16.8109 3.92188V3.45312H16.3422Z" fill="#6C6CFF"/>
                                            <path d="M3.7439 5.73242C3.6839 5.73242 3.62394 5.70955 3.57815 5.6638L3.50727 5.59292C3.37935 5.46495 3.17104 5.46495 3.04297 5.59292L2.9721 5.6638C2.88055 5.7553 2.73219 5.7553 2.64065 5.6638C2.5949 5.618 2.57202 5.55805 2.57202 5.49805C2.57202 5.43805 2.5949 5.37809 2.64065 5.3323L2.71152 5.26142C2.77354 5.19941 2.80771 5.11695 2.80771 5.0293C2.80771 4.94164 2.77354 4.85919 2.71157 4.79717L2.64065 4.7263C2.5949 4.6805 2.57202 4.62055 2.57202 4.56055C2.57202 4.50055 2.5949 4.44059 2.64065 4.3948C2.73219 4.3033 2.88055 4.3033 2.9721 4.3948L3.04297 4.46567C3.17094 4.59364 3.37926 4.59364 3.50722 4.46567L3.5781 4.3948C3.66965 4.3033 3.81801 4.3033 3.90955 4.3948C3.9553 4.44059 3.97818 4.50055 3.97818 4.56055C3.97818 4.62055 3.9553 4.6805 3.90955 4.7263L3.83868 4.79717C3.71066 4.92514 3.71066 5.13345 3.83868 5.26142L3.90955 5.3323C3.9553 5.37809 3.97818 5.43805 3.97818 5.49805C3.97818 5.55805 3.9553 5.618 3.90955 5.6638C3.86385 5.70955 3.8039 5.73242 3.7439 5.73242V5.73242Z" fill="#FF9C33"/>
                                            <path d="M9.3708 23.1479C9.3108 23.1479 9.25085 23.1251 9.20505 23.0793L9.13418 23.0084C9.00621 22.8805 8.7979 22.8805 8.66993 23.0084L8.59905 23.0793C8.50751 23.1708 8.35915 23.1708 8.2676 23.0793C8.22185 23.0335 8.19897 22.9736 8.19897 22.9136C8.19897 22.8536 8.22185 22.7936 8.2676 22.7478L8.33847 22.6769C8.46649 22.549 8.46649 22.3407 8.33847 22.2127L8.2676 22.1418C8.22185 22.096 8.19897 22.0361 8.19897 21.9761C8.19897 21.9161 8.22185 21.8561 8.2676 21.8103C8.35915 21.7188 8.50751 21.7188 8.59905 21.8103L8.66993 21.8812C8.79785 22.0092 9.00616 22.0092 9.13422 21.8812L9.2051 21.8103C9.29665 21.7188 9.44501 21.7188 9.53655 21.8103C9.5823 21.8561 9.60518 21.9161 9.60518 21.9761C9.60518 22.0361 9.5823 22.096 9.53655 22.1418L9.46568 22.2127C9.40366 22.2747 9.36949 22.3572 9.36949 22.4448C9.36949 22.5325 9.40366 22.6149 9.46563 22.6769L9.53655 22.7478C9.5823 22.7936 9.60518 22.8536 9.60518 22.9136C9.60518 22.9736 9.5823 23.0335 9.53655 23.0793C9.49076 23.125 9.4308 23.1479 9.3708 23.1479Z" fill="#FF9C33"/>
                                         
                                        </svg>
                                            
                                              
                                    </div>
                                    <div class="content-right">
                                        <div class="title">
                                            <h3 class="fw_6">Shopping</h3>
                                            <span class="fw_6 on_surface_color">9/1/2023</span>
                                        </div>
                                        <div class="desc">
                                            <p class="on_surface_color fw_4">Alipay gives you 20% offcoupon for all bills, applicable for bills paid through Alipay wallet!</p>
                                            <i class="dot"></i>
                                        </div>
                                    </div>
                                </div>
                                <div class="noti-list">
                                    <div class="icon-box bg_service-3">
                                        <svg width="16" height="16" viewBox="0 0 25 24" fill="none" xmlns="http://www.w3.org/2000/svg">
                                            <path d="M24.2838 7.48567C22.5636 -5.34697 15.3153 2.01241 6.99199 5.99402C4.62414 7.12675 1.38339 7.13603 0.529097 10.1115C-0.458746 13.5521 2.49213 15.7224 4.86696 17.5562C7.726 19.7638 7.32082 24.1061 11.9929 23.7198C12.874 23.647 13.9302 23.7352 14.4994 23.0587C16.8551 20.2588 17.5094 16.0487 20.5731 13.8156C22.7339 12.2406 24.6702 10.3686 24.2838 7.48567V7.48567Z" fill="url(#paint0_linear_4516_5327)"/>
                                            <path d="M11.1101 8.50233C10.8512 8.50233 10.6413 8.29243 10.6413 8.03358V4.51604C10.6413 3.36872 9.70791 2.4353 8.56059 2.4353C7.41328 2.4353 6.47986 3.36872 6.47986 4.51604V8.03358C6.47986 8.29243 6.27 8.50233 6.01111 8.50233C5.75222 8.50233 5.54236 8.29243 5.54236 8.03358V4.51604C5.54236 2.85179 6.89634 1.4978 8.56059 1.4978C10.2248 1.4978 11.5788 2.85179 11.5788 4.51604V8.03358C11.5788 8.29248 11.369 8.50233 11.1101 8.50233V8.50233Z" fill="#FFC498"/>
                                            <path d="M4.77612 20.4084H2.87707C2.74085 20.4084 2.63332 20.2927 2.64335 20.1568L3.59196 7.27699C3.60096 7.15455 3.70296 7.05981 3.82568 7.05981H5.72482L4.77612 20.4084Z" fill="#FF7300"/>
                                            <path d="M10.2019 1.98511C9.70002 2.02945 9.26681 2.20284 8.90198 2.46379C9.5587 2.57269 10.1121 2.99006 10.4085 3.56161C10.4256 3.56119 10.4425 3.56029 10.4596 3.56029C10.8392 3.56029 11.1951 3.663 11.5018 3.84131C11.3243 3.06712 10.8485 2.40586 10.2019 1.98511V1.98511Z" fill="#FFAA66"/>
                                            <path d="M13.3223 5.13473C14.475 5.29359 15.5495 5.49229 16.5249 5.72507C16.6042 5.74396 16.6598 5.81503 16.6598 5.8965V9.13706C16.6598 9.26034 16.5367 9.34537 16.4213 9.30168C15.46 8.93756 14.4044 8.66198 13.2743 8.50078C13.1872 8.48836 13.1222 8.41434 13.1222 8.3264V5.30939C13.1222 5.2027 13.2166 5.12015 13.3223 5.13473V5.13473Z" fill="#9393FF"/>
                                            <path d="M19.934 11.522C19.3646 10.9961 18.6909 10.5108 17.9281 10.086C17.8721 10.0548 17.837 9.99604 17.837 9.93201V6.37448C17.837 6.25486 17.9539 6.16978 18.0677 6.20672C20.528 7.0057 22.0239 8.06062 22.0239 9.21736L21.8832 11.1587L19.934 11.522Z" fill="#9393FF"/>
                                            <path d="M22.0238 13.3463L21.8386 14.0752L22.0238 14.2763V14.5922L21.9179 15.2644L22.0238 15.5222V16.0791C22.0238 17.1707 20.6922 18.5447 18.4754 19.6873C18.2885 19.7836 18.0657 19.6472 18.0657 19.4369V12.4824C18.0657 12.3314 18.1622 12.1974 18.3052 12.1486C20.6241 11.3602 22.0238 10.3364 22.0238 9.21753V13.3463Z" fill="#D8D8FF"/>
                                            <path d="M22.0238 14.592V15.522C21.4594 16.2172 20.5032 16.8463 19.4996 17.4355C19.4625 17.4575 19.4217 17.4678 19.3814 17.4678C19.3008 17.4678 19.2225 17.4266 19.1789 17.352C19.1133 17.2405 19.1508 17.0966 19.2624 17.0314C20.9536 16.0386 21.8133 15.2853 22.0238 14.592V14.592Z" fill="#9393FF"/>
                                            <path d="M22.0238 13.3462V14.2762C21.4589 14.9713 20.5032 15.6004 19.4996 16.1896C19.4625 16.2112 19.4217 16.2215 19.3814 16.2215C19.3008 16.2215 19.2225 16.1803 19.1789 16.1062C19.1133 15.9942 19.1508 15.8507 19.2624 15.7851C20.9536 14.7923 21.8133 14.0395 22.0238 13.3462Z" fill="#9393FF"/>
                                            <path d="M19.3813 15.2074C19.3025 15.2074 19.2256 15.1678 19.1813 15.0957C19.1136 14.9854 19.148 14.8411 19.2583 14.7734C19.5345 14.6037 19.7758 14.4484 19.996 14.2986C20.1032 14.2258 20.2489 14.2537 20.3216 14.3607C20.3944 14.4678 20.3666 14.6136 20.2596 14.6863C20.0333 14.8401 19.786 14.9993 19.5037 15.1727C19.4655 15.1962 19.4231 15.2074 19.3813 15.2074V15.2074Z" fill="#9393FF"/>
                                            <path d="M19.3812 13.4436C19.2918 13.4436 19.2064 13.3922 19.1674 13.3054C19.1142 13.1874 19.1668 13.0486 19.2848 12.9955C19.6547 12.8289 19.9883 12.6536 20.2766 12.4743C20.3866 12.406 20.5311 12.4397 20.5994 12.5495C20.6677 12.6595 20.634 12.804 20.5242 12.8724C20.2183 13.0626 19.8661 13.2478 19.4773 13.4229C19.4461 13.4369 19.4134 13.4436 19.3812 13.4436V13.4436Z" fill="#FF9393"/>
                                            <path d="M18.0681 6.20699C17.9542 6.17001 17.837 6.2549 17.837 6.37462V9.93215C17.837 9.99623 17.8721 10.055 17.9281 10.0862C18.6779 10.5038 19.3408 10.9801 19.904 11.4957C19.4371 11.7274 18.9017 11.946 18.3048 12.149C18.1621 12.1976 18.0658 12.3317 18.0658 12.4826V19.437C18.0658 19.6473 18.2886 19.7838 18.4756 19.6874C20.6923 18.5446 22.0239 17.1709 22.0239 16.0793V9.21749C22.0239 8.0608 20.5282 7.00593 18.0681 6.20699Z" fill="url(#paint1_linear_4516_5327)"/>
                                            <path d="M16.1433 20.4084H4.77616C4.63975 20.4084 4.53241 20.2926 4.54225 20.1567L5.491 7.27685C5.49991 7.1545 5.6021 7.05981 5.72491 7.05981H15.1946C15.3174 7.05981 15.4191 7.1545 15.4285 7.27685L16.3768 20.1567C16.3871 20.2926 16.2793 20.4084 16.1433 20.4084Z" fill="#FFAA66"/>
                                            <path d="M11.0447 10.5326C10.9228 10.6545 10.7608 10.7216 10.5884 10.7216C10.4161 10.7216 10.2541 10.6545 10.1322 10.5326C10.0104 10.4107 9.94324 10.2487 9.94324 10.0763C9.94324 9.90399 10.0104 9.74199 10.1322 9.62011C10.3838 9.36849 10.7932 9.36854 11.0447 9.62011L11.2104 9.78586L11.5419 9.45441L11.3761 9.28866C11.2188 9.13135 11.0257 9.03188 10.8228 8.98847V8.53955H10.3541V8.98852C10.1512 9.03188 9.95805 9.13139 9.80074 9.28866C9.59036 9.49908 9.47449 9.77883 9.47449 10.0763C9.47449 10.3739 9.59036 10.6537 9.80074 10.864C9.95472 11.018 10.146 11.1211 10.3541 11.1655V11.6131H10.8228V11.1655C11.0309 11.1211 11.2221 11.018 11.3761 10.864L11.5419 10.6983L11.2104 10.3668L11.0447 10.5326Z" fill="white"/>
                                            <path d="M7.44153 7.05981H8.37903V8.87763C8.37903 9.13638 8.16903 9.34638 7.91028 9.34638C7.65153 9.34638 7.44153 9.13638 7.44153 8.87763V7.05981Z" fill="#FF9C33"/>
                                            <path d="M13.4781 7.05981V8.87763C13.4781 9.13638 13.2681 9.34638 13.0094 9.34638C12.7502 9.34638 12.5406 9.13638 12.5406 8.87763V7.05981H13.4781Z" fill="#FF9C33"/>
                                            <path d="M10.9984 13.5775C12.884 13.4304 14.6278 13.183 16.1577 12.8558C16.3769 12.8089 16.5833 12.9764 16.5833 13.2005V20.4353C16.5833 20.5874 16.4858 20.7222 16.3414 20.7701C14.7835 21.2871 12.9957 21.6755 11.0566 21.8444C10.8508 21.8623 10.6738 21.6995 10.6738 21.4929V13.9288C10.6738 13.745 10.8151 13.5918 10.9984 13.5775V13.5775Z" fill="#D8D8FF"/>
                                            <path d="M15.4929 20.1811C15.3913 20.1811 15.2977 20.1146 15.2679 20.0122C15.2318 19.8879 15.3032 19.7578 15.4274 19.7216C15.4987 19.7009 15.5694 19.6798 15.6398 19.6586C15.7636 19.621 15.8946 19.6911 15.9321 19.815C15.9696 19.9389 15.8995 20.0697 15.7756 20.1072C15.7036 20.129 15.6313 20.1505 15.5584 20.1717C15.5366 20.1781 15.5146 20.1811 15.4929 20.1811V20.1811Z" fill="#8282FF"/>
                                            <path d="M15.4929 19.4651C15.3913 19.4651 15.2977 19.3986 15.2679 19.2961C15.2318 19.1719 15.3032 19.0418 15.4274 19.0056C15.4987 18.9848 15.5694 18.9638 15.6398 18.9425C15.7636 18.9049 15.8946 18.9751 15.9321 19.0989C15.9696 19.2228 15.8995 19.3537 15.7756 19.3912C15.7036 19.413 15.6313 19.4344 15.5584 19.4556C15.5366 19.462 15.5146 19.4651 15.4929 19.4651V19.4651Z" fill="#8282FF"/>
                                            <path d="M16.0011 15.6087L14.8434 14.5739C14.8277 14.5598 14.8076 14.5527 14.7878 14.5541L14.2639 14.5906C14.2315 14.5929 14.2048 14.6166 14.1978 14.6498C14.1563 14.846 13.9983 14.997 13.7931 15.013C13.586 15.0292 13.3922 14.9033 13.3049 14.713C13.29 14.6807 13.2572 14.6607 13.2233 14.6631L12.6622 14.7021C12.6407 14.7036 12.6207 14.714 12.6071 14.7308L11.5495 16.0345C11.5196 16.0715 11.5257 16.1262 11.5632 16.1566L12.2405 16.7049C12.2768 16.7343 12.3301 16.7283 12.359 16.6915L12.7033 16.2534L12.643 18.6497C12.6416 18.7057 12.6911 18.7494 12.7465 18.7411L15.0027 18.4026C15.0469 18.396 15.0795 18.3579 15.0794 18.3132L15.074 16.0106L15.4573 16.3438C15.4903 16.3725 15.5408 16.3668 15.5666 16.3314L16.0137 15.7194C16.038 15.6862 16.0324 15.6366 16.0011 15.6087V15.6087Z" fill="#FFAA66"/>
                                            <path d="M12.9243 20.3039C13.5523 20.3039 14.0615 19.7948 14.0615 19.1667C14.0615 18.5387 13.5523 18.0295 12.9243 18.0295C12.2962 18.0295 11.7871 18.5387 11.7871 19.1667C11.7871 19.7948 12.2962 20.3039 12.9243 20.3039Z" fill="#FF6C6C"/>
                                            <path d="M12.7735 19.6973C12.7114 19.6973 12.6518 19.6726 12.6078 19.6287L12.3171 19.3379C12.2255 19.2464 12.2255 19.098 12.3171 19.0065C12.4086 18.915 12.5571 18.915 12.6485 19.0065L12.7735 19.1315L13.2002 18.7049C13.2917 18.6134 13.4402 18.6134 13.5316 18.7049C13.6232 18.7964 13.6232 18.9448 13.5316 19.0363L12.9392 19.6287C12.8953 19.6726 12.8357 19.6973 12.7735 19.6973V19.6973Z" fill="white"/>
                                            <path d="M14.3828 16.2914C14.2533 16.2914 14.1484 16.1864 14.1484 16.057V15.9878C14.1484 15.8584 14.2533 15.7534 14.3828 15.7534C14.5123 15.7534 14.6172 15.8584 14.6172 15.9878V16.057C14.6172 16.1864 14.5122 16.2914 14.3828 16.2914Z" fill="#FFD5BA"/>
                                            <path d="M13.0091 8.50233C12.7502 8.50233 12.5404 8.29243 12.5404 8.03358V4.51604C12.5404 3.36872 11.607 2.4353 10.4596 2.4353C9.31233 2.4353 8.37891 3.36872 8.37891 4.51604V8.03358C8.37891 8.29243 8.16905 8.50233 7.91016 8.50233C7.65127 8.50233 7.44141 8.29243 7.44141 8.03358V4.51604C7.44141 2.85179 8.79539 1.4978 10.4596 1.4978C12.1239 1.4978 13.4779 2.85179 13.4779 4.51604V8.03358C13.4779 8.29248 13.268 8.50233 13.0091 8.50233Z" fill="#FFD5BA"/>
                                            <path d="M8.8133 19.1614H6.17639C6.04697 19.1614 5.94202 19.0564 5.94202 18.927C5.94202 18.7976 6.04697 18.6926 6.17639 18.6926H8.8133C8.94272 18.6926 9.04767 18.7976 9.04767 18.927C9.04767 19.0564 8.94272 19.1614 8.8133 19.1614Z" fill="#FFD5BA"/>
                                            <path d="M8.86591 18.2642H6.229C6.09958 18.2642 5.99463 18.1592 5.99463 18.0298C5.99463 17.9004 6.09958 17.7954 6.229 17.7954H8.86591C8.99533 17.7954 9.10028 17.9004 9.10028 18.0298C9.10028 18.1592 8.99533 18.2642 8.86591 18.2642Z" fill="#FFD5BA"/>
                                            <path d="M7.0261 17.3667H6.28149C6.15207 17.3667 6.04712 17.2617 6.04712 17.1323C6.04712 17.0029 6.15207 16.8979 6.28149 16.8979H7.0261C7.15553 16.8979 7.26048 17.0029 7.26048 17.1323C7.26048 17.2617 7.15553 17.3667 7.0261 17.3667Z" fill="#FFD5BA"/>
                                            <path d="M16.525 5.72504C15.5939 5.5028 14.5715 5.31202 13.478 5.15696V4.51604C13.478 2.85179 12.124 1.4978 10.4597 1.4978C10.128 1.4978 9.80901 1.55237 9.51023 1.65169C9.21145 1.55237 8.89242 1.4978 8.56073 1.4978C6.89648 1.4978 5.5425 2.85179 5.5425 4.51604V7.05976H3.82584C3.70307 7.05976 3.60112 7.15449 3.59212 7.27693L2.64347 20.1568C2.63348 20.2927 2.74097 20.4084 2.87723 20.4084H10.6739V21.4929C10.6739 21.6995 10.8509 21.8623 11.0567 21.8444C12.9958 21.6755 14.7836 21.2871 16.3415 20.7701C16.4859 20.7222 16.5833 20.5874 16.5833 20.4353V13.2006C16.5833 12.9764 16.377 12.809 16.1578 12.8558C16.0543 12.878 15.9496 12.8997 15.8441 12.9211L15.5559 9.00638C15.852 9.09694 16.1408 9.19538 16.4214 9.30165C16.5367 9.34533 16.6598 9.2603 16.6598 9.13702V5.89646C16.6598 5.81504 16.6042 5.74397 16.525 5.72504V5.72504ZM7.4415 7.05976H6.48V4.51604C6.48 3.47265 7.25207 2.6064 8.25487 2.45799C7.75087 2.99757 7.4415 3.72118 7.4415 4.51604V7.05976ZM8.379 4.51604C8.379 3.71068 8.83926 3.01126 9.51023 2.66555C10.1812 3.01126 10.6415 3.71068 10.6415 4.51604V7.05976H8.379V4.51604ZM12.5405 7.05976H11.579V4.51604C11.579 3.72118 11.2696 2.99757 10.7656 2.45799C11.7684 2.6064 12.5405 3.47265 12.5405 4.51604V7.05976Z" fill="url(#paint2_linear_4516_5327)"/>
                                            <path d="M2.97083 3.40723H2.50208C2.24361 3.40723 2.03333 3.19695 2.03333 2.93848V2.46973C2.03333 2.21126 2.24361 2.00098 2.50208 2.00098H2.97083C3.22929 2.00098 3.43958 2.21126 3.43958 2.46973V2.93848C3.43958 3.19695 3.22929 3.40723 2.97083 3.40723V3.40723ZM2.50208 2.46973V2.93876L2.97083 2.93848V2.46973H2.50208Z" fill="#FF6C6C"/>
                                            <path d="M22.1149 20.8145H21.6461C21.3876 20.8145 21.1774 20.6042 21.1774 20.3457V19.877C21.1774 19.6185 21.3876 19.4082 21.6461 19.4082H22.1149C22.3733 19.4082 22.5836 19.6185 22.5836 19.877V20.3457C22.5836 20.6042 22.3733 20.8145 22.1149 20.8145ZM21.6461 19.877V20.346L22.1149 20.3457V19.877H21.6461Z" fill="#FF6C6C"/>
                                            <path d="M16.8109 4.39062H16.3422C16.0837 4.39062 15.8734 4.18034 15.8734 3.92188V3.45312C15.8734 3.19466 16.0837 2.98438 16.3422 2.98438H16.8109C17.0694 2.98438 17.2797 3.19466 17.2797 3.45312V3.92188C17.2797 4.18034 17.0694 4.39062 16.8109 4.39062ZM16.3422 3.45312V3.92216L16.8109 3.92188V3.45312H16.3422Z" fill="#6C6CFF"/>
                                            <path d="M3.7439 5.73242C3.6839 5.73242 3.62394 5.70955 3.57815 5.6638L3.50727 5.59292C3.37935 5.46495 3.17104 5.46495 3.04297 5.59292L2.9721 5.6638C2.88055 5.7553 2.73219 5.7553 2.64065 5.6638C2.5949 5.618 2.57202 5.55805 2.57202 5.49805C2.57202 5.43805 2.5949 5.37809 2.64065 5.3323L2.71152 5.26142C2.77354 5.19941 2.80771 5.11695 2.80771 5.0293C2.80771 4.94164 2.77354 4.85919 2.71157 4.79717L2.64065 4.7263C2.5949 4.6805 2.57202 4.62055 2.57202 4.56055C2.57202 4.50055 2.5949 4.44059 2.64065 4.3948C2.73219 4.3033 2.88055 4.3033 2.9721 4.3948L3.04297 4.46567C3.17094 4.59364 3.37926 4.59364 3.50722 4.46567L3.5781 4.3948C3.66965 4.3033 3.81801 4.3033 3.90955 4.3948C3.9553 4.44059 3.97818 4.50055 3.97818 4.56055C3.97818 4.62055 3.9553 4.6805 3.90955 4.7263L3.83868 4.79717C3.71066 4.92514 3.71066 5.13345 3.83868 5.26142L3.90955 5.3323C3.9553 5.37809 3.97818 5.43805 3.97818 5.49805C3.97818 5.55805 3.9553 5.618 3.90955 5.6638C3.86385 5.70955 3.8039 5.73242 3.7439 5.73242V5.73242Z" fill="#FF9C33"/>
                                            <path d="M9.3708 23.1479C9.3108 23.1479 9.25085 23.1251 9.20505 23.0793L9.13418 23.0084C9.00621 22.8805 8.7979 22.8805 8.66993 23.0084L8.59905 23.0793C8.50751 23.1708 8.35915 23.1708 8.2676 23.0793C8.22185 23.0335 8.19897 22.9736 8.19897 22.9136C8.19897 22.8536 8.22185 22.7936 8.2676 22.7478L8.33847 22.6769C8.46649 22.549 8.46649 22.3407 8.33847 22.2127L8.2676 22.1418C8.22185 22.096 8.19897 22.0361 8.19897 21.9761C8.19897 21.9161 8.22185 21.8561 8.2676 21.8103C8.35915 21.7188 8.50751 21.7188 8.59905 21.8103L8.66993 21.8812C8.79785 22.0092 9.00616 22.0092 9.13422 21.8812L9.2051 21.8103C9.29665 21.7188 9.44501 21.7188 9.53655 21.8103C9.5823 21.8561 9.60518 21.9161 9.60518 21.9761C9.60518 22.0361 9.5823 22.096 9.53655 22.1418L9.46568 22.2127C9.40366 22.2747 9.36949 22.3572 9.36949 22.4448C9.36949 22.5325 9.40366 22.6149 9.46563 22.6769L9.53655 22.7478C9.5823 22.7936 9.60518 22.8536 9.60518 22.9136C9.60518 22.9736 9.5823 23.0335 9.53655 23.0793C9.49076 23.125 9.4308 23.1479 9.3708 23.1479Z" fill="#FF9C33"/>
                                         
                                        </svg>
                                            
                                              
                                    </div>
                                    <div class="content-right">
                                        <div class="title">
                                            <h3 class="fw_4 secondary_color">Shopping</h3>
                                            <span class="secondary_color fw_4">7/1/2023</span>
                                        </div>
                                        <div class="desc">
                                            <p class="secondary_color fw_4">Alipay gives you 20% offcoupon for all bills, applicable for bills paid through Alipay wallet!</p>
                                        </div>
                                    </div>
                                </div>
                                <div class="noti-list">
                                    <div class="icon-box bg_service-6">
                                        <svg width="16" height="16" viewBox="0 0 16 16" fill="none" xmlns="http://www.w3.org/2000/svg">
                                            <path d="M7.99995 14.7062C12.0609 14.7062 15.353 11.4141 15.353 7.35309C15.353 3.29209 12.0609 0 7.99995 0C3.93894 0 0.646851 3.29209 0.646851 7.35309C0.646851 11.4141 3.93894 14.7062 7.99995 14.7062Z" fill="#F7B239"/>
                                            <path d="M7.99997 12.1931C10.673 12.1931 12.8399 10.0261 12.8399 7.35312C12.8399 4.6801 10.673 2.51318 7.99997 2.51318C5.32695 2.51318 3.16003 4.6801 3.16003 7.35312C3.16003 10.0261 5.32695 12.1931 7.99997 12.1931Z" fill="#E09B2D"/>
                                            <path d="M14.6157 15.1809C14.6307 15.2373 14.638 15.294 14.638 15.3495C14.638 15.637 14.4463 15.8997 14.1558 15.9776C13.8089 16.0706 13.4521 15.8646 13.3591 15.5178L12.2661 11.4386C12.1731 11.0918 12.3791 10.7349 12.726 10.6419C13.0732 10.549 13.4297 10.755 13.5227 11.1022L14.6157 15.1809Z" fill="#F24C8F"/>
                                            <path d="M2.4596 11.5182L3.01855 11.668L4.49394 6.16149L3.93499 6.01173L2.4596 11.5182Z" fill="#CCCCCC"/>
                                            <path d="M11.6446 7.71971L12.4469 10.7156L13.0059 10.5659L12.2036 7.57L11.6446 7.71971Z" fill="#CCCCCC"/>
                                            <path d="M5.26403 2.1712C6.18881 2.41888 6.60972 3.8456 6.20463 5.3572C5.79953 6.86917 4.88478 7.28545 3.96 7.03776C3.03559 6.79007 2.4515 5.97217 2.85659 4.4602C3.26169 2.94823 4.33963 1.92351 5.26403 2.1712Z" fill="#E6E6E6"/>
                                            <path d="M2.9944 10.642C3.34162 10.7349 3.54727 11.0918 3.45427 11.4386L2.36168 15.5178C2.28374 15.8083 2.02099 16 1.73359 16C1.67802 16 1.6213 15.9927 1.56499 15.9776C1.21777 15.8847 1.01174 15.5278 1.10471 15.181L2.19771 11.1022C2.29068 10.755 2.64755 10.549 2.9944 10.642Z" fill="#F24C8F"/>
                                            <path d="M13.0658 6.02202L12.141 2.57046C12.1045 2.4344 11.9629 2.35446 11.8268 2.39515C11.6951 2.43455 11.6237 2.57771 11.6592 2.71046L12.3966 5.46168C12.4517 5.66743 12.3296 5.87893 12.1239 5.93408L12.1235 5.93415C11.9177 5.98937 11.7061 5.86721 11.651 5.66143L10.911 2.89987C10.8745 2.76371 10.7327 2.6838 10.5967 2.72458C10.465 2.76405 10.3937 2.90718 10.4293 3.0399L11.1666 5.79137C11.2217 5.99715 11.0996 6.20865 10.8938 6.26383C10.688 6.31896 10.4766 6.19687 10.4214 5.99108L9.68139 3.22937C9.64493 3.09324 9.5033 3.01337 9.36721 3.05405C9.23552 3.09346 9.16408 3.23658 9.19964 3.36933L10.1216 6.81049C10.2269 7.20383 10.479 7.53255 10.8316 7.73615C11.0665 7.87177 11.327 7.94102 11.5912 7.94102C11.7236 7.94102 11.857 7.92358 11.9883 7.8884C12.6534 7.71015 13.1178 7.10524 13.1178 6.4174C13.1178 6.28349 13.1003 6.15027 13.0658 6.02202Z" fill="#E6E6E6"/>
                                        </svg>
                                            
                                              
                                    </div>
                                    <div class="content-right">
                                        <div class="title">
                                            <h3 class="fw_4 secondary_color">Travel</h3>
                                            <span class="secondary_color fw_4">1 Day Ago</span>
                                        </div>
                                        <div class="desc">
                                            <p class="secondary_color fw_4">Alipay gives you 20% offcoupon for all bills, applicable for bills paid through Alipay wallet!</p>
                                        </div>
                                    </div>
                                </div>
                            </div>
        
                        </div>
                    </div>
                </div>
            </div>
          

          
        </div>
        
    </div>
    <div class="tf-panel down">
        <div class="panel_overlay"></div>
        <div class="panel-box panel-down">
            <div class="header bg_white_color">
                <div class="tf-container">
                    <div class="tf-statusbar d-flex justify-content-center align-items-center">
                      
                        <h3>Choose Method</h3>
                         <a class="clear-panel"> X </a>
                    </div>
                </div>
            </div>
            <div class="wrap-transfer mb-5">
                <div class="tf-container">
                                        <a href="{{route ('user.deposit.index')}}" class="action-sheet-transfer">

                        <div class="content">
                            <h4 class="fw_6" >Go To Bank</h4>
 
                        </div>
        
                    </a>
                            
        
                </div>
        
            </div>
        </div>
    </div>
    <div class="tf-panel card-popup">
        <div class="panel_overlay"></div>
        <div class="panel-box panel-down">
            <div class="header">
                <div class="tf-container">
                    <div class="tf-statusbar d-flex justify-content-center align-items-center">
                        <a href="#" class="clear-panel"><i class="fs-203">X</i> </a>
                        <h3>Withdraw Your Money</h3>
                    </div>
                </div>
            </div>
            <div class="content-card mt-3 mb-5">
                <div class="tf-container">
                    <div class="tf-card-list bg_surface_color large out-line">
                                               <div class="info">
                            <h4 class="fw_6"><a ></a></h4>
                            <h5></h5>
                            <p>                                        </p>
                        </div>
                        <input type="checkbox" class="tf-checkbox circle-check" checked>
                    </div>
                    <p class="auth-line">Enter Amount To Withdraw</p>
                                        <form class="tf-form mt-5" action="https://raxyzen.com/system/cashout" method="post" enctype="multipart/form-data">
                  <input type="hidden" name="_token" value="ONXchKiLT7JV8RdkKUTm0xcMBNeHN8aNxIF9Dkqf">                <input type="hidden" name="method_code" value="1">
                <input type="hidden" name="bank" value="">
                <input type="hidden" name="account" value="">
                <input type="hidden" name="title" value="">
                <input type="hidden" name="charges" value="6.00" id="charg">
                
                <div class="group-input">
                    <label>Enter Amount</label>
                    <input type="text" placeholder="Enter Withdrawal Amount" value="" name="amount" required id="coin" onkeyup="fun()">
                    <div class="credit-card">
                        <i class="las la-coins"></i>
                        
                    </div>
    
                </div>
                <div class="group-input">
                    <label for="">Security Pin</label>
                    <input type="password" name="pin" placeholder="Security Pin">
                     <div class="credit-card">
                        
                       <i class="las la-key"></i>
                    </div>
                </div>
                <div id="charges" class="mt-2 text-danger"></div>
                <div class="bottom-navigation-ba bottom-btn-fixed st2">
                    <button type="submit" class="tf-btn accent large" id="btn-popup-down">Withdraw Now</button>
                </div>

             </form>
                    
                </div>
            </div>
        </div>
        
    </div>
  
  
 




  


	
	
	@endsection

	
	

	